;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-unify -*-
#|
-------------------------------------------------------------------------------
TITLE: A Modified Unification Algorithm for Type Inference
-------------------------------------------------------------------------------
File:    ti-unify.em
Version: 2.0 (last modification on Tue Feb  8 17:03:12 1994)
State:   proposed

DESCRIPTION:
Insert equations of type expressions into a given set of variable
substitutions.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
$__log

-------------------------------------------------------------------------------
|#

#module ti-unify
 (import (lzs mzs ti ti-codes ti-lattice ti-exprs ti-meet-join ti-eqs
	      ti-write ti-copy)
  syntax (ti)
  export (unify))

;;; ---------------------------------------------------------------------------
;;; GENERAL UNIFICATION
;;; ---------------------------------------------------------------------------

(defgeneric unify (stack subs))

(defmethod unify ((stack <null>)	;empty stack
		  (subs <type-var-substitutions>))
  subs)					;unification succeeded

(defmethod unify ((stack <pair>)	;stack not empty
		  (subs <type-var-substitutions>))
  (let* ((actual-equ (car stack))
	 (left-expr (?left-expr actual-equ))
	 (right-expr (?right-expr actual-equ)))
    (cond ((unify-exprs left-expr right-expr subs) ;unify first equation
	   (ti-format2 t "~%new subs ~A" (ti-print-string subs))
	   (unify (cdr stack) subs))	;unification goes ahead
	  (t nil))))			;unification failed

;;; ---------------------------------------------------------------------------
;;; UNIFICATION OF TYPE EXPRESSIONS
;;; ---------------------------------------------------------------------------
	    
(defgeneric unify-exprs (expr1 expr2 subs))

(defmethod unify-exprs ((expr1 <atomic-type>)
			(expr2 <atomic-type>)
			(subs <type-var-substitutions>))
  (meet-type-exprs expr1 expr2))

(defmethod unify-exprs ((expr1 <slot-id>)
			(expr2 <slot-id>)
			(subs <type-var-substitutions>))
  (meet-type-exprs expr1 expr2))

(defmethod unify-exprs ((expr1 <slot-id>)
			(expr2 <atomic-type>)
			(subs <type-var-substitutions>))
  (meet-type-exprs expr1 expr2))

(defmethod unify-exprs ((expr1 <atomic-type>)
			(expr2 <slot-id>)
			(subs <type-var-substitutions>))
  (meet-type-exprs expr1 expr2))

;;; ---------------------------------------------------------------------------
(defmethod unify-exprs ((expr1 <type-var>)
			(expr2 <type-expr>)
			(subs <type-var-substitutions>))
  (add-unify-equation subs expr1 expr2))

(defmethod unify-exprs ((expr1 <type-expr>)
			(expr2 <type-var>)
			(subs <type-var-substitutions>))
  (add-unify-equation subs expr2 expr1))
 
;;; ---------------------------------------------------------------------------
(defgeneric add-unify-equation (subs var expr))

(defmethod add-unify-equation ((subs <type-var-substitutions>)
			       (var <type-var>)
			       (expr <type-expr>))
  (let ((equ (get-last-substitution subs var)))
    (if equ
	(let ((new-expr (unify-exprs expr (?right-expr equ) subs)))
	  (if new-expr
	      (set-right-expr equ new-expr)
	    nil))
      (add-substitution subs var expr))))

(defmethod add-unify-equation ((subs <type-var-substitutions>)
			       (var <type-var>)
			       (expr <type-var>))
  (if (null (check-equality subs var expr))
      (let ((equ (get-last-substitution subs var)))
	(if equ
	    (let ((right-expr (?right-expr equ)))
	      (set-right-expr equ expr)
	      (add-unify-equation subs expr right-expr))
	  (add-substitution subs var expr)))
    t))


#module-end