;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-const -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-------------------------------------------------------------------------------
TITLE: Type Inference of Constants
-------------------------------------------------------------------------------
File:    ti-const.em
Version: 2.0 (last modification on Fri Jan 28 16:22:15 1994)
State:   proposed

DESCRIPTION:
Link between EuLisp constants and type expressions.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/ti-const.em[2.0]:
  
[1.1] Wed May  5 11:24:52 1993 akind@isst proposed
  
[1.2] Thu Jun  3 11:42:12 1993 akind@isst proposed
  
[1.3] Wed Aug 18 16:09:27 1993 akind@isst proposed
  
[1.4] Fri Aug 27 17:29:27 1993 akind@isst proposed
  
[1.5] Wed Sep  8 09:37:55 1993 akind@isst published
  
[1.6] Thu Sep 23 14:32:31 1993 akind@isst proposed
  [Tue Sep 14 15:16:03 1993] Intention for change:
[1.7] Mon Oct 11 10:29:38 1993 akind@isst published
  
[1.8] Wed Jan 19 13:18:51 1994 akind@isst saved
  
[1.9] Mon Jan 31 09:34:31 1994 akind@isst published
  [Wed Jan 19 10:34:20 1994] Intention for change:
  --- no intent expressed ---
[2.0] Mon Jan 31 09:34:31 1994 akind@isst proposed
  [Wed Jan 19 10:34:20 1994] Intention for change:
  --- no intent expressed ---

-------------------------------------------------------------------------------
|#

#module ti-const
 (import (ti lzs ti-lattice ti-exprs ti-signature
	     (only (~class-of) lzs-mop)
	     (only (expand-literal) expand-literal)) 
  syntax (ti)
	 
  export (constant-type))

;;; ---------------------------------------------------------------------------
;;; CONSTANT TYPE EXPRESSIONS
;;; ---------------------------------------------------------------------------

(defgeneric constant-type (value))

(defmethod constant-type (value)	; may be already a <literal-instance>
  (let* ((expanded-literal (expand-literal value))
	 (lattice-type (find-lattice-type-for-literal expanded-literal)))
    (if (null lattice-type)
	(setq lattice-type (?lattice-type (~class-of expanded-literal))))
    (lattice-type-to-atomic-type lattice-type)))

(defmethod constant-type ((value <null>))
  (<null>-type))

;;; Handling slot names.
(defmethod constant-type ((value <symbol>))
  (make <slot-id> :slot-name value))

;;; Handling function objects.
(defmethod constant-type ((value <fun>))
  (<function>-type))

(defmethod constant-type ((value <named-const>))
  (lattice-type-to-atomic-type (?lattice-type (?type value))))

#module-end