;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-comp -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-------------------------------------------------------------------------------
TITLE: Inference with Compound Lattice Types (fpi-list, sy-list, cons-list ..)
-------------------------------------------------------------------------------
File:    ti-comp.em
Version: 2.0 (last modification on Fri Jan 28 16:21:58 1994)
State:   proposed

DESCRIPTION:
We distinguish monomorphic lists (mono-lists) and polymorphic lists
(poly-lists). Monomorphic lists contain elements with the same type,
for example <symbol>, <fpi> or <cons>.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/ti-comp.em[2.0]:
  
[1.1] Fri Oct  8 09:43:02 1993 akind@isst proposed
  empty module to submit
[1.2] Mon Oct 11 10:32:20 1993 akind@isst published
  
[1.3] Tue Jan  4 11:47:01 1994 akind@isst saved
  [Fri Dec 10 14:43:35 1993] Intention for change:
[1.4] Wed Jan 19 13:18:46 1994 akind@isst saved
  
[1.5] Mon Jan 31 09:34:25 1994 akind@isst published
  [Mon Jan 10 15:10:33 1994] Intention for change:
  --- no intent expressed ---
[2.0] Mon Jan 31 09:34:25 1994 akind@isst proposed
  [Mon Jan 10 15:10:33 1994] Intention for change:
  --- no intent expressed ---
 

-------------------------------------------------------------------------------
|#


#module ti-comp
(import (mzs ti ti-lattice ti-exprs ti-eqs ti-meet-join ti-write
	     (only (format) common-lisp))
 syntax (ti)
 export (check-compound-types-before check-compound-types-after
	convert-all-compound-types reset-write-access-stamps))

;;; ---------------------------------------------------------------------------
;;; Check compound types and convert them to uncompound ones probably.
;;; ---------------------------------------------------------------------------
 
;; Copy all compound lattice types of a descriptor and set their write-access-
;; stamp in case it is nil to the latest write-access-stamp.
;; See also comment for check-compound-types-before.
(DEFGENERIC check-compound-types-after (descr))

(DEFMETHOD check-compound-types-after ((descr <type-descr>))
  (let ((no-type-clash t))
    (dolist (equ (?equations (?type-vars descr)))
      (let ((expr (?right-expr equ)))
	(if (and no-type-clash (atomic-type-p expr))
	    (if (?comp-name expr)
		(let ((new-name (check-compound-types-after (?name expr))))
		  (if new-name
		      (let ((new-atom (compute-to-atom new-name)))
			(if new-atom
			    (set-right-expr equ new-atom)
			  (setq no-type-clash ())))))))))
    (if (null no-type-clash)
	(ti-format t "~%Notice: type descriptor removed (after): ~A"
		(ti-print-string descr))
      no-type-clash)))
  
(DEFMETHOD check-compound-types-after ((name <pair>))
  (let ((op-symbol (car name)))
    (cond ((eq op-symbol ^not)
	   (let* ((subname (car (cdr name)))
		  (new-subname (check-compound-types-after subname)))
	     (if new-subname
		 (list ^not new-subname))))
	  ((eq op-symbol ^or)
	   (let* ((subname1 (car (cdr name)))
		  (subname2 (car (cdr (cdr name))))
		  (new-subname1 (check-compound-types-after subname1))
		  (new-subname2 (check-compound-types-after subname2)))
	     (if (or new-subname1 new-subname2)
		 (list ^or
		       (or new-subname1 subname1)
		       (or new-subname2 subname2)))))
	  ((eq op-symbol ^and)
	   (let* ((subname1 (car (cdr name)))
		  (subname2 (car (cdr (cdr name))))
		  (new-subname1 (check-compound-types-after subname1))
		  (new-subname2 (check-compound-types-after subname2)))
	     (if (or new-subname1 new-subname2)
		 (list ^and
		       (or new-subname1 subname1)
		       (or new-subname2 subname2))))))))

(DEFMETHOD check-compound-types-after ((lattice-type <lattice-type>))
  (if (?compound lattice-type)
      (let ((new-lattice-type (copy-lattice-type lattice-type)))
	(if (null (?write-access-stamp new-lattice-type))
	    (setf (?write-access-stamp new-lattice-type)
	      (new-write-access-stamp)))
	(format t "~%after: outcomming stamp: ~A min-stamp: ~A new stamp: ~A latest-stamp: ~A - ~A"
		   (?write-access-stamp lattice-type)
		   (?write-access-stamp 
		    (get-strategic-lattice-type (?name lattice-type)))
		   (?write-access-stamp new-lattice-type)
		   (?latest-write-access-stamp *the-lattice*)
		   (?name lattice-type))
	new-lattice-type)
    ()))

;; Convert all compound lattice types of a descritor that may be affected
;; be accessing operations on the itself or a super lattice type to the next
;; super non-compound lattice type. The conversion is done when the write-
;; access-stamp of the actual lattice type is less than the write-access-
;; stamp of the origin lattice type in the type lattice (*the-lattice*).
;; All compound lattice type have thus to be copied when after an inference
;; step (see check-compound-types-after).
(DEFGENERIC check-compound-types-before (descr))

(DEFMETHOD check-compound-types-before ((descr <type-descr>))
  (let ((eqs (append (?equations (?type-vars descr))
		     (?equations (?type-vars (?t-descr-before descr)))))
	(no-type-clash t))
    (dolist (equ eqs)
      (let ((expr (?right-expr equ)))
	(if (and no-type-clash (atomic-type-p expr))
	    (if (?comp-name expr)
		(let ((new-name (check-compound-types-before (?name expr))))
		  (if new-name
		      (let ((new-atom (compute-to-atom new-name)))
			(if new-atom
			    (set-right-expr equ (compute-to-atom new-name))
			  (setq no-type-clash ())))))))))
    (if (null no-type-clash)
	(ti-format t "~%Notice: type descriptor removed (before): ~A"
		(ti-print-string descr))
      no-type-clash)))
  
(DEFMETHOD check-compound-types-before ((name <pair>))
  (let ((op-symbol (car name)))
    (cond ((eq op-symbol ^not)
	   (let* ((subname (car (cdr name)))
		  (new-subname (check-compound-types-before subname)))
	     (if new-subname
		 (list ^not new-subname))))
	  ((eq op-symbol ^or)
	   (let* ((subname1 (car (cdr name)))
		  (subname2 (car (cdr (cdr name))))
		  (new-subname1 (check-compound-types-before subname1))
		  (new-subname2 (check-compound-types-before subname2)))
	     (if (or new-subname1 new-subname2)
		 (list ^or
		       (or new-subname1 subname1)
		       (or new-subname2 subname2)))))
	  ((eq op-symbol ^and)
	   (let* ((subname1 (car (cdr name)))
		  (subname2 (car (cdr (cdr name))))
		  (new-subname1 (check-compound-types-before subname1))
		  (new-subname2 (check-compound-types-before subname2)))
	     (if (or new-subname1 new-subname2)
		 (list ^and
		       (or new-subname1 subname1)
		       (or new-subname2 subname2))))))))

(DEFMETHOD check-compound-types-before ((lattice-type <lattice-type>))
  (if (?compound lattice-type)
      (let ((min-stamp (?write-access-stamp ; get the original lattice type
			(get-strategic-lattice-type (?name lattice-type)))))
	(format t "~%before: incomming stamp: ~A min-stamp: ~A latest-stamp: ~A - ~A"
		   (?write-access-stamp lattice-type)
		   min-stamp
		   (?latest-write-access-stamp *the-lattice*)
		   (?name lattice-type))
	(if (< (?write-access-stamp lattice-type) min-stamp)
	    (convert-to-super-non-compound-type lattice-type)
	  ()))
    ()))

;; Convert all comound lattice types of a descriptor on next super non-
;; compound lattice types. This function is used to ignore all compound 
;; lattice types.
(DEFGENERIC convert-all-compound-types (descr))

(DEFMETHOD convert-all-compound-types ((descr <type-descr>))
  (let ((no-type-clash t))
    (dolist (equ (?equations (?type-vars descr)))
      (let ((expr (?right-expr equ)))
	(if (and no-type-clash (atomic-type-p expr))
	    (let ((new-name (convert-all-compound-types (?name expr))))
	      (if new-name
		  (let ((new-name (compute-to-atom new-name)))
		    (if new-name
			(set-right-expr equ new-name)
		      (setq no-type-clash new-name))))))))
    (if (null no-type-clash)
	(ti-format t "~%Notice: type descriptor removed (convert): ~A"
		   (ti-print-string descr))
      no-type-clash)))
  
(DEFMETHOD convert-all-compound-types ((name <pair>))
  (let ((op-symbol (car name)))
    (cond ((eq op-symbol ^not)
	   (let* ((subname (car (cdr name)))
		  (new-subname (convert-all-compound-types subname)))
	     (if new-subname
		 (list ^not new-subname))))
	  ((eq op-symbol ^or)
	   (let* ((subname1 (car (cdr name)))
		  (subname2 (car (cdr (cdr name))))
		  (new-subname1 (convert-all-compound-types subname1))
		  (new-subname2 (convert-all-compound-types subname2)))
	     (if (or new-subname1 new-subname2)
		 (list ^or
		       (or new-subname1 subname1)
		       (or new-subname2 subname2)))))
	  ((eq op-symbol ^and)
	   (let* ((subname1 (car (cdr name)))
		  (subname2 (car (cdr (cdr name))))
		  (new-subname1 (convert-all-compound-types subname1))
		  (new-subname2 (convert-all-compound-types subname2)))
	     (if (or new-subname1 new-subname2)
		 (list ^and
		       (or new-subname1 subname1)
		       (or new-subname2 subname2))))))))

(DEFMETHOD convert-all-compound-types ((lattice-type <lattice-type>))
  (if (?compound lattice-type)
      (convert-to-super-non-compound-type lattice-type)
    ()))

;; Set write-access-stamps of all lattice type of a descriptor to nil.
(DEFGENERIC reset-write-access-stamps (obj))

(DEFMETHOD reset-write-access-stamps ((descr <type-descr>))
  (dolist (equ (?equations (?type-vars descr)))
    (let ((expr (?right-expr equ)))
      (if (atomic-type-p expr)
	  (reset-write-access-stamps (?name expr))))))

(DEFMETHOD reset-write-access-stamps ((name <pair>))
  (let ((op-symbol (car name)))
    (cond ((eq op-symbol ^not)
	   (reset-write-access-stamps (car (cdr name))))
	  ((or (eq op-symbol ^or) (eq op-symbol ^and))
	   (reset-write-access-stamps (car (cdr name)))
	   (reset-write-access-stamps (car (cdr (cdr name))))))))

(DEFMETHOD reset-write-access-stamps ((lattice-type <lattice-type>))
  (if (?compound lattice-type)
      (setf (?write-access-stamp lattice-type) ())))


#module-end