;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-codes -*-
#|
Copyright (C) ISST - Fraunhofer Institute for Software Engineering and Systems 
Engineering - Berlin 1994


-------------------------------------------------------------------------------
TITLE: Encoding Lattice Types
-------------------------------------------------------------------------------
File:    ti-codes.em
Version: 2.0 (last modification on Tue Feb  8 17:04:52 1994)
State:   proposed

DESCRIPTION:
Bit codes are assigned to lattice types in order to use fast low-level
bit operations to implement the lattice operations meet, join, and
complement. This modules provides the bit codes and operations on
them.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/ti-codes.em[2.0]:
  
[1.1] Wed Apr  7 18:04:57 1993 akind@isst proposed
  
[1.2] Wed Apr 21 16:33:27 1993 akind@isst proposed
  
[1.3] Tue Aug  3 11:46:42 1993 akind@isst proposed
  
[1.4] Wed Aug 11 13:34:30 1993 akind@isst proposed
  
[1.5] Wed Aug 18 16:09:20 1993 akind@isst published
  
[1.6] Thu Sep 23 14:32:21 1993 akind@isst proposed
  [Tue Sep 14 15:15:47 1993] Intention for change:
[1.7] Mon Oct 11 10:29:17 1993 akind@isst saved
  
[1.8] Tue Oct 12 10:31:49 1993 akind@isst published
  
[1.9] Mon Jan 31 15:13:40 1994 ukriegel@isst proposed
  [Mon Jan 31 15:13:00 1994] Intention for change:
  $copyright
  done
[1.10] Tue Feb  8 17:24:22 1994 akind@isst published
  [Tue Feb  8 16:55:09 1994] Intention for change:
  new header
[2.0] Tue Feb  8 17:24:22 1994 akind@isst proposed
  [Tue Feb  8 16:55:09 1994] Intention for change:
  new header

-------------------------------------------------------------------------------
|#


#module ti-codes
 (import (ti
	  (only (logand logior logxor logandc2 expt minusp) common-lisp))
  syntax (ti)
  export (bottom-code
	  reset-used-codes
	  next-code 
	  join-codes
	  meet-codes
	  complement-code
	  substract-codes
	  xor-codes
	  eq-code-p
	  meet-codes-p
	  subcode-p
	  bottom-code-p
	  complement-codes-p))

;;; ---------------------------------------------------------------------------
;;; GENERATING NEW LATTICE TYPE CODES
;;; ---------------------------------------------------------------------------

;;; Answer the constant bottom code.
(defun bottom-code ()
  0)

(deflocal *used-codes* (bottom-code))

(defun reset-used-codes () (setq *used-codes* (bottom-code)))

;;; Answer a new type code; increment number of used codes.
(defun next-code ()
  (let ((new-code (expt 2 *used-codes*)))
    (setf *used-codes* (+ 1 *used-codes*))
    new-code))

;;; Meet lattice type codes.
(defun join-codes (code1 code2)
  (if (minusp code1)
      (if (minusp code2)
	  (- (logand (abs code1) (abs code2)))
	(- (logandc2 (abs code1) code2)))
    (if (minusp code2)
	(- (logandc2 (abs code2) code1))
      (logior code1 code2))))

;;; Meet lattice type codes.
(defun meet-codes (code1 code2)
  (if (minusp code1)
      (if (minusp code2)
	  (- (logior (abs code1) (abs code2)))
	(logandc2 code2 (abs code1)))
    (if (minusp code2)
	(logandc2 code1 (abs code2))
      (logand code1 code2))))

;;; Complement lattice type codes.
(defun complement-code (code)
  (- code))

;;; Xor lattice type codes.
(defun xor-codes (code1 code2)
  (logxor code1 code2))

;;; Substract lattice type codes.
(defun substract-codes (code1 code2)
  (logandc2 code1 code2))

;;; ---------------------------------------------------------------------------
;;; TYPE CODE PREDICATES
;;; ---------------------------------------------------------------------------

;;; Answer whether two type codes are equal.
(defun eq-code-p (code1 code2)
  (= code1 code2))

;;; Answer whether a type code is the bottom type code.
(defun bottom-code-p (code)
  (eq-code-p code (bottom-code)))

;;; Answer whether two type codes do meet, e.g. do have set the same bits.
(defun meet-codes-p (code1 code2)
  (null (bottom-code-p (meet-codes code1 code2))))

;;; Answer whether one type code is a subcode of another.
(defun subcode-p (code1 code2)
  (eq-code-p (meet-codes code1 code2) code1))

;;; Answer whether two lattice type codes are complementary.
(defun complement-codes-p (code1 code2)
  (zerop (+ code1 code2)))


#module-end