;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: standard-init -*-
#|
$__copyright
-----------------------------------------------------------------------------------
TITLE: initialization protocol of the compile time MOP for standard classes
-----------------------------------------------------------------------------------
File:    standard-init.em
Version: 2.0 (last modification on Wed Jun 22 10:44:36 1994)
State:   proposed

DESCRIPTION:
The methods for <standard-class-def> implement the single inheritance case which
is the default for the predefined EuLisp class <class>.


DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/standard-init.em[2.0]:
  compile time MOP for standard classes
[1.1] Tue Mar 23 09:45:35 1993 wheick@isst saved
  [Mon Mar 22 17:28:19 1993] Intention for change:
  compute-representation and import for functions from whc-definitions inserted
  and export
[1.2] Wed Mar 24 13:47:30 1993 imohr@isst proposed
  classes and generic functions ok
[1.3] Wed Mar 24 16:48:58 1993 imohr@isst proposed
  class options representation. ok
[1.4] Thu Mar 25 14:10:39 1993 wheick@isst saved
  [Thu Mar 25 08:59:44 1993] Intention for change:
  two new paramerts for type. functions in initialize
[1.5] Wed Mar 31 10:40:57 1993 imohr@isst proposed
  literals for structures, literal expanders and expose ok
[1.6] Fri Apr  2 16:04:01 1993 imohr@isst proposed
  [Thu Apr  1 14:35:43 1993] Intention for change:
  + method ~compute-class-precedence-list for empty superclass list
[1.7] Tue Apr  6 16:11:00 1993 imohr@isst saved
  + stuff for lattice types
[1.8] Tue Apr  6 16:40:04 1993 imohr@isst proposed
  
[1.9] Thu Apr  8 15:20:49 1993 imohr@isst proposed
  code generation for classes ok
[1.10] Wed Apr 14 13:21:08 1993 imohr@isst proposed
  methods for ~compute-representation/predicate/constructor deleted
[1.11] Wed Apr 28 09:58:50 1993 imohr@isst saved
  slot-accessor-fun's and slot-init-fun's with annotation slot
[1.12] Mon May  3 13:32:43 1993 imohr@isst proposed
  + lists for statically allocated instances
[1.13] Thu May  6 10:41:35 1993 imohr@isst proposed
  ~compute-reader/writer moved to mm-initialize.em
[1.14] Thu May  6 12:05:29 1993 imohr@isst proposed
  now ignoring method definitions when no generic function exist
[1.15] Tue Jun  1 13:53:30 1993 imohr@isst proposed
  + list of all slot descriptions (for type inference)
[1.16] Mon Aug 30 15:25:27 1993 imohr@isst proposed
  [Mon Aug 30 14:01:19 1993] Intention for change:
  collecting subclasses in a class
[1.17] Wed Sep  8 13:23:36 1993 imohr@isst proposed
  [Wed Sep  8 11:59:46 1993] Intention for change:
  - import of el2lzs-rules
[1.18] Wed Sep 15 11:56:45 1993 imohr@isst proposed
  [Mon Sep 13 08:28:40 1993] Intention for change:
  complete generic functions
[1.19] Fri Oct  1 18:49:36 1993 imohr@isst proposed
  [Fri Oct  1 10:18:02 1993] Intention for change:
  allow creation of slot accessors for %string
[1.20] Wed Oct 13 15:45:17 1993 imohr@isst proposed
  [Mon Oct 11 13:34:56 1993] Intention for change:
  + initarg-option for slots
[1.21] Fri Oct 15 17:34:38 1993 imohr@isst proposed
  [Fri Oct 15 08:28:41 1993] Intention for change:
  creation of slot accessors for tail-classes only if required
[1.22] Tue Oct 19 09:13:45 1993 hfried@isst published
  [Tue Oct 19 09:10:31 1993] Intention for change:
  ausschriften
[1.23] Tue Nov  9 11:33:50 1993 imohr@isst proposed
  [Mon Nov  1 09:02:17 1993] Intention for change:
  error noted by keith removed
[1.24] Mon Nov 29 13:21:18 1993 imohr@isst proposed
  [Mon Nov 29 10:57:35 1993] Intention for change:
  removing error in inheritance of slot-descriptions
[1.25] Mon Dec  6 15:49:30 1993 imohr@isst proposed
  [Mon Dec  6 09:05:39 1993] Intention for change:
  replace initfunctions by initvalues if possible
  initvalue is now set if possible
[1.26] Wed Jan 19 16:13:55 1994 imohr@isst proposed
  get/set-slot-value
[1.27] Tue Feb  1 14:02:38 1994 imohr@isst saved
  imporved error message when redefined initarg appears
[1.28] Wed Feb  2 09:15:54 1994 imohr@isst proposed
  [Mon Jan 10 16:14:14 1994] Intention for change:
  removing *list-of-new-slot-descriptions*
[1.29] Mon Feb  7 08:26:46 1994 imohr@isst published
  [Wed Feb  2 12:01:39 1994] Intention for change:
  imported classes
  new slot access and imported classes ok
[1.30] Thu Feb 24 09:10:24 1994 wheick@isst proposed
  [Mon Feb 21 11:59:17 1994] Intention for change:
  insert eulisp0,1
  done
[1.31] Thu May  5 11:52:27 1994 imohr@isst proposed
  separate compilation of eulisp0
[1.32] Mon Jun 20 11:55:05 1994 imohr@isst proposed
  [Wed May 11 15:41:01 1994] Intention for change:
  option code-identifier for slots
  Beiratssitzung Abschluss
[1.33] Wed Jun 22 16:45:28 1994 imohr@isst proposed
  
[2.0] Wed Jun 22 16:45:28 1994 imohr@isst proposed
  

-----------------------------------------------------------------------------------
|#

#module standard-init

(import (eulisp1
         lzs-mop
         accessors
         lzs
         option-lists
         tail-module
         el2lzs-error
         (only (append remove-duplicates substitute mapc mapcar mapcan find warn 
                       make-instance
                       nconc vector) 
           common-lisp))

 syntax (eulisp1
         (only (case push) common-lisp))

 )

;;; -----------------------------------------------------------------------------------
;;; initialization of class definitions
;;; -----------------------------------------------------------------------------------
;;; The methods for <standard-class-def> implement the compile time MOP for the
;;; single inheritance case like the application MOP defined for <class>

(defmethod ~initialize ((class <standard-class-def>) initlist)
;options in initlist are: name direct-superclasses direct-slot-specs 
;direct-initargs representation allocation
  (let ((name (get-option ^name initlist nil))
        (direct-superclasses (get-option ^direct-superclasses initlist nil))
        (direct-slot-specs (get-option ^direct-slot-descriptions initlist nil))
        (direct-initargs (get-option ^direct-initargs initlist nil))
        (representation (get-option ^representation initlist nil))
        (allocation (get-option ^allocation initlist nil))
        (direct-super-lattice-types (get-option ^direct-super-lattice-types 
                                                initlist nil))
        effective-slots inherited-slots
        )

  ; resetting of annotations holding intermediate informations during
  ; compilation 
  (setf (?place class) nil)
  (setf (?expanded-literal class) nil)
  
  (cond ((null (?identifier class)) 
         (setf (?identifier class) name))
        ((eq (?identifier class) name))
        (t (warn "identifiers for class name (~A) and binding (~A) are not the same"
                 name (?identifier class))))
  (setf (?supers class) direct-superclasses)
  (mapc (lambda (superclass)
          (push class (?subclasses superclass)))
        direct-superclasses)
  (setf (?lattice-type class) (~compute-lattice-type class direct-superclasses
                                                     direct-super-lattice-types))
  (setf (?class-precedence-list class) 
        (~compute-class-precedence-list class direct-superclasses))
  (setf (?initargs class)
        (~compute-initargs class direct-initargs
                           (~compute-inherited-initargs class direct-superclasses)))
  (setq inherited-slots 
        (~compute-inherited-slot-descriptions class direct-superclasses))
  (setq effective-slots
        (~compute-slot-descriptions class direct-slot-specs
                                    inherited-slots))
  (setf (?effective-slots class) effective-slots)
  (setf (?representation class)
        (~compute-representation class representation allocation))
  (~compute-and-ensure-slot-accessors class effective-slots inherited-slots)
  class))

(defmethod ~initialize ((class <tail-class-def>) initlist)
  ;recognized options in initlist are: name direct-slot-specs 
  ;direct-initargs representation allocation
  (let ((name (get-option ^name initlist nil))
        (direct-slot-specs (get-option ^direct-slot-descriptions initlist nil))
        (direct-initargs (get-option ^direct-initargs initlist nil))
        (representation (get-option ^representation initlist nil))
        (allocation (get-option ^allocation initlist t))
        (direct-super-lattice-types (get-option ^direct-super-lattice-types 
                                                initlist nil))
        effective-slots
        )
    
    ; resetting annotations holding intermediate informations during
    ; compilation 
    (setf (?place class) nil)
    (setf (?expanded-literal class) nil)
    
    (cond ((null (?identifier class)) 
           (setf (?identifier class) name))
          ((eq (?identifier class) name))
          (t (warn "identifiers for class name (~A) and binding (~A) are not the same"
                   name (?identifier class))))
    (setf (?supers class) nil)
    (setf (?lattice-type class) 
          (~compute-lattice-type class () direct-super-lattice-types))
    (setf (?class-precedence-list class)  (list class))
    (setf (?initargs class) direct-initargs)
    (setq effective-slots (create-tail-slot-defs class direct-slot-specs))
    (setf (?effective-slots class) effective-slots)
    (setf (?representation class)
          (~compute-representation class representation allocation))
    (compute-and-ensure-tail-slot-accessors class effective-slots)
    class))

(defmethod ~initialize ((class <imported-class>) initlist)
  (let ((name (get-option ^name initlist nil))
        (direct-superclasses (get-option ^direct-superclasses initlist nil))
        (effective-slot-specs (get-option ^effective-slot-descriptions initlist nil))
        (direct-initargs (get-option ^direct-initargs initlist nil))
        (direct-super-lattice-types (get-option ^direct-super-lattice-types 
                                                initlist nil))
        (representation (get-option ^representation initlist nil))
	(converter (get-option ^converter initlist nil))
        )

  ; resetting of annotations holding intermediate informations during
  ; compilation 
  (setf (?place class) nil)
  
  (cond ((null (?identifier class)) 
         (setf (?identifier class) name))
        ((eq (?identifier class) name))
        (t (warn "identifiers for class name (~A) and binding (~A) are not the same"
                 name (?identifier class))))
  (setf (?supers class) direct-superclasses)
  (mapc (lambda (superclass)
          (push class (?subclasses superclass)))
        direct-superclasses)
  (setf (?lattice-type class) 
        (~compute-lattice-type class direct-superclasses
                               direct-super-lattice-types))
  (setf (?class-precedence-list class) 
        (~compute-class-precedence-list class direct-superclasses))
  (setf (?initargs class)
        (~compute-initargs class direct-initargs
                           (~compute-inherited-initargs class direct-superclasses)))
  (setf (?effective-slots class) 
        (~compute-slot-descriptions class effective-slot-specs
                                    ()))
  (setf (?representation class)
        (~compute-representation class representation 
                                 nil)) ; no allocation
  (setf (?converter class) converter)
  class))

;;; -----------------------------------------------------------------------------------
;;; ~compute-class-precedence-list
;;; -----------------------------------------------------------------------------------
(defmethod ~compute-class-precedence-list ((class <class-def>)
                                           direct-superclasses)
  (cons class (~class-precedence-list (car direct-superclasses))))

(defmethod ~compute-class-precedence-list ((class <class-def>)
                                           (direct-superclasses <null>))
  (list class))


;;; -----------------------------------------------------------------------------------
;;; ~compute-inherited-slot-descriptions, ~compute-slot-descriptions
;;; -----------------------------------------------------------------------------------


(defmethod ~compute-inherited-slot-descriptions ((class <class-def>) 
                                                 direct-superclasses)
  (list (~class-slot-descriptions (car direct-superclasses))))

(defmethod ~compute-inherited-slot-descriptions ((class <class-def>) 
                                                 (direct-superclasses <null>))
  (list nil))


(defmethod ~compute-slot-descriptions ((class <class-def>) 
                                       direct-slot-specs 
                                       inherited-slot-descriptions)
  (nconc (mapcar (lambda (inherited-slot)
                   (create-specializing-slot class inherited-slot direct-slot-specs))
                 (car inherited-slot-descriptions))
         (create-slot-defs class direct-slot-specs 
                           (car inherited-slot-descriptions))))

(defmethod ~compute-slot-descriptions ((class <imported-class>) 
                                       effective-slot-specs 
                                       not-used)
  ; in case of imported classes the list of effective slots is given such that
  ; no inheritance for slots is necessary
  (create-slot-defs-of-imported-class class effective-slot-specs))

(defgeneric create-specializing-slot (class inherited-slot direct-slot-specs))

(defmethod create-specializing-slot ((class <class-def>) 
                                     inherited-slot direct-slot-specs)
  ; creates slot-specs for slots specializing inherited ones and for slots
  ; simply inherited from superclass without specialization
  (let* ((specializing-slot (make-instance <slot-desc> 
                             :identifier (~slot-description-name inherited-slot)
                             :specializes inherited-slot
                             :slot-of class))
         (slot-spec (find (~slot-description-name inherited-slot) direct-slot-specs
                          :key (lambda (slot-spec) (get-option ^name slot-spec nil))))
         (initfunction (get-option ^initfunction slot-spec nil))
         (type (get-option ^type slot-spec nil))
         (initarg (get-option ^initarg slot-spec nil))
         )
    (when initfunction
      (setf (?slot initfunction) specializing-slot))
    (setf (?initfunction specializing-slot) 
          (or initfunction (?initfunction inherited-slot)))
    (cond ((null initfunction) 
           (setf (?initvalue specializing-slot) 
                 (?initvalue inherited-slot)))
          ((function-with-constant-value-p initfunction) 
           (setf (?initvalue specializing-slot) 
                 (get-constant-function-value initfunction))))
    (setf (?type specializing-slot) 
          (or type (?type inherited-slot)))
    (setf (?initarg specializing-slot)
          (if (and initarg
                   (?initarg inherited-slot))
            (progn
              (error-redefinition-of-inherited-initarg
               specializing-slot
               inherited-slot
               initarg)
              (?initarg inherited-slot))
            (or initarg (?initarg inherited-slot))))
    specializing-slot))

(defgeneric function-with-constant-value-p (fun))
(defmethod function-with-constant-value-p ((fun <generic-fun>)) nil)
(defmethod function-with-constant-value-p ((fun <simple-fun>))
  (let ((body (?body fun)))
    (and (null (eq body ^unknown))
         (or (and (named-const-p body)
                  (null (eq (?value body) ^unknown)))
             (sym-p body)
             (structured-literal-p body)
             (literal-instance-p body)
             (class-def-p body)
             (fun-p body)
             (null (lzs-object-p body)) ; for example a number
             ))))

(defun get-constant-function-value (fun)
  (let ((value (?body fun)))
    (if (named-const-p value)
      (?value value)
      value)))

(defun create-slot-defs (class direct-slot-specs inherited-slot-descriptions)
  ; creates new slot definition, which means slot definitions introduced by the
  ; current class and not inherited from the superclass
  (if (null direct-slot-specs) 
    nil
    (let* ((slot-spec (car direct-slot-specs))
           (name (get-option ^name slot-spec nil))
           (initfunction (get-option ^initfunction slot-spec nil))
           (initarg (get-option ^initarg slot-spec nil)))
      (if (find name inherited-slot-descriptions
                :key #'~slot-description-name)
        ; it was a slot specialization
        (create-slot-defs class (cdr direct-slot-specs)
                          inherited-slot-descriptions)
        ; it was a slot definition, a new slot-description must be created 
        (let ((slot (make-instance <slot-desc>
                      :identifier name
                      :initfunction initfunction
                      :initarg initarg
                      :type (get-option ^type slot-spec %object)
                      :slot-of class)))
          (when initfunction
            (setf (?slot initfunction) slot)
            (when (function-with-constant-value-p initfunction)
              (setf (?initvalue slot) 
                    (get-constant-function-value initfunction))))
          (cons slot
                (create-slot-defs class (cdr direct-slot-specs)
                                  inherited-slot-descriptions)))))))

(defmethod create-slot-defs-of-imported-class (class effective-slot-specs)
  ; creates new slot definitions for all given effective slots
  (mapcar (lambda (slot-spec)
            (make-instance <slot-desc>
              :identifier (get-option ^name slot-spec nil)
              :code-identifier (get-option ^c-identifier slot-spec nil)
              :initarg (get-option ^initarg slot-spec nil)
              :type (get-option ^type slot-spec %object)
              :slot-of class))
          effective-slot-specs))

(defun create-tail-slot-defs (class slot-specs)
  (if (null slot-specs) 
    nil
    (let* ((slot-spec (car slot-specs))
           (name (get-option ^name slot-spec nil))
           (initfunction (get-option ^initfunction slot-spec nil))
           (initarg (get-option ^initarg slot-spec nil))
           (reader? (get-option ^reader slot-spec nil))
           (writer? (get-option ^writer slot-spec nil))
           (slot (make-instance <slot-desc>
                   :identifier name
                   :initfunction initfunction
                   :initarg initarg
                   :type (get-option ^type slot-spec %object)
                   :slot-of class)))
      (when initfunction
        (setf (?slot initfunction) slot))
      (when reader? (setf (?reader slot) t))
      (when writer? (setf (?writer slot) t))
      (cons slot
            (create-tail-slot-defs class (cdr slot-specs))))))
  
;;; -----------------------------------------------------------------------------------
;;; ~compute-inherited-initargs, ~compute-initargs
;;; -----------------------------------------------------------------------------------
(defmethod ~compute-inherited-initargs ((class <class-def>)
                                        direct-superclasses)
  (list (?initargs (car direct-superclasses))))

(defmethod ~compute-inherited-initargs ((class <class-def>)
                                        (direct-superclasses <null>))
  (list nil))


(defmethod ~compute-initargs ((class <class-def>)
                              initargs inherited-initarg-lists)
  (remove-duplicates (append initargs (car inherited-initarg-lists))))

;;; -----------------------------------------------------------------------------------
;;; ~compute-representation defined in representation.em
;;; ~compute-constructor defined in mm-initialize.em
;;; ~compute-predicate defined in mm-initialize.em
;;; -----------------------------------------------------------------------------------

;;; -----------------------------------------------------------------------------------
;;; Initialization of the Slot Access Protocol
;;; -----------------------------------------------------------------------------------

(defmethod ~compute-and-ensure-slot-accessors 
           ((class <standard-class-def>) effective-slots inherited-slots) 
  ; a reader and a writer is generated for every type of slot (new,
  ; specializing, inherited) to get different signatures for the type inference 
  (mapc (lambda (slot)
          (setf (?reader slot) 
                (~compute-slot-reader class slot effective-slots))
          (setf (?writer slot) 
                (~compute-slot-writer class slot effective-slots)))
        effective-slots)
  effective-slots)

;(defmethod ~compute-and-ensure-slot-accessors 
;           ((class <%string>) effective-slots inherited-slots) 
;  ; to avoid creation of accessors for slot 'length' of %string because this is
;  ; not allowed before apply-level-2
;  (mapc (lambda (slot)
;          (unless (eq ^length (~slot-description-name slot))
;            (setf (?reader slot) 
;                  (~compute-slot-reader class slot effective-slots))
;            (setf (?writer slot) 
;                  (~compute-slot-writer class slot effective-slots))))
;        effective-slots)
;  effective-slots)

(defun compute-and-ensure-tail-slot-accessors (class slots) 
  (mapc (lambda (slot)
            (when (?reader slot)
              (setf (?reader slot) (~compute-slot-reader class slot slots)))
            (when (?writer slot)
              (setf (?writer slot) (~compute-slot-writer class slot slots))))
        slots)
  slots)

; The methods for ~compute-slot-reader and ~compute-slot-writer are defined in
; mm-initialize.em 

;;; -----------------------------------------------------------------------------------
;;; Initialization of Generic Functions and Methods
;;; -----------------------------------------------------------------------------------

(defmethod ~initialize ((gf <defined-generic-fun>) options)
  ;options are: name domain range method-class method*
  ;additional option for the compiler: parameters
  (let ((name (get-option ^name options nil))
        (domain (get-option ^domain options nil))
        (range (get-option ^range options nil))
        (method-class (get-option ^method-class options nil))
        (params (get-option ^parameters options nil)))
    (cond ((null (?identifier gf)) 
           (setf (?identifier gf) name))
          ((eq (?identifier gf) name))
          (t (warn "identifiers for generic function name (~A) and binding (~A) are not the same"
                   name (?identifier gf))))
    (setf (?domain gf) domain)
    (setf (?params gf) params)
    (setf (?range-and-domain gf)
          (apply #'vector range domain))    
    gf))

(defmethod ~initialize ((method <method-def>) options)
  ;options are: domain range function generic-function
  (let ((domain (get-option ^domain options nil))
        (range (get-option ^range options nil))
        (function (get-option ^function options nil))
        (generic-function (get-option ^generic-function options nil)))
    (setf (?domain method) domain)
    (setf (?fun method) function)
    (setf (?generic-fun method) generic-function)
    (setf (?range-and-domain function)
          (apply #'vector range domain))
    method))

(defmethod ~add-method ((gf <global-generic-fun>) (method <method-def>))
  (when (method-valid-p method gf)
    (push method (?method-list gf)))
  gf)

(defmethod ~add-method ((gf <imported-generic-fun>) (method <method-def>))
  (when t ; (method-valid-p method gf) this test should be used but the problem
          ; is that sometimes the method functions are declared in the .def-file
          ; after the generic function is declared and so the method functions
          ; have the slot params not set when add-method is called
    (push method (?method-list gf)))
  gf)

(defmethod ~add-method (gf (method <method-def>))
  ; it is not allowed to add a method to other things than generic functions
  (error-invalid-gf-for-add-method gf)
  nil)

(defun method-valid-p (method gf)
  (cond ((non-congruent-lambda-lists-p (?params (?fun method)) 
                                       (?params gf))
         (error-non-congruent-lambda-lists method gf)
         nil)
        ((incompatible-method-domain-p (?domain method) 
                                       (?domain gf))
         (error-incompatible-method-domain method gf)
         nil)
        ((method-domain-clash-p method gf)
         (error-method-domain-clash method gf)
         nil)
        (t t)))

(defun non-congruent-lambda-lists-p (params1 params2)
  (null (and (= (length (?var-list params1))
                (length (?var-list params2)))
             (if (?rest params1) 
               (?rest params2)
               (null (?rest params2))))))

(defun incompatible-method-domain-p (method-domain gf-domain)
  (cond ((null method-domain) nil)
        ((~subclassp (car method-domain)
                     (car gf-domain))
         (incompatible-method-domain-p (cdr method-domain)
                                       (cdr gf-domain)))
        (t t)))

(defun method-domain-clash-p (method gf)
  (find (?domain method) (?method-list gf)
        :key #'?domain
        :test #'equal))

#module-end
