;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: predicates -*-
#|
$__copyright
-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    predicates.em
Version: 2.0 (last modification on Wed May 25 12:52:03 1994)
State:   proposed

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/predicates.em[2.0]:
  some general predicates
[1.1] Tue Feb  8 16:10:43 1994 akind@isst published
  [Tue Feb  8 10:12:01 1994] Intention for change:
  unknown-applications-p should be exported
[1.2] Mon Feb 28 10:48:45 1994 imohr@isst saved
  basic system compilation: first step (not yet error free)
[1.3] Thu May  5 11:52:24 1994 imohr@isst proposed
  separate compilation of eulisp0
[1.4] Mon Jun 20 11:55:03 1994 imohr@isst proposed
  [Wed May 25 12:50:08 1994] Intention for change:
  discriminating functions can't be exported for lisp
  Beiratssitzung Abschluss
[2.0] Mon Jun 20 11:55:03 1994 imohr@isst proposed
  [Wed May 25 12:50:08 1994] Intention for change:
  discriminating functions can't be exported for lisp
  Beiratssitzung Abschluss

-----------------------------------------------------------------------------------
|#

#module predicates
(import (eulisp0
	 lzs
	 accessors)
 syntax (eulisp0)
 expose ()
 export (*compilation-type*  ; set by function compile in module apply-compiler
         *basic-system*      ; set by function load-basic-modules in module apply-compiler
	 signature-needed-for-code-generation-p
         exported-for-lisp-p 
         exported-p
         class-sealed-p
         generic-function-sealed-p
	 unknown-applications-p
         is-lisp
         ))

;;; -----------------------------------------------------------------------------------
;;; global variables
;;; -----------------------------------------------------------------------------------
(deflocal *compilation-type* nil) 
; actually the following values are supported: 
; :application :basic-system


(deflocal *basic-system* nil)
; holds either () if no precompiled basic system is used or the module
; describing the basic system (got from a .def-file)

;;; -----------------------------------------------------------------------------------
;;; 
;;; -----------------------------------------------------------------------------------
(defun signature-needed-for-code-generation-p (fun)
  ;answer whether the type scheme can be set to nil
  (or (null (eq *compilation-type* :application))
      (null (special-sys-fun-p fun))))

;;; -----------------------------------------------------------------------------------
;;; the following functions may be used after mark-as-exported was called (in
;;; compile[apply-compiler] 
;;; -----------------------------------------------------------------------------------

(defun exported-for-lisp-p (obj)
  (and (eq *compilation-type* :basic-system)
       (global-p obj)
       (?exported obj)
       (null (discriminating-fun-p obj))))

(defun exported-p (obj)
  (and (global-p obj)
       (?exported obj)))

(defun class-sealed-p (class)
  ; returns true if it is impossible to create an additional subclass for class
  ; outside the compilation unit (i.e in using modules or at runtime)
  (or (null (?exported class))
      (eq *compilation-type* :application)))

(defun generic-function-sealed-p (gf)
  ; returns true if it is impossible to add additional methods outside the
  ; compilation unit (i.e in using modules or at runtime) 
  (or (null (?exported gf))
      (eq *compilation-type* :application)))

;;; -----------------------------------------------------------------------------------
;;; the following functions may be called after side effect analysis
;;; -----------------------------------------------------------------------------------

(defun unknown-applications-p (fun)
  (or (?exported fun)
      (?expanded-literal fun)))

;;; -----------------------------------------------------------------------------------
;;; tests for lisp functions
;;; -----------------------------------------------------------------------------------

(defun is-lisp (obj)
  (or (null (imported-p obj))
      (eq (?language obj) ^lisp)))

#module-end
