;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: messages -*-
#|
$__copyright
-----------------------------------------------------------------------------------
TITLE: Signalling Compiler Messages
-----------------------------------------------------------------------------------
File:    messages.em
Version: 2.0 (last modification on Wed Feb  9 15:07:39 1994)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/ukriegel/Eu2C/Apply/messages.em[2.0]:
  some basic stuff for generating error, warning, and info messages
[2.0] Fri Feb 25 14:05:44 1994 imohr@isst proposed
  some basic stuff for generating error, warning, and info messages

-----------------------------------------------------------------------------------
|#

#module messages
(import (eulisp0
         configuration
         lzs accessors
         (only (format *terminal-io*) common-lisp))
 syntax (eulisp0
         dynamic)
 export (write-message
         write-message-conditional))

(deflocal *line-length* 75)

(defun write-message (key message . args)
  (write-msg key message args))

(defun write-message-conditional (level key format . args)
  (unless (< (dynamic *info-level*) level)
    (write-msg key format args)))

(defun write-msg (key message args)
  (when key
    (let ((header 
           (format nil "~A~@[ in module '~(~A~)'~]"
                   key
                   (if (dynamic *current-module*)
                     (?identifier (dynamic *current-module*))
                     nil))))
      (format *terminal-io*
              "~%--- ~A ~V{-~}~%~
               ~@[--- in form ~((~2{~A ~} ...)~)~%~]"
              header
              (- *line-length* (length header) 5)
              '(())
              (dynamic current-defining-form)
              )))
  (format *terminal-io* "~?" message args)
  (when key (format *terminal-io* "~%~V{-~}" *line-length* '(()))))

#module-end
