;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs-main -*-
#|
$__copyright
-----------------------------------------------------------------------------------
TITLE: EuLisp-to-LZS-Transformer: the common parts
-----------------------------------------------------------------------------------
File:    el2lzs-main.em
Version: 2.0 (last modification on Mon Feb 28 16:00:17 1994)
State:   proposed

DESCRIPTION:
This module contains all things which are needed for the implementation of
transformation rules (implemented in EL2LZS-RULES) and for the work with
LZS-modules. It provides also the function TRANS-MODULE which transforms an
EuLisp-Module in list-representation into an LZS-module.

DOCUMENTATION:

NOTES:
Up to now no error-checking or error-handling takes places. This means, that
the incoming EuLisp-module must be in correct syntax.

REQUIRES:

PROBLEMS:
To avoid module dependency cycles type-inference::set-signature-from-classes was
used with explicit package qualifier. In the future el2lzs-main should be
divided into 2 modules.

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 

 10.06.1992 Ingo Mohr
 initial version
 
 11.06.1992 Ingo Mohr
 - tested and debugged
 - function-objects with body=UNDEFINED are now created if an unbound lexical
 variable appears in functional position

 15.06.1992 Ingo Mohr
 bug in creation of defined-sym removed (the name-slot is now set) 

 16.06.1992 Ingo Mohr
 all slots of undefined functions are set 

 17.06.1992 Ingo Mohr
 - require/provide removed because of incompatibility and loading problems
 - added: handling of export

Log for /export/home/saturn/ukriegel/Eu2C/Apply/el2lzs-main.em[2.0]:
  Main part of the frontend.
[1.1] Wed Mar 17 08:55:50 1993 imohr@isst proposed
  Transmod can now return a list of bindings.
[1.2] Wed Mar 31 10:38:59 1993 imohr@isst proposed
  literals for structures, literal expanders and expose ok
[1.3] Mon Apr 19 15:44:05 1993 imohr@isst proposed
  without warning when searching for a class binding for lattice-types
[1.4] Mon Apr 19 18:54:53 1993 imohr@isst saved
  now message _whole-form_ not used is avoided
[1.5] Tue Apr 20 16:05:45 1993 imohr@isst proposed
  format instead of warn for lexical binding not found
[1.6] Tue Apr 27 17:30:04 1993 imohr@isst proposed
  initfunction of module now calls initialization of used modules
[1.7] Thu May  6 11:11:09 1993 imohr@isst saved
  ignore bad exports (no lexical binding for an exported identifier)
[1.8] Fri May  7 13:41:00 1993 imohr@isst saved
  result-type for module-init-functions
[1.9] Fri May  7 14:41:33 1993 imohr@isst proposed
  
[1.10] Tue May 11 13:41:38 1993 imohr@isst saved
  error when marking exported things removed
[1.11] Tue May 11 14:46:52 1993 imohr@isst saved
  error in mark-as-exported
[1.12] Wed May 12 12:33:02 1993 imohr@isst proposed
  
[1.13] Mon May 24 16:27:05 1993 imohr@isst saved
  * initfunctions are calling only needed other initfunctions
  * checking for name clashes during import and expose
  * reverse the lists of objects in a module
[1.14] Tue May 25 10:59:43 1993 imohr@isst proposed
  error messages more beautiful
[1.15] Thu Jun  3 17:39:05 1993 imohr@isst proposed
  symbols
[1.16] Thu Jul 15 15:42:24 1993 ukriegel@isst proposed
  [Thu Jul 15 15:13:06 1993] Intention for change:
  replace $
  done
[1.17] Thu Aug 26 15:03:02 1993 imohr@isst published
  [Thu Aug 26 11:01:07 1993] Intention for change:
  add signature in init-functions for TI
  using symbol-function and find-symbol to avoid recursive modules
[1.18] Mon Sep 27 11:08:52 1993 imohr@isst proposed
  [Fri Sep 24 11:34:48 1993] Intention for change:
  error when compiling this module
  defclass (CL) -> defstandardclass
[1.19] Thu Sep 30 12:50:22 1993 imohr@isst proposed
  [Thu Sep 30 12:45:14 1993] Intention for change:
  + <module-init-function>
[1.20] Fri Oct 15 17:34:12 1993 imohr@isst proposed
  [Thu Oct 14 08:17:50 1993] Intention for change:
  new style module syntax
[1.21] Mon Oct 18 16:55:54 1993 imohr@isst saved
  [Mon Oct 18 09:28:08 1993] Intention for change:
  correct syntax error messages
[1.22] Wed Oct 20 14:03:25 1993 imohr@isst proposed
  errors
[1.23] Wed Oct 20 18:44:47 1993 imohr@isst published
  [Wed Oct 20 14:04:05 1993] Intention for change:
  --- no intent expressed ---
[1.24] Tue Nov  9 11:34:58 1993 imohr@isst proposed
  [Mon Nov  1 15:36:18 1993] Intention for change:
[1.25] Wed Nov 24 08:47:33 1993 imohr@isst proposed
  
[1.26] Tue Nov 30 14:11:34 1993 imohr@isst proposed
  interface construction with more error detection
[1.27] Tue Dec  7 17:07:49 1993 imohr@isst proposed
  <binding> extracted and moved to new module binding.em
[1.28] Fri Jan 14 15:18:47 1994 imohr@isst proposed
  module-id -> module
[1.29] Mon Feb  7 08:26:13 1994 imohr@isst published
  [Tue Dec  7 17:15:56 1993] Intention for change:
  --- no intent expressed ---new slot access and imported classes ok
[1.30] Fri Feb 11 12:02:31 1994 wheick@isst proposed
  [Thu Feb 10 09:13:45 1994] Intention for change:
  insert eulisp0,1
  done
[1.31] Mon Feb 28 10:47:03 1994 imohr@isst saved
  basic system compilation: first step (not yet error free)
[1.32] Thu May  5 11:52:10 1994 imohr@isst proposed
  separate compilation of eulisp0
[2.0] Thu May  5 11:52:10 1994 imohr@isst proposed
  separate compilation of eulisp0

-----------------------------------------------------------------------------------
|#

#module el2lzs-main
(import ((except (member concatenate) eulisp1)
         class-ext
         (only (first second third fourth nthcdr caar
                      concatenate intern
                      push pushnew string make-instance delete-if delete-if-not
                      class-of find-if
                      delete delete-duplicates remove-if-not cddr nsubst
                      append mapcar assoc mapc mapcan member reverse subclassp nconc get
                      listp stringp vector) 
           common-lisp)
         lzs accessors
         binding
         el2lzs-load
         el2lzs-error)
 syntax (eulisp1
         el2lzs-basic
         class-ext
         (only (case declare ignore) 
           common-lisp))
 expose (lzs
         accessors
         el2lzs-basic)
 expose ((only (first rest cadar caar
                      make-instance
                      ignore declare
                      case)
           common-lisp)))

;;; -----------------------------------------------------------------------------------
;;; For debugging and error messages
;;; -----------------------------------------------------------------------------------
(export-syntax with-defining-form)

(defmacro with-defining-form body
  `(dynamic-let ((current-defining-form 
                  (or (dynamic current-defining-form) ;to shadow mapping of def-forms
                      (whole-form))))
     ,@body))

;;; -----------------------------------------------------------------------------------
;;; initialization of transformations
;;; -----------------------------------------------------------------------------------

(define-transformation trans)

(define-transformation transmod)

(define-transformation transdef)

(define-transformation transsyn)

;;; -----------------------------------------------------------------------------------
;;;  some environments for transformations
;;; -----------------------------------------------------------------------------------

(export find-in-env 
        find-in-lex-env find-in-symbol-env find-in-dynamic-env find-in-mac-env
        find-lexical-binding
        find-syntax-binding
        make-undefined-function
        add-to-lex-env add-to-lex-env* in-lex-env
        find-module
        module-env
        env-plus
        reset-environments
        )

(export-syntax lex-env ; only an identifier, nesseciary when using in-lex-env
  )

;ATTENTION: the environments are not handled right, the lex must be
;module-specific and the dynamic and the symbol must be global!!! ?????

(defun find-in-env (env id)
  (get-lzs-object
   (find-binding env id)))

(defun find-binding (env id)
  (find-if (lambda (el)
              (eq id (?identifier el)))
            env))

; adds one new element to an environment if it is not NIL
; in the cases when this element cannot be NIL cons is used for efficiency 
(defun env-plus (new env)
  (if (null new)
    env
    (cons new env)))

;;; -----------------------------------------------------------------------------------
(defvar lex-env ())                     ; the lexical environment
                                        ; which can grow and shrink

(defun find-in-lex-env (id)
  (or (find-in-env (dynamic lex-env) id)
      (error-no-lexical-binding id)))

(defun find-lexical-binding (id)
  (or (find-binding (dynamic lex-env) id)
      (error-no-lexical-binding id)))

(defun add-top-lexical (obj)
  (cond ((null (member (?identifier obj) (dynamic lex-env)
                       :key #'?identifier))
         (push obj (dynamic lex-env))
         t)
        ((member (?identifier obj) 
                 (?lex-env (dynamic *current-module*)) ;here are only the
                                                       ;imported bindings
                 :key #'?identifier)
         (error-redefinition-of-imported-lexical obj)
         nil)
        (t (error-redefinition-of-top-lexical obj)
           nil)))

(defun add-to-lex-env (obj)
  (push obj (dynamic lex-env)))

(defun add-to-lex-env* (objects)
  (dynamic-setq lex-env
                (append objects (dynamic lex-env))))

(defmacro in-lex-env (new-env . forms)
  `(let ((lex-env (dynamic lex-env)))
     (dynamic-let ((lex-env ,new-env))
                  ,@forms)))

;;; -----------------------------------------------------------------------------------
(defvar mac-env ())                     ; the lexical environment for syntax expansion

(defun find-in-mac-env (id)
  (find-in-env (dynamic mac-env) id))

(defun add-to-mac-env (obj)
  (push obj (dynamic mac-env)))

;;; -----------------------------------------------------------------------------------
(defvar symbol-env ())                  ; the set of used symbols

(defun find-in-symbol-env (id)
  (find-in-env (dynamic symbol-env) id))

(defmacro add-to-symbol-env (obj)
  `(push ,obj (dynamic symbol-env)))

;;; -----------------------------------------------------------------------------------
(defvar dynamic-env ())                 ; the set of dynamic variables
; (all are viewed as global ones)
(defun find-in-dynamic-env (id)
  (find-in-env (dynamic dynamic-env) id))

(defmacro add-to-dynamic-env (obj)
  `(push ,obj (dynamic dynamic-env)))

(defvar undefined-functions () )

(defun make-undefined-function (fun)
  (let ((undefined-fun (find-in-env (dynamic undefined-functions) fun)))
    (unless undefined-fun
      (setq undefined-fun
            (make-instance <global-fun>
              :identifier fun
              :params ()
              :body 'undefined))
      (dynamic-setq undefined-functions
                    (nconc (dynamic undefined-functions) (list undefined-fun))))
    undefined-fun))

;;; -----------------------------------------------------------------------------------
(deflocal module-env ())                  ; the set of modules 

(defun find-module (id)
(find-in-env module-env id))

(defmacro add-to-module-env (mod)
`(let ((mod ,mod))
   (push mod module-env)
   mod))

;;; -----------------------------------------------------------------------------------

(defun reset-environments ()
  (setq module-env (list (find-module ^%tail)))
  (dynamic-setq dynamic-env nil)
  (dynamic-setq symbol-env nil))

;;; -----------------------------------------------------------------------------------
;;; %TAIL: the basic module
;;; -----------------------------------------------------------------------------------
(export $tail-module)

(defconstant $tail-module (make-instance <module> :identifier ^%tail))

(add-to-module-env $tail-module)

;;; -----------------------------------------------------------------------------------
;;;  auxilliary functions
;;; -----------------------------------------------------------------------------------

(export instance-of-p find-instances-of make-defined-sym)

(defun instance-of-p (instance class)
(subclassp (class-of instance) class))

(defun find-instances-of (zws-class environment)
(remove-if-not (lambda (obj)
                   (instance-of-p obj zws-class))
               environment))

(defun make-defined-sym (id)
; creates a <defined symbol> in package "eulisp" and adds it to the global symbol
; environment 
  (let ((sym (find-in-symbol-env id)))
    (unless sym
      (setq sym (make-instance <defined-sym>
                  :name (string id)
                  :package "eulisp"
                  :identifier id))
      (add-to-symbol-env sym))
    sym))

;;; -----------------------------------------------------------------------------------
;;; transformation of a module definition: the main function
;;; -----------------------------------------------------------------------------------

(export trans-module)

(defvar *current-module* nil)
(defvar waiting-export-directives nil)

(defun trans-module (module-def)
(let* ((name (second module-def))
       body
       (%unsigned-word-integer           ; to avoid recursive modules
        (find-in-env (?lex-env (find-module 'es::%tail))
                     'es::%unsigned-word-integer))
       (%eq                             ; to avoid recursive modules
        (find-in-env (?lex-env (find-module 'es::%tail))
                     'es::%eq))
       ($unsigned-0 (make-instance <literal-instance> 
                    :class %unsigned-word-integer
                    :value-list '(0)))
       ($unsigned-1 (make-instance <literal-instance> 
                    :class %unsigned-word-integer
                    :value-list '(1)))
       (initflag (make-instance <global-static> 
                   :identifier (list ^init name ^done)
                   :module ()
                   :type %unsigned-word-integer
                   :initial-value $unsigned-0)))
(dynamic-let ((*current-module* (make-instance <module> :identifier name))
              (waiting-export-directives nil))
  (setq body (trans-module-header module-def))
  (setf (?module initflag) (dynamic *current-module*))

  (dynamic-let ((mac-env (?syntax-env (dynamic *current-module*))))
    (setq body 
         (transsyn (cons 'es::progn body)))); syntaxexpands the forms and
                                        ; simplifies syntax as embedded progn's
                                        ; and implicit progn's

  (setq body                            ; this is neccesary because of the
                                        ; progn-simplification 
        (cond ((null body) nil)         ; no expressions?
              ((and (consp body)        ; more than 1 expression?
                    (eq (first body) 'es::progn))
               (cdr body))
              (t (list body))))         ; exactly 1 expression

  (dynamic-let ((lex-env (?lex-env (dynamic *current-module*))) ;imported bindings
                (dynamic-env (remove-if-not #'dynamic-p 
                                            (?var-list (dynamic *current-module*))))
                #|(symbol-env (?sym-list (dynamic *current-module*)))|#
                (undefined-functions ()))

    (setq body (collect-top-lexicals body))

    ; now the module holds its top-level lexical environment and the object-lists
    ; are filled with the global defined objects with empty structure part 

    ;now handle the collected export-directives from the module header
    (trans-export-directives (dynamic waiting-export-directives))

    (setq body (mapcan #'transdef body)); transforms bodies of defs, handles
                                        ; exports and collects top-level forms
    ;  (make-interface-file (dynamic lex-env)
    ;                       (dynamic symbol-env))

    (push initflag (?var-list (dynamic *current-module*)))
    (setq body 
          (make-instance <if-form>
            :pred
            (make-instance <app>
              :function %eq
              :arg-list (list (make-instance <var-ref> :var initflag)
                              $unsigned-0))
            :then
            (make-instance <progn-form> 
              :form-list (append (used-modules-initialization 
                                  (?used-runtime-modules (dynamic *current-module*))) 
                                 body
                                 (list (make-instance <setq-form>
                                         :location (make-instance <var-ref> 
                                                     :var initflag)
                                         :form $unsigned-1))))
            :else
            $unsigned-1))
    
    (setf (?toplevel-forms (dynamic *current-module*))
          (make-instance <module-init-fun>
            :range-and-domain (vector %unsigned-word-integer)
            :params (make-instance <params>)
            :body body                
            :exported () 
            :identifier (module-init-function-name name)
            :module (dynamic *current-module*)))
    (cl:funcall (cl:symbol-function
                 (cl:find-symbol (string 'set-signature-from-classes)
                                 "TI-SIGNATURE"))
     (?toplevel-forms (dynamic *current-module*))
     (list %unsigned-word-integer))

    ; the extension of the module list was placed here to guarantee that all
    ; modules which are needed by import or by expose are already in the module
    ; environment 
    (add-to-module-env (dynamic *current-module*))

    ; reverse the collected objects in the module such that the order of
    ; definitions in the generated code is the same as in the source
    (setf (?fun-list (dynamic *current-module*)) 
          (reverse (?fun-list (dynamic *current-module*))))
    (setf (?class-def-list (dynamic *current-module*)) 
          (reverse (?class-def-list (dynamic *current-module*))))
    (setf (?named-const-list (dynamic *current-module*)) 
          (reverse (?named-const-list (dynamic *current-module*))))
    (setf (?var-list (dynamic *current-module*)) 
          (reverse (?var-list (dynamic *current-module*))))
    (setf (?sym-list (dynamic *current-module*)) 
          (reverse (?sym-list (dynamic *current-module*))))

    (dynamic *current-module*)
    ))))

(defun collect-top-lexicals (body)
  ; collects top-level lexical bindings and removes forms which redefines
  ; previously defined top lexicals
  (setq body
        (mapcar (lambda (form)
                  (dynamic-let ((current-defining-form form))
                     ;to provide the current form for error message output
                     (if (add-top-lexical-bindings (transmod form))
                       form nil)))
                body))
  (setf (?lex-env (dynamic *current-module*)) (dynamic lex-env))
  body)

(defun add-top-lexical-bindings (binding-s)
  (cond ((null binding-s) t)
        ((null (consp binding-s))
         (add-top-lexical binding-s))
        ((add-top-lexical-bindings (car binding-s)) 
         (add-top-lexical-bindings (cdr binding-s)))
        (t ;if the car leads to an error then the rest of the lexical bindings
           ;should also be added, at least to get possible error messages, 
           ;but the overall result is FALSE
         (add-top-lexical-bindings (cdr binding-s))
         nil)))

(defun module-init-function-name (module-name)
  (list ^init module-name))

(defun used-modules-initialization (modules)
  (if (null modules) nil
      (let ((initfun (?toplevel-forms (car modules))))
        (if (null initfun)
          (used-modules-initialization (cdr modules))
          (cons (make-instance <app> :function initfun :arg-list () )
                (used-modules-initialization (cdr modules)))))))

(defun splice-lists (l)
  (cond ((null l) nil)
        ((listp (car l))
         (nconc (car l) (splice-lists (cdr l))))
        ((null (cdr l)) l)
        (t (splice-lists-1 l))))

(defun splice-lists-1 (l)
  ;l has at least 2 elements andits first one isn't a list
  (cond ((null (cdr l)) 
         (if (listp (car l)) (car l) l))
        ((listp (second l))
         (setf (cdr l)
               (nconc (second l) (splice-lists (cddr l))))
         l)
        ((null (cddr l)) l)
        (t (splice-lists (cdr l))
           l)))

;;; -----------------------------------------------------------------------------------
;;; transformation of interface modules
;;; -----------------------------------------------------------------------------------

(export set-module-init-function)

(defun trans-if-module (module-def)
(let* ((name (second module-def)))
(dynamic-let ((*current-module* (make-instance <module> :identifier name))
              (waiting-export-directives nil))
  (setq body (trans-module-header module-def))

  (dynamic-let ((lex-env (?lex-env (dynamic *current-module*))) ;imported bindings
                (dynamic-env (remove-if-not #'dynamic-p 
                                            (?var-list (dynamic *current-module*))))
                #|(symbol-env (?sym-list (dynamic *current-module*)))|#
                (undefined-functions ()))

    (setq body (collect-top-lexicals body))

    ; now the module holds its top-level lexical environment and the object-lists
    ; are filled with the global defined objects with empty structure part 

    ;now handle the collected export-directives from the module header
    (trans-export-directives (dynamic waiting-export-directives))

    (setq body (mapcan #'transdef body)); transforms bodies of defs, handles
                                        ; exports and collects top-level forms
    ;  (make-interface-file (dynamic lex-env)
    ;                       (dynamic symbol-env))

    ; the initfunction in ?toplevel-forms is set by %annotate-function with key
    ; init-function 

    ; the extension of the module list was placed here to guarantee that all
    ; modules which are needed by import or by expose are already in the module
    ; environment 
    (add-to-module-env (dynamic *current-module*))

    ; reverse the collected objects in the module such that the order of
    ; definitions in the generated code is the same as in the source
    (setf (?fun-list (dynamic *current-module*)) 
          (reverse (?fun-list (dynamic *current-module*))))
    (setf (?class-def-list (dynamic *current-module*)) 
          (reverse (?class-def-list (dynamic *current-module*))))
    (setf (?named-const-list (dynamic *current-module*)) 
          (reverse (?named-const-list (dynamic *current-module*))))
    (setf (?var-list (dynamic *current-module*)) 
          (reverse (?var-list (dynamic *current-module*))))
    (setf (?sym-list (dynamic *current-module*)) 
          (reverse (?sym-list (dynamic *current-module*))))

    (dynamic *current-module*)
    ))))

(defun set-module-init-function (fun key value)
  (setf (?toplevel-forms (dynamic *current-module*))
        fun))

;;; -----------------------------------------------------------------------------------
;;; transformation of module header
;;; -----------------------------------------------------------------------------------

(defun trans-module-header (module-def)
  (if (has-old-style-module-header module-def)
    (trans-old-style-module-header module-def)
    (progn (trans-directives (third module-def))
           (cdr (cddr module-def)))))

(defun has-old-style-module-header (module-def)
  (and (>= (length module-def) 4)
       (consp (fourth module-def))
       (eq ^syntax (car (fourth module-def)))))

(defun trans-old-style-module-header (module-def)
  (info-old-style-module-header module-def)
  (trans-imports (third module-def))    ; creates the imported lexical
                                        ; environment
  (trans-old-style-syntax-imports (fourth module-def))
  (trans-old-style-local-syntax-definitions (cddr (fourth module-def)))
  (cddr (cddr module-def)))

(defun trans-directives (module-directives)
  (cond ((null module-directives) nil)
        ((null (consp module-directives))
         (error-bad-module-directive module-directives nil))
        ((null (cdr module-directives))
         (error-bad-module-directive (car module-directives) nil))
        ((null (member (first module-directives)
                       ^(import syntax expose export c-import)))
         (error-bad-module-directive (first module-directives)
                                     (second module-directives))
         (trans-directives (cddr module-directives)))
        ((null (listp (second module-directives)))
         (error-bad-module-directive (first module-directives)
                                     (second module-directives))
         (trans-directives (cddr module-directives)))
        (t
         (trans-directive (first module-directives)
                          (second module-directives))
         (trans-directives (cddr module-directives)))))

(defun trans-directive (key value)
  (cond ((eq key ^export)
         ; this must wait until all imports and all global
         ; lexicals are collected
         (dynamic-setq waiting-export-directives
                       (cons value (dynamic waiting-export-directives))))
        ((eq key ^expose)
         (trans-expose value))
        ((eq key ^import)
         (trans-imports value))
        ((eq key ^syntax)
         (trans-syntax-imports value))
        ((eq key ^c-import)
         (trans-c-imports value))
        ))

(defun trans-imports (import-specs)
  (setf (?lex-env (dynamic *current-module*))
        (append
         (compute-runtime-interface import-specs)
         (?lex-env (dynamic *current-module*)))))

(defun trans-syntax-imports (import-specs)
  (setf (?syntax-env (dynamic *current-module*))
        (append
         (compute-syntax-interface import-specs)
         (?syntax-env (dynamic *current-module*)))))

(defun trans-expose (import-specs)
  (let ((iface (compute-interface import-specs t t)))
    (setf (?exports (dynamic *current-module*))
          (append (if-import iface)
                  (?exports (dynamic *current-module*))))
    (setf (?syntax-exports (dynamic *current-module*))
          (append (if-syntax iface)
                  (?syntax-exports (dynamic *current-module*))))
;    (format t "~%exposed by ~A: ~%import=~A~%syntax=~A" 
;            (?identifier (dynamic *current-module*))
;            (mapcar #'?identifier (if-import iface))
;            (mapcar #'?identifier (if-syntax iface)))
    ))

(defun trans-c-imports (file-spec-list)
  (mapc (lambda (file)
          (if (or (symbolp file)
                  (stringp file))
            (setf (?c-imports (dynamic *current-module*))
                  (cons file (?c-imports (dynamic *current-module*))))
            (error-bad-c-import-spec file)))
        file-spec-list))

(defun trans-export-directives (export-directives)
  (mapc (lambda (export-spec)
          (transdef (cons ^export export-spec)))
        export-directives))

;;; -----------------------------------------------------------------------------------
;;; analyzing import specification
;;; -----------------------------------------------------------------------------------

(defun compute-runtime-interface (import-specs)
  (if-import (compute-interface import-specs t nil)))

(defun compute-syntax-interface (import-specs)
  (if-syntax (compute-interface import-specs nil t)))

(defgeneric trans-old-style-syntax-imports (import-specs))

(defmethod trans-old-style-syntax-imports ((import-specs <null>))
  nil)

(defmethod trans-old-style-syntax-imports ((import-specs <pair>))
  (if (and (eq (first import-specs) ^syntax)
           (cdr import-specs)
           (listp (second import-specs)))
    (setf (?syntax-env (dynamic *current-module*))
          (append
           (compute-syntax-interface (second import-specs))
           (?syntax-env (dynamic *current-module*))))
    (error-bad-old-style-syntax-import import-specs)
    ))

(defmethod trans-old-style-syntax-imports (import-specs)
  (error-bad-old-style-syntax-import import-specs))




(defun compute-interface (import-specs import? syntax?)
  (let ((iface (compute-interface-without-check import-specs import? syntax?)))
    (mk-if
     (delete-duplicates (if-import iface)
                        :test #'equal-binding-p)
     (delete-duplicates (if-syntax iface)
                        :test #'equal-binding-p))))

(defun equal-binding-p (binding1 binding2)
  (cond ((eq binding1 binding2) ; a shortcut for the following test
         t)
        ((eq (?identifier binding1)
             (?identifier binding2))
         (unless (eq (get-lzs-object binding1)
                     (get-lzs-object binding2))
           (error-name-clash binding1 
                             binding2))
         t)
        (t nil)))

(defun compute-interface-without-check (import-specs import? syntax?)
  (append-if-s
   (mapcar (lambda (import-spec) 
             (compute-interface-1 import-spec import? syntax?))
           import-specs)))

(defun compute-interface-1 (import-spec import? syntax?)
  (if (symbolp import-spec)            ; a module name
    (mk-if (and import? (module-runtime-interface import-spec))
           (and syntax? (module-syntax-interface import-spec)))
    (let ((interface (compute-interface-without-check (cddr import-spec)
                                                      import? syntax?)))
      (case (car import-spec)
        (ES::except (except-interface (second import-spec) interface import-spec))
        (ES::only   (only-interface   (second import-spec) interface import-spec))
        (ES::rename (rename-interface (second import-spec) interface import-spec))))))

; an interface in this context is a pair of import bindins and syntax bindings
(defun if-import (interface)
  (car interface))

(defun if-syntax (interface)
  (cdr interface))

(defun add-if (import syntax interface)
  (mk-if (if import (cons import (if-import interface)) (if-import interface))
         (if syntax (cons syntax (if-syntax interface)) (if-syntax interface))))

(defun mk-if (import syntax)
  (cons import syntax))

(defun if-diff (if1 if2)
  (mk-if (if-diff-1 (if-import if1)
                    (if-import if2))
         (if-diff-1 (if-syntax if1)
                    (if-syntax if2))))

(defun if-diff-1 (if1 if2)
  (cond ((null if1) nil)
        ((member (car if1) if2)
         (if-diff-1 (cdr if1) if2))
        (t (cons (car if1)
                 (if-diff-1 (cdr if1) if2)))))

(defun append-if-s (if-list)
  (mk-if (mapcan #'if-import if-list)
         (mapcan #'if-syntax if-list)))

(defun except-interface (identifiers interface if-spec)
  (if-diff interface
           (only-interface identifiers interface if-spec)))

(defun only-interface (identifiers interface if-spec)
  (if (null identifiers) nil
      (let ((object-in-import
             (member (car identifiers) (if-import interface) 
                     :key #'?identifier))
            (object-in-syntax
             (member (car identifiers) (if-syntax interface) 
                     :key #'?identifier)))
        (cond ((and object-in-import object-in-syntax)
               (warning-binding-in-import-and-syntax (car identifiers) if-spec)
               (add-if (and object-in-import (car object-in-import))
                       nil
                       (only-interface (cdr identifiers) interface if-spec)))
              ((or object-in-import object-in-syntax)
               (add-if (and object-in-import (car object-in-import))
                       (and object-in-syntax (car object-in-syntax))
                       (only-interface (cdr identifiers) interface if-spec)))
              (t
               (warning-non-existent-binding-in-interface (car identifiers) if-spec)
               (only-interface (cdr identifiers) interface if-spec))))))

(defun rename-interface (rename-spec interface if-spec)
  (let ((bindings-to-be-renamed
         (only-interface (mapcar #'car rename-spec)
                         interface
                         if-spec)))
    (mk-if (mapcar (lambda (binding)
                     (rename-binding binding (if-import bindings-to-be-renamed) rename-spec))
                   (if-import interface))
           (mapcar (lambda (binding)
                     (rename-binding binding (if-syntax bindings-to-be-renamed) rename-spec))
                   (if-syntax interface)))))

(defun rename-binding (binding bindings-to-be-renamed rename-spec)
  (cond ((null bindings-to-be-renamed) binding)
        ((eq binding (car bindings-to-be-renamed))
         (make-binding :identifier (second (car rename-spec))
                       :refers-to binding))
        (t (rename-binding binding (cdr bindings-to-be-renamed) (cdr rename-spec)))))

(defun module-runtime-interface (module-id)
  (let ((module (find-or-load-module module-id)))
    (if module
      (progn
        (pushnew module (?used-runtime-modules (dynamic *current-module*))
                 :key #'?identifier)
        (copy-list (?exports module)))
      nil)))

(defun module-syntax-interface (module-id)
  (let ((module (find-or-load-module module-id)))
    (if module
      (progn
        (pushnew module (?used-syntax-modules (dynamic *current-module*))
                 :key #'?identifier)
        (copy-list (?syntax-exports module)))
      nil)))

;;; -----------------------------------------------------------------------------------
;;; loading module files
;;; -----------------------------------------------------------------------------------

(export load-module load-if-module)

(defun find-or-load-module (module-id)
(or (find-module module-id) (load-module module-id)))

(defun load-module (module-id)
(load-apply-module module-id #'trans-module))

(defun load-if-module (module-id)
(load-def-file module-id #'trans-if-module))

;;; -----------------------------------------------------------------------------------
;;; installing local syntax definitions
;;; -----------------------------------------------------------------------------------

(defun trans-old-style-local-syntax-definitions (defmacro-forms)
  (dynamic-let ((mac-env (?syntax-env (dynamic *current-module*)))
                (lex-env (?lex-env (dynamic *current-module*))))
     (setf (?syntax-env (dynamic *current-module*))
           (nconc (mapcar #'transmod defmacro-forms)
                  (?syntax-env (dynamic *current-module*))))))

#module-end
