/*****************************************************************************\
*                                                                             *
*       			trace.c		   		              *
*									      *
\*****************************************************************************/
#include <stdio.h>
#include <setjmp.h>
#include "xalloc_conf.h"
#include "xalloc_misc.h"

/*****************************************************************************/
/** some definitions only used by the collector -- instead of a header file **/
/*****************************************************************************/


		/* at first some machine dependent definitions */
#define stack_grows_down

#ifdef	sparc

#define DATASTART	&etext
#define	STACKTOP	stacktop

#define	SAVE_REGS()	asm("t	3")	/* ST_FLUSH_WINDOWS */	

#endif	sparc

#ifdef	__hp9000s700

#undef stack_grows_down
#define stack_grows_up

#define DATASTART	0x40001000
#define STACKTOP	stacktop

#define SAVE_REGS()	save_registers()	/* an assembler written func. */
#define NB_REGS		29
void * reg_safe[NB_REGS];	/* the space to put the register contents to */

#endif	__hp9000s700

#ifndef sparc
#ifndef __hp9000s700
	--> unsupported machine <--
#endif
#endif


#define	MS_MARK	0x80000000	/* is set in length word of MS-obj. to mark */

#define ms_ismarked(p)	(*(p) & MS_MARK)
#define ms_mark(p)	(*(p) |= MS_MARK)
#define ms_unmark(p)	(*(p) &= ~MS_MARK)


#define	stack_not_empty		(stkpointer != stktop)

#ifdef	STACK_ON_HEAP

#define	STKSIZE		CARDSIZE
#define	init_gc_stack()		{stkpointer = stktop = (long *) sbrk(STKSIZE); \
					endofstack = (long *) sbrk(0);}
#define	remove_gc_stack()	brk(stktop)
#define	inc_gc_stack(e)		{sbrk(STKSIZE); e = (long *) sbrk(0);}
#define	gcpop(p)		(long *)*(--p)
#define	gcpush(v,p,e)	{ if(p == e) inc_gc_stack(e);	\
				*p++ = (long)(v);}

#else		/* stack on machine stack */

#define	init_gc_stack()		{int i; stktop = (long *)((long)&i - STACKGAP);\
					stkpointer = stktop;}
#define	remove_gc_stack()	{/* nothing to be removed */}
#define gcpop(p)		(long *)*(++p)
#define	gcpush(v,p,e)	{*p-- = (long)(v);}

#endif		/* STACK_ON_HEAP */

#define	itrace(v,p,e)	if(p_in_heap(v)) gcpush(v,p,e)

#define	mark_card(c)		(c)->root = NULL
#define card_marked(c)		((c)->root == NULL)

/*****************************************************************************/
/*******************************  rootset  ***********************************/
/*****************************************************************************/
#ifdef ROOT_SET_IN_USE

long	ROOTSET[MAX_ROOT_SET_ENTRIES];
long	*ROOTSETEND = ROOTSET;

void
initialize_root_set()
{
	ROOTSETEND = ROOTSET;
}

void
add_to_root_set(p)
	void	*p;
{
#ifdef SECURITY_FIRST
	if(ROOTSETEND >= &ROOTSET[MAX_ROOT_SET_ENTRIES])
		error("Unable to insert root address");
	else
#endif
		*ROOTSETEND++ = (long)p;
}

void
delete_from_root_set(p)
	void	*p;
{
	long	*l;
	for(l = ROOTSET; ((l<ROOTSETEND) && (*l!=(long)p)); l++);
	if(l<ROOTSETEND)
		*l = *(--ROOTSETEND);
}
#else

extern	end, etext;	/* all locations of static data */

#endif

/*****************************************************************************/
/********************************  trace  ************************************/
/*****************************************************************************/

long	*stktop, *stkpointer, *endofstack;

void trace_pointer(ptr)	/* to be called from user defined mark functions */
register long *ptr;
{ 
	itrace(ptr, stkpointer, endofstack);
}

/************************ predefined mark functions **************************/

void trace_all(ptr, length)
register long	**ptr;
register long	length;
{
	length>>=2;
	while(length > 0){
		length--;
		itrace(ptr[length],stkpointer,endofstack);
	}
}

void trace_nothing(ptr, length)
register long	**ptr;
register long	length;
{
	/* nothing to do */
}

void trace_first(ptr, length)
register long	**ptr;
register long	length;
{
	itrace(ptr[0],stkpointer,endofstack);
}

void trace_second(ptr, length)
register long	**ptr;
register long	length;
{
	itrace(ptr[1],stkpointer,endofstack);
}

void trace_pair(ptr, length)
register long	**ptr;
register long	length;
{
	itrace(ptr[0],stkpointer,endofstack);
	itrace(ptr[1],stkpointer,endofstack);
}


/*****************************************************************************
*                   multi-thread stack allocation                            *
*****************************************************************************/
void mark_all_roots();

#ifndef NOTHREADS

static int nb_threads = 0;
static ithread ithreadpool = NULL;

ithread get_ithread_from_pool(){
	if(ithreadpool == 0){
		return 0;
	} else {
		ithread it = ithreadpool;
		ithreadpool = ithread_next(it);
		ithread_use(it);
		return it;
	}
}

ithread get_new_ithread(){
	ithread it;
	{int i = (int)sbrk(sizeof(struct ithread) + 4);
	if(i % 8 != 0) i += 4;
	it = (ithread) i;}
	ithread_use(it);
	bzero((char *)(it->th_Freepts), sizeof(it->th_Freepts));
	return it;
}

long register_thread(){	/* returns a number to be used in the next few funct's*/
	ithread it;
	if(it = get_ithread_from_pool()){
		return ithread_nb(it);
	} else {
		Threads[++last_used_thread] = 0;
		return last_used_thread; 
	}
}

long * get_thread_stack(long i){
	if(Threads[i] == 0)
		Threads[i] = get_new_ithread();
	return ithread_stack(Threads[i]);
}

jmp_buf * get_thread_mach_state(long i){
	if(Threads[i] == 0)
		Threads[i] = get_new_ithread();
	return &ithread_mach_state(Threads[i]);
}

void unregister_thread(long i){
	ithread_unuse(Threads[i]);
	ithread_next(Threads[i]) = ithreadpool;
	ithreadpool = Threads[i];
	ithread_nb(Threads[i]) = i;
}
	

static jmp_buf main_machine_state;
#define MAIN_SP_ADR	sp_adr(main_machine_state)
static main_still_active = 1;

jmp_buf * get_main_mach_state(){
	return &main_machine_state;
}

void unregister_main_thread(){	/* main-thread has ended */
	main_still_active = 0;
}

void mark_thread_stacks(){
	int i;
	long * top;
	ithread it;
	for(i = 1; i <= last_used_thread; i++){
		it = Threads[i];
		if(ithread_used(it)){
			top = ithread_stack(it);
			if(i == current_thread_nb)	/* jmp-buf not actual */
				mark_all_roots((long *)(&i), top);
			else {
				mark_all_roots((long *)(ithread_sp(it)), top);
				mark_all_roots((long *)(ithread_mach_state(it)),
		(long *)((char *)(ithread_mach_state(it)) + sizeof(jmp_buf)));
			}
		}
	}
	/* now for the main-thread */
	if(main_still_active)
		if(current_thread_nb == 0)
			mark_all_roots((long *)(&i), stacktop);
		else {
			mark_all_roots((long *)(* MAIN_SP_ADR), stacktop);
			mark_all_roots((long *)(main_machine_state),
		(long *)((char *)(main_machine_state) + sizeof(jmp_buf)));
		}
}

#endif

#ifdef NOTHREADS
#define THREADS_RUNNING (0)
#define CURRENT_THREAD_NB (0)
#else
#define THREADS_RUNNING	(last_used_thread != 0)
#define CURRENT_THREAD_NB current_thread_nb
#endif

void trace_from_gc_stack();

void mark_machine_stack()
{
	int i;

	/* Here the stack is complete in any way, and we must get something
	 * like the stack pointer. Some bytes more or less doesn't matter,
	 * because we are at least two function calls deep in the memory
	 * management (our own values haven't to be traced from), and we leave
	 * a large gap when putting our mark stack below the stack_pointer.
	 * So we decide to use (&i) for this purpose.
	 */

#ifdef stack_grows_down
	mark_all_roots((long *)&i, (long *)STACKTOP);
#else
#ifdef stack_grows_up
	mark_all_roots((long *)STACKTOP, (long *)&i);
#else
	--> where else does the stack grow ??
#endif
#endif
}

void
marking()		/* first phase of our mark/sweep - collector */
{
	register long *p;
	register card *c;
	long i;

	/* The first function_call is used to put all registers onto the stack. 
	 * For Sparc_machines, this "function" is defined as an assembler
	 * statement above; it may be also defined for other machines.
	 */
	SAVE_REGS();

#ifndef NOTHREADS
	if(THREADS_RUNNING)		/* multi-thread-version */
		mark_thread_stacks();
	else
#endif					/* single-thread-version */
		mark_machine_stack();

	/* trace from root set or from all globals resp. data pages */
#ifdef	ROOT_SET_IN_USE
	{
	  register long *rsp = stkpointer;
	  register long *reos = endofstack;
	  for(p = ROOTSET; p < ROOTSETEND; p++){
		register long *g = (long *)*p;
#ifdef SECURITY_FIRST
		if(!is_pointer(g)) 	/* did the user add something wrong
					 * to the root set ?
					 */
			error("mark: wrong root in root set");
#endif
		itrace((long *)*g,rsp,reos);

	  }
#ifdef __hp9000s700	/* possibly some additional roots on register-safe */
	  for(i = NB_REGS; i != 0; i--)
		itrace(reg_safe[i], rsp, reos);
#endif
	  stkpointer = rsp;
	  endofstack = reos;
	}
	trace_from_gc_stack();
#else	/* ! ROOT_SET_IN_USE */
	mark_all_roots((long *)&etext, gcarraybegin);
	mark_all_roots(gcarrayend, (long *)&end);
	/* hp9000's register-safe is scanned through, too */
#endif

	/* Now all locations reachable via registers, the stack or global
	 * variables are marked. We can return.
	 */
}


void mark_all_roots(from, to)
register long * from, * to;
{
	register long *rsp = stkpointer;
	register long *reos = endofstack;
	register long *p;

	/* We start marking with collecting all root addresses.
	 * We are trying to be a little faster when using two registers 
	 * for the stackpointer and the (possible) end of stack area.
	 */
	for(p = from; p < to; p++)
		itrace((long *)*p,rsp,reos);

	stkpointer = rsp;
	endofstack = reos;
	trace_from_gc_stack();
}


void trace_from_gc_stack()
{
	register long * p;
	register card * c;
	/* trace from the just built gc_stack. unfortunately, we can't use
	 * registers to hold our markstackpointer, because it will be changed
	 * by called trace_functions, too */
	while(stack_not_empty){
		p = gcpop(stkpointer);
		c = CARD_ADDR(p);
		if(living_card(c)){	/* B/W - test */
#ifdef	USE_MTSS
		    if(mt_card(c)){
			long *fp = p-1;
			if(consistent_pointer(c,fp,get_size(c),get_mask(c)))
			  if(is_tdscr(*fp))
			    if(!ismarked(c,fp)){
				    mark(c,fp);
				    (get_mark_fcn(*fp)(p, get_real_size(c)));
				}
		    	continue;
		    }
#endif
#ifdef	USE_STMS
		    if(ms_card(c)){
			if(consistent_ms_pointer(c,p))
			  if(!ms_ismarked(p-1)){
			    ms_mark(p-1);
			    (get_mark_fcn(get_tdscr(c)))(p,get_ms_real_size(p));
			  }
		        continue;
		    }
#endif
#ifdef	USE_STSS
		    if(consistent_pointer(c,p,get_size(c),get_mask(c)))
			if(!ismarked(c,p)){
			    mark(c,p);
			    (get_mark_fcn(get_tdscr(c)))(p, get_real_size(c));
		    	}
#endif
		}
	}
}

/*****************************************************************************/
/********************************  sweep  ************************************/
/*****************************************************************************/

/* remove mark bits for objects in free lists of card-descriptor cd */
void
clear_fsl_marks(cd)
	register CardDscr cd;
{
	register long *p;
	register card *c;
	p = (long *)get_freept_addr(cd);
	while(p = (long *) *p){
		c = CARD_ADDR(p);
		if(ismarked(c,p))
			unmark(c,p);
	}
}

long
ss_sweep(c, cd)
	register card  *c;
	register CardDscr cd;
{
	register long  step, used, *fsl;
	register long  *pt = c->mkarea;
	register long  *en = pt + NB_OF_MARK_WORDS;

	/* At first test, whether this card is empty. This works very fast by
	 * checking 32 bits at ones.
	 */
	for(; (pt < en) && (*pt == 0); pt++);
	if(pt == en)	return(0);

	/* There are some marked objects on this card, build a list of the 
	 * other ones
	 */
	step = get_size_d(cd);
	fsl = get_free_object(cd);
	used = 0;
	pt = (long *)c + byte2word(CARDSIZE) - step;
	en = c->userspace;

	while(pt >= en){
		if(ismarked(c,pt)){	/* skip all marked objects */
			pt -= step;
			used += step;
		} else {		/* connect the others */
			*pt = (long)fsl;
			fsl = pt;

#ifdef	OPTIMIZED_POINTER_TESTS
	/* we migth have increased the size of the objects, so the (possibly
	 * unused but traced) end of these objects must be set to zero */
			if(step == 4)
				pt[3] = 0;
			else 
				if(step == 8){ 
					pt[5] = 0;
					pt[6] = 0;
					pt[7] = 0;
				}
#endif

			pt -= step;
		}
	}	
	/* write internal fsl to free list */
	store_free_object(cd,fsl);
	clear_marks(c);
	return(word2byte(used));
}


#ifdef USE_STMS
long
ms_sweep(c,cd)	/* assumes c to be pointer to ms_card, sweeps card and builds a
		 * free list on it, storing its space to the free list of its
		 * card_dscr. if an unmarked large object is found on the card,
		 * and some small objects stay there, the 'continued' cards
		 * will be reclaimed explicitely, because clean_card_list is
		 * unable to do this job.
		 * function returns number of bytes still in use.
		 */
register card		*c;
register CardDscr	cd;
{
	register int		new = 1;
	register vobject	*ifsl = (vobject *)get_free_object(cd);
	register long		*ptr = c->userspace;
	register long		*e = (long *)(c + 1);
	register long		used = 0;

	while(ptr < e){
	    if(ismarked(c,ptr)){	/* begin of object */
		if(ms_ismarked(ptr)){	/* surviver */
		    ms_unmark(ptr);	/* reset mark bit */
		    new = 1;   		/* free space will start after this */
		    used += *ptr;	/* still in use */
		    ptr += *ptr;	/* behind this object */
		} else {		/* no pointer to this obj, reclaim it */
		    unmark(c,ptr);	/* no longer begin of obj */
#ifdef USE_LARGE
		    if(*ptr>USERSPACE){	/* large object found */
			/* as this is the last object on that card, we can
			 * test, whether we found any surviver before this
			 * and break otherwise
			 */
			if(used == 0) break;
			/* the card stays used, we must reclaim the tail of now
			 * unused 'continued' cards and decrement c->cardnum
			 */
			reclaim_card(e, get_cardnum(c) - 1);
			put_cardnum(c,1);
			/* the part of this object which is on the first card
			 * will become a part of the free list as below
			 */
			if(new){
			    ((vobject *)ptr)->vlength = e - ptr; /* length */
			    ((vobject *)ptr)->vnext = ifsl;
			    ifsl = (vobject *)ptr;	/* into free list */
			    ptr = e;			/* behind card */
			} else {		/* concat. with before space */
			    ifsl->vlength += (e - ptr);	/* increase before */
			    ptr = e;			/* behind card */
			}
		    } else
#endif 
		    {
			if(new){		/* start of space */
			    ((vobject *)ptr)->vlength = *ptr; /* length */
			    ((vobject *)ptr)->vnext = ifsl;
			    ifsl = (vobject *)ptr;	/* into free list */
			    ptr += ((vobject *)ptr)->vlength;/* behind this */
			    new = 0;
			} else {		/* connect with before space */
			    ifsl->vlength += *ptr; /* increase before space */
			    ptr += *ptr;	   /* behind this object */
			}
		    }
		}
	    } else {			/* found part of former free list */
		if(new){		/* start of space */
		    ((vobject *)ptr)->vnext = ifsl;
		    ifsl = (vobject *)ptr;
		    ptr += ((vobject *)ptr)->vlength;	/* behind this object */
		    new = 0;
		} else {		/* concat. with before space */
		    ifsl->vlength += ((vobject *)ptr)->vlength; /* inc before */
		    ptr += ((vobject *)ptr)->vlength;	/* behind this object */
		}
	    }
	}
	if(used > 0)		/* some bytes on that card are still in use */
		th_store_free_object(get_threadnb(c),cd,(long *)ifsl);
	return(word2byte(used));
}
#endif

/************** remove marked cards, close holes in cardlist *****************/
void
clean_card_list()
{
	register card **ci = first_card_index;

	while(ci < last_card_index){
	    if(card_marked(*ci)){
#ifdef	USE_LARGE
		reclaim_card(*ci,get_cardnum(*ci)); /* call to heap.c */
#else
		reclaim_card(*ci);
#endif
		prev_card_index(last_card_index);
		while((ci < last_card_index) &&(card_marked(*last_card_index))){
#ifdef	USE_LARGE
		   reclaim_card(*last_card_index,get_cardnum(*last_card_index));
#else
		   reclaim_card(*last_card_index);
#endif
		   prev_card_index(last_card_index);
		}
		if(ci < last_card_index){
			*ci = *last_card_index;
			(*ci)->root = ci;
		}
	    }
	    next_card_index(ci);
	}
}

void * (*hold_threads)() = NULL;
void * (*cont_threads)() = NULL;


/*****************************************************************************/
/***************************  garbage collection  ****************************/
/*****************************************************************************/

void
force_garbage_collection()
{
	register card	**ci, *c;
	register CardDscr	cd;
	register long used;
	register long bytes_in_use = 0;
	register int i;

#ifdef NOTHREADS
#define sweeped_cards	curnumcard
#define INC_SWEEPED_CARDS(x)
#else
	long sweeped_cards = 0;
#define INC_SWEEPED_CARDS(x)	(sweeped_cards += x)
#endif

        ++gc_count;
#ifdef GCREPORTS
	fprintf(stderr, "GC %D:",gc_count);
	fflush(stderr);
#endif

#ifndef NOTHREADS
#ifndef HOLD_ALL
	if (hold_threads != NULL) hold_threads();
#endif
#endif
	init_gc_stack();
	marking();
	remove_gc_stack();

#ifndef NOTHREADS
#ifndef HOLD_ALL
	if (cont_threads != NULL) cont_threads();
#endif
#endif
			/* inspect all cdscr's to sweep all cards,
			 * mark empty cards for later being removed */
	for(cd = 0; cd < last_used_card; cd++){
		ci = &Cards[cd];
#ifdef	USE_STMS
		if(ms_card_d(cd)){
			/* on the current thread: clear free list of that cd */
			store_free_object(cd, NULL);
			while(c = *ci){			/* c becomes *last */
			    if(get_threadnb(c) == CURRENT_THREAD_NB){
				INC_SWEEPED_CARDS(get_cardnum(c));
				if(used = ms_sweep(c,cd)){	/* not empty */
					bytes_in_use += used;
					ci = &(c->next);
				} else {		/* empty */
					*ci = c->next;	/* off_crd_lst*/
					mark_card(c);
				}
			    } else {
				ci = &(c->next);
			    }
			}
		} else 
#endif
		{	/* ss_card */
#ifdef	USE_LARGE
		    if(basiccards(get_size_d(cd)) == 1){
#endif
			/* clear mark bits for objects in free list because
			 * if any object in the free list has been marked by
			 * default, all objects behind this in free list
			 * will have been marked, too
			 */
			clear_fsl_marks(cd);	
			store_free_object(cd, NULL);
			while(c = *ci){
			    if(get_threadnb(c) == CURRENT_THREAD_NB){
				INC_SWEEPED_CARDS(1);
				if(used = ss_sweep(c,cd)){	/* not empty */
					bytes_in_use += used;
					ci = &(c->next);
				} else {		/* empty */
					*ci = c->next;	/* off_crd_lst*/
					mark_card(c);
				}
			    } else {
				clear_marks(c);
				ci = &(c->next);
			    }
			}
#ifdef	USE_LARGE
		    } else {	/* large cards in use on this carddscr. */
			while(c = *ci){
			    if(get_threadnb(c) == CURRENT_THREAD_NB){
				INC_SWEEPED_CARDS(get_cardnum(c));
				if(ismarked(c,c->userspace)){ /* surviver */
					unmark(c,c->userspace);
					bytes_in_use += get_real_size(c);
					ci = &(c->next);
				} else {
					*ci = c->next;	/* off_card_lst */
					mark_card(c);
				}
			    } else {
				large_unmark(c);
				ci = &(c->next);
			    }
			} /* end while */
		    } /* end if basiccards(...)==1 */
#endif
		} /* end if ms_card ... else ss_card */
	} /* end for each carddescriptor */

	clean_card_list();	/* may be inlined */

#ifdef  GCREPORTS
	fprintf(stderr, " %i of %i bytes reclaimed\n",
			CARDSIZE*curnumcard-bytes_in_use, CARDSIZE*curnumcard);
#endif
	if((GCDIFF * bytes_in_use) > (GCMULT * CARDSIZE * sweeped_cards))
		/* to few of our storage has been reclaimed, try to get more */
		inc_heap();
}


void xalloc_info()
{ /* print configuration and runtime info */
  fprintf(stderr,"\nNumber of Garbage Collections: %d",gc_count);
  fprintf(stderr,"\nInitial number of Cards %d",start_nb_of_cards);
  fprintf(stderr,"\nNumber of used Cards %d",curnumcard);
  fprintf(stderr,"\nLast heap increment %d",hincr);
  fprintf(stderr,"\nGCMULT %d GCDIFF %d HMULT %d HDIFF %d",GCMULT,GCDIFF,HMULT,HDIFF);
#ifdef ROOT_SET_IN_USE
  fprintf(stderr,"\nUserdefined root set was used");
#else
  fprintf(stderr,"\nAnonymous root set was used");
#endif
#ifdef STACK_ON_HEAP
  fprintf(stderr,"\nMarking stack was allocated on heap");
#else
  fprintf(stderr,"\nMarking stack was allocated on stack");
#endif
  fprintf(stderr,"\n");fflush(stderr);

}












