/*
-----------------------------------------------------------------------------------
TITLE: Initialization of c runtime constants
-----------------------------------------------------------------------------------
File:    c-runtime.c
Version: 1.2 (last modification on Thu Oct 14 14:13:21 1993)
State:   published

DESCRIPTION:
Initialization of runtime constants like size of FILE ore jmp_buf

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel
HISTORY: 
Log for /tmp_mnt/home/saturn/ukriegel/Dist/ApplyC/c-runtime.c[1.0]
	Wed Oct  6 19:32:07 1993 ukriegel@isst proposed $
 run time functions and initialization
 
c-runtime.c[1.1] Fri Oct  8 17:23:54 1993 ukriegel@isst proposed $
 [Fri Oct  8 13:28:27 1993] Intention for change:
 most-positive-fixnum
 most-positive-double
 
c-runtime.c[1.2] Thu Oct 14 14:13:46 1993 ukriegel@isst published $
 [Thu Oct 14 14:11:06 1993] Intention for change:
 delete error handler
 


-----------------------------------------------------------------------------------
*/


#include <stdio.h>
#include <setjmp.h>
#include <signal.h>
#include <float.h>
#include "xalloc_user.h"
#include "xalloc_misc.h"
#include "xalloc_conf.h"

#ifdef ROOT_SET_IN_USE
 long StaticLiteralBegin;
 long StaticLiteralEnd;
/*
 long StaticVariableRoot;
 long StaticObjectRoot;
 long StaticRootEnd;
*/

#endif


FILE *stdin_c;
long int size_of_file;
long int size_of_jmpbuf;
long int fpe_signal_code;
double most_positive_double_float;
double least_positive_double_float;
double most_negative_double_float; 
double least_negative_double_float;

#ifdef ROOT_SET_IN_USE
void gc_init()
{ long *ptr;
   void c_runtime_init();


   /* call runtime initialization of system constants */   
  /*
    for (ptr = (long *) StaticVariableRoot; ptr < (long *)&StaticObjectRoot; ++ptr)
    if(p_in_heap((void *)**ptr)
      add_to_root_set((void *))**ptr);

    for (ptr = (long *) StaticObjectRoot; ptr < (long  *)&StaticRootEnd; ++ptr)
    if(p_in_heap((void *)*ptr)
      add_to_root_set((void *) *ptr);

  */

 
  for(ptr = (long *)&StaticLiteralBegin;ptr < (long *)&StaticLiteralEnd; ptr++)
   if(p_in_heap((long *)*ptr))
      add_to_root_set((long *)*ptr); 
}

#endif

void c_runtime_init()
{
  stdin_c = stdin;
  size_of_file = sizeof(FILE);
  size_of_jmpbuf = sizeof(jmp_buf);
  fpe_signal_code = SIGFPE;
  most_positive_double_float = DBL_MAX;
  least_positive_double_float = DBL_MIN;
  most_negative_double_float = - DBL_MAX; 
  least_negative_double_float = -DBL_MIN;
#ifdef ROOT_SET_IN_USE
  gc_init();
#endif
}








