;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: type-inference -*-
#|
-------------------------------------------------------------------------------
TITLE: Main Type Inference File
-------------------------------------------------------------------------------
File:    type-inference.em
Version: 1.48 (last modification on Thu Dec  9 16:09:30 1993)
State:   proposed

DESCRIPTION:
Provides type inference functions, that are used in other
parts of the APPLY compiler.

DOCUMENTATION:

NOTES:

REQUIRES:
Other modules that are used for type inference directly or
indirectly by this module are:

ti-signature  Handling Type Schemes (Signatures)
ti-descr      Default Type Descriptors
ti-special    Special Inference with some System (TAIL) Functions
ti-comp       Inference with Compound Lattice Types
ti-const      Type Inference of Constants
ti-init       Initialization of the Typ Inference System
ti-meet-join  Operations on Type Expressions for Type Inference
ti-unify      A Modified Unification Algorithm for Type Inference
ti-eqs        Type Equations for Type Inference
ti-exprs      Type Expressions for Type Inference
ti-copy       Copying Type Inference Objects
ti-write      Formatting Type Inference Objects
ti-lattice    Lattice and Lattice Types Used for Type Inference
ti-codes      Encoding Lattice Types
ti            Auxiliary Functions and Parameters for Type Inference

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /tmp_mnt/home/saturn/akind/Lisp/Apply/type-inference.em[1.0]
	Tue Apr  6 13:58:49 1993 akind@isst save $
 
type-inference.em[1.1] Tue Apr  6 14:03:02 1993 akind@isst save $
 [Tue Apr  6 14:02:28 1993] Intention for change:
 
type-inference.em[1.2] Tue Apr  6 15:38:48 1993 akind@isst save $
 [Tue Apr  6 15:38:27 1993] Intention for change:
 log removed from the file header.
 
type-inference.em[1.3] Tue Apr  6 15:56:25 1993 akind@isst save $
 [Tue Apr  6 15:55:48 1993] Intention for change:
 
type-inference.em[1.4] Wed Apr  7 11:47:32 1993 akind@isst proposed $
 
type-inference.em[1.5] Wed Apr  7 14:53:34 1993 akind@isst proposed $
 
type-inference.em[1.6] Wed Apr  7 15:12:46 1993 akind@isst proposed $
 
type-inference.em[1.7] Wed Apr  7 18:02:37 1993 akind@isst proposed $
 
type-inference.em[1.8] Tue Apr 13 14:37:22 1993 akind@isst proposed $
 
type-inference.em[1.9] Tue Apr 13 14:52:37 1993 akind@isst proposed $
 
type-inference.em[1.10] Wed Apr 14 13:30:41 1993 akind@isst proposed $
 
type-inference.em[1.11] Fri Apr 16 18:12:27 1993 akind@isst proposed $
 
type-inference.em[1.12] Mon Apr 19 18:03:39 1993 akind@isst proposed $
 
type-inference.em[1.13] Tue Apr 20 17:37:53 1993 akind@isst proposed $
 
type-inference.em[1.14] Wed Apr 21 16:43:32 1993 akind@isst save $
 
type-inference.em[1.15] Fri May  7 10:59:56 1993 akind@isst proposed $
 
type-inference.em[1.16] Mon May 10 13:36:52 1993 ukriegel@isst proposed $
 [Mon May 10 09:40:47 1993] Intention for change:
 unify-descrs called without fun
 done
 
type-inference.em[1.17] Tue May 18 17:30:17 1993 akind@isst proposed $
 
type-inference.em[1.18] Mon May 24 12:10:35 1993 akind@isst proposed $
 
type-inference.em[1.19] Tue May 25 11:08:56 1993 akind@isst proposed $
 
type-inference.em[1.20] Tue May 25 11:44:58 1993 akind@isst proposed $
 
type-inference.em[1.21] Tue May 25 17:28:19 1993 akind@isst proposed $
 
type-inference.em[1.22] Wed May 26 12:12:36 1993 akind@isst proposed $
 
type-inference.em[1.23] Thu May 27 10:12:22 1993 akind@isst proposed $
 
type-inference.em[1.24] Mon Aug  9 14:30:22 1993 akind@isst proposed $
 
type-inference.em[1.25] Mon Aug  9 16:11:38 1993 akind@isst proposed $
 
type-inference.em[1.26] Fri Aug 20 17:23:02 1993 akind@isst proposed $
 
type-inference.em[1.27] Tue Aug 24 09:32:33 1993 akind@isst proposed $
 
type-inference.em[1.28] Tue Aug 24 16:24:51 1993 akind@isst proposed $
 
type-inference.em[1.29] Wed Aug 25 17:38:42 1993 akind@isst proposed $
 
type-inference.em[1.30] Fri Aug 27 17:29:19 1993 akind@isst published $
 
type-inference.em[1.31] Mon Sep 13 13:48:13 1993 akind@isst save $
 New header.
 
type-inference.em[1.32] Tue Sep 14 12:41:23 1993 akind@isst save $
 [Mon Sep 13 14:11:34 1993] Intention for change:
 
type-inference.em[1.33] Tue Sep 21 09:13:25 1993 akind@isst save $
 [Tue Sep 21 09:07:08 1993] Intention for change:
 
type-inference.em[1.34] Tue Sep 21 14:46:02 1993 akind@isst proposed $
 [Tue Sep 21 14:43:24 1993] Intention for change:
 
type-inference.em[1.35] Wed Sep 22 09:01:17 1993 akind@isst proposed $
 [Wed Sep 22 09:00:18 1993] Intention for change:
 
type-inference.em[1.36] Wed Sep 22 17:28:09 1993 akind@isst proposed $
 [Wed Sep 22 17:27:29 1993] Intention for change:
 
type-inference.em[1.37] Thu Sep 23 14:34:37 1993 akind@isst proposed $
 
type-inference.em[1.38] Fri Sep 24 10:04:54 1993 akind@isst save $
 
type-inference.em[1.39] Fri Oct  1 14:40:05 1993 akind@isst save $
 [Mon Sep 27 10:14:38 1993] Intention for change:
 
type-inference.em[1.40] Mon Oct 11 10:29:00 1993 akind@isst proposed $
 
type-inference.em[1.41] Tue Oct 12 17:12:13 1993 akind@isst published $
 
type-inference.em[1.42] Thu Oct 21 15:03:00 1993 akind@isst save $
 
type-inference.em[1.43] Tue Nov  2 16:21:09 1993 akind@isst save $
 
type-inference.em[1.44] Tue Nov  9 17:28:20 1993 akind@isst save $
 
type-inference.em[1.45] Tue Nov 16 13:11:43 1993 akind@isst proposed $
 
type-inference.em[1.46] Thu Nov 18 09:55:46 1993 akind@isst proposed $
 
type-inference.em[1.47] Thu Nov 18 17:12:23 1993 akind@isst proposed $
 
type-inference.em[1.48] Thu Dec  9 16:58:27 1993 akind@isst proposed $
 

-------------------------------------------------------------------------------
|#

#module-name type-inference
#module-import (ti lzs lzs-mop mzs lzs-modules tail-module apply-funs analyse-h
		   name-of-fun
		   ti ti-lattice  ti-exprs ti-eqs ti-write ti-copy ti-comp
		   ti-meet-join ti-signature ti-const ti-descrs ti-special
		   (only (mapc mapcar dotimes format terpri) common-lisp))
#module-syntax-import (ti)
#module-syntax-definitions
#module-header-end

;;; ---------------------------------------------------------------------------
;;; EXPORT
;;; ---------------------------------------------------------------------------

(EXPORT inference constant-type
	balance balance-applications
	filled-formal-descr filled-recursive-descr filled-actual-descr
	general-var-formal-descr general-var-recursive-descr
	general-var-actual-descr
	empty-formal-descr empty-recursive-descr empty-actual-descr
	get-descr-type set-descr-type get-previous-subs
	set-signature set-signature-from-classes set-predicate-signature
	reduce-descr set-joined-result-types
        convert-to-sys-type-vec class-as-type-expr
	check-result-subtypes check-subtype-exprs
	initialize-lattice general-type %object-type
	copy-descr-up-to ti-copy-subs
	ti-format ti-short-write ti-def-write)

;;; ---------------------------------------------------------------------------
;;; SPECIALIZING ACTUAL TYPE DESCRIPTORS
;;; ---------------------------------------------------------------------------

;; Inference step, i.e. a function is call with an actual type scheme.
(DEFUN inference (fun descrs)
  (ti-statistics *fun-call-key*)
  (if *use-compound-types*		; treat compound type?
      (mapc #'check-compound-types-before descrs))
  (let ((result-descrs (compute-inference fun descrs)))
  (if *use-compound-types*
      (mapc #'check-compound-types-after result-descrs))
  (ti-format2 t "~%== NEW DESCRS:~A" (ti-print-string result-descrs))
  result-descrs))

(DEFGENERIC compute-inference (fun descrs))

(DEFMETHOD compute-inference ((fun <fun>) descrs)
  (let ((formal-descrs ())
	(standard-inference nil))
    (cond ((eq fun %select)
	   (setq formal-descrs (convert-to-formal-descrs-%select descrs))
	   (setf (?signature fun) formal-descrs))
	  ((eq fun %setf-select)
	   (ti-statistics *%setf-select-key*)
	   (setq formal-descrs (convert-to-formal-descrs-%setf-select descrs))
	   (setf (?signature fun) formal-descrs))
	  ((eq fun %extract)
	   (setq formal-descrs (convert-to-formal-descrs-%extract descrs))
	   (setf (?signature fun) formal-descrs))
	  ((eq fun %setf-extract)
	   (setq formal-descrs (convert-to-formal-descrs-%setf-extract descrs))
	   (setf (?signature fun) formal-descrs))
	  ((eq fun %funcall)
	   (setq formal-descrs (convert-to-formal-descrs-%funcall descrs))
	   (setf (?signature fun) formal-descrs))
	  (t
	   (setq formal-descrs (?signature fun))
	   (setq standard-inference t)))
    (ti-format2 t "~%== FUNCTION DESCRS:~A" (ti-print-string fun))
    (ti-format2 t "~%== ACTUAL DESCRS:~A"
		(ti-print-string
		 (mapcar (lambda (descr)
			   (get-previous-subs (ti-copy-descr descr)))
			 descrs)))
    (if formal-descrs			; uncomplete signature?
	(if standard-inference
	    (unify-descrs fun descrs formal-descrs)
	  (unify-descrs fun descrs formal-descrs t))
      (let ((range-and-domain-descr (?type-descr fun)))
	(if range-and-domain-descr
	    (unify-descrs fun descrs (list range-and-domain-descr))
	  (mapcar #'get-previous-subs descrs))))))

(DEFMETHOD compute-inference ((fun <defined-generic-fun>) descrs)
  (ti-format2 t "~%== GENERIC FUNCTION DESCRS:~A" (ti-print-string fun))
  (if (null (?signature fun))
      (ti-format2 t "~%~A" (?identifier fun)))
  (ti-format2 t "~%== ACTUAL DESCRS:~A"
	      (ti-print-string
	       (mapcar (lambda (descr)
			 (get-previous-subs (ti-copy-descr descr)))
		       descrs)))
;  (ti-error)
  (let* ((formal-descrs (?signature fun))
	 (result-descrs
	  (if formal-descrs
	      (unify-descrs fun descrs formal-descrs)
	    (let ((range-and-domain-descr (?type-descr fun)))
;	      (ti-error)
	      (if range-and-domain-descr
		  (unify-descrs fun descrs (list range-and-domain-descr))
		(mapcar #'get-previous-subs descrs))))))
    (setq *actual-method-subset*
      (select-methods fun result-descrs))
;;    (cond (*ti-verbose*
;;	   (terpri) (terpri)
;;	   (ti-short-write t (mapcar #'ti-copy-descr result-descrs))
;;	   (terpri)
;;	   (ti-short-write-methods t (?method-list fun))
;;	   (format t "~%Notice: reduced possible methods ~A -> ~A"
;;		      (length (?method-list fun))
;;		      (length *actual-method-subset*))
;;	   (ti-short-write-methods t *actual-method-subset*)
;;	   (terpri) (terpri)))
    (ti-format2 t "~%== NEW DESCRS:~A" (ti-print-string result-descrs))
    (if (null *actual-method-subset*)
	(ti-error))			; no applicable method!
    result-descrs))

;;; Condense descriptor list to a single descriptor.
(DEFUN balance (descrs)
  (join-descrs-min (ti-copy-descr (car descrs)) (cdr descrs)))

;;; Condense application descriptor list to a single descriptor.
(DEFUN balance-applications (fun applications)
  (if (null *use-global-optimization*)
      (balance (?type-descr-s fun))
    (let* ((new-descr (balance (mapcar #'?type-descr applications)))
	   (old-descr (balance (?type-descr-s fun)))
	   (result-type (get-result-type new-descr))
	   (optimized ()))
      (format t "g")			; mark global optimization
      (if (%void-type-p result-type)
	  (set-result-type-min new-descr (get-result-type old-descr)))
;;      (cond (*ti-verbose*
;;	     (dotimes (i (length (?type-vec new-descr)))
;;	       (setq optimized
;;		 (or (null (and (subtype-expr-p
;;				 (get-arg-type old-descr i)
;;				 (get-arg-type new-descr i))
;;				(subtype-expr-p
;;				 (get-arg-type new-descr i)
;;				 (get-arg-type old-descr i))))
;;		     optimized)))
;;	     (if optimized
;;		 (progn
;;		   (format t "~2%Global optimization of ~A function ~A::~A~%"
;;			   (funtype-of fun)
;;			   (?module-id fun)
;;			   (name-of fun))
;;		   (ti-short-write t new-descr)
;;		   (format t "~%    instead of~%")
;;		   (ti-short-write t old-descr)))))
      new-descr)))

#module-end