;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-init -*-
#|
-------------------------------------------------------------------------------
TITLE: Initialization of the Typ Inference System
-------------------------------------------------------------------------------
File:    ti-init.em
Version: 1.11 (last modification on Mon Sep 27 15:45:54 1993)
State:   save

DESCRIPTION:
This module provides functions to reset and initialize the type
inference system

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /tmp_mnt/home/saturn/akind/Lisp/ti-init.em[1.0]
	Wed Apr 21 16:48:53 1993 akind@isst proposed $
 
ti-init.em[1.1] Wed May  5 11:25:26 1993 akind@isst proposed $
 
ti-init.em[1.2] Tue May 18 17:22:11 1993 akind@isst proposed $
 
ti-init.em[1.3] Thu Jun  3 13:09:22 1993 akind@isst proposed $
 
ti-init.em[1.4] Tue Aug  3 11:47:02 1993 akind@isst proposed $
 
ti-init.em[1.5] Wed Aug 11 13:34:57 1993 akind@isst proposed $
 
ti-init.em[1.6] Wed Aug 18 16:09:59 1993 akind@isst proposed $
 
ti-init.em[1.7] Fri Aug 20 17:23:20 1993 akind@isst proposed $
 
ti-init.em[1.8] Wed Aug 25 17:38:58 1993 akind@isst proposed $
 
ti-init.em[1.9] Fri Aug 27 17:29:46 1993 akind@isst published $
 
ti-init.em[1.10] Thu Sep 23 14:33:06 1993 akind@isst proposed $
 
ti-init.em[1.11] Fri Oct  1 14:41:12 1993 akind@isst save $
 [Mon Sep 27 10:47:59 1993] Intention for change:
 expose %pointer, %union, %prestruct .
 

-------------------------------------------------------------------------------
|#

		       		       		  
#module-name ti-init
#module-import (lzs mzs ti ti-codes ti-lattice ti-exprs ti-eqs ti-meet-join 
		    ti-write ti-signature
		    (only (mapc maphash dolist) common-lisp)) 
#module-syntax-import (ti)
#module-syntax-definitions
#module-header-end

;;; ---------------------------------------------------------------------------
;;; EXPORT
;;; ---------------------------------------------------------------------------

(EXPORT ti-initialize update-all-type-expr-codes)

;;; ---------------------------------------------------------------------------
;;; INITIALIZATION
;;; ---------------------------------------------------------------------------

;; Initialize the type inference system.
(DEFUN ti-initialize ()
  (reset-funs-with-defined-signatures)
  (reset-actual-type-var-id)
  (reset-lattice-type-values)
  (initialize-ti-statistics)
  (initialize-lattice)
  (add-sys-types))

;;; ---------------------------------------------------------------------------
;;; ADDING SYSTEM TYPES
;;; ---------------------------------------------------------------------------

;; Add the predefined system functions (TAIL functions) to the lattice.
(DEFUN add-sys-types ()
  (def-strategic-lattice-type ^(%number (top) (bottom)))
  (def-strategic-lattice-type ^(%integer (%number) (bottom)))
  (def-strategic-lattice-type ^(%unsigned-integer (%integer) (bottom)))
  (def-strategic-lattice-type ^(%signed-integer (%integer) (bottom)))
  (def-sys-lattice-type ^(%unsigned-byte-integer (%unsigned-integer) (bottom)))
  (def-sys-lattice-type ^(%signed-byte-integer (%signed-integer) (bottom)))
  (def-sys-lattice-type ^(%unsigned-half-integer (%unsigned-integer) (bottom)))
  (def-sys-lattice-type ^(%signed-half-integer (%signed-integer) (bottom)))
  (def-sys-lattice-type ^(%unsigned-word-integer (%unsigned-integer) (bottom)))
  (def-sys-lattice-type ^(%signed-word-integer (%signed-integer) (bottom)))
  (def-strategic-lattice-type ^(%float (%number) (bottom)))
  (def-sys-lattice-type ^(%single-float (%float) (bottom)))
  (def-sys-lattice-type ^(%double-float (%float) (bottom)))
  (def-sys-lattice-type ^(%extended-float (%float) (bottom)))
;;; ---------------------------------------------------------------------------
  (def-sys-lattice-type ^(%void (top) (bottom)))
  (def-strategic-lattice-type ^(%false (top) (bottom)))
;  (def-strategic-lattice-type ^(%character (top) (bottom)))
  (def-sys-lattice-type ^(%string (top) (bottom)))
;;; ---------------------------------------------------------------------------
  (def-strategic-lattice-type ^(%defined-type (top) (bottom)))
;  (def-strategic-lattice-type ^(%pointer (%defined-type) (bottom)))
;  (def-strategic-lattice-type ^(%vector (%defined-type) (bottom)))
  ;; All user defined classes are subclasses of %struct.
  (def-strategic-lattice-type ^(%struct (%defined-type) (bottom)))
;  (def-strategic-lattice-type ^(%prestruct (%defined-type) (bottom)))
;  (def-strategic-lattice-type ^(%union (%defined-type) (bottom)))
;;; ---------------------------------------------------------------------------
  (def-sys-lattice-type ^(%jmpbuf (top) (bottom)))
  (def-sys-lattice-type ^(%pjmpbuf (top) (bottom)))
;;; ---------------------------------------------------------------------------
  (def-sys-lattice-type ^(%function (top) (bottom))))

;;; ---------------------------------------------------------------------------
;;; RECOMPUTE THE CODES OF ALL TYPE EXPRESSIONS
;;; ---------------------------------------------------------------------------

;; Signatures are read in before all lattice types are included into the
;; lattice. Thus before inference starts the type expression codes have to
;; be updated.
(DEFUN update-all-type-expr-codes ()
  (ti-format t "~%Update all type expression codes ...")
  (maphash (lambda (key lattice-type)
	     (let ((expr (?atomic-expr lattice-type)))
	       (if expr
		   (setf (?code expr) (?code lattice-type)))))
	   *the-lattice-table*)
  (mapc #'update-type-expr-codes (funs-with-defined-signatures))
  (ti-format t " done."))

(DEFUN update-atomic-type-expr-codes (atomic-expr)
  (let ((new-code (?code (compute-to-atom (?name atomic-expr))))
	(old-code (?code atomic-expr)))
    (if (null (eq-code-p old-code new-code))
	(progn
	  (setf (?code atomic-expr) new-code)
	  (ti-format t "~%Notice: code of expr ~A updated"
		     (ti-print-string-no-cr atomic-expr))))))

(DEFGENERIC update-type-expr-codes (obj))

(DEFMETHOD update-type-expr-codes ((obj <type-descr>))
  (dolist (equ (?equations (?type-vars obj)))
    (let ((left-expr (?left-expr equ))
	  (right-expr (?right-expr equ)))
      (if (atomic-type-p left-expr)
	  (update-atomic-type-expr-codes left-expr))
      (if (atomic-type-p right-expr)
	  (update-atomic-type-expr-codes right-expr)))))

(DEFMETHOD update-type-expr-codes ((obj <fun>))
  (mapc #'update-type-expr-codes (?signature obj)))

#module-end