;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-eqs -*-
#|
-------------------------------------------------------------------------------
TITLE: Type Equations for Type Inference
-------------------------------------------------------------------------------
File:    ti-eqs.em
Version: 1.24 (last modification on Tue Dec  7 13:28:50 1993)
State:   proposed

DESCRIPTION:
Type equations are used in descriptors of type schemes. Type equations
allow to define equation systems to describe the dependencies between
argument and result types of polymorphic functions.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /tmp_mnt/home/saturn/akind/Lisp/Apply/ti-eqs.em[1.0]
	Tue Apr  6 13:22:40 1993 akind@isst proposed $
 
ti-eqs.em[1.1] Wed Apr 21 16:33:49 1993 akind@isst proposed $
 
ti-eqs.em[1.2] Wed May  5 11:25:08 1993 akind@isst save $
 
ti-eqs.em[1.3] Thu May  6 17:27:36 1993 akind@isst save $
 
ti-eqs.em[1.4] Fri May  7 12:10:15 1993 akind@isst save $
 
ti-eqs.em[1.5] Fri May  7 12:18:06 1993 akind@isst save $
 
ti-eqs.em[1.6] Fri May  7 14:14:54 1993 akind@isst save $
 
ti-eqs.em[1.7] Fri May  7 21:20:55 1993 akind@isst proposed $
 
ti-eqs.em[1.8] Tue May 18 17:23:11 1993 akind@isst proposed $
 
ti-eqs.em[1.9] Wed May 19 09:27:42 1993 akind@isst proposed $
 
ti-eqs.em[1.10] Wed May 19 13:10:21 1993 akind@isst proposed $
 
ti-eqs.em[1.11] Mon May 24 12:08:13 1993 akind@isst proposed $
 
ti-eqs.em[1.12] Tue May 25 11:08:16 1993 akind@isst proposed $
 
ti-eqs.em[1.13] Tue May 25 13:14:52 1993 akind@isst proposed $
 
ti-eqs.em[1.14] Thu Jul 22 13:43:42 1993 akind@isst proposed $
 
ti-eqs.em[1.15] Thu Jul 22 14:27:35 1993 akind@isst proposed $
 
ti-eqs.em[1.16] Thu Jul 22 14:34:04 1993 akind@isst proposed $
 
ti-eqs.em[1.17] Wed Aug 18 16:09:42 1993 akind@isst proposed $
 
ti-eqs.em[1.18] Fri Aug 20 14:20:53 1993 akind@isst proposed $
 
ti-eqs.em[1.19] Tue Aug 24 17:09:49 1993 akind@isst proposed $
 
ti-eqs.em[1.20] Fri Aug 27 17:29:34 1993 akind@isst published $
 
ti-eqs.em[1.21] Thu Sep 23 14:32:48 1993 akind@isst proposed $
 
ti-eqs.em[1.22] Fri Oct  1 14:40:49 1993 akind@isst save $
 [Thu Sep 23 15:43:58 1993] Intention for change:
 
ti-eqs.em[1.23] Mon Oct 11 10:30:00 1993 akind@isst published $
 
ti-eqs.em[1.24] Thu Dec  9 16:57:24 1993 akind@isst proposed $
 [Tue Dec  7 13:17:56 1993] Intention for change:
 

-------------------------------------------------------------------------------
|#


#module-name ti-eqs
#module-import (ti ti-lattice ti-exprs ti-meet-join
		   (only (position-if rplaca rplacd assoc) common-lisp))
#module-syntax-import (ti)
#module-syntax-definitions
#module-header-end

;;; ---------------------------------------------------------------------------
;;; EXPORT
;;; ---------------------------------------------------------------------------

(export <type-var-substitutions>
	?left-expr ?right-expr set-left-expr set-right-expr
	new-type-equation eval-to-equation
	contains-type-var-p
	substitute-type-var
	<type-equation-stack> ?equations
	push-type-equation pop-type-equation
	get-substitution get-last-substitution
	add-substitution add-equation
	join-substitutions append-substitutions condense-substitutions
	reduce-substitutions check-equality
	convert-to-atomic-type convert-to-slot-name
	convert-general-to-%object-type)

;;; ---------------------------------------------------------------------------
;;; TYPE EQUATIONS
;;; ---------------------------------------------------------------------------

(DEFSTANDARDCLASS <type-equation-stack> ()
  (equations :accessor :initarg :initform ()))

(DEFSTANDARDCLASS <type-var-substitutions> (<type-equation-stack>))

;;; Create a new type equation.
(DEFUN new-type-equation (left-expr right-expr)
  (cons left-expr right-expr))

(DEFUN eval-to-equation (expr-list)
  (new-type-equation (eval-to-expr (car expr-list))
		     (eval-to-expr (car (cdr expr-list)))))

;; Answer the left side of a type equation.
(DEFUN ?left-expr (equ)
  (car equ))

;; Answer the right side of a type equation.
(DEFUN ?right-expr (equ)
  (cdr equ))

;; Modify the left side of a type equation.
(DEFUN set-left-expr (equ expr)
  (rplaca equ expr))

;; Modify the right side of a type equation.
(DEFUN set-right-expr (equ expr)
  (rplacd equ expr))

;;; ---------------------------------------------------------------------------
;;; Substitutions of type variables inside of type equations.
(DEFUN substitute-type-var (eqs		;<type-equation-stack>
			    var-old	;<type-var>
			    expr-new)	;<type-expr>
  (if (null (eq-type-var-p var-old new-expr))
    (dolist (equ (?equations eqs))
      (let ((left-expr (?left-expr equ))
	    (right-expr (?right-expr equ)))
	(if (eq-type-var-p left-expr var-old)
	    (set-left-expr equ new-expr)
	  (if (eq-type-var-p var-old right-expr)
	      (set-right-expr equ new-expr))))))
  eqs)

;;; ---------------------------------------------------------------------------
;;; Add a type equation to a type equation stack.
(DEFUN push-type-equation (equ-stack	;<type-equation-stack>
			   equ)		;<pair>
  (setf (?equations equ-stack)
    (cons equ (?equations equ-stack)))
  equ-stack)

;;; Remove a type equation from a type equation stack.
(DEFUN pop-type-equation (eq-stack)	;<type-equation-stack>
  (let ((equ (car (?equations eq-stack))))
    (setf (?equations eq-stack)
      (cdr (?equations eq-stack)))
    equ))

;;; ---------------------------------------------------------------------------
;;; SUBSTITUTION ACCESS
;;; ---------------------------------------------------------------------------

;; Answer the type equation that has a special type var at the left side.
(DEFUN get-substitution (subs		;<type-var-substitutions>
			 var)		;<type-var>
  (assoc var (?equations subs) :test #'eq-type-var-p))

;;; Answer the last equation of a list of equations. The var of the 
;;; right expression of the last equation does not occur again in the subs.
(DEFUN get-last-substitution (subs	;<type-var-substitutions>
			      var)	;<type-var>
  (let ((equ (get-substitution subs var)))
    (if equ
	(let ((right-expr (?right-expr equ)))
	  (if (type-var-p right-expr)
	      (get-last-substitution subs right-expr)
	    equ))
      nil)))

(DEFUN add-substitution (subs		;<type-var-substitutions>
			 var		;<type-var>
			 expr)		;<type-expr>
  (push-type-equation subs (new-type-equation var expr)))

;;; ---------------------------------------------------------------------------
;;; MERGING SUBSTITUTIONS
;;; ---------------------------------------------------------------------------

;;; Join subs1 and subs2 and put result to subs2.
(DEFUN join-substitutions (subs1	;<type-var-substitutions>
			   subs2)	;<type-var-substitutions>
;  (ti-format t "~%join-subs ~A and ~A"
;	     (ti-print-string subs1)
;	     (ti-print-string subs2))
  (dolist (equ (?equations subs1))
    (join-equation subs2 (?left-expr equ) (?right-expr equ)))
  subs2)

(DEFGENERIC join-equation (subs var expr))

(DEFMETHOD join-equation ((subs <type-var-substitutions>)
			  (var <type-var>)
			  (expr <type-expr>))
  (let ((equ (get-last-substitution subs var)))
    (if equ
	(set-right-expr equ (join-type-exprs expr (?right-expr equ)))
      (add-substitution subs var expr))))

(DEFMETHOD join-equation ((subs <type-var-substitutions>)
			  (var <type-var>)
			  (expr <type-var>))
  (if (null (check-equality subs var expr))
      (let ((equ (get-last-substitution subs var)))
	(if equ
	    (let ((right-expr (?right-expr equ)))
	      (set-right-expr equ expr)
	      (join-equation subs expr right-expr))
	  (add-substitution subs var expr)))))

;;; ---------------------------------------------------------------------------
(DEFGENERIC add-equation (subs var expr))

(DEFMETHOD add-equation ((subs <type-var-substitutions>)
			 (var <type-var>)
			 (expr <type-expr>))
  (let ((equ (get-last-substitution subs var)))
    (if equ
	(let ((new-expr (meet-type-exprs expr (?right-expr equ))))
	  (if new-expr
	      (set-right-expr equ new-expr)
	    nil))
      (add-substitution subs var expr))))

(DEFMETHOD add-equation ((subs <type-var-substitutions>)
			 (var <type-var>)
			 (expr <type-var>))
  (if (null (check-equality subs var expr))
      (let ((equ (get-last-substitution subs var)))
	(if equ
	    (let ((right-expr (?right-expr equ)))
	      (set-right-expr equ expr)
	      (add-equation subs expr right-expr))
	  (add-substitution subs var expr)))
    t))

;;; Answer whether two type vars are set equal in substitutions.
(DEFUN check-equality (subs		;<type-var-substitutions>
		       var1		;<type-var>
		       var2)		;<type-var>
  (if (or (check-equality-fwd subs var1 var2)
	  (check-equality-fwd subs var2 var1))
      t
    (let ((equ (get-substitution subs var1)))
      (if (and equ (type-var-p (?right-expr equ)))
	  (check-equality subs (?right-expr equ) var2)
	nil))))

(DEFGENERIC check-equality-fwd (var1 var2 subs))

(DEFMETHOD check-equality-fwd ((subs <type-var-substitutions>)
			       (var1 <type-var>)
			       (var2 <type-var>))
  (if (eq-type-var-p var1 var2) t
    (let ((equ (get-substitution subs var1)))
      (if equ
	  (check-equality-fwd subs (?right-expr equ) var2)
	nil))))

(DEFMETHOD check-equality-fwd ((subs <type-var-substitutions>)
			       (var1 <type-expr>)
			       (var2 <type-expr>))
  nil)

;;; ---------------------------------------------------------------------------
;;; Reduce the number of type variables inside of substitutions.
(DEFUN reduce-substitutions (subs1	;<type-var-substitutions>
			     subs2	;<type-var-substitutions>
			     vec)	;<vector>
  (dovector (var i vec)
    (extract-equation var subs1 subs2 vec))
  subs2)

(DEFUN extract-equation (vec-var	;<type-var>
			 subs1		;<type-var-substitutions>
			 subs2		;<type-var-substitutions>
			 vec)		;<vector>
  (let ((index (position-if (lambda (vec-var2)
			  (and
			   (check-equality-fwd subs1 vec-var vec-var2)
			   (null (eq-type-var-p vec-var vec-var2))))
			vec)))
    (if index
	(add-substitution subs2 vec-var (vector-ref vec index))
      (add-substitution subs2 vec-var
			(convert-to-atomic-type vec-var subs1)))))

;;; Append subs1 and subs2 and put result to subs1.
(DEFUN append-substitutions (subs1	;<type-var-substitutions>
			     subs2)	;<type-var-substitutions>
  (setf (?equations subs1)
    (append (?equations subs1) (?equations subs2)))
  subs1)
 
;;; ---------------------------------------------------------------------------
;;; CONVERSION OF TYPE EXPRESSIONS
;;; ---------------------------------------------------------------------------

;;; Convert a type expr to an atomic type.
(DEFGENERIC convert-to-atomic-type (expr subs . other-subs))

(DEFMETHOD convert-to-atomic-type ((expr <type-expr>)
				   subs . other-subs)
  expr)

(DEFMETHOD convert-to-atomic-type ((expr <type-var>)
				   (subs <type-var-substitutions>) . other-subs)
  (let ((equ (get-last-substitution subs expr)))
    (if equ
	(?right-expr equ)
      (if other-subs
	  (convert-to-atomic-type expr (car other-subs) (cdr other-subs))
	(progn
	  (ti-format t "~%Warning: variable var~A not in substitutions"
		     (?id expr))
	  (ti-error)
	  (general-type))))))

;;; Convert all general types to %object types (see also ti-signature).
(DEFGENERIC convert-general-to-%object-type (subs))
  
(DEFMETHOD convert-general-to-%object-type ((subs <type-var-substitutions>))
  (dolist (equ (?equations subs))
    (let ((expr (?right-expr equ)))
      (if (and (atomic-type-p expr) (general-type-p expr))
	  (set-right-expr equ (%object-type))))))

;;; ---------------------------------------------------------------------------
;;; CONVERSION OF TYPE EXPRESSIONS TO SLOT NAME
;;; ---------------------------------------------------------------------------

;;; Convert a type expr to a slot name.
(DEFGENERIC convert-to-slot-name (expr subs))

(DEFMETHOD convert-to-slot-name ((expr <type-expr>)
				 subs)
  (ti-format t "~%Warning: type expr cannot be converted to slot name")
  (ti-error)
  nil)

(DEFMETHOD convert-to-slot-name ((expr <slot-id>)
				 subs)
  (?slot-name expr))

(DEFMETHOD convert-to-slot-name ((expr <type-var>)
				 (subs <type-var-substitutions>))
  (let ((equ (get-last-substitution subs expr)))
    (cond (equ
	   (?slot-name (?right-expr equ)))
	  (t
	   (ti-format t "~%Warning: type var cannot be converted to slot name")
	   (ti-error)
	   nil))))


#module-end