;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: tail-module -*-
#|
-----------------------------------------------------------------------------------
TITLE: Compiler Interface to Basic Module %tail
-----------------------------------------------------------------------------------
File:    tail-module.em
Version: 1.12 (last modification on Fri Nov  5 17:00:12 1993)
State:   proposed

DESCRIPTION:
the definition functions for tail data types

DOCUMENTATION:
see in the APPLY-paper machine description

NOTES:


REQUIRES:

PROBLEMS:

AUTHOR:
w. heicking

CONTACT: 
w. heicking

HISTORY: 
Log for /tmp_mnt/home/saturn/rrosen/Lisp/Apply/tail-module.em[1.0]
	Mon Mar  8 08:15:37 1993 wheick@isst proposed $
 tail-module
 
tail-module.em[1.1] Wed Mar 24 17:09:59 1993 wheick@isst save $
 [Wed Mar 17 11:19:47 1993] Intention for change:
 export new tail classes %pointer-to.
 
tail-module.em[1.2] Mon Apr 19 13:46:07 1993 wheick@isst save $
 new representation <%direct>
 
tail-module.em[1.3] Mon Apr 19 14:16:01 1993 wheick@isst save $
 export <%function>
 
tail-module.em[1.4] Mon Apr 19 14:45:29 1993 wheick@isst proposed $
 
tail-module.em[1.5] Wed May  5 13:46:09 1993 wheick@isst proposed $
 
tail-module.em[1.6] Tue May 25 16:42:07 1993 akind@isst save $
 [Fri May  7 21:20:21 1993] Intention for change:
 
tail-module.em[1.7] Tue May 25 16:53:48 1993 wheick@isst save $
 done
 
tail-module.em[1.8] Thu May 27 11:36:14 1993 wheick@isst proposed $
 
tail-module.em[1.9] Wed Sep  1 18:08:23 1993 imohr@isst proposed $
 [Wed Sep  1 12:09:00 1993] Intention for change:
 reset for module %tail
 
tail-module.em[1.10] Fri Sep  3 08:05:00 1993 ukriegel@isst published $
 [Fri Sep  3 08:04:00 1993] Intention for change:
 expose wrong syntax
 done
 
tail-module.em[1.11] Fri Oct  1 18:49:41 1993 imohr@isst published $
 [Fri Oct  1 14:33:55 1993] Intention for change:
 longjmp
 
tail-module.em[1.12] Fri Nov  5 17:00:37 1993 imohr@isst proposed $
 [Fri Nov  5 16:58:06 1993] Intention for change:
 + new %size-of's
  

-----------------------------------------------------------------------------------
|#


#module-name tail-module

#module-import
(accessors
 level-1-eulisp
 LZS
 MZS
;;only to test data types take:
;;tail-types
 machine-description; for the whole machine-description
 debugging
 el2lzs
 expand-literal
 (only (make-instance vector append delete-if-not last butlast)
   common-lisp)
)

#module-syntax-import
(level-1-eulisp apply-standard debugging
                machine-description)

#module-syntax-definitions

#module-header-end

;--- exports

(export 
  ;;;accesses for data types
  ;;;!!!the following (and other symbols, 
  ;;;see define-tail-sys-functions and 
  ;;;define-tail-aux-sys-functions below) 
  ;;;are exported automatically by define-tail!!!
  ;;;%ref %extract %select %preselect %view 
  ;;;%size-of-instance %size-as-component %pointer-of

  ;;;pointer arithmetic functions have the names like
  ;;;rainers addition functions!!!! I can not export!!!
;;;  %plus %minus
  ;;;definitions
  ;%define-type %define-variable %define-constant
  ;;;other accesses
          
;;;float-data-p
  give-data-type
  data-type-p

  ;;;data-code generation functions
  ;;;generate-data-code generate-data-code1
  ;;;defined data types
  %byte-integer %half-integer %word-integer
  %unsigned-byte-integer %signed-byte-integer 
  %unsigned-half-integer %signed-half-integer
  %unsigned-word-integer %signed-word-integer
  %direct-integer %signed-direct-integer
  %single-float %double-float %extended-float 
  %void
  %direct
  %function
  %string
  %jmpbuf
  %pjmpbuf

;;; only my aux data types
;;;??? %memory-free %string-asciz %string-ascii
;;;??? %alignment %global %local %comment %label-aux

;;;are only introduced by %define
;;;%boolean %true %false %character %string

  <%byte-integer> <%half-integer> <%word-integer>
  <%unsigned-byte-integer> <%signed-byte-integer> 
  <%unsigned-half-integer> <%signed-half-integer>
  <%unsigned-word-integer> <%signed-word-integer>
  <%direct-integer> <%signed-direct-integer>
  <%single-float> <%double-float> <%extended-float> 
  <%void>
  <%direct>
  <%function>
  <%string>
  <%jmpbuf>
  <%pjmpbuf>

;;;are only introduced by %define
;;;<%boolean> <%true> <%false> <%character> <%string>

;;; only my aux data types
;;;??? <%memory-free> <%string-asciz> <%string-ascii>
;;;??? <%alignment> <%global> <%local> <%comment> <%label-aux>

 
  ;;;data types for rainers code generation
  %general-pointer %pointer-byte-integer 
  %pointer-signed-byte-integer %pointer-unsigned-byte-integer
  %pointer-signed-half-integer %pointer-half-integer
  %pointer-unsigned-half-integer

  %GOTO %LABEL
  %MAKE-PROC-EPILOG
  %MAKE-PROC-PROLOG
  %MAKE-DATA-SEGMENT
  %MAKE-CODE-SEGMENT
  %MAKE-COMMENTLINE %CALL
  %JMPL %MOVE-BLOCK %MOVE
  %LE %GE %LT %GT
  %NEQ %EQ %CXTOD %CXTOS
  %CXTOI %CDTOX %CDTOS
  %CDTOI %CSTOX %CSTOD
  %CSTOI %CITOX %CITOD
  %CITOS %ZERO-EXTEND
  %SIGN-EXTEND %SQRT %ABS
  %ROTATER %ROTATEL %ASHIFTR
  %LSHIFTR %ASHIFTL %LSHIFTL
  %XOR %OR %AND %NOT
  %MOD %DIV %MULT %NEG
  %MINUS %PLUS
  %setjmp %longjmp

  <%GOTO> <%LABEL>
  <%MAKE-PROC-EPILOG>
  <%MAKE-PROC-PROLOG>
  <%MAKE-DATA-SEGMENT>
  <%MAKE-CODE-SEGMENT>
  <%MAKE-COMMENTLINE> <%CALL>
  <%JMPL> <%MOVE-BLOCK> <%MOVE>
  <%LE> <%GE> <%LT> <%GT>
  <%NEQ> <%EQ> <%CXTOD> <%CXTOS>
  <%CXTOI> <%CDTOX> <%CDTOS>
  <%CDTOI> <%CSTOX> <%CSTOD>
  <%CSTOI> <%CITOX> <%CITOD>
  <%CITOS> <%ZERO-EXTEND>
  <%SIGN-EXTEND> <%SQRT> <%ABS>
  <%ROTATER> <%ROTATEL> <%ASHIFTR>
  <%LSHIFTR> <%ASHIFTL> <%LSHIFTL>
  <%XOR> <%OR> <%AND> <%NOT>
  <%MOD> <%DIV> <%MULT> <%NEG>
  <%MINUS> <%PLUS>
  <%setjmp> <%longjmp>



;;;the table to hold the reference between names and instances
;;;for types, variables, constants and for rainer
  table-of-class-instances)

 (expose (only ($tail-module) el2lzs)) ; export without import

;;;in define-tail mit export export (like the real data types)
;;;to export from the tail module application
;;;but for this module define-tail exports always

(define-tail-sys-functions 
  %ref
  %extract
  %select
  %preselect
  %view
  %size-of-instance
  %size-as-component
  %cast
  %funcall
  ;??%setf

;  %setjmp
;  %longjmp

;;;now export the following from tail!!
  %pointer-of-variable
  %pointer-of-function
  %pointer-of-extract
  %pointer-of-select
  
  %setf-variable
  %setf-ref
  %setf-extract
  %setf-select
  %setf-view
  %setf-cast
  )

;;;the old version:
;;;in define-tail mit export nil (like the aux data types)
;;;without to export from the tail module application
;;;but for this module define-tail exports always
;
;(define-tail-aux-sys-functions
;  %pointer-of-variable
;  %pointer-of-function
;  %pointer-of-extract
;  %pointer-of-select
;  
;  %setf-variable
;  %setf-ref
;  %setf-extract
;  %setf-select
;  %setf-view
;  %setf-cast)

;;; -----------------------------------------------------------------------------------
;;; resetting module %tail
;;; -----------------------------------------------------------------------------------
(export
  reset-%tail 
  add-toplevel-forms-for-tail-module)

(defun reset-%tail ()
  (setf (?fun-list $tail-module)
        (delete-if-not #'special-sys-fun-p (?fun-list $tail-module)))
  ;?var-list is set by set-init-fun-for-tail-module
  (setf (?named-const-list $tail-module) nil)
  (setf (?sym-list $tail-module) nil)
  (setf (?syntax-exports $tail-module) nil)
  (setf (?syntax-env $tail-module) nil)
  (setf (?exports $tail-module) 
        (append (?class-def-list $tail-module)
                (?fun-list $tail-module)))
  (setf (?lex-env $tail-module) (?exports $tail-module))
  (set-init-fun-for-tail-module))

(defconstant $unsigned-0 
  (make-literal-instance %unsigned-word-integer '(0)))
(defconstant $unsigned-1 
  (make-literal-instance %unsigned-word-integer '(1)))

(defun set-init-fun-for-tail-module ()
  ;NOTE SIDE EFFECT:
  ;sets the variable list of %tail
  (let ((initflag (make-instance <global-static> 
                    :identifier ()
                    :module-id ()
                    :type %unsigned-word-integer
                    :initial-value $unsigned-0)))
    (setf (?var-list $tail-module) (list initflag))
    (setf (?toplevel-forms $tail-module)
          (make-instance <global-fun>
            :range-and-domain (vector %unsigned-word-integer)
            :params (make-instance <params>)
            :body 
            (make-instance <if-form>
              :pred
              (make-instance <app>
                :function %eq
                :arg-list (list (make-instance <var-ref> :var initflag)
                                $unsigned-0))
              :then
              (make-instance <progn-form> 
                :form-list (list (make-instance <setq-form>
                                   :location (make-instance <var-ref> 
                                               :var initflag)
                                   :form $unsigned-1)))
              :else
              $unsigned-1)                
            :exported () 
            :identifier "basic-initialization"
            :module-id (?identifier $tail-module)))))

(defun add-toplevel-forms-for-tail-module (forms)
  (let ((progn (?then (?body (?toplevel-forms $tail-module)))))
    (setf (?form-list progn)
          (append (butlast (?form-list progn))
                  forms 
                  (last (?form-list progn))))))

#module-end
