;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: static-allocation -*-
#|
-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    static-allocation.em
Version: 1.37 (last modification on Thu Sep  2 15:12:31 1993)
State:   published

DESCRIPTION:
try to allocate static data

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
til now adjustment array is put directly in front of static data
all adresses in this array til 0xffffffff are considered as root addresses
REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/static-allocation.em[1.0]
	Thu Mar 11 13:34:53 1993 ukriegel@isst save $
 Static allocation functions hackers version, without static cards
 needs special %class-of
 
static-allocation.em[1.1] Thu Mar 11 15:54:40 1993 wheick@isst proposed $
 [Thu Mar 11 15:44:09 1993] Intention for change:
 new import for <class-def> is lzs
 ,
 
static-allocation.em[1.2] Thu Mar 11 17:12:44 1993 wheick@isst proposed $
 [Thu Mar 11 16:08:32 1993] Intention for change:
 klammerfehler in lambda-list
 <stream> not available, missing imports from cl, accessor function missing
 
static-allocation.em[1.3] Fri Mar 12 09:20:23 1993 ukriegel@isst save $
 [Fri Mar 12 09:10:15 1993] Intention for change:
 Klammerfehler, importe berichtigt
 
static-allocation.em[1.4] Fri Mar 12 12:43:12 1993 ukriegel@isst save $
 [Fri Mar 12 11:26:16 1993] Intention for change:
 format change in write-static-cards
 format in write-static-cards changed, explicite import of format, push dolist
 
static-allocation.em[1.5] Thu Apr  1 12:03:04 1993 rrosen@isst save $
 [Fri Mar 12 15:05:39 1993] Intention for change:
 --- no intent expressed ---
static-allocation.em[1.6] Thu Apr  1 12:20:46 1993 ukriegel@isst proposed $
 [Thu Apr  1 12:04:25 1993] Intention for change:
 exclude import of common-lisp-emulation
 import specs changed
 
static-allocation.em[1.7] Fri Apr  2 11:06:31 1993 ukriegel@isst save $
 
static-allocation.em[1.8] Fri Apr  2 11:08:37 1993 ukriegel@isst proposed $
 in front of each datum there is now the class for static data
 all static data are inside _gc_start_root and _gc_end_root labels
 
static-allocation.em[1.9] Mon Apr  5 07:48:39 1993 ukriegel@isst proposed $
 sets global roots in front of static data
 
static-allocation.em[1.10] Tue Apr  6 14:10:51 1993 ukriegel@isst proposed $
 [Tue Apr  6 13:55:56 1993] Intention for change:
 postpone generation of labels until write-static-cards
 changed interface literal-object instead of label
 add-root-label gets a label
 
static-allocation.em[1.11] Wed Apr  7 08:32:09 1993 ukriegel@isst save $
 
static-allocation.em[1.12] Wed Apr  7 13:25:21 1993 ukriegel@isst proposed $
 cycle during load resolved
 generate-alignment, generate-scope used
 
static-allocation.em[1.13] Wed Apr  7 17:51:11 1993 ukriegel@isst proposed $
 [Wed Apr  7 17:21:52 1993] Intention for change:
 begin and end label for static literal area
 _StaticLiteralBegin/End added
 
static-allocation.em[1.14] Fri Apr 16 07:04:42 1993 ukriegel@isst proposed $
 [Fri Apr 16 06:24:35 1993] Intention for change:
 generate-op-code0l -> gen-op-code0l
 done
 
static-allocation.em[1.15] Thu Apr 29 11:01:50 1993 ukriegel@isst save $
 [Thu Apr 29 09:36:56 1993] Intention for change:
 add length in front of tag vor vector-class-instances
 interface for static-allocate changed, instead of length the representation instance is used as parameter
 
static-allocation.em[1.16] Fri Apr 30 09:27:59 1993 ukriegel@isst save $
 [Fri Apr 30 09:25:29 1993] Intention for change:
 acdr , cddr
 done
 
static-allocation.em[1.17] Fri Apr 30 11:37:46 1993 ukriegel@isst save $
 [Fri Apr 30 11:27:10 1993] Intention for change:
 use representationb-class to dispatch
 write-static-code added
 
static-allocation.em[1.18] Fri Apr 30 14:28:48 1993 ukriegel@isst save $
 [Fri Apr 30 12:45:03 1993] Intention for change:
 import <%pointer-to-vector>
 done
 
static-allocation.em[1.19] Fri Apr 30 16:43:43 1993 ukriegel@isst proposed $
 [Fri Apr 30 16:09:38 1993] Intention for change:
 length for static vectors from literal instance
 done
 
static-allocation.em[1.20] Wed May  5 18:36:56 1993 ukriegel@isst proposed $
 [Wed May  5 18:27:49 1993] Intention for change:
 gadgets for wh
 meth write-static data for <%machine-type>
 
static-allocation.em[1.21] Wed May  5 19:10:49 1993 ukriegel@isst proposed $
 [Wed May  5 19:08:04 1993] Intention for change:
 .align in front of tag
 
static-allocation.em[1.22] Thu May  6 09:31:36 1993 ukriegel@isst proposed $
 [Thu May  6 09:26:44 1993] Intention for change:
 import lzs-mop
 
static-allocation.em[1.23] Fri May 14 13:44:43 1993 ukriegel@isst proposed $
 [Fri May 14 06:05:42 1993] Intention for change:
 wrong class label
 
static-allocation.em[1.24] Fri May 14 17:14:09 1993 ukriegel@isst proposed $
 [Fri May 14 15:27:42 1993] Intention for change:
 wrong class label from wh
 done
 
static-allocation.em[1.25] Wed May 19 09:24:48 1993 ukriegel@isst proposed $
 [Wed May 19 09:18:07 1993] Intention for change:
 add-root-variable
 done
 
static-allocation.em[1.26] Wed May 19 11:49:01 1993 ukriegel@isst save $
 [Wed May 19 11:47:24 1993] Intention for change:
 typing errore corrected
 
static-allocation.em[1.27] Wed May 19 12:05:00 1993 ukriegel@isst save $
 [Wed May 19 12:02:35 1993] Intention for change:
 add-root-label -> add-root-object
 done
 
static-allocation.em[1.28] Wed May 19 13:49:46 1993 ukriegel@isst save $
 [Wed May 19 13:45:37 1993] Intention for change:
 dummy for add-root-label
 done
 
static-allocation.em[1.29] Wed May 19 15:55:13 1993 ukriegel@isst save $
 [Wed May 19 15:46:58 1993] Intention for change:
 reset code-collectors
 done
 
static-allocation.em[1.30] Mon May 24 07:51:20 1993 ukriegel@isst proposed $
 [Mon May 24 07:46:33 1993] Intention for change:
 StaTicRootEnd
 done
 
static-allocation.em[1.31] Mon Jun 21 11:20:26 1993 ukriegel@isst proposed $
 [Mon Jun 21 11:18:02 1993] Intention for change:
 alignment for static strings
 done
 
static-allocation.em[1.32] Tue Jun 22 08:15:11 1993 ukriegel@isst proposed $
 [Tue Jun 22 06:04:14 1993] Intention for change:
 alignment for strings
 done
 
static-allocation.em[1.33] Mon Jul 19 13:32:44 1993 ukriegel@isst proposed $
 [Mon Jul 19 12:01:29 1993] Intention for change:
 actually-byte-length
 done
 
static-allocation.em[1.34] Fri Aug  6 08:37:24 1993 ukriegel@isst save $
 [Mon Jul 19 14:11:51 1993] Intention for change:
 + import of ?actually-byte-length
 
static-allocation.em[1.35] Fri Aug  6 08:53:19 1993 imohr@isst proposed $
 [Fri Aug  6 08:52:38 1993] Intention for change:
 --- no intent expressed ---adapted for C-code generation
 
static-allocation.em[1.36] Tue Aug 17 14:24:23 1993 imohr@isst proposed $
 code generation with asm-ops
 
static-allocation.em[1.37] Thu Sep  2 15:13:41 1993 ukriegel@isst published $
 [Thu Sep  2 15:11:29 1993] Intention for change:
 replace conditions by el-conditions
 done
 

-----------------------------------------------------------------------------------
|#

#module-name static-allocation
#module-import (level-0-eulisp
                accessors;??for missing ?mm-type
                (rename ((push cl:push)
                         (dolist cl:dolist)
                         (format cl:format)
                         (cadr cl:cadr)
                         (cddr cl:cddr)
                         (mapc cl:mapc))
                  (only (push dolist format cadr cddr mapc) common-lisp))
                (only (expand-literal) expand-literal)
                (only (~vector-class-element-type) lzs-mop)
                (only (<class-def>) lzs)
                (only (<stream>) el-stream)
                (only (asm-identifier c-identifier type-identifier) code-identifier)
                compiler-conditions
                (only (<%pointer-to-vector>
                       <%pointer-to-struct>
                       <%machine-type>
                       ?actually-byte-length) machine-description)
                asm-ops)

#module-syntax-import (level-0-eulisp dynamic)
#module-syntax-definitions

(defmacro extract-class-label-from-literal 
          (literal-instance)
  `(asm-identifier (expand-literal (?class ,literal-instance))))

; the following definitions were inherited from codegen-data where there are also
; local definitions

(defmacro with-label (label comment . body)
  `(dynamic-let ((*label* ,label)
                 (*label-comment* ,comment)) 
     ,@body))

(defmacro with-comment (comment . body)
  `(dynamic-let ((*comment* ,comment)) ,@body))

(defmacro with-new-alignment body
  `(dynamic-let ((*alignment* 1)
                 (*align* nil))
     ,@body))


#module-header-end
(define-compiler-condition <root-set-overflow>(<condition>)
  "The number of generated root labels ~s exceeds ~s" :generated :defined)
(export 
  static-allocate 
  write-static-cards 
  write-instance-imports
  write-global-defs
  add-root-object 
  add-root-label  ;;soon obsolete used in whc-gen-code only
  add-root-variable
  initialize-static-data-code-collectors)
;;Hackers version by e.u.kriegel


(deflocal static-asm-code ())
(deflocal root-objects ())
(deflocal root-variables ())
;;reseting code collectors

(defun initialize-static-data-code-collectors()
  (setq static-asm-code ())
  (setq root-objects ())
  (setq root-variables ()))
;;generation of class labels is postponed until code will be written
;;literal instance is consed in front of list of code strings
(defun static-allocate
           (literal-instance list-of-strings representation-instance)
 (cl:push (cons representation-instance (cons literal-instance list-of-strings)) 
       static-asm-code)
representation-instance)

;add new top level object to the root set
(defun add-root-object(label)
      (cl:push label root-objects))
(defun add-root-label(label)
      (cl:push label root-objects)) 
(defun add-root-variable(label)
      (cl:push label root-variables))
 
(defgeneric write-static-data (representation literal-instance code))

(defmethod write-static-data 
           ((representation <%pointer-to-vector>) literal-instance code)
  ;;write out a static object with rep pointer-to-vector
  (with-new-alignment
    ;;write length in bytes
    (.word (* (car (?value-list literal-instance))
              (?actually-byte-length (?representation
                                      (~vector-class-element-type (?class literal-instance))))))
    ;;write class label
    (.word (extract-class-label-from-literal literal-instance)))
  ;;write data code
  (write-code code))

(defmethod write-static-data 
           ((representation <%machine-type>) literal-instance code)
  ;;write data code only
  (write-code code))

(defmethod write-static-data 
           (representation literal-instance code)
  ;;write class label
  (with-new-alignment
    (.word (extract-class-label-from-literal literal-instance)))
  ;;write data code
  (write-code code))

(defun write-code (code)
  (cl:format (dynamic code-output) "~{~a~}" code))

(defun write-static-cards ()
  ; (dynamic code-output) should be bound to a stream for code output
  (let ((len (+ 1 (length root-objects)
                (length root-variables))))
    (if (> len #x4000)
      (compiler-error <root-set-overflow> :defined #x4000 :generated len)
      (Progn
        ;;put adjustment-array in front of static data
        ;;static variable root must be dereferenced to get roots
        (.seg ^data)
        (with-new-alignment
          (.global "_StaticVariableRoot")       
          (with-label "_StaticVariableRoot" "table of root variables for GC"
            (.skip 0) ; to get a label if no root variable exists
            (cl:mapc #'.word root-variables))
          ;;static object roots
          (.global "_StaticObjectRoot")
          (with-label "_StaticObjectRoot" "table of addresses of root objects for GC"
            (.skip 0) ; to get a label if no root object exists
            (cl:mapc #'.word root-objects))
          ;;write end mark
          (.align 4)
          (.global "_StaticRootEnd")
          (with-label "_StaticRootEnd" nil
            (.skip (- #x10000 (* len 4))));;  ??
          (.global "_StaticLiteralBegin")
          (with-label "_StaticLiteralBegin" nil
            (.skip 0))
          )
        (cl:dolist (entry static-asm-code)
          (write-static-data (car entry) (cl:cadr entry) (cl:cddr entry)))
        
        (.global "_StaticLiteralEnd")
        (with-label "_StaticLiteralEnd" nil
            (.skip 0))
        ))))

(defun write-global-defs ()
  (cl:mapc (lambda (inst-descr)
             (.global (asm-identifier (cl:cadr inst-descr))))
           static-asm-code))

(defun write-instance-imports (stream)
  (cl:mapc (lambda (inst-descr)
             (let ((inst (cl:cadr inst-descr)))
               (cl:format stream "extern ~A ~A;~%"
                          (instance-type-spec (?representation (?class inst)) (?class inst))
                          (c-identifier inst))))
           static-asm-code))

(defgeneric instance-type-spec (representation class))
(defmethod instance-type-spec ((representation <%pointer-to-struct>) class)
  (cl:format nil "struct ~A" (type-identifier class)))
(defmethod instance-type-spec ((representation <%pointer-to-vector>) class)
  (type-identifier (~vector-class-element-type class)))

;(write-static-cards t)

#module-end
