;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: side-effects-h -*-
#|
-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    side-effects-h.em
Version: 1.4 (last modification on Wed Nov 24 15:37:29 1993)
State:   proposed

DESCRIPTION:
definition of the structures for side-effect analyse and teh function
 set-side-effect

DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Friedrich
CONTACT: horst.friedrich@isst.fhg.de 

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/side-effects-h.em[1.0]
	Thu Mar 25 08:54:28 1993 hfried@isst proposed $
 Zur Seiteneffektanalyse
 
side-effects-h.em[1.1] Thu Mar 25 11:22:09 1993 hfried@isst proposed $
 [Thu Mar 25 08:56:26 1993] Intention for change:
 new head
 
side-effects-h.em[1.2] Tue Apr 13 14:11:27 1993 hfried@isst proposed $
 [Thu Mar 25 11:55:21 1993] Intention for change:
 
side-effects-h.em[1.3] Mon Jun 21 11:49:36 1993 hfried@isst published $
 [Tue Apr 13 14:17:15 1993] Intention for change:
 
side-effects-h.em[1.4] Fri Nov 26 10:39:54 1993 imohr@isst proposed $
 [Wed Nov 24 14:33:13 1993] Intention for change:
 use defstandardclass for class definitions
 

-----------------------------------------------------------------------------------
|#

#module side-effects-h
(import (level-1-eulisp
         accessors
         )

 syntax  (level-1-eulisp
          apply-standard)

 export (set-read-side-effect
         set-write-side-effect
         <gloc> <fgloc>
         ?gplace ?fun ?glocs
         gloc-p
         )
 )

; class-definitions
; ------------------

;accessors
(defgeneric ?gplace (gloc))
(defgeneric ?fun (fgloc))
(defgeneric ?glocs (fgloc))

(defstandardclass <gloc> () 
;                 ------
  (gplace :accessor :initarg :initform ())
  (type   :accessor :initarg :initform ())
  :predicate
)

(defstandardclass <fgloc> ()
;                 -------
  (fun :accessor :initarg) ; fgloc belongs to this function
  (glocs :accessor :initarg :initform ())
  :predicate
)

;;definitions and init-forms

(defun set-read-side-effect (fun key value)
  (let ((gloc (make <gloc> :gplace value))
        (fread-gloc (?fread-gloc fun)))
  (if fread-gloc
    (setf (?glocs fread-gloc)
          (cons gloc (?glocs fread-gloc)))
    (setf (?fread-gloc fun)
          (make <fgloc> :fun fun
                :glocs (list gloc))))
  (setf (?sys-glocs fun) ^t))
)

(defun set-write-side-effect (fun key value)
  (let ((gloc (make <gloc> :gplace value))
        (fwrite-gloc (?fwrite-gloc fun)))
  (if fwrite-gloc
    (setf (?glocs fwrite-gloc)
          (cons gloc (?glocs fwrite-gloc)))
    (setf (?fwrite-gloc fun)
          (make <fgloc> :fun fun
                :glocs (list gloc))))
  (setf (?sys-glocs fun) ^t))
)

#module-end
