;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: representation -*-
#|
-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    representation.em
Version: 1.2 (last modification on Wed Nov 24 10:03:21 1993)
State:   proposed

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
the original author

CONTACT: 
the person which is currently responsible for this file

HISTORY: 
Log for /export/home/saturn/wheick/Lisp/Apply/representation.em[1.0]
	Mon Nov 22 15:29:24 1993 ukriegel@isst save $
 accessors for representation.
 
representation.em[1.1] Tue Nov 23 12:56:14 1993 ukriegel@isst save $
 [Tue Nov 23 06:23:59 1993] Intention for change:
 byte-length
 
representation.em[1.2] Wed Nov 24 11:07:37 1993 ukriegel@isst proposed $
 [Tue Nov 23 14:05:10 1993] Intention for change:
 clean up
 

-----------------------------------------------------------------------------------
|#

#module representation

(import
 (level-1-eulisp
  lzs
  (only (<tail-class-def>) lzs-mop)
  ;accessors
  )
 
 syntax
 (level-1-eulisp 
  (only (defstandardclass) apply-standard)
  )
 
 export 
 
 (  <basic-class-def>
    <%integer>
    <%signed>
    <%unsigned> 
    <%float> ;new name
    <%aux-type>
    <%representation>
    <%machine-type>
    <%pointer> ;superclass of all pointer representations
    <%pointer-to-struct>
    <%pointer-to-vector>
    <%pointer-to-void>
    <%direct>
    <address-expr>
    ?alignment
    ?allocation
    ?byte-length
    ?byte-length-of-instance 
    ?byte-length-as-component
    ?mm-type
    ?mm-card

    )
 )
(defgeneric ?alignment (obj))
(defgeneric ?allocation (obj))
(defgeneric ?byte-length (obj))
(defgeneric ?byte-length-as-component (pobj))
(defgeneric ?byte-length-of-instance (obj))
(defgeneric ?mm-type (obj))
(defgeneric ?mm-card(obj))




(defstandardclass <%representation> ()
  :default-slot-options (:accessor :initarg)
  :slots
   alignment    ;alignment (of all types)
;;   bit-length   ;length (in bits) of all types; *UK* 24.11.93
   byte-length  ;length (in bytes) of all types

   allocation   ;slots
   mm-type      ;for the
   mm-card      ;memory management
 ;  class        ;backpointer to the class

;;new in %representation*UK* 24.11.93
;   integer      ;T/NIL
;   signed       ;T/NIL
;   var-code     ;assembler code for generation
;   const-code
   )  ;not used

;make a new class for %machine-type
;%bit ...%quad-word are instances from this class and are holded
;on the corresponding constants 
(defstandardclass <%machine-type> (<%representation>) ())


(defstandardclass <%aux-type> (<%representation>) ())

;;;the basic-data-type = basic-class-def takes informations 
;;;from %types = tail-class-def
;;;and from %representation
;;;!!!the old one!!!



;;;but I think it is better to cut the representation from the 
;;;eulisp hierarchy and take
;;;!!!the new one!!!

(defstandardclass <basic-class-def> (<tail-class-def>))

(defstandardclass <%integer> (<basic-class-def>) ())

(defstandardclass <%float> (<basic-class-def>) ())


;;; take <%signed> and <%unsigned> as mixin and not as subclass
;;; from <%integer-def>

;;; mixins for <%signed> and <%unsigned>
(defstandardclass <%signed> () ())

(defstandardclass <%unsigned> () ())



(defstandardclass <%pointer> (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  type                     ;type of the data to which the pointer points
  offset)                  ;not used

(defstandardclass <%pointer-to-struct> (<%pointer>)
  ;;;the old one                       (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  slot-and-type-names  ; see %struct: like an a-list ((slot type) ...)
  label-for-struct  ; this is the label for the real struct
  offset)

(defstandardclass <%pointer-to-vector> (<%pointer>)
  ;;;the old one                       (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  type    ;type of the data to which the pointer points
  length-of-vector
  label-for-vector  ; this is the label for the real vector
  offset)

(defstandardclass <%pointer-to-void> (<%pointer>)
  ;;;the old one                     (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  (alignment :initform 4)
  (byte-length :initform 4)
  (bit-length :initform 32)
  slot1  
  slot2  
  offset)

(defstandardclass <%direct> (<%representation>)
  :default-slot-options (:accessor :initarg)
  :slots
  type) 






;;;class of address-expressions
(defstandardclass <address-expr> ()
  :default-slot-options (:accessor :initarg)
  :slots
  address         ;label
  offset          ;offset
  type            ;type of the data
  slot            ;used for intern usage
  top-type-name)  ;contains the (rest) ini-list

#module-end
