;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: mm-initialize -*-
#|
-----------------------------------------------------------------------------------
TITLE: initialize classes dor memory management system
-----------------------------------------------------------------------------------
File:    mm-initialize.em
Version: 1.88 (last modification on Tue Nov 30 13:15:57 1993)
State:   proposed

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
1.)at the moment the slot gc-tracer belongs to the class, not to the representation
this should be changed in the near future and all calls to (?gc-tracer class)
should be changed into (?gc-tracer representation-object)

2.)length parameter in representation pointer-to-vector is assumed to be of type %unsigned-word-integer

3.)we are going to generate mm-types if none are given - there might be minor
problems with synchronization in case of module compilation

4.)the allocator function is generated only for representation
pointer-to-struct. this should be changed in the future to 
a) allocator only for instances of <structure-class>
b) for all classes if this is needed

REQUIRES:

PROBLEMS:
1.)any changes of type <pointer-to-void> must be done conformely with changes in
the generation of trace functions for <%pointer-to-struct>-thingies.
2.)now there is a cast to %unsigned-word-integer which should be replaced with an
type %pointer....

3.)~compute constructor:
	the generated let expr needs a genuine variable alloc
	what about constructors if a user writes its own intialization

        representation direct : it is assumed that classes with such a
	representation have only one slot !!!!

4.)problem with direct
5.)ensure-vector-length hack
6.)%size-of only correct code for pointer-to-struct and pointer-to-vector
   to use %size-of, constructors for multiple-type-card-allocated objects have
   use the cds stored in the class !!!
   what about dynamically calculated card and type descriptors?
   Ensure that init-frorms of "library module" is executed first!!!!!!!!!
   estimated-size in canonize-mm-card methods is not necessaryly machine
   independent
   there should be an option which defines the use of that estimation
  

AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel

HISTORY: 
Log for /tmp_mnt/home/saturn/apply/Eu2C/Apply/mm-initialize.em[1.0]
	Mon Apr  5 09:03:37 1993 ukriegel@isst proposed $
 initialization for memory management system
 
mm-initialize.em[1.1] Mon Apr  5 15:38:32 1993 ukriegel@isst save $
 enhanced
 still to be coded are runtime initialization forms
 
mm-initialize.em[1.2] Wed Apr  7 15:08:29 1993 ukriegel@isst save $
 [Wed Apr  7 15:07:28 1993] Intention for change:
 continue
 
 
mm-initialize.em[1.3] Wed Apr  7 15:58:16 1993 ukriegel@isst save $
 mm-type is literal instance
 
mm-initialize.em[1.4] Thu Apr  8 14:59:17 1993 ukriegel@isst save $
 still to be done generate-trace-code
 
mm-initialize.em[1.5] Tue Apr 13 15:33:34 1993 ukriegel@isst save $
 [Tue Apr 13 15:32:45 1993] Intention for change:
 add constructor and predicates
 done
 
mm-initialize.em[1.6] Wed Apr 14 09:03:33 1993 ukriegel@isst save $
 [Wed Apr 14 09:00:21 1993] Intention for change:
 change call of instance-of-p to call of %instance-of-p
 done
 
mm-initialize.em[1.7] Wed Apr 14 09:51:26 1993 ukriegel@isst save $
 [Wed Apr 14 09:50:17 1993] Intention for change:
 add imports
 done
 
mm-initialize.em[1.8] Wed Apr 14 11:58:15 1993 ukriegel@isst save $
 [Wed Apr 14 11:40:48 1993] Intention for change:
 slot gc-traces  belongs to class not to the representation
 change canonize-gc-tracer
 done
 
mm-initialize.em[1.9] Wed Apr 14 12:37:30 1993 ukriegel@isst save $
 ~compute-constructor/predicate methods added for abstrct-class-def and tail-class def respectively
 
mm-initialize.em[1.10] Wed Apr 14 14:08:29 1993 ukriegel@isst save $
 ?size replaced by ?byte-length
 
mm-initialize.em[1.11] Wed Apr 14 16:31:33 1993 ukriegel@isst save $
 [Wed Apr 14 15:23:55 1993] Intention for change:
 no initialization for %class %abstract-class <basic-class-def> .
 done and predefined card-descriptor 10 for %class
 
mm-initialize.em[1.12] Wed Apr 14 17:04:39 1993 ukriegel@isst save $
 [Wed Apr 14 17:00:07 1993] Intention for change:
 whc-classes exports <basic-class-def> not tail-module, so I have to add an import.
 done
 
mm-initialize.em[1.13] Thu Apr 15 13:42:40 1993 ukriegel@isst save $
 [Thu Apr 15 13:23:07 1993] Intention for change:
 general-object-tracer must be renamed into trace-general-object
 done
 
mm-initialize.em[1.14] Fri Apr 16 14:10:41 1993 ukriegel@isst proposed $
 [Fri Apr 16 12:45:30 1993] Intention for change:
 literal instances for mm-constants
 done
 
mm-initialize.em[1.15] Fri Apr 16 15:15:25 1993 ukriegel@isst save $
 
mm-initialize.em[1.16] Fri Apr 16 15:17:27 1993 ukriegel@isst save $
 in constructor-bq-expression let -> ,^let
 vector imported from cl
 
mm-initialize.em[1.17] Fri Apr 16 15:46:33 1993 ukriegel@isst save $
 [Fri Apr 16 15:45:24 1993] Intention for change:
 body in complete-function encapsulated by an progn
 done
 
mm-initialize.em[1.18] Fri Apr 16 15:57:05 1993 ukriegel@isst save $
 [Fri Apr 16 15:48:59 1993] Intention for change:
 documentation
 
mm-initialize.em[1.19] Fri Apr 16 16:10:17 1993 ukriegel@isst save $
 
mm-initialize.em[1.20] Fri Apr 16 16:28:48 1993 ukriegel@isst proposed $
 make-card-descriptor now with %signed-byte-integer
 
mm-initialize.em[1.21] Mon Apr 19 13:03:34 1993 ukriegel@isst proposed $
 [Mon Apr 19 12:06:54 1993] Intention for change:
 for function-objects declare type %function
 done
 
mm-initialize.em[1.22] Tue Apr 20 13:53:10 1993 ukriegel@isst proposed $
 [Tue Apr 20 13:36:59 1993] Intention for change:
 don#t use ?representation
 (car superclasses) replaced by (car (cdr superclasses)) in canonize allocation
 
mm-initialize.em[1.23] Fri Apr 23 06:12:54 1993 ukriegel@isst save $
 structure changed to compute-constructur-using-representation
 seems to work for pointer-to-struct
 
mm-initialize.em[1.24] Fri Apr 23 08:11:20 1993 ukriegel@isst save $
 now some more casts meet the spec of mm-interface
 a wrong increment of last-used-card-descriptor was replaced by last used-type-descriptor
 literal instances for system classes have now the correct %unsigned-half-integer for mm-type and card
 
mm-initialize.em[1.25] Mon Apr 26 08:48:47 1993 ukriegel@isst save $
 
mm-initialize.em[1.26] Mon Apr 26 12:07:40 1993 ukriegel@isst save $
 
mm-initialize.em[1.27] Tue Apr 27 11:16:14 1993 ukriegel@isst save $
 
mm-initialize.em[1.28] Tue Apr 27 14:30:36 1993 ukriegel@isst proposed $
 [Tue Apr 27 14:28:29 1993] Intention for change:
 imports from machine-description
 .,
 done
 
mm-initialize.em[1.29] Tue Apr 27 14:38:47 1993 ukriegel@isst save $
 
mm-initialize.em[1.30] Tue Apr 27 14:40:41 1993 ukriegel@isst proposed $
 to make rr happy everything with <%direct> is commented
 
mm-initialize.em[1.31] Wed Apr 28 14:04:04 1993 ukriegel@isst proposed $
 done
 + constructors for vector classes
 
mm-initialize.em[1.32] Thu Apr 29 13:12:42 1993 ukriegel@isst save $
 Init of basic-classes
 
mm-initialize.em[1.33] Thu Apr 29 13:52:11 1993 ukriegel@isst save $
 dummy-init
 
mm-initialize.em[1.34] Fri Apr 30 10:45:41 1993 ukriegel@isst save $
 changed to 5 class slots
 
mm-initialize.em[1.35] Fri Apr 30 16:41:05 1993 ukriegel@isst proposed $
 size for classes now 16 byte
 
mm-initialize.em[1.36] Mon May  3 14:17:31 1993 ukriegel@isst proposed $
 [Mon May  3 14:15:27 1993] Intention for change:
 make-instance -> cl:make-instance
 done
 
mm-initialize.em[1.37] Tue May  4 07:58:43 1993 ukriegel@isst save $
 
mm-initialize.em[1.38] Tue May  4 08:00:38 1993 ukriegel@isst save $
 
mm-initialize.em[1.39] Wed May  5 09:35:01 1993 ukriegel@isst save $
 default-multiple-size-card-descr set for %string
 
mm-initialize.em[1.40] Wed May  5 11:06:35 1993 ukriegel@isst save $
 initialization for %string
 
mm-initialize.em[1.41] Wed May  5 12:13:12 1993 ukriegel@isst save $
 
mm-initialize.em[1.42] Wed May  5 15:26:43 1993 ukriegel@isst save $
 set allocation to multiple-type-card for class abstract class object metaclass
 
mm-initialize.em[1.43] Wed May  5 16:00:49 1993 ukriegel@isst proposed $
 adding :slot slot to accessor functions
 
mm-initialize.em[1.44] Thu May  6 10:52:14 1993 ukriegel@isst proposed $
 [Thu May  6 08:06:35 1993] Intention for change:
 
 dummy-initialization for <abstract-class-def>
 
mm-initialize.em[1.45] Thu May  6 12:08:49 1993 ukriegel@isst save $
 
mm-initialize.em[1.46] Thu May  6 12:28:41 1993 ukriegel@isst save $
 
mm-initialize.em[1.47] Fri May  7 10:38:18 1993 ukriegel@isst save $
 typing mistakre
 
mm-initialize.em[1.48] Fri May  7 10:51:27 1993 ukriegel@isst save $
 
mm-initialize.em[1.49] Fri May  7 17:50:01 1993 ukriegel@isst proposed $
 cast around $select for trace-pointer
 
mm-initialize.em[1.50] Mon May 10 10:11:16 1993 ukriegel@isst proposed $
 [Mon May 10 10:08:48 1993] Intention for change:
 mm-initialize method for direct
 done
 
mm-initialize.em[1.51] Mon May 10 15:28:29 1993 ukriegel@isst proposed $
 [Mon May 10 13:56:47 1993] Intention for change:
 pointer-to-void changes in trace-fcn
 done
 
mm-initialize.em[1.52] Tue May 11 13:30:59 1993 ukriegel@isst proposed $
 [Tue May 11 11:46:10 1993] Intention for change:
 dummy init for <%direct> added
 
mm-initialize.em[1.53] Fri May 14 13:45:28 1993 ukriegel@isst save $
 [Thu May 13 08:54:48 1993] Intention for change:
 version with long type-and-card descrs
 and init-forms formax-used-???-descrs added
 
mm-initialize.em[1.54] Fri May 14 17:16:33 1993 ukriegel@isst proposed $
 [Fri May 14 14:06:19 1993] Intention for change:
 initialization form for max-used-card-descriptor.
 
mm-initialize.em[1.55] Tue May 18 12:20:29 1993 ukriegel@isst save $
 
mm-initialize.em[1.56] Wed May 19 16:41:11 1993 ukriegel@isst proposed $
 
mm-initialize.em[1.57] Wed May 26 09:14:10 1993 ukriegel@isst save $
 [Wed May 26 09:09:57 1993] Intention for change:
 length in vector is number not literal instance
 done
 
mm-initialize.em[1.58] Wed May 26 15:02:11 1993 ukriegel@isst proposed $
 [Wed May 26 14:53:30 1993] Intention for change:
 constructor for direct
 done
 
mm-initialize.em[1.59] Wed May 26 16:51:22 1993 ukriegel@isst proposed $
 [Wed May 26 16:22:23 1993] Intention for change:
 continuation in compiler-error missed
 done
 
mm-initialize.em[1.60] Wed May 26 17:26:15 1993 ukriegel@isst save $
 [Wed May 26 17:24:33 1993] Intention for change:
 ensure-vector-length returns lit inst. of type %swi
 dondone
 
mm-initialize.em[1.61] Wed May 26 17:59:01 1993 ukriegel@isst proposed $
 [Wed May 26 17:54:51 1993] Intention for change:
 
mm-initialize.em[1.62] Thu Jun 10 11:48:34 1993 ukriegel@isst proposed $
 [Thu Jun 10 09:42:28 1993] Intention for change:
 correct init for vectors length is spint
 length is %unsigned-word-integer
 
mm-initialize.em[1.63] Tue Jun 22 10:35:00 1993 ukriegel@isst save $
 generate initfun only if there are init-params
 
mm-initialize.em[1.64] Tue Jun 22 13:21:33 1993 ukriegel@isst proposed $
 nothing done
 
mm-initialize.em[1.65] Wed Jun 23 16:24:53 1993 ukriegel@isst proposed $
 [Wed Jun 23 15:27:25 1993] Intention for change:
 mm-initialize-using-representation for pointer-to-vector
 supplies nil for multiple-size-cards if size is not given
 change canonize-mm-card to generic
 done
 
mm-initialize.em[1.66] Tue Jun 29 09:38:00 1993 ukriegel@isst proposed $
 [Tue Jun 29 08:35:40 1993] Intention for change:
 vector init fun makes type-clashes if element or length are parameters
 length parameter, if given in constructor funs, must be of type %signed-word-integer.
 
mm-initialize.em[1.67] Tue Jul  6 11:43:23 1993 ukriegel@isst proposed $
 $largest-predefined-type-descriptor added, tds will be generated if needed
 proper initialization added
 
mm-initialize.em[1.68] Tue Jul  6 13:40:24 1993 ukriegel@isst proposed $
 [Tue Jul  6 12:32:55 1993] Intention for change:
 add generated-mm-types
 done
 
mm-initialize.em[1.69] Fri Jul  9 11:56:34 1993 ukriegel@isst proposed $
 [Wed Jul  7 07:59:36 1993] Intention for change:
 collect all initialized classes in initialized-classes
 done
 
mm-initialize.em[1.70] Tue Aug 10 14:10:38 1993 imohr@isst proposed $
 [Tue Aug 10 13:58:57 1993] Intention for change:
 remove generation of slot-writers for representation direct
 ok
 
mm-initialize.em[1.71] Mon Aug 23 11:20:01 1993 ukriegel@isst proposed $
 [Mon Aug 23 10:28:05 1993] Intention for change:
 condition handling
 no writer constructed, only bindings
 
mm-initialize.em[1.72] Tue Aug 24 09:12:13 1993 ukriegel@isst proposed $
 [Tue Aug 24 09:08:32 1993] Intention for change:
 
mm-initialize.em[1.73] Fri Aug 27 17:08:03 1993 imohr@isst save $
 [Fri Aug 27 13:48:58 1993] Intention for change:
 creation of function pointers by %function-literal
 explicit use of make-instance for <literal-instance> replaced by
 make-literal-instance
 
mm-initialize.em[1.74] Wed Sep  1 18:08:10 1993 imohr@isst proposed $
 [Tue Aug 31 07:16:11 1993] Intention for change:
 static initialization of basic classes
 
mm-initialize.em[1.75] Wed Sep  8 12:46:26 1993 ukriegel@isst published $
 [Wed Sep  8 10:59:38 1993] Intention for change:
 correct tracing for pointer-to-struct-reprs.
 pointer-representation-p changed
 
mm-initialize.em[1.76] Thu Sep 23 13:58:11 1993 imohr@isst proposed $
 [Tue Sep 21 16:11:53 1993] Intention for change:
 naming gc tracers
 improved naming of generated functions
 
mm-initialize.em[1.77] Fri Sep 24 13:16:57 1993 ukriegel@isst proposed $
 [Fri Sep 24 13:16:50 1993] Intention for change:
 set predicate-signature
 done
 
mm-initialize.em[1.78] Thu Sep 30 16:16:03 1993 imohr@isst proposed $
 [Wed Sep 29 08:56:34 1993] Intention for change:
 + computation of allocator
 
mm-initialize.em[1.79] Tue Oct 12 15:34:30 1993 ukriegel@isst proposed $
 [Tue Oct 12 14:16:35 1993] Intention for change:
 ensure-vector-length
 
mm-initialize.em[1.80] Wed Oct 13 15:45:37 1993 imohr@isst proposed $
 [Wed Oct 13 08:25:23 1993] Intention for change:
 handling of slot initargs
 
mm-initialize.em[1.81] Fri Oct 15 17:34:22 1993 imohr@isst published $
 [Fri Oct 15 09:35:15 1993] Intention for change:
 + allocation ()
 
mm-initialize.em[1.82] Mon Nov  1 12:10:21 1993 ukriegel@isst proposed $
 [Mon Nov  1 10:54:38 1993] Intention for change:
 comp-constr using-rep ptr-to-vect lit inst for sze
 ~compute-constructor-using-representation for pointer-to-vector
 literal-instance for number-of-slots ok
 
mm-initialize.em[1.83] Thu Nov  4 09:15:55 1993 ukriegel@isst save $
 
mm-initialize.em[1.84] Mon Nov  8 11:55:41 1993 ukriegel@isst proposed $
 [Mon Nov  8 08:06:28 1993] Intention for change:
 new machine description, ~vector-class-instance-lengt ~vector-class-instance-length-literal
 
mm-initialize.em[1.85] Mon Nov 22 15:25:10 1993 ukriegel@isst save $
 [Mon Nov 22 05:56:01 1993] Intention for change:
 ?byte-length
 ?byte-length replaced by ?byte-length-of-instance. from mod. representation
 
mm-initialize.em[1.86] Tue Nov 23 12:52:39 1993 ukriegel@isst save $
 [Tue Nov 23 07:11:17 1993] Intention for change:
 last-used-card-des.
 macros
 
mm-initialize.em[1.87] Wed Nov 24 11:07:15 1993 ukriegel@isst proposed $
 [Wed Nov 24 10:03:08 1993] Intention for change:
 
mm-initialize.em[1.88] Tue Nov 30 13:16:28 1993 ukriegel@isst proposed $
 [Tue Nov 30 13:13:00 1993] Intention for change:
 delete last-used-type-desc.
 printout last-used-type-descriptor commented out
 

-----------------------------------------------------------------------------------
|#


#module mm-initialize
(import
(level-0-eulisp 
 mm-initialize-syntax ;for constants last-used-tds...
 compiler-conditions 
 lzs-mop 
 lzs 
 representation
 accessors 
 el2lzs
 (only (get-option check-options) option-lists)
 (only (complete-function add-function) el2lzs-rules)
 (only (<basic-class-def>
        <%pointer-to-struct>
        <%pointer-to-vector>
        <%pointer>
        <%direct>
        <%string>
        %string
        ) machine-description)
 tail-module
 apply-funs
 (only (?byte-length-of-instance ?byte-length-as-component) representation)
 
 (only (set-predicate-signature) type-inference)
 (rename   ((mapcan cl:mapcan)
            (mapcar cl:mapcar)
            (make-instance cl:make-instance)
            (find cl:find)
            (vector cl:vector)
            (member cl:member)
            (not cl:not))
   (only (mapcan mapcar make-instance find vector member not) common-lisp))
 
 expand-literal)
syntax 
(level-1-eulisp   
 mm-initialize-syntax             
 (rename
   ((push cl:push)
    (incf cl:incf)
    (cond cl:cond)
    ) common-lisp)
)


export (mm-initialize init-mm-initialize))



;;definitions and init-forms
;;; -----------------------------------------------------------------------------------
;;; Definition of used compiler-conditions
;;; -----------------------------------------------------------------------------------

(define-compiler-condition <wrong-allocation-argument> (<condition>)
  "The allocation argument ~A in class ~A is not defined" :argument :class )

(define-compiler-condition <wrong-initialization-argument-length-for-vector-class> (<condition>)
  "The vector class ~A is defined with an initvalue of ~A for length and can ~
therefore not have a length argument for the constructor function" :class
  :length)

(define-compiler-condition <missing-length-argument> (<condition>)
  "The vector class ~A is defined without  an initvalue and no init-value is~
given in the constructor form" :class )

;;; -----------------------------------------------------------------------------------
;;; Constants
;;; -----------------------------------------------------------------------------------

(defconstant $default-class-card-descriptor 10)
(defconstant $default-%string-card-descriptor 11)

(defconstant $dummy-class-mm-type (literal-instance %signed-word-integer -1))
(defconstant $dummy-class-mm-card (literal-instance %signed-word-integer -1))
;;$dynamic-class-mm-card-for-vector-classes is used to signal the need for
;;creating card descriptors in constructor functions during class definition and allocation 
;;if no length is given and if allocation is not on multiple-size-cards
(defconstant $dynamic-class-mm-card-for-vector-classes (literal-instance %signed-word-integer -10))
;;; -----------------------------------------------------------------------------------
;;; Variables, initial values for accumulator vars are set in init-mm-initialize
;;;
;;;-----------------------------------------------------------------------------------
(deflocal generated-mm-types ())

(deflocal initialized-classes ())
(deflocal last-used-type-descriptor-reset ())
;;Using %size-of there it is not possible to calculate the size of instances
;;during apply compilation -- therefore all multiple-type-card-instances have to
;;use card-descriptors which are created dynamically during runtime
(deflocal multiple-type-card-descriptors ())
(deflocal multiple-size-card-descriptors ());; default for class %string



;;; -----------------------------------------------------------------------------------
;;; Assumtion: mm-options not specified in %define-xx-class are set to ()
;;; mm-type specified ->
;;; 	corresponding card-descriptor is already used ->
;;;		generate '(set-type-descriptor mm-type (?gc-tracer representation))
;;;	corresponding card-descriptor not yet used ->		 
;;;			constructor can be generated with mm-type and mm-card values
;;;		generate '(set-type-descriptor mm-type (?gc-tracer representation))
;;;		         '(set-card-descriptor card-type size mm-type)
;;;			constructor can be generated with mm-type and mm-card values
;;; mm-type not specified ->
;;;	card and type descriptors must be generated dynamically at run-time
;;;	corresponding class slots must be set
;;;	constructor has to use values of mm-card and mm-type class slots
;;;	generate '(let* ((mm-type (make-type-descriptor class gc-tracer))
;;;                      (mm-card (make-card-descriptor card-type size mm-type)))
;;;                   (set-mm-type-in-class)
;;;                   (set-mm-card-in-class))
;;; -----------------------------------------------------------------------------------
;;; -----------------------------------------------------------------------------------
;;; Initialization of max-used-card-descriptor an max-used-type-descriptor
;;; -----------------------------------------------------------------------------------
(defun init-mm-initialize()
  ;;set accumulator vars
  (setq generated-mm-types ())
  (setq initialized-classes ())
  (setq last-used-type-descriptor 0)
  (setq last-used-type-descriptor-reset ())
  (setq last-used-card-descriptor 10)
  (setq multiple-type-card-descriptors 
        nil)
  (setq multiple-size-card-descriptors 
        nil)
  (let ((max-tds (cl:make-instance <defined-named-const> 
              :identifier ^max-used-type-descriptor
              :module-id  ^%tail
              :value (literal-instance %unsigned-word-integer last-used-type-descriptor)))
        (max-cds (cl:make-instance <defined-named-const> 
              :identifier ^max-used-card-descriptor
              :module-id  ^%tail
              :value (literal-instance %unsigned-word-integer last-used-card-descriptor))))
    (add-toplevel-forms-for-tail-module
     (list (cl:make-instance <app> 
             :function set-lowest-used-type-descriptor
             :arg-list 
             (list (cl:make-instance <app>
                     :function %plus
                     :arg-list (list (literal-instance %unsigned-word-integer 1)
                                     max-used-type-descriptor))))
           (cl:make-instance <app> 
             :function set-lowest-used-card-descriptor
             :arg-list
             (list (cl:make-instance <app>
                     :function %plus
                     :arg-list (list (literal-instance %unsigned-word-integer 1)
                                     max-used-card-descriptor))))))
    
  ))
  

;;; -----------------------------------------------------------------------------------
;;; 
;;; -----------------------------------------------------------------------------------

(defun dummy-initialization-for 
       (class representation-object)
  (setf(?mm-type representation-object) $dummy-class-mm-type)
  (setf(?mm-card representation-object) $dummy-class-mm-card)
  (setf(?allocation representation-object) ^multiple-type-card)
  (setf(?gc-tracer class) ^unknown)
  (setf(?allocator class) ^unknown)
  )
  
(defgeneric mm-initialize 
  (class representation-object allocation mm-type-literal))

(defmethod mm-initialize
           ((class <basic-class-def>) representation-object allocation mm-type-literal)
  ;;insert dummy values
  (dummy-initialization-for class representation-object))

(defmethod mm-initialize
           ((class <basic-class-def>) 
            (representation-object <%pointer-to-struct>) 
            allocation mm-type-literal)
  ; until now only %string
  (mm-initialize-standard class representation-object allocation
                          mm-type-literal))

(defmethod mm-initialize
           ((class <basic-class-def>) 
            (representation-object <%pointer-to-vector>) 
            allocation mm-type-literal)
  ; basic classes for this case not yet exist
  (mm-initialize-standard class representation-object allocation
                          mm-type-literal))

(defmethod mm-initialize
           ((class <abstract-class-def>) representation-object allocation mm-type-literal)
  (dummy-initialization-for class representation-object))

(defmethod mm-initialize
           ((class <tail-class-def>) representation-object allocation mm-type-literal)
  (if allocation
    (mm-initialize-standard class representation-object allocation
                            mm-type-literal)
    (dummy-initialization-for class representation-object)))

(defmethod mm-initialize
           ((class <standard-class-def>) (representation-object <%direct>)
            allocation mm-type-literal)
  ;;prevent <direct> from handling with mm-type
  (dummy-initialization-for  class representation-object))

(defmethod mm-initialize 
           ((class <standard-class-def>) representation-object allocation
            mm-type-literal)
  (mm-initialize-standard class representation-object allocation
                          mm-type-literal))

(defun mm-initialize-standard (class representation-object allocation mm-type-literal)
  (cl:push class initialized-classes)
  ;;generate mm-type if none is given
  ;;be careful in case of module compilation
  (let ((mm-type (if mm-type-literal
                   (if (numberp mm-type-literal)
                     mm-type-literal
                     (car (?value-list mm-type-literal)))
                   (progn
                     ;;reset of last used type descriptor to value of $largest-predefined-type-descriptor
                     ;;defined in module basic-classes-typedscrs
                     ;;must be done here and not in init-mm-initialize, because
                     ;;of $largest-predefined-type-descriptor is not available
                     ;;at initialization time
                     (if last-used-type-descriptor-reset
                       ()
                       (progn
                         (setq last-used-type-descriptor-reset t)
                         (setq last-used-type-descriptor 
                             (car (?value-list
                                   (?value $largest-predefined-type-descriptor))))
                         ;;(cl:format t "~%;;last-used-type-descriptor set to ~A" last-used-type-descriptor)
                         )
                       )
                     (setq last-used-type-descriptor (+ 1
                                                        last-used-type-descriptor))
                     (cl:push (cons last-used-type-descriptor class) generated-mm-types)
                     last-used-type-descriptor))))
    
    (mm-initialize-using-representation representation-object class allocation mm-type))
  )


(defmethod mm-initialize-using-representation
           ((representation-object <%direct>) class allocation mm-type)
  (dummy-initialization-for class representation-object))

(defmethod mm-initialize-using-representation
           ((representation-object <%pointer-to-struct>) class allocation mm-type)
  (canonize-gc-tracer class representation-object)
  (if mm-type
    (progn
      (canonize-mm-type class representation-object mm-type)
      (canonize-mm-card class representation-object 
                        (canonize-allocation class representation-object allocation) 
                        mm-type))
    (create-runtime-mm-initforms  representation-object class
                                  (canonize-allocation class representation-object allocation)))
  (canonize-allocator class representation-object)      ;this needs mm-type and mm-card
  )


(defmethod mm-initialize-using-representation
       ((representation-object <%pointer-to-vector>) class allocation mm-type)
  (canonize-gc-tracer class representation-object)
  (if (and mm-type (or (cl:not (null (~vector-class-instance-length class)))
                       (eq allocation ^multiple-size-card)))
    (progn
      (canonize-mm-type class representation-object mm-type)
      (canonize-mm-card class representation-object 
                        (canonize-allocation class representation-object allocation) 
                        mm-type))
    (create-runtime-mm-initforms  representation-object class
                                  (canonize-allocation class representation-object allocation)))
  )


(defun canonize-mm-type
       (class representation-object mm-type)
  (setf (?mm-type representation-object) (literal-instance %signed-word-integer mm-type))
  (if (>= mm-type last-used-type-descriptor);;= in case of generated mm-type
    (progn (setq last-used-type-descriptor mm-type)
           ;;last-used-type-descriptor contains the max of used type-descriptors
           (setf (car (?value-list (?value max-used-type-descriptor))) last-used-type-descriptor))
    ())
  ;add initform (set-type-descriptor mm-type class (?gc-tracer
  ;representation-object)) 
  (cl:push (cl:make-instance <app>
             :function set-type-descriptor
             :arg-list (list 
                        (literal-instance %unsigned-word-integer mm-type)
                        (cl:make-instance <app>
                          :function %cast
                          :arg-list (list
                                     %unsigned-word-integer
                                     class))
                        (cl:make-instance <app>
                          :function %cast
                          :arg-list (list
                                     %function
                                     (?gc-tracer class)))))
           (?initialization class))
  )

(defun canonize-gc-tracer 
       (class representation-object )
  ;;computes gc-tracer for a class and fills slot gc-tracer
  ;; should become true in the future
  ;; (setf(?gc-tracer representation-object) (generate-trace-code  representation-object class))
  (setf(?gc-tracer class) (generate-trace-code representation-object class )))

(defmethod create-runtime-cdscr-initform 
       (class cdscr cardtype size tdscr)
  ;;last-used-card-descriptor contains the max of used card descriptors
  ;;size is assumed to be an lzs-expression with %size-of or an literal
  (setf(car (?value-list (?value max-used-card-descriptor)))
       last-used-card-descriptor)
  (cl:push (cl:make-instance <app> 
             :function set-card-descriptor
             :arg-list (list 
                        (literal-instance %unsigned-word-integer cdscr)
                        (literal-instance %signed-byte-integer cardtype)
                        size
                        (literal-instance %unsigned-word-integer tdscr)
                        ))
           (?initialization class))
  
) 
;;; -----------------------------------------------------------------------------------
;;; Generation of type and card descriptors during runtime
;;; -----------------------------------------------------------------------------------

;;if no value for mm-type is given, it should be created during run time

(defun create-runtime-mm-initforms 
       (representation-object class allocation)
  (create-runtime-mm-type-initform representation-object class allocation)
  (create-runtime-mm-card-initform representation-object class allocation))



(defmethod create-runtime-mm-type-initform
       ((representation-object <%pointer>) class allocation)
  ;;actions to be done
  ;;set dummy values into mm-slots of representation-object to have no unbound slots
  (setf(?mm-type representation-object) $dummy-class-mm-type)
  ;;generation of typ descriptor
  ;;inscribe corresponding values into class-object
  ;;all constructors have to use the values from that class object
  ;;generate type-descriptor and sets mm-type
  (cl:push (cl:make-instance <app>
             :function set-class-mm-type
             :arg-list (list
                        class
                        (cl:make-instance <app>
                          :function make-type-descriptor
                          :arg-list (list
                                     (cl:make-instance <app>
                                                      :function %cast
                                                      :arg-list (list
                                                                 %unsigned-word-integer
                                                                 class))
                                     (cl:make-instance <app>
                                                      :function %cast
                                                      :arg-list (list
                                                                 %function
                                                                 (?gc-tracer class)))))))
           (?initialization class)))


(defmethod create-runtime-mm-card-initform
       ((representation-object <%pointer-to-struct>) class allocation)
  ;;actions to be done
  ;;set dummy values into mm-slots of representation-object to have no unbound values
  (setf(?mm-card representation-object) $dummy-class-mm-card)
  ;;generation card descriptor
  ;;inscribe corresponding values into class-object
  ;;all constructors have to use the values from that class object
  ;;generate card descriptor using mm-type from class and 
  ;;then set mm-card
  (cl:push (cl:make-instance <app>
             :function set-class-mm-card
             :arg-list (list
                        class
                        (cl:make-instance <app>
                          :function make-card-descriptor
                          :arg-list (list
                                     (literal-instance %signed-byte-integer  (card-type-code allocation))
                                     ;;(literal-instance %signed-word-integer
                                     ;;(?byte-length-of-instance representation-object))
                                     (cl:make-instance <app>
                                                      :function %size-of-instance
                                                      :arg-list (list class))
                                     (cl:make-instance <app>
                                       :function class-mm-type
                                       :arg-list (list class))))))
           (?initialization class))
  )


(defmethod create-runtime-mm-card-initform
           ((representation-object <%pointer-to-vector>) class allocation)
  ;;actions to be done
  ;;set dummy values into mm-slots of representation-object to have no unbound slots
  ;;generation of card descriptor if ~vector-class-instance-length is not () or
  ;;if allocation is multiple-size-card
  ;;inscribe corresponding values into class-object
  ;;if ~vector-class-instance-length returns nil ansd allocation is not multiple-size-card
  ;;no card descriptor can be generated. So every time a constructor is called,
  ;;there will be a call to make-card-descriptor which generates one if there is none
  ;;all constructors have to use the values from that class object
  ;;generate card descriptor using mm-type from class and 
  ;;then set mm-card
  
  (let ((size (~vector-class-instance-byte-length class allocation)))
    (if (eq size $dynamic-class-mm-card-for-vector-classes)
      ;;signal that there is a vector-class without known length
      (setf(?mm-card representation-object) $dynamic-class-mm-card-for-vector-classes)
      
      ;;there is a length defined as initvalue or vector is allocated on multiple
      ;;size card
      (progn
        ;;set dummy values into mm-slots of representation-object to have no unbound slots
        (setf(?mm-card representation-object) $dummy-class-mm-card)
        (cl:push (cl:make-instance <app>
                   :function set-class-mm-card
                   :arg-list (list
                              class
                              (cl:make-instance <app>
                                :function make-card-descriptor
                                :arg-list (list
                                           (literal-instance %signed-byte-integer  (card-type-code allocation))
                                           ;;(literal-instance %signed-word-integer (?byte-length-of-instance representation-object))
                                           ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                                           size
                                           (cl:make-instance <app>
                                             :function class-mm-type
                                             :arg-list (list class))))))
                 (?initialization class)))))
  )
  
  
(defun ~vector-class-instance-byte-length (class allocation)
  ;;returns either #%i0 or an corresponding lzs-expression with %size-of or
  ;;value of $dynamic-class-mm-card-for-vector-classes
  (let ((size (~vector-class-instance-length class)))
    (if (null size)
      (if (eq allocation ^multiple-size-card)
        (literal-instance %signed-word-integer 0)
        $dynamic-class-mm-card-for-vector-classes)
      (cl:make-instance <app>
        :function %mult
        :arg-list (list (literal-instance %signed-word-integer size)
                        (cl:make-instance <app>
                          :function %size-as-component
                          :arg-list (list (~vector-class-element-type
                                           class))))))))


(defun canonize-allocation (class representation-object allocation)
  ;;if no representation is given lookup in the superclass
  ;;returns allocation
  (if allocation
    allocation
    (setq allocation (?allocation (~class-representation (car (cdr (~class-precedence-list class)))))))
  (setf(?allocation representation-object) allocation)
  allocation)

;;; -----------------------------------------------------------------------------------
;;; canonize-mm... methods try to estimate descriptors during compilation time
;;; -----------------------------------------------------------------------------------

(defgeneric canonize-mm-card (class representation-object allocation mm-type))

(defmethod canonize-mm-card (class (representation-object <%pointer-to-vector>) allocation mm-type)
  ;;assume that allocation and mm-type are set
  ;;mm-type not set -> must be generated during run time
  ;;creation of card-descriptors
  (let ((estimated-size (?byte-length-of-instance representation-object))
        (size (~vector-class-instance-byte-length class allocation))
        (ctype (card-type-code allocation)))
    (cond  
     ((eq allocation ^single-card)
      ;;handle single card type descriptors
      
      (cl:incf last-used-card-descriptor )
      (setf (?mm-card representation-object) 
            (literal-instance %signed-word-integer last-used-card-descriptor))
	(create-runtime-cdscr-initform class last-used-card-descriptor
                                     ctype
                                     size 
                                     mm-type))
     ;;handle multiple type card descriptors
     ;;multiple type card descriptors is something like an option list with
     ;;estimated-size and corresponding card descriptor
     ((eq allocation ^multiple-type-card)
      (canonize-multiple-card-descriptors class representation-object size
                                          mm-type ctype estimated-size multiple-type-card-descriptors))
     ((eq allocation  ^multiple-size-card)
      ;;special treatent for vector with unknown size
      ;;size nil would result in %iNIL in set-mm-card
      ;; ~vector-class-instance-byte-length is always not null, so there is no
      ;; need to test length
      (canonize-multiple-card-descriptors class representation-object size mm-type ctype class multiple-size-card-descriptors))
     (t (compiler-error <wrong-allocation-argument> () :argument allocation
                        :class (?identifier class))))))

(defmethod canonize-mm-card 
       (class representation-object allocation mm-type)
  ;;assume that allocation and mm-type are set
  ;;mm-type not set -> must be generated during run time
  ;;creation of card-descriptors
  (let ((estimated-size (?byte-length-of-instance representation-object))
        ;;estimated-size is the size of instance in bytes
        ;;this calculatiion is not necessaryly machine-independent
        (ctype (card-type-code allocation))
        (size (cl:make-instance <app>
                :function %size-of-instance
                :arg-list (list class))))
    (cond  
     ((eq allocation ^single-card)
      ;;handle single card type descriptors
      
      (cl:incf last-used-card-descriptor )
      (setf (?mm-card representation-object) 
            (literal-instance %signed-word-integer last-used-card-descriptor))
	(create-runtime-cdscr-initform class last-used-card-descriptor
                                     ctype
                                     size 
                                     mm-type))
     ;;handle multiple type card descriptors
     ;;multiple type card descriptors is something like an option list with
     ;;estimated-size and corresponding card descriptor
     ((eq allocation ^multiple-type-card)
      (canonize-multiple-card-descriptors class representation-object size mm-type ctype estimated-size multiple-type-card-descriptors))
     ((eq allocation  ^multiple-size-card)
      (canonize-multiple-card-descriptors class representation-object size mm-type ctype class multiple-size-card-descriptors))
     (t (compiler-error <wrong-allocation-argument> () :argument allocation
                        :class (?identifier class))))))


;;; -----------------------------------------------------------------------------------
;;; Generation of trace functions
;;; -----------------------------------------------------------------------------------

(defgeneric pointer-representation-p(representation))

(defmethod pointer-representation-p 
           ((representation <%pointer>))
  t)
(defmethod pointer-representation-p 
           (representation)
  ())

(defgeneric generate-trace-code (representation-instance class))

(defmethod generate-trace-code
           ((representation-instance <%pointer-to-struct>)
            class )
  ;;returns a symbol naming the trace function or a lambda list 
  ;;containing (trace (%select object slot-name))-forms
  (let* ((slot-descrs (~class-slot-descriptions class))
         (len (length slot-descrs))
	 (ptr ^ptr)
	 (trace-calls (cl:mapcan (lambda(slot)
                                   (if (pointer-representation-p
                                        (?representation (~slot-description-type slot)))
                                     (list `(,trace-pointer (,%cast
                                                             ,<pointer-to-void>
                                                             (,^%select ,ptr
                                                                        ,(~slot-description-name
                                                                          slot)))))
                                     (); no trace necessary
                                     )) slot-descrs)) 
	 )
    (let ((le (length trace-calls)))
      (cond
       ;;nothing to do - object does not contain pointer
       ((= le 0)
        (%function-literal trace-nothing))
       ;;someting like a pair
       ((and (= le 2)(= len 2))
        (%function-literal trace-pair))
       ((and (= le len) (> le 1))
        (%function-literal trace-general-object))
       (t (%function-literal
           (add-function
            (complete-function 
             (cl:make-instance <global-fun>
               :range-and-domain (cl:vector %void class %signed-word-integer) 
               :identifier (list ^trace (?identifier class))
               )
             (list ptr ^length)
             (if (= le 1)
               (car trace-calls)
               (cons ^progn trace-calls))
             (?lex-env (find-module ^mm-interface))))))))))




(defmethod generate-trace-code
           ((representation-instance <%pointer-to-vector>)
            class )
  (if (pointer-representation-p (?representation (~vector-class-element-type class)))
    ;;since all elements have the same type, use trace-general-object
    (%function-literal trace-general-object)    
    ;;noting to do here
    (%function-literal trace-nothing)))


(defmethod generate-trace-code
           ((representation-instance <%direct>) class)
  (%function-literal trace-nothing))




(defun card-type-code
       (allocation)
  (if (eq allocation ^multiple-type-card) 
    1
    (if (eq allocation ^multiple-size-card)
      2
      4)
    )
  )

;;; -----------------------------------------------------------------------------------
;;; generation of forms used for the creation of constructors
;;; -----------------------------------------------------------------------------------

(defun convert-literal-for-allocation
       (li)
  ;;mm-type and mm-card are stored as %signed-word-integer
  ;;allocation functions require %unsigned-word-integer
  ;;so there is a neet for conversion
  (make-literal-instance %unsigned-word-integer 
                        (?value-list li)))

(defmethod generate-allocation-code 
       ((representation <%pointer-to-struct>) class parameters)
  (let* (
         (mm-type (?mm-type representation))
         (mm-card (?mm-card representation))
         (allocation (?allocation representation))
         ;;(size (?byte-length-of-instance representation))
         (tds (if (eq mm-type $dummy-class-mm-type) 
                `(,class-mm-type ,class)
                (convert-literal-for-allocation mm-type) ))
         (cds (if (eq $dummy-class-mm-card mm-card)  
                `(,class-mm-card ,class) 
                (convert-literal-for-allocation mm-card))))
    (if (eq allocation ^single-card)
      `(,allocate-on-single-card ,cds)
      (if (eq allocation ^multiple-type-card)
        `(,allocate-on-multiple-type-card ,cds ,tds)
        (if (eq allocation ^multiple-size-card)
         ;; `(,allocate-on-multiple-size-card ,cds ,(literal-instance
         ;;                                          %signed-word-integer size))
          `(,allocate-on-multiple-size-card ,cds (,%size-of-instance ,class))
          (compiler-error <wrong-allocation-argument> () :argument allocation
                          :class (?identifier class)))))))

;;; -----------------------------------------------------------------------------------
;;; Special treatment needed if no length is specified and allocation is one of
;;; single-card or multiple type card - the only chance I see is to generate a
;;; call to make-card-descriptor which looks in the mm-database whether or not a
;;; corresponding descriptor already exists - otherwise it creates one.
;;; -----------------------------------------------------------------------------------

(defmethod generate-allocation-code 
       ((representation <%pointer-to-vector>) class parameters)
  (let* (
         (mm-type (?mm-type representation))
         (mm-card (?mm-card representation))
         (allocation (?allocation representation))
         (size (ensure-vector-length representation class parameters))
         (ctype (literal-instance %signed-byte-integer (card-type-code allocation)))
         (tds (if (eq mm-type $dummy-class-mm-type) 
                `(,class-mm-type ,class )
                (convert-literal-for-allocation mm-type) ))
         (cds (if (eq $dummy-class-mm-card mm-card)  
                `(,class-mm-card ,class)
                (if (eq $dynamic-class-mm-card-for-vector-classes mm-card)
                  `(,make-card-descriptor ,ctype ,size ,tds) 
                  (convert-literal-for-allocation mm-card)))))
    (if (eq allocation ^single-card)
      `(,allocate-on-single-card ,cds)
      (if (eq allocation ^multiple-type-card)
        `(,allocate-on-multiple-type-card ,cds ,tds)
        (if (eq allocation ^multiple-size-card)
          `(,allocate-on-multiple-size-card ,cds (,%cast ,%signed-word-integer ,size))
          (compiler-error <wrong-allocation-argument> () :argument allocation
                          :class (?identifier class)))))))


;(defun ensure-vector-length 
;       (representation-instance class parameters)
;  (let ((initial-length (~vector-class-instance-length class ))
;        (length-parameter (cl:find ^length parameters)))
;    (cond ((and length-parameter initial-length)
;           (compiler-error
;            <wrong-initialization-argument-length-for-vector-class> ()
;                           :class class :length initial-length))
;          ((and (null initial-length) (cl:not length-parameter))
;           (compiler-error <missing-length-argument> () :class class))
;;          (initial-length (literal-instance %signed-word-integer (?byte-length-of-instance representation-instance)))
;;;;a hack to get true size 
;          (initial-length 
;           (literal-instance %signed-word-integer (* initial-length                                                              
;                                                       (?byte-length-as-component  (?representation
;                                                                                (~vector-class-element-type class)) ))))
;          (length-parameter
;           `(,%mult ,(literal-instance %signed-word-integer (?byte-length-as-component  (?representation
;                                                                                        (~vector-class-element-type class)) ))
;                     (,%cast ,%signed-word-integer ,^length)))
;          )
;    ))

(defun ensure-vector-length 
       (representation-instance class parameters)
  ;;
  ;;representation * class * parameters -> %unsigned-word-integer
  ;;
  (let ((initial-length (~vector-class-instance-length-literal class ))
        (length-parameter (cl:find ^length parameters)))
    (cond ((and length-parameter initial-length)
           (compiler-error
            <wrong-initialization-argument-length-for-vector-class> ()
            :class class :length initial-length))
          ((and (null initial-length) (cl:not length-parameter))
           (compiler-error <missing-length-argument> () :class class))
          (initial-length 
           `(,%mult (,%cast ,%unsigned-word-integer (,%size-as-component  ,(~vector-class-element-type class) ))
                    initial-length))
          (length-parameter
           `(,%mult (,%cast ,%unsigned-word-integer (,%size-as-component  ,(~vector-class-element-type class)))
                    (,%cast ,%unsigned-word-integer ,^length)))
          )
    ))
;;; -----------------------------------------------------------------------------------
;;; generation of constructors and predicates
;;; -----------------------------------------------------------------------------------

(defmethod ~compute-constructor 
           ((class <abstract-class-def>) parameters)
  ())

(defmethod ~compute-constructor
           ((class <standard-class-def>) parameters)
  (~compute-constructor-using-representation (?representation class) class
                                             parameters))


(defmethod ~compute-constructor-using-representation 
           ((representation-object <%direct>)
            class parameters)
  ;the number of arguments (length of parameters) should be exactly 1 and must
  ;name the only slot
  ;the constructor function only makes a type conversion from slot type to the
  ;class for which the constructor is created
  (add-function
     (complete-function 
      (cl:make-instance <constructor-fun>
        :range-and-domain 
        (cl:vector class
               (~slot-description-type (car (~class-slot-descriptions
                                             class))));;superclasses may not
                                                      ;;have slots
        :initargs parameters
        :constructor-for class)
      parameters                        ; lambda-list
      `(,%cast ,class ,(car parameters)); body
      (?lex-env (find-module ^mm-interface)))))



(defmethod ~compute-constructor-using-representation 
           ((representation-object <%pointer-to-struct>)
            class parameters)
  ;parameters which doesn't name a slot initarg are ignored
  (let* ((slot-descriptions (~class-slot-descriptions class))
         (access-list 
          (cl:mapcar (lambda(slot)
                       (let ((slot-name (~slot-description-name slot))
                             (initarg (~slot-description-initarg slot))
                             (initfunction (~slot-description-initfunction slot)))
                         (if (member initarg parameters)
                           ;;initarg of slot is contained in parameters
                           (list ^%setf (list ^%select ^alloc slot-name) 
                                 initarg)
                           (if initfunction
                             ;;there is a initfunction
                             (list ^%setf (list ^%select ^alloc slot-name) 
                                   (list initfunction))
                             ;;do nothing
                             ())))) 
                     slot-descriptions))
         )
    (add-function
     (complete-function 
      (cl:make-instance <constructor-fun>
        :range-and-domain 
        (apply #'cl:vector class
               (cl:mapcar (lambda (initarg)
                            (~slot-description-type
                             (cl:find initarg slot-descriptions 
                                      :key #'~slot-description-initarg)))
                          parameters))
        :initargs parameters
        :constructor-for class)
      parameters                        ; lambda-list
      `(,^let ((,^alloc (,%cast ,class ,(generate-allocation-code
                                          representation-object class parameters))))
              (,^progn
               ,@access-list
               ,^alloc))                                ; body
      (?lex-env (find-module ^mm-interface)))))
  )

(defmethod ~compute-constructor-using-representation 
           ((representation-object <%pointer-to-vector>)
            class parameters)
  ;the possible parameters for a vector constructor are element and length
  ;length must be given if the slot length has no initform
  ;length must not be given if the slot length has an initform
  ;element specifies the initial value for all vector elements
  ;element can be omitted in which case the vector is leaved uninitialized
  ;if element is given then an initfunction is generated which runs over the
  ;whole vector and initializes its elements with the argument element
  (let* ((slot-descriptions (~class-slot-descriptions class))
         (number-of-slots (if (~vector-class-instance-length-literal class)
                            (~vector-class-instance-length-literal class)
                            `(,%cast ,%unsigned-word-integer ,^length)))
         (init-value (if (member ^element parameters)
                       ^element
                       (if (~vector-class-element-initfunction class)
                         (list (~vector-class-element-initfunction class))
                         ())))
         (init-fun () ))
    ;;making init-fun
    (if init-value 
      (progn
        (setq init-fun (cl:make-instance <global-fun>
                         :range-and-domain (cl:vector %void class
                                                      %unsigned-word-integer
                                                      (~vector-class-element-type class)) 
                         :identifier (list ^init (?identifier class))
                         ))
        (add-function 
         (complete-function 
          init-fun
          ; lambda-list
          ^(instance length value) 
          ; body                       
          `(,^if (,%gt ,^length ,(literal-instance %unsigned-word-integer 0))
                 (,^progn (,^%setf(,^%extract ,^instance ,^length) 
                                  ,^value) 
                          (,init-fun ,^instance (,%minus ,^length
                                                         
                                                         ,(literal-instance %unsigned-word-integer 1)) ,^value))
                 (,^%setf (,^%extract ,^instance ,(literal-instance %unsigned-word-integer 0)) ,^value))                                
          (?lex-env (find-module ^mm-interface)))))
      ())
    ;;still to do initialization
    (add-function
     (complete-function 
      (cl:make-instance <constructor-fun>
        :range-and-domain 
        (apply #'cl:vector class
               (cl:mapcar (lambda (slot-name)
                            (~slot-description-type
                             (cl:find slot-name slot-descriptions 
                                      :key #'~slot-description-name)))
                          parameters))
        :initargs parameters
        :constructor-for class)
      parameters                        ; lambda-list
      
      (if init-fun
        `(,^let ((,^alloc (,%cast ,class ,(generate-allocation-code
                                           representation-object class parameters))))
                (,^progn
                 
                 (,init-fun ,^alloc ,number-of-slots ,init-value)
                 
                 ,^alloc))
        `(,%cast ,class ,(generate-allocation-code
                          representation-object class parameters)))                                
      (?lex-env (find-module ^mm-interface))))
    ))



;;; -----------------------------------------------------------------------------------
;;; installing allocator function in a class
;;; -----------------------------------------------------------------------------------

(defgeneric canonize-allocator (class representation))

(defmethod canonize-allocator (class (representation <%pointer-to-struct>))
  (setf (?allocator class)
        (add-function
         (complete-function
          (cl:make-instance <global-fun>
            :range-and-domain (cl:vector class)
            :identifier (list ^allocate (?identifier class)))
          ()                            ; no parameters
          `(,%cast ,class
                   ,(generate-allocation-code representation class ()))
          (?lex-env (find-module ^mm-interface))))))

;;; -----------------------------------------------------------------------------------
;;; Predicates
;;; -----------------------------------------------------------------------------------

(defmethod ~compute-predicate ((class <standard-class-def>))
  (let ((pred (add-function
               (complete-function
                (cl:make-instance <global-fun> :range-and-domain (cl:vector %object %object))
                ^(object)                             ; lambda-list
                `(,%instance-of-p ,^object ,class)    ; body
                ()))))
    ;;set signature for predicate
    (set-predicate-signature pred class)
    pred))


(defmethod ~compute-predicate 
           ((class <tail-class-def>))
  ())


;;; -----------------------------------------------------------------------------------
;;; Reader and Writer
;;; -----------------------------------------------------------------------------------

(defmethod ~compute-slot-reader 
           (class slot effective-slots)
  (~compute-slot-reader-using-representation (?representation class) class slot
                                             effective-slots))
;;reader for direct values is only a cast to the slot-type
(defmethod ~compute-slot-reader-using-representation 
           ((representation-object <%direct>)
            class slot effective-slots)
  (add-function
   (complete-function (cl:make-instance <slot-accessor-fun>
                        :slot slot
                        :range-and-domain (cl:vector (~slot-description-type slot)
                                                  class))
                      ^(object)
                      `(,%cast  ,(~slot-description-type slot) ,^object)
                      (tail-environment))))

(defmethod ~compute-slot-reader-using-representation 
           ((representation-object <%pointer-to-struct>)
            class slot effective-slots)
  (add-function
   (complete-function (cl:make-instance <slot-accessor-fun>
                        :slot slot
                        :range-and-domain (cl:vector (~slot-description-type slot)
                                                  class))
                      ^(object)
                      `(,^%select ,^object ,(~slot-description-name slot))
                      (tail-environment))))

(defmethod ~compute-slot-reader-using-representation 
           ((representation-object <%pointer-to-vector>)
            class slot effective-slots)
  (if (eq ^element (~slot-description-name slot))
    ;;reader for element = access fun for vectors
    (add-function
     (complete-function (cl:make-instance <slot-accessor-fun>
                          :slot slot
                          :range-and-domain (cl:vector (~slot-description-type slot)
                                                    class %unsigned-word-integer))
                        ^(object index)
                        `(,%extract ,^object ,^index)
                        (tail-environment)))
    ;;reader for length = call to object-size which is imported in mm-initialize
    (add-function
     (complete-function (cl:make-instance <slot-accessor-fun>
                          :slot slot
                          :range-and-domain (cl:vector %unsigned-word-integer
                                                    class))
                        ^(object)
;                        `(,%cast ,%unsigned-word-integer 
;                                (,%div  (,%vector-class-instance-size ,^object) 
;                                        ,(literal-instance %unsigned-word-integer (?byte-length-as-component  (?representation
;                                                                           
;                                                                           (~vector-class-element-type class))))))
                        `(,%div  (,%vector-class-instance-size ,^object) 
                                        (,%cast ,%unsigned-word-integer (,%size-as-component ,(~vector-class-element-type class))))
                        (tail-environment)))))



(defmethod ~compute-slot-writer 
           (class slot effective-slots)
  (~compute-slot-writer-using-representation (?representation class) class slot
                                             effective-slots))


(defmethod ~compute-slot-writer-using-representation 
           ((representation-object <%direct>) 
            class slot effective-slots)
  ; a writer for classes with representation direct isn't possible
  nil)

(defmethod ~compute-slot-writer-using-representation 
           ((representation-object <%pointer-to-struct>) 
            class slot effective-slots)
  (add-function
   (complete-function (cl:make-instance <slot-accessor-fun>
                        :slot slot
                        :range-and-domain (cl:vector (~slot-description-type slot)
                                                  class
                                                  (~slot-description-type slot)))
                      ^(object new-value)
                      `(,^%setf (,^%select ,^object 
                                           ,(~slot-description-name slot))
                                ,^new-value)
                      (tail-environment))))


(defmethod ~compute-slot-writer-using-representation 
           ((representation-object <%pointer-to-vector>) 
            class slot effective-slots)
  
  (if (eq ^element (~slot-description-name slot))
    (add-function
     (complete-function (cl:make-instance <slot-accessor-fun>
                          :slot slot
                          :range-and-domain (cl:vector (~slot-description-type slot)
                                                    class %unsigned-word-integer
                                                    (~slot-description-type slot)))
                        ^(object index new-value)
                        `(,^%setf (,%extract ,^object ,^index)
                                  ,^new-value)
                        (tail-environment)))
    ;writer for length cannot be constructed
    ()
  ))


(defun info()
  (mm-describe initialized-classes))

(defun mm-describe(l)
  (if (null l)
    ()
    (progn
      (let* ((class (car l))
           (representation (?representation class))
           (mm-type (car (?value-list(?mm-type representation))))
           (mm-card (car (?value-list (?mm-card representation))))
           (allocation (symbol-name (?allocation representation))))
      (cl:format t "~%Class ~a has ~%~3Trepresentation ~a ~%~3Tmm-type: ~A ~%~3Tmm-card: ~A
~%~3Tallocation: ~a" (symbol-name (?identifier class)) 
                 #+:ALLEGRO(clos::class-name (clos::class-of representation))
                 #-:ALLEGRO (cl:class-name (cl:class-of representation)) mm-type mm-card allocation))
      (mm-describe (cdr l)))))

#module-end
