;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: lzs-class-init -*-
#|
-----------------------------------------------------------------------------------
TITLE: module for the definition of tail data types
-----------------------------------------------------------------------------------
File:    lzs-class-init.em
Version: 1.19 (last modification on Fri Oct 15 10:35:09 1993)
State:   proposed

DESCRIPTION:
initialisation of object system

DOCUMENTATION:


NOTES:


REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
w. heicking

CONTACT: 
w. heicking

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/lzs-class-init.em[1.0]
	Tue Mar 30 15:08:46 1993 wheick@isst save $
 initialization of lzs classes
 
lzs-class-init.em[1.1] Wed Mar 31 10:39:42 1993 imohr@isst proposed $
 + initialization for %object and %class
 
lzs-class-init.em[1.2] Fri Apr  2 16:04:19 1993 imohr@isst proposed $
 [Thu Apr  1 14:58:09 1993] Intention for change:
 initialization of predefined classes
 
lzs-class-init.em[1.3] Wed Apr  7 09:38:46 1993 imohr@isst proposed $
 [Wed Apr  7 09:16:02 1993] Intention for change:
 removing activation of initialize for predefined classes
 
lzs-class-init.em[1.4] Thu Apr  8 15:20:55 1993 imohr@isst proposed $
 code generation for classes ok
 
lzs-class-init.em[1.5] Mon Apr 19 15:43:07 1993 imohr@isst proposed $
 %function
 
lzs-class-init.em[1.6] Tue Apr 20 16:09:24 1993 imohr@isst proposed $
 [Mon Apr 19 15:44:49 1993] Intention for change:
 --- no intent expressed ---init for basic classes (%signed-word-integer.)
 
lzs-class-init.em[1.7] Fri Apr 30 17:21:42 1993 imohr@isst save $
 + collection of static symbols and generic functions
 
lzs-class-init.em[1.8] Fri Apr 30 17:23:22 1993 imohr@isst save $
 mapcar imported
 
lzs-class-init.em[1.9] Mon May  3 13:30:47 1993 imohr@isst proposed $
 + lists for statically allocated instances
 
lzs-class-init.em[1.10] Thu May  6 08:44:49 1993 imohr@isst proposed $
 %string
 
lzs-class-init.em[1.11] Wed Jun  2 10:48:40 1993 imohr@isst proposed $
 + initialization of *list-of-new-slot-descriptions*
 
lzs-class-init.em[1.12] Thu Jun  3 14:37:10 1993 imohr@isst proposed $
 slot accessors for %object. are now deleted during initialization
 
lzs-class-init.em[1.13] Wed Jul 14 15:50:58 1993 imohr@isst proposed $
 
lzs-class-init.em[1.14] Thu Aug  5 09:35:11 1993 imohr@isst proposed $
 [Thu Jul 22 08:34:10 1993] Intention for change:
 --- no intent expressed ---+ initialization for basic class %string
 
lzs-class-init.em[1.15] Wed Sep  1 18:07:59 1993 imohr@isst published $
 [Tue Aug 31 07:34:23 1993] Intention for change:
 static initialization of basic classes
 
lzs-class-init.em[1.16] Fri Sep 17 16:00:52 1993 imohr@isst proposed $
 [Fri Sep 17 14:00:03 1993] Intention for change:
 put list of collected symbols into module %tail
 
lzs-class-init.em[1.17] Thu Sep 30 16:16:17 1993 imohr@isst proposed $
 [Thu Sep 23 08:11:39 1993] Intention for change:
 + converter
 make slot accessors available in %tail
 
lzs-class-init.em[1.18] Fri Oct  1 18:47:42 1993 imohr@isst proposed $
 [Fri Oct  1 07:16:47 1993] Intention for change:
 provide slot-accessors for %string, %class.
 
lzs-class-init.em[1.19] Fri Oct 15 17:34:53 1993 imohr@isst proposed $
 [Fri Oct 15 09:09:18 1993] Intention for change:
 + option reader for %string in slot description list for initialize
 

-----------------------------------------------------------------------------------
|#
;;;begin module lzs-class-init

#module-name lzs-class-init


#module-import
(accessors
 level-1-eulisp
 lzs
 lzs-mop
 standard-init
 el2lzs
 expand-literal
 tail-module
 (only (mm-initialize) mm-initialize)
 (only (make-instance append mapc apply mapcar vector remove-if)
   common-lisp)
 machine-description)

#module-syntax-import
(level-1-eulisp 
 apply-standard 
 debugging
 (only (instance-of-p) el2lzs-main)
 (only (setf push)
   common-lisp)
 )

#module-syntax-definitions

#module-header-end

(export 
  initialize-predefined-standard-classes
  initialize-static-instance-collectors 
  set-static-instance-collectors
  )

(defconstant $class-type-descriptor 4)
(defconstant $abstract-class-type-descriptor 5)
(defconstant $tail-class-type-descriptor 6)
(defconstant $%string-type-descriptor 7)

(defgeneric generated-function-p (fun))
(defmethod generated-function-p (fun) nil)
(defmethod generated-function-p ((fun <slot-accessor-fun>)) t)
(defmethod generated-function-p ((fun <slot-init-fun>)) t)
(defmethod generated-function-p ((fun <constructor-fun>)) t)

(defun initialize-predefined-standard-classes ()
(dynamic-let ((*current-module* $tail-module))

   ; the following variable must be set to () before any slot description is
   ; created 
   (setq *list-of-new-slot-descriptions* nil)

   ; remove all generated accessor-functions... created in a previous run for
   ; %object... in module %tail
   (setf (?fun-list $tail-module)
         (remove-if #'generated-function-p (?fun-list $tail-module)))

   (setf (?class %object) %abstract-class)
   (setf (?class %class) %class)

   (~initialize %object 
                (list ^name ^%object
                      ^direct-superclasses ()
                      ^direct-slot-descriptions ()
                      ^direct-initargs ()
                      ^representation ^pointer-to-void
                      ))
   (~initialize %class 
                (list ^name ^%class
                      ^direct-superclasses (list %object)
                      ^direct-slot-descriptions 
                      (list (list ^name ^class-precedence-list 
                                  ^type %object)
                            (list ^name ^slot-descriptions 
                                  ^type %object)
                            (list ^name ^mm-type
                                  ^type %signed-word-integer)
                            (list ^name ^mm-card
                                  ^type %signed-word-integer)
                            (list ^name ^gc-tracer
                                  ^type %function)
                            (list ^name ^converter
                                  ^type %object)
                            (list ^name ^allocator
                                  ^type %function)
                            )
                      ^direct-initargs ^(name 
                                         direct-superclasses 
                                         direct-slot-descriptions 
                                         direct-initargs)
                      ^representation ^pointer-to-struct
                      ^allocation ^multiple-type-card
                      ^mm-type $class-type-descriptor
                      ))

   (name-and-export-reader %class ^class-precedence-list 
                           ^%class-precedence-list)
   (name-and-export-reader %class ^slot-descriptions 
                           ^%class-slot-descriptions)
   (name-and-export-accessor %class ^mm-type 
                           ^%class-mm-type)
   (name-and-export-accessor %class ^mm-card 
                           ^%class-mm-card)
   (name-and-export-accessor %class ^gc-tracer 
                           ^%class-gc-tracer)
   (name-and-export-reader %class ^converter 
                           ^%class-converter)
   (name-and-export-reader %class ^allocator 
                           ^%class-allocator)

   (~initialize %abstract-class 
                (list ^name ^%abstract-class
                      ^direct-superclasses (list %class)
                      ^direct-slot-descriptions ()
                      ^direct-initargs ()
                      ^representation ^pointer-to-struct
                      ^mm-type $abstract-class-type-descriptor
                      ^allocation ^multiple-type-card
                      ))
   (~initialize %tail-class 
                (list ^name ^%tail-class
                      ^direct-superclasses (list %class)
                      ^direct-slot-descriptions ()
                      ^direct-initargs ()
                      ^representation ^pointer-to-struct
                      ^mm-type $tail-class-type-descriptor
                      ^allocation ^multiple-type-card
                      ))
   (~initialize %string 
                (list ^name ^%string
                      ^direct-superclasses ()
                      ^direct-slot-descriptions 
                      (list (list ^name ^length)
                            (list ^name ^element
                                  ^type %unsigned-byte-integer
                                  ^reader t
                                  ^writer t)
                            )
                      ^direct-initargs ^(length element)
                      ^representation ^pointer-to-vector
                      ^mm-type $%string-type-descriptor
                      ^allocation ^multiple-size-card
                      ))

   (name-and-export-accessor %string ^element
                             ^%string-ref)

   (add-toplevel-forms-for-tail-module (?initialization %object))
   (add-toplevel-forms-for-tail-module (?initialization %class))
   (add-toplevel-forms-for-tail-module (?initialization %abstract-class))
   (add-toplevel-forms-for-tail-module (?initialization %tail-class))
   (add-toplevel-forms-for-tail-module (?initialization %string))
   
   (mapc #'initialize-basic-class (?class-def-list $tail-module))
   
))

(defgeneric initialize-basic-class (class))
(defmethod initialize-basic-class (class) nil)
(defmethod initialize-basic-class ((class <%string>)) 
  (setf (?class class) %tail-class)
  (setf (?expanded-literal class) nil)
  (setf (?class-precedence-list class) nil))
(defmethod initialize-basic-class ((class <basic-class-def>)) 
  (setf (?place class) nil)
  (setf (?expanded-literal class) nil)
  (setf (?initialization class) nil)
  (setf (?class class) %tail-class)
  (setf (?class-precedence-list class) nil)
  ;lattice-type is set by the initialization of the type inference
  (mm-initialize class (?representation class)
                 nil nil)
  )

(defun initialize-static-instance-collectors ()
  (let ((list-of-static-symbols
         (find-lexical ^%list-of-static-symbols $tail-module))
        (list-of-static-generic-functions
         (find-lexical ^%list-of-static-generic-functions $tail-module)))
    (unless list-of-static-symbols
      (setq list-of-static-symbols
            (make-instance <defined-named-const> 
              :identifier ^%list-of-static-symbols
              :module-id  ^%tail
              :value ^unknown))
      (add-lexical list-of-static-symbols $tail-module ^export))
    (unless list-of-static-generic-functions
      (setq list-of-static-generic-functions
            (make-instance <defined-named-const> 
              :identifier ^%list-of-static-generic-functions
              :module-id  ^%tail
              :value ^unknown))
      (add-lexical list-of-static-generic-functions $tail-module ^export))

    (setf (?value list-of-static-symbols) ^unknown)
    (setf (?code-identifier list-of-static-symbols) nil)
    (setf (?exported list-of-static-symbols) nil)
    (setf (?place list-of-static-symbols) nil)
    (setf (?type list-of-static-symbols) %object)

    (setf (?value list-of-static-generic-functions) ^unknown)
    (setf (?code-identifier list-of-static-generic-functions) nil)
    (setf (?exported list-of-static-generic-functions) nil)
    (setf (?place list-of-static-generic-functions) nil)
    (setf (?type list-of-static-generic-functions) %object)
    ))

(defun set-static-instance-collectors (modules)
  (setf (?value (find-lexical ^%list-of-static-symbols $tail-module))
        (dynamic symbol-env))
  (setf (?sym-list $tail-module) (dynamic symbol-env)))

(defun name-and-export-reader (class slot-name reader-name)
  (let ((reader (~slot-description-slot-reader
                 (~find-slot-description class slot-name))))
    (setf (?identifier reader) reader-name)
    (push reader (?lex-env $tail-module))
    (push reader (?exports $tail-module))))

(defun name-and-export-accessor (class slot-name accessor-name)
  (let* ((slot (~find-slot-description class slot-name))
         (accessor (~slot-description-slot-reader slot))
         (writer (~slot-description-slot-writer slot)))
    (setf (?identifier accessor) accessor-name)
    (setf (?identifier writer) (list ^setter accessor-name))
    (setf (?setter accessor) writer)
    (push accessor (?lex-env $tail-module))
    (push accessor (?exports $tail-module))))

#module-end
;;;eof lzs-class-init