;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: generate-header-file -*-
#|
-----------------------------------------------------------------------------------
TITLE: generation of header files
-----------------------------------------------------------------------------------
File:    generate-header-file.em
Version: 1.21 (last modification on Fri Dec 10 15:22:15 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:
(dynamic code-output) must be bound to a stream to which the C-code should be written 

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /tmp_mnt/home/saturn/imohr/Lisp/Apply/generate-header-file.em[1.0]
	Tue Apr 27 14:32:07 1993 ukriegel@isst proposed $
 generation of header file for top module - a nice hack
 
generate-header-file.em[1.1] Wed Apr 28 13:32:52 1993 ukriegel@isst proposed $
 [Wed Apr 28 13:21:12 1993] Intention for change:
 :if-does-not-exist
 done
 
generate-header-file.em[1.2] Wed Apr 28 16:39:38 1993 ukriegel@isst proposed $
 [Wed Apr 28 16:34:29 1993] Intention for change:
 defined-named-const
 done
 
generate-header-file.em[1.3] Thu Apr 29 08:54:39 1993 ukriegel@isst proposed $
 [Thu Apr 29 08:50:08 1993] Intention for change:
 
generate-header-file.em[1.4] Mon May  3 12:13:44 1993 ukriegel@isst save $
 [Mon May  3 10:46:19 1993] Intention for change:
 add declarations
 c declarations added - a hack 
 
generate-header-file.em[1.5] Tue May  4 14:13:53 1993 ukriegel@isst proposed $
 [Tue May  4 13:00:18 1993] Intention for change:
 discard underscore if any
 done
 
generate-header-file.em[1.6] Thu May  6 09:46:55 1993 ukriegel@isst proposed $
 [Thu May  6 09:41:21 1993] Intention for change:
 
generate-header-file.em[1.7] Fri May  7 08:51:33 1993 ukriegel@isst proposed $
 generates extern in front of lisp
 still to do is cooorect c type
 
generate-header-file.em[1.8] Fri May  7 12:31:41 1993 ukriegel@isst proposed $
 [Fri May  7 11:04:24 1993] Intention for change:
 --- no intent expressed ---c declarations removed
 
generate-header-file.em[1.9] Tue May 11 14:28:30 1993 ukriegel@isst proposed $
 [Tue May 11 10:41:02 1993] Intention for change:
 export module-init-fun
 rename taken into account
 
generate-header-file.em[1.10] Wed May 12 17:32:14 1993 ukriegel@isst proposed $
 [Wed May 12 17:32:04 1993] Intention for change:
 --- no intent expressed ---
generate-header-file.em[1.11] Wed May 12 18:11:13 1993 ukriegel@isst proposed $
 [Wed May 12 17:42:20 1993] Intention for change:
 reset minus in identifiers by underscores
 done
 
generate-header-file.em[1.12] Thu May 27 10:27:40 1993 ukriegel@isst save $
 [Thu May 27 10:26:00 1993] Intention for change:
 lowecase file names
 done
 
generate-header-file.em[1.13] Thu May 27 13:24:16 1993 ukriegel@isst proposed $
 [Thu May 27 12:55:50 1993] Intention for change:
 
generate-header-file.em[1.14] Fri May 28 11:09:57 1993 ukriegel@isst proposed $
 done
 
generate-header-file.em[1.15] Tue Jun  1 06:37:36 1993 ukriegel@isst proposed $
 [Tue Jun  1 06:31:12 1993] Intention for change:
  typedef *double double-float
 done
 
generate-header-file.em[1.16] Tue Jun  1 09:43:19 1993 ukriegel@isst save $
 [Tue Jun  1 09:40:36 1993] Intention for change:
 
generate-header-file.em[1.17] Wed Jun  2 12:30:36 1993 ukriegel@isst proposed $
 [Wed Jun  2 12:28:39 1993] Intention for change:
 add empty line to make unix happy
 done
 
generate-header-file.em[1.18] Wed Jun  2 15:14:37 1993 ukriegel@isst proposed $
 [Wed Jun  2 15:13:32 1993] Intention for change:
 
generate-header-file.em[1.19] Fri Jul  9 15:47:43 1993 ukriegel@isst proposed $
 [Fri Jul  9 13:16:53 1993] Intention for change:
 add strings
 <name> is named in header file as NAME_CLASS
 
generate-header-file.em[1.20] Thu Aug  5 09:37:09 1993 imohr@isst published $
 [Mon Jul 26 11:25:15 1993] Intention for change:
 new code identifiers
 C-code generation
 
generate-header-file.em[1.21] Mon Dec 13 11:56:40 1993 imohr@isst proposed $
 [Tue Dec  7 12:57:36 1993] Intention for change:
 replace the content by a version for application-header-files 
 compatible to c-code-generation
 generation of h-file for modules with export interface
 

-----------------------------------------------------------------------------------
|#

#module generate-header-file
(import (level-1-eulisp
         accessors
         lzs
         representation
         binding
         code-identifier
         c-typing
         (only (%object) lzs-mop)
         (only (find-module) el2lzs-main) ; for test only
         (only (format mapc reverse)
           common-lisp))

 syntax (level-1-eulisp
         c-code-syntax
         (only (push) 
           common-lisp))

 export (generate-header-file) 
 )

(defun generate-header-file (module)
  (init-generate-header-file)
  (let ((id (?identifier module)))
    (name-exported-object module) ; to get a name for the initialization function
    (collect-exported-objects (cons %object (?exports module)))
    (write-code "/*header file for EuLisp module '~(~A~)' */" id)
    (write-code "~2%/*** classes ***/")
    (mapc #'generate-type-declaration *exported-types*)
    (write-code "~2%/*** functions ***/")
    (mapc #'generate-function-declaration *exported-functions*)
    (write-code "~2%/***    module initialization function    ***/")
    (write-code  "~%/*** must be called one and only one time ***/")
    (write-code "~%extern ~A();" (c-identifier module))
    (write-code "~2%/*** constants ***/")
    (write-code "~2%/*** variables ***/")
    (write-code "~2%/*** renamed exports ***/")
    (mapc #'generate-rename-macro *rename-exports*)
    (write-code "~2%/*end of header file for EuLisp module '~(~A~)'  */~2%" id)))

(deflocal *exported-classes* nil) ; these classes are exported as objects and types
(deflocal *exported-types* nil)   ; these classes are exported as types only
(deflocal *exported-functions* nil)
(deflocal *exported-constants* nil)
(deflocal *exported-variables* nil)
(deflocal *rename-exports* nil)

(defun init-generate-header-file ()
  (setq *exported-classes* nil)
  (setq *exported-types* nil)
  (setq *exported-functions* nil)
  (setq *exported-constants* nil)
  (setq *exported-variables* nil)
  (setq *rename-exports* nil)
  )

;;; -----------------------------------------------------------------------------------
;;; 
;;; -----------------------------------------------------------------------------------

(defun collect-exported-objects (objects)
  (mapc #'name-exported-object objects)
  (mapc #'collect-xobj objects)
  (setq *exported-classes* (reverse *exported-classes*))
  (setq *exported-types* (reverse *exported-types*))
  (setq *exported-functions* (reverse *exported-functions*))
  (setq *exported-constants* (reverse *exported-constants*))
  (setq *exported-variables* (reverse *exported-variables*))
  (setq *rename-exports* (reverse *rename-exports*))
  )

(defgeneric collect-xobj (object))

(defmethod collect-xobj ((object <class-def>))
  (push object *exported-classes*)
  (push object *exported-types*))

(defmethod collect-xobj ((object <fun>))
  (push object *exported-functions*))

(defmethod collect-xobj ((object <named-const>))
  (if (fun-p (?value object))
    (collect-xobj (?value object))
    nil)); (push object *exported-constants*)))

(defmethod collect-xobj ((object <static>))
  nil); (push object *exported-variables*))

(defmethod collect-xobj ((binding <binding>))
  (when (collect-xobj (finally-referred-object binding))
    (push binding *rename-exports*)))

;;; -----------------------------------------------------------------------------------
;;; Type Declarations
;;; -----------------------------------------------------------------------------------

(defun generate-type-declaration (class-def)
  (type-declaration class-def (?representation class-def)))

(defgeneric type-declaration (class-def representation))

(defmethod type-declaration (class-def (representation <%pointer-to-struct>))
;  (write-code "~%~@<typedef ~;~Istruct ~A ~:_*~:*~A~;;~:>" 
;          (type-identifier class-def))
  )

(defmethod type-declaration (class-def (representation <%pointer-to-vector>))
;  (write-code "~%~@<typedef ~;~I~A ~:_*~A~;;~:>" 
;          (type-identifier (~vector-class-element-type class-def))
;          (type-identifier class-def))
  )

(defmethod type-declaration (class-def (representation <%pointer-to-void>))
  (write-code "~%typedef void* ~A;" (type-identifier class-def))
  )

(defmethod type-declaration (class-def (representation <%direct>))
;  (write-code "~%~@<typedef ~;~I~A ~:_~A~;;~:>" 
;          (type-identifier (get-referred-class representation class-def))
;          (type-identifier class-def))
  )

(defmethod type-declaration ((class-def <basic-class-def>) representation)
  ; basic types are mapped directly to their C counterparts
  nil)

;;; -----------------------------------------------------------------------------------
;;; Function Declarations
;;; -----------------------------------------------------------------------------------

(defgeneric generate-function-declaration (object))

(defmethod generate-function-declaration ((object <generic-fun>)) 
  ; do nothing
  nil)

(defmethod generate-function-declaration ((fun <special-sys-fun>))
  ; do nothing
  nil)			

(defmethod generate-function-declaration ((fun <defined-fun>))
  (generate-function-decl fun))

(defmethod generate-function-declaration ((fun <imported-fun>))
  nil)

(defun generate-function-decl (fun)
  (write-code "~%extern ~A ~A();"
	      (type-identifier %object #|(result-type fun)|#)
	      (c-identifier fun)))

;;; -----------------------------------------------------------------------------------
;;; Rename Exports
;;; -----------------------------------------------------------------------------------

(defun generate-rename-macro (binding)
  (write-code "~%#define ~A ~A"
              (c-identifier binding)
              (c-identifier (finally-referred-object binding))))

#module-end