;;;-*- Mode: Lisp; Package: EL2LZS-RULES -*-
#|
-----------------------------------------------------------------------------------
TITLE: Rules for the EuLisp-to-LZS-Transformer
-----------------------------------------------------------------------------------
File:    el2lzs-rules.em
Version: 1.44 (last modification on Mon Dec  6 12:03:23 1993)
State:   proposed

DESCRIPTION:
the description of the content

DOCUMENTATION:
Ingo Mohr: Die Abbildung von EuLisp auf die Lisp-nahe Zwischensprache.
(APPLY-Arbeitspapier) 
File: el2lzs.tex

NOTES:
Up to now nearly no error-checking or error-handling takes places. This means,
that the incoming EuLisp-module must be in correct syntax.

Dynamic variables, let/cc and unwind-protect are mapped to other forms. So they
are not expressed in form of their LZS-counterparts.

REQUIRES:


PROBLEMS:


AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 

 10.06.1992 Ingo Mohr
 initial version
 
 11.06.1992 Ingo Mohr
 - tested and debugged
 - function-objects with body=UNDEFINED are now created if an unbound lexical
 variable appears in functional position

 15.06.1992 Ingo Mohr
 bug in creation of defined-sym removed (the name-slot is now set) 

 16.06.1992 Ingo Mohr
 all slots of undefined functions are set 

 17.06.1992 Ingo Mohr
 - require/provide removed because of incompatibility and loading problems
 - added: handling of export

Log for /export/home/saturn/apply-kunde/Lisp/Apply/el2lzs-rules.em[1.0]
	Fri Feb 26 16:58:14 1993 imohr@isst save $
 Rules for the syntax expansion and for the transformation to LZS.
 
el2lzs-rules.em[1.1] Fri Mar  5 14:49:40 1993 imohr@isst save $
 + %define-variable (without initial value)
 
el2lzs-rules.em[1.2] Wed Mar 10 16:03:52 1993 imohr@isst proposed $
 handles new resp. changed syntax for %define-variable/constant/function
 and %declare-external-variable/function
 
el2lzs-rules.em[1.3] Wed Mar 17 08:56:58 1993 imohr@isst save $
 + %define-standard-class; the complete-.-functions are not
 yet defined, up to now they only fill () into params and body slots
 
el2lzs-rules.em[1.4] Thu Mar 18 14:17:48 1993 imohr@isst save $
 * slot accessors are now generated for %define-.-class
 * bug in trans-%setf for variable references eliminated
 
el2lzs-rules.em[1.5] Mon Mar 22 16:45:07 1993 imohr@isst save $
 MOP for transformation of class definitions into LZS
 
el2lzs-rules.em[1.6] Wed Mar 24 13:45:31 1993 imohr@isst proposed $
 classes and generic functions ok
 
el2lzs-rules.em[1.7] Wed Mar 31 10:39:05 1993 imohr@isst proposed $
 literals for structures, literal expanders and expose ok
 
el2lzs-rules.em[1.8] Wed Mar 31 16:21:22 1993 imohr@isst proposed $
 error in %let* removed
 
el2lzs-rules.em[1.9] Fri Apr  2 17:12:00 1993 imohr@isst proposed $
 [Wed Mar 31 16:22:55 1993] Intention for change:
 --- no intent expressed ---some errors removed from transformation of labels
 
el2lzs-rules.em[1.10] Wed Apr  7 15:37:59 1993 imohr@isst proposed $
 
el2lzs-rules.em[1.11] Wed Apr  7 15:57:12 1993 imohr@isst proposed $
 
el2lzs-rules.em[1.12] Thu Apr  8 15:23:09 1993 imohr@isst proposed $
 constants: dereferencing values
 
el2lzs-rules.em[1.13] Thu Apr 15 10:15:07 1993 imohr@isst save $
 [Thu Apr  8 15:29:10 1993] Intention for change:
 
el2lzs-rules.em[1.14] Fri Apr 16 17:08:45 1993 imohr@isst proposed $
 error in or removed
 
el2lzs-rules.em[1.15] Mon Apr 19 18:55:30 1993 imohr@isst save $
 external names for external functrions and variables are set
 
el2lzs-rules.em[1.16] Tue Apr 20 16:06:13 1993 imohr@isst proposed $
 representation direct
 
el2lzs-rules.em[1.17] Wed Apr 28 12:40:17 1993 imohr@isst proposed $
 %define-variable with initial value
 
el2lzs-rules.em[1.18] Mon May  3 14:02:45 1993 imohr@isst proposed $
 error killed in transformation for expose
 
el2lzs-rules.em[1.19] Mon May  3 16:28:55 1993 imohr@isst save $
 function objects on operator position
 
el2lzs-rules.em[1.20] Tue May  4 10:58:41 1993 imohr@isst save $
 option language is used for creation of external names
 
el2lzs-rules.em[1.21] Tue May  4 14:36:36 1993 imohr@isst proposed $
 
el2lzs-rules.em[1.22] Thu May  6 11:12:31 1993 imohr@isst proposed $
 ignore bad exports (no lexical binding for an exported identifier)
 
el2lzs-rules.em[1.23] Tue May 25 16:27:24 1993 imohr@isst proposed $
 error in literal expansion for structured literals removed
 
el2lzs-rules.em[1.24] Thu May 27 17:07:07 1993 imohr@isst proposed $
 () now not transformed into defined-symbol
 
el2lzs-rules.em[1.25] Thu May 27 18:31:12 1993 imohr@isst proposed $
 dotted-list literals
 
el2lzs-rules.em[1.26] Thu Jun  3 17:39:15 1993 imohr@isst proposed $
 symbols
 
el2lzs-rules.em[1.27] Thu Jun 17 17:03:11 1993 imohr@isst proposed $
 [Thu Jun  3 17:40:47 1993] Intention for change:
 --- no intent expressed ---Urlaub
 
el2lzs-rules.em[1.28] Thu Aug  5 09:36:44 1993 imohr@isst proposed $
 [Mon Jul 19 09:49:38 1993] Intention for change:
 code-identifier for asm without _
 C-code generation
 
el2lzs-rules.em[1.29] Wed Sep  1 18:08:16 1993 imohr@isst proposed $
 [Wed Sep  1 16:36:59 1993] Intention for change:
 + a hack to get sometimes the type of a named-const
 
el2lzs-rules.em[1.30] Wed Sep  8 13:23:51 1993 imohr@isst proposed $
 [Wed Sep  8 09:24:11 1993] Intention for change:
 computation of arg-num during transformation to lzs
 
el2lzs-rules.em[1.31] Wed Sep  8 16:35:22 1993 imohr@isst proposed $
 [Wed Sep  8 15:37:59 1993] Intention for change:
 transformation of vectors to structured-literal
 
el2lzs-rules.em[1.32] Wed Sep 15 11:57:17 1993 imohr@isst proposed $
 [Mon Sep 13 08:28:31 1993] Intention for change:
 complete generic functions
 
el2lzs-rules.em[1.33] Mon Sep 20 13:18:55 1993 imohr@isst proposed $
 %define-function with rest parameter
 
el2lzs-rules.em[1.34] Tue Sep 21 14:52:15 1993 imohr@isst proposed $
 [Mon Sep 20 13:20:55 1993] Intention for change:
 --- no intent expressed ---defun setter
 
el2lzs-rules.em[1.35] Thu Sep 23 13:11:51 1993 imohr@isst proposed $
 [Thu Sep 23 10:33:49 1993] Intention for change:
 put local funs into fun-list of the module
 
el2lzs-rules.em[1.36] Fri Oct  1 18:48:10 1993 imohr@isst proposed $
 [Fri Oct  1 11:13:40 1993] Intention for change:
 let/cc, unwind-protect, dynamic
 
el2lzs-rules.em[1.37] Wed Oct  6 14:36:21 1993 hfried@isst proposed $
 [Mon Oct  4 14:21:10 1993] Intention for change:
 import apply-funs
 
el2lzs-rules.em[1.38] Fri Oct 15 17:35:59 1993 imohr@isst proposed $
 
el2lzs-rules.em[1.39] Wed Oct 20 14:03:08 1993 imohr@isst proposed $
 +declare-c-function
 
el2lzs-rules.em[1.40] Wed Oct 20 18:45:43 1993 imohr@isst published $
 
el2lzs-rules.em[1.41] Tue Nov  9 11:35:26 1993 imohr@isst proposed $
 [Thu Oct 21 15:33:31 1993] Intention for change:
 --- no intent expressed ---new style module header
 errors for setq
 
el2lzs-rules.em[1.42] Wed Nov 24 08:47:44 1993 imohr@isst proposed $
 
el2lzs-rules.em[1.43] Tue Nov 30 13:56:03 1993 imohr@isst proposed $
 [Tue Nov 30 08:44:35 1993] Intention for change:
 new mechanism for expose (here only for old style module headers)
 
el2lzs-rules.em[1.44] Mon Dec  6 15:48:17 1993 imohr@isst proposed $
 [Mon Dec  6 12:02:22 1993] Intention for change:
 removing error in expansion of car-nested lists
 

-----------------------------------------------------------------------------------
|#

;#|*C*
#module el2lzs-rules
(import (level-1-eulisp 
         el2lzs-main 
         el2lzs-error
         pair-ext 
         list-ext
         option-lists
         tail-module
         (only (%object) lzs-mop)
         ;(only (%list) apply-funs)
         apply-funs
         quasiquote
         (only (set-interpreter call) eval)
         (only (REVERSE APPEND NOT NCONC MAPCAR mapc remove
                        vector format listp list*
                        string string-downcase prog1) 
           common-lisp))
 syntax (level-1-eulisp el2lzs-main
                        (only (case) common-lisp))
 expose (el2lzs el2lzs-main lzs-modules)
 export (transsyn-progn complete-function 
         trans-params trans-lambda             ; for el2lzs-generic
         lambda-specializers lambda-parameters ; for el2lzs-generic
         fun-spec-name fun-spec-type           ; for el2lzs-generic
         compute-arg-descr                     ; for generic-dispatch
         )
 export (add-function 
         add-class
         add-const
         add-var
         lzslit)
 )

;;; -----------------------------------------------------------------------------------
;;; TS (transsyn): expands and simplifies syntax
;;; -----------------------------------------------------------------------------------

(defmethod transsyn (object) object)    ; the default case: nothing to expand

(deftranssyn (quote CONST)
  (whole-form))

(deftranssyn (setq ID EXPR)
  (progn (setf (third (whole-form)) (transsyn EXPR))
         (whole-form)))

(deftranssyn (dynamic-setq ID EXPR)
  (progn (setf (third (whole-form)) (transsyn EXPR))
         (whole-form)))

(deftranssyn (if ANT CONS ALT)
  ; it is possible to handle this by the default case (expand all arguments) but
  ; a separate rules provides early detection of syntax violations
  (list ^if
        (transsyn ANT)
        (transsyn CONS)
        (transsyn ALT)))

; extra syntax expansion for OR isn't necessary because it can be handled like
; the standard case, which expands simply all arguments

(deftranssyn (lambda PARAMS . BODY)
  (list ^lambda PARAMS (transsyn-progn BODY)))

(deftranssyn (let VARS . BODY)
  (transsyn-let-forms ^let VARS BODY))

(deftranssyn (let* VARS . BODY)
  (transsyn-let-forms ^let* VARS BODY))

(deftranssyn (dynamic-let VARS . BODY)
  (transsyn-let-forms ^dynamic-let VARS BODY))

(defun transsyn-let-forms (let-symbol vars body)
  (if (null vars)
    (transsyn-progn body)
    (list let-symbol 
          (transsyn-vars vars)
          (transsyn-progn body))))

(defun transsyn-vars (vars)
  (cond ((null vars) nil)
        ((symbolp (first vars))
         (setf (cdr vars) (transsyn-vars (rest vars)))
         vars)
        (t (setf (second (first vars)) (transsyn (second (first vars))))
           (setf (cdr vars) (transsyn-vars (rest vars)))
           vars)))

(deftranssyn (labels FUNS . BODY)
  (if (null FUNS)
    (transsyn-progn BODY)
    `(,^labels ,(transsyn-funs FUNS) ,(transsyn-progn BODY))))

(defun transsyn-funs (funs)
  (if (null funs) nil
      (let* ((fun (first funs))
             (ID (first fun))
             (PARAMS (second fun))
             (BODY (cddr fun)))
        (cons (list ID PARAMS (transsyn-progn BODY))
              (transsyn-funs (rest funs))))))

(deftranssyn (let/cc ID . BODY)
  (progn (setf (cdr (cdr (whole-form)))
               (list (transsyn-progn BODY)))
         (whole-form)))

(deftranssyn (dynamic ID) (whole-form))

(deftranssyn ((operator) . EXPRS)
  (cond ((and (symbolp operator)
              (find-in-mac-env operator))
         (transsyn (call (find-in-mac-env operator)
                                             EXPRS)))
        ((atom operator)
         ; this is for identifiers and function objects in operator position 
         (cons operator (transsyn* EXPRS)))
        (t (transsyn-listop (cons (transsyn operator)
                                  EXPRS)))))

(defun transsyn* (exprs)
  (if (null exprs)
    nil
    (progn (setf (car exprs) (transsyn (car exprs)))
           (transsyn* (cdr exprs))
           exprs)))

(defun transsyn-listop (expr)
  (if (symbolp (first expr))
    (transsyn expr)
    (progn (setf (cdr expr) (transsyn* (cdr expr)))
           expr)))

(deftranssyn (progn . EXPRS)
  (transsyn-progn EXPRS))

(defun transsyn-progn (forms)
  (transsyn-expanded-progn (transsyn-progn-forms forms)))

(defun transsyn-expanded-progn (forms)
  (cond ((null forms) nil)                      ; progn with 0 forms
        ((null (rest forms)) (first forms))     ; progn with 1 form
        (t (cons ^progn forms))))               ; progn with more forms

(defun transsyn-progn-forms (forms)
  (cond ((null forms) nil)
        ((and (consp (first forms))
              (eq (first (first forms)) ^progn))
         (transsyn-progn-forms (nconc (rest (first forms))
                                      (rest forms))))
        ; expand the first form; if the result is an progn then put its forms
        ; onto the current progn-level
        (t (let ((form (transsyn (first forms))))
             (if (and (consp form) (eq (first form) ^progn))
               (append (cdr form) (transsyn-progn-forms (rest forms)))
               (cons form
                     (transsyn-progn-forms (rest forms))))))))

(deftranssyn (defconstant ID VALUE)
  ; after syntax transformation no special handling of the initform to recognize
  ; function definitions using defconstant are necessary
  (with-defining-form 
    (setq VALUE (transsyn VALUE))
    (cond ((null (consp VALUE))
           (setf (third (whole-form)) VALUE)
           (whole-form))
          ((eq (car VALUE) ^lambda)
           `(,^defun ,@(cdr (car VALUE))))
          (t 
           (setf (third (whole-form)) VALUE)
           (whole-form)))))

(deftranssyn (defvar ID VALUE)
  (with-defining-form
    (setf (third (whole-form)) (transsyn VALUE))
    (whole-form)))

(deftranssyn (deflocal ID VALUE)
  (with-defining-form
    (setf (third (whole-form)) (transsyn VALUE))
    (whole-form)))

(deftranssyn (defun FUN-SPEC PARAMS . BODY)
  (with-defining-form
    (setf (cdr (cdr (cdr (whole-form))))
          (list (transsyn-progn BODY)))
    (whole-form)))

(deftranssyn (defmacro ID PARAMS . BODY)
  (with-defining-form
  `(,^progn
    (,^defun ,ID ,PARAMS ,(transsyn-progn BODY))
    (,^export-syntax ,ID))))

; --- exports

(deftranssyn (export . IDS) (whole-form))       ; don't expand anything

(deftranssyn (export-syntax . IDS) (whole-form)); don't expand anything

(deftranssyn (expose . XSPECS) (whole-form))    ; don't expand anything

(deftranssyn (quasiquote EXPRS)
  (transsyn (unquote-constructor EXPRS)))       ; the expanded form may be a
                                                ; macro call

;;; -----------------------------------------------------------------------------------
;;; TM (transmod): definitions into LZS without body expansion
;;;                collection of objects into environments
;;; -----------------------------------------------------------------------------------

;;; -----------------------------------------------------------------------------------
;;; some auxillary functions to extend the lists of defined objects in a
;;; lzs-module

(defun add-function (fun)
  (push fun (?fun-list (dynamic *current-module*)))
  (set-module-id fun)
  fun)

(defun add-class (class)
  (push class (?class-def-list (dynamic *current-module*)))
  (set-module-id class)
  class)

(defun add-const (const)
  (push const (?named-const-list (dynamic *current-module*)))
  (set-module-id const)
  const)

(defun add-var (var)
  (push var (?var-list (dynamic *current-module*)))
  (set-module-id var)
  var)

(defun set-module-id (obj)
  (setf (?module-id obj) 
        (?identifier (dynamic *current-module*))))

;;; -----------------------------------------------------------------------------------

(defmethod transmod ((id <symbol>))
  nil)

(deftransmod ((operator) . args)
  ; no top-level binding is defined
  nil)

(deftransmod (defconstant id init)
  (add-const
   (make-instance <defined-named-const>
     :identifier id)))

(deftransmod (deflocal id init)
  (add-var
   (make-instance <global-static>
     :identifier id)))

(deftransmod (defun fun-spec parameters body)
  ;the body was transformed to a single form by transsyn
  (cond ((symbolp fun-spec)
        ; a (function) binding is defined
         (add-function
          (make-instance <global-fun>
            :identifier fun-spec)))
        ; otherwise no binding is defined
        (t nil)))


#|
(deftransmod (defcondition name superclass . init-options) ...)
|#

(deftransmod (defmacro ID PARAMETERS . BODY)
  ; This rule is only activated for local macro definitions in the syntax
  ; section. Macro definitions in the module body are mapped to
  ; defun-forms during the syntax expansion.
  ; The body must be syntax-expanded here. Therefore, the caller of transmod for
  ; local macros should set (dynamic mac-env) and (dynamic lex-env) right.
  ; transmod can transform also the body of the local macro because only
  ; references to imported bindings can appear.
  (with-defining-form
    (let ((lzs-fun (make-instance <global-fun> :identifier id)))
      (trans-lambda (transsyn-progn BODY)
                    lzs-fun
                    (trans-params PARAMETERS nil))
      lzs-fun)))

;;; -----------------------------------------------------------------------------------
;;; TD (transdef): expands bodies of definitions
;;; -----------------------------------------------------------------------------------

(deftransdef (defconstant ID INIT)
  (let ((obj (find-in-lex-env ID)))
    (with-defining-form
      (cond ((symbolp INIT)
             (setf (?type obj) %object)
             (set-constant-value obj (trans INIT)))
            ((or (atom INIT) 
                 (eq (first INIT) ^quote)
                 (eq (first INIT) ^%literal)) 
             (setf (?value obj) (trans INIT))
             (setf (?type obj) %object)
             nil)
            (t (setf (?type obj) %object)
               (list (make-instance <setq-form> ;trans for setq to a constant
                       ;isn't possible !
                       :location obj
                       :form (trans INIT))))))))

(defgeneric set-constant-value (obj init))
(defmethod set-constant-value (obj (init <var>))
  (list (make-instance <setq-form> ;trans for setq to a constant
                                   ;isn't possible !
                     :location obj
                     :form init)))
(defmethod set-constant-value (obj init)
  (setf (?value obj) init)
  nil)

(deftransdef (deflocal ID EXPR)
  (with-defining-form
    (list (trans (list ^setq ID EXPR)))))

#|
(deftransdef (defvar ID EXPR)
  (list (trans (list ^dynamic-setq ID EXPR))))
|#

(deftransdef (defvar ID EXPR)
  (with-defining-form
    (list
     (make-instance <setq-form>
       :location (make-instance <var-ref>
		   :var %top-dynamic)
       :form (make-instance <app>
	       :function %make-dynamic
	       :arg-list (list (make-defined-sym ID)
			       (trans EXPR)
			       (make-instance <var-ref> 
				 :var %top-dynamic)))))))

(deftransdef (defun fun-spec parameters body)
  ;the body was transformed to a single form by transsyn
  (with-defining-form
    (let* ((name (fun-spec-name fun-spec))
           (type (fun-spec-type fun-spec))
           (fun (find-in-lex-env name)))
      (cond ((eq type ^setter)
             (setq fun 
                   (setf (?setter fun)
                         (add-function 
                          (make-instance <global-fun>
                            :identifier fun-spec)))))
            )
      (trans-lambda ;sets params and body in function object
       body
       fun
       (trans-params parameters nil))
      nil)))

(defun fun-spec-name (fun-spec)
  (if (symbolp fun-spec)
    fun-spec
    (car (cdr fun-spec))))

(defun fun-spec-type (fun-spec)
  (if (symbolp fun-spec)
    nil
    (car fun-spec)))

(deftransdef (export . IDS)
  (progn
    (setf (?exports (dynamic *current-module*))
          (append (remove nil ; () appears if no lexical binding was found
                          (mapcar (lambda (id) (find-lexical-binding id))
                                  IDS))
                  (?exports (dynamic *current-module*))))
    nil))

(deftransdef (export-syntax . IDS)
  ; ATTENTION: is only right for defined objects, it goes wrong for
  ; syntax-imported things
  (progn (setf (?syntax-exports (dynamic *current-module*))
               (append (remove nil ; () appears if no lexical binding was found
                               (mapcar (lambda (id) (find-lexical-binding id))
                                       IDS))
                       (?syntax-exports (dynamic *current-module*))))
         nil))

(deftransdef (expose . XSPECS)
  (progn (el2lzs-main::trans-expose XSPECS)
         nil))

;; the following are the default cases for transdef

(deftransdef ((operator) . args)
  (list (trans (cons operator args))))

(defmethod transdef (non-list)          ; identifiers and literals on top level
  nil)                                  ; are ignored

;;; -----------------------------------------------------------------------------------
;;; TE (trans): transformation of expressions
;;; constants,literals and variables
;;; -----------------------------------------------------------------------------------

(defmethod trans ((empty-list <null>))
  nil)

(defmethod trans ((LIT <string>))
  (make-instance <structured-literal> :value LIT))

(defmethod trans ((LIT <vector>))
  (make-instance <structured-literal> :value (lzslit LIT)))

(defmethod trans ((LIT <object>)) LIT)

(deftrans (quote LIT)
  (cond ((symbolp LIT)
         (make-defined-sym LIT))
	((consp LIT) 
         (make-instance <structured-literal> :value (lzslit LIT)))
	(t (trans LIT))))

(defgeneric lzslit (LIT))

(defmethod lzslit ((LIT <collection>))
  (map #'lzslit LIT))

(defmethod lzslit ((LIT <object>))
  LIT)

(defmethod lzslit ((LIT <null>))
  ; this method is needed because () is also a symbol in CL
  LIT)

(defmethod lzslit ((LIT <symbol>))
  (make-defined-sym LIT))

(defmethod lzslit ((LIT <pair>))
  (lzslit-list LIT))

(defun lzslit-list (list)
  (cond ((atom list) 
         (lzslit list))
        ((eq (car list) ^%literal)
         (trans list))
        (t 
         (cons (lzslit-list (car list))
               (lzslit-list (cdr list))))))

;;; -----------------------------------------------------------------------------------
;;; variables and assignments
;;; -----------------------------------------------------------------------------------

(defmethod trans ((ID <symbol>))
  (let ((VAR (find-in-lex-env ID)))
    (cond ((instance-of-p VAR <static>) 
           (make-instance <var-ref> :var VAR))
          (t (constant-value VAR)))))

(deftrans (setq ID EXPR)
  (let ((location (trans ID)))
    (if (var-ref-p location)
      (make-instance <setq-form> 
        :location location 
        :form (trans EXPR))
      (progn
        (error-invalid-assignment ID)
        nil))))

(defgeneric constant-value (object))
(defmethod constant-value (object) object)
(defmethod constant-value ((object <defined-named-const>))
  (if (eq (?value object) ^unknown)
    object
    (constant-value (?value object))))

;;; -----------------------------------------------------------------------------------
;;; control flow
;;; -----------------------------------------------------------------------------------
(deftrans (if ANT CONS ALT)
  (make-instance <if-form> 
    :pred (trans ANT) :then (trans CONS) :else (trans ALT)))

(deftrans (or . FORMS)
  (cond ((null FORMS) nil)
        ((null (cdr FORMS)) (trans (car FORMS)))
        (t (make-or-expansion (trans (car FORMS))
                              (trans (cons ^or (cdr FORMS)))))))

(defgeneric make-or-expansion (first-form else-part))
(defmethod make-or-expansion (first-form else-part)
  (let ((var (make-instance <local-static>)))
    (make-instance <let*-form>
      :var-list (list var)
      :init-list (list first-form)
      :body (make-instance <if-form>
              :pred (make-instance <var-ref> :var var)
              :then (make-instance <var-ref> :var var)
              :else else-part))))
(defmethod make-or-expansion ((first-form <var-ref>) else-part)
  (make-instance <if-form>
    :pred first-form
    :then first-form
    :else else-part))

(deftrans (progn . EXPRS)
  (make-instance <progn-form> :form-list (trans-exprs EXPRS)))

(defun trans-exprs (exprs)
(if (null exprs) ()
    (cons (trans (first exprs)) (trans-exprs (rest exprs)))))

;;; -----------------------------------------------------------------------------------
;;; variable bindings: lambda expressions
;;; -----------------------------------------------------------------------------------

;;; --- completion of partially created function objects

(defun complete-function (lzs-fun arguments body environment)
  (dynamic-let ((lex-env environment))
     (trans-lambda body lzs-fun (trans-params arguments nil))))


(deftrans (lambda PARAMETERS BODY)
  (trans-lambda BODY
                (add-function (make-instance <local-fun>
                                :identifier (make-local-fun-identifier nil)))
                (trans-params PARAMETERS nil)))

(defvar *function-id* nil)

(defun make-local-fun-identifier (local-id)
  (let ((function-id 
         (if (listp (dynamic *function-id*))
           (dynamic *function-id*)
           (list (dynamic *function-id*)))))
    (cond ((and (null local-id) 
                (null function-id)) 
           (list ^unnamed (?identifier (dynamic *current-module*))))
          (local-id 
           `(,^local ,@function-id ,local-id)) 
          (t 
           `(,^local ,@function-id)))))

(defun trans-lambda (BODY funobj params)
  (dynamic-let ((*function-id* (?identifier funobj)))
     (setf (?params funobj) params)
     (setf (?body funobj) (in-lex-env (env-plus (?rest params)
                                                (append (?var-list params) lex-env))
                                      (trans BODY)))
     (setf (?arg-num funobj) (compute-arg-descr params))
     funobj))

(defun trans-params (params req)
(cond ((null params) 
       (make-instance <params> 
         :var-list (reverse req)
         :rest ()))
      ((symbolp params)                 ; error if (neq rst ())
       (make-instance <params> 
         :var-list (reverse req)
         :rest (make-instance <local-static> 
                              :identifier params)))
      (t
       (trans-params (rest params) 
                     (cons (make-instance <local-static>
                             :identifier (first params))
                           req)))))

(defun compute-arg-descr (params)
  (if (?rest params)
    (* -1 (+ 1 (length (?var-list params))))
    (length (?var-list params))))

;;; -----------------------------------------------------------------------------------
;;;  variable bindings: let and let*
;;; -----------------------------------------------------------------------------------
(deftrans (let VARS BODY)
  (trans-let BODY (trans-vars VARS () () #'cenv)))

(deftrans (let* VARS BODY)
  (trans-let BODY (trans-vars VARS () () #'xenv)))

(defun trans-let (BODY v)
  (make-instance <let*-form> 
                 :var-list (vars v) 
                 :init-list (inits v)
                 :body (in-lex-env (append (vars v) lex-env)
                                   (trans BODY))))

(defun trans-vars (varlist vars inits ecomb)
(cond ((null varlist) (cons (reverse vars) (reverse inits)))
      ((symbolp (first varlist))
       (trans-vars (rest varlist)
                   (cons (make-instance <local-static>
                                        :identifier (first varlist))
                         vars)
                   (cons () inits)
                   ecomb))
      (t (trans-vars (rest varlist)
                     (cons (make-instance <local-static> 
                                          :identifier (first (first varlist)))
                           vars)
                     (cons (in-lex-env (funcall ecomb lex-env vars)
                                       (trans (second (first varlist))))
                           inits)
                     ecomb))))

(defun cenv (context local) context)
(defun xenv (context local) (append local context))

(defun vars (pair) (car pair))
(defun inits (pair) (cdr pair))

;;; -----------------------------------------------------------------------------------
;;;  variable bindings: labels
;;; -----------------------------------------------------------------------------------

(deftrans (labels FUNS BODY)
  (trans-labels BODY (trans-funs FUNS)))

(defun trans-labels (BODY funs)
  (prog1
   (make-instance <labels-form>
    :fun-list funs
    :body (in-lex-env (append funs lex-env)
                      (trans BODY)))
    (mapc #'rename-local-fun funs)))

(defun rename-local-fun (fun)
  ; to give the local functions better names
  (setf (?identifier fun)
        (make-local-fun-identifier (?identifier fun))))

(defun trans-funs (FUNS)
  (if (null FUNS) ()
      (let ((ID (first (first FUNS)))
            (PARAMETERS (second (first FUNS)))
            (BODY (third (first FUNS)))
            (FUNS (cdr FUNS)))
        (cons (trans-label-fun BODY
                               (add-function
                                (make-instance <local-fun> 
                                 :identifier ID))
                               (trans-params PARAMETERS () ))
              (trans-funs FUNS)))))

(defun trans-label-fun (BODY fun params)
  (setf (?params fun) params)
  (setf (?body fun) (in-lex-env (cons fun
                                      (env-plus (?rest params)
                                                (append (?var-list params)
                                                        lex-env)))
                                (trans BODY)))
  fun)

;;; -----------------------------------------------------------------------------------
;;;  variable bindings: let/cc
;;; -----------------------------------------------------------------------------------

(deftrans (let/cc ID BODY)
  (trans-let/cc BODY (make-instance <cont> :identifier ID)))

#| --- let/cc -> <let/cc-form> ---
(defun trans-let/cc (BODY cont)
  (make-instance <let/cc-form> 
    :cont cont
    :body (in-lex-env (cons cont lex-env)
                      (trans BODY))))
|#

(defun trans-let/cc (BODY cont)
  (let* ((v-buffer (make-instance <local-static> 
                     :identifier ^jmp-buffer
                     :type %jmpbuf))
         (v-buffer-closure-var (make-instance <local-static>
                                 :identifier ^jmp-buffer-closure-var))
         (v-current-unwind (make-instance <local-static> 
                             :identifier ^current-unwind))
         (v-current-dynamic (make-instance <local-static> 
                              :identifier ^current-dynamic))
         (cont-closure
          (add-function
           (complete-function
            (make-instance <local-fun>
              :identifier (make-local-fun-identifier (?identifier cont)))
            ^(result)
            ^(progn
               (%setf letcc-result result)
               (%setf stop-unwind-before (%cast %pjmpbuf current-unwind))
               (%setf continue-at ;(%pointer-of 
                      (%cast %pjmpbuf 
                             jmp-buffer-closure-var))
               ;)
               (unwind-continue unwind))
            (list* v-current-unwind v-buffer-closure-var
                   apply-environment)))))
    (setf (?range-and-domain cont-closure)
          (vector %void %object %object)) ; !!! cons/object is a hack (constructed, local 
    ; !!! closure-function)
    (make-instance <let*-form> 
      :var-list (list v-current-unwind 
                      v-current-dynamic 
                      ;cont
                      v-buffer
                      )
      :init-list (list 
                  (make-instance <app>
                    :function %cast
                    :arg-list (list %object (make-instance <var-ref> :var %unwind)))
                  (make-instance <var-ref> :var %top-dynamic)      
                  ;cont-closure
                  ^unknown
                  ; (make-instance <var-ref> :var v-buffer) ; trick
                  )
      :type-list (list %object ;%pjmpbuf       
                       %dynamic 
                       ;%object
                       %jmpbuf
                       )
      :body 
      ;  (make-instance <let*-form> :var-list (list v-buffer)
      ;       :type-list (list %jmpbuf) :body
      (make-instance <if-form> 
        :pred (in-lex-env (cons v-buffer apply-environment)
                          (trans ^(%eq (%setjmp jmp-buffer)
                                       (%literal %signed-word-integer 0))))
        :then (make-instance <let*-form>
                :var-list (list v-buffer-closure-var cont)
                :init-list (list (in-lex-env (cons v-buffer apply-environment)
                                             (trans ^(%cast <object> 
                                                            (%pointer-of jmp-buffer))))
                                 cont-closure)
                :type-list (list %object %object)
                :body (in-lex-env (list* cont v-buffer-closure-var lex-env)
                                  (trans BODY)))
        ;(in-lex-env (cons cont lex-env)
        ;                  (trans BODY))
        :else (in-lex-env (list* ;v-buffer 
                           v-current-dynamic apply-environment)
                          (trans ^(progn
                                    (%setf top-dynamic current-dynamic)
                                    letcc-result)))))))

;;; -----------------------------------------------------------------------------------
;;; function calls and application
;;; -----------------------------------------------------------------------------------

(deftrans ((operator) . ARGS)
  (cond ((atom operator)
         ; this is for identifiers and function objects in operator position 
         (make-instance <app>
           :function (trans-function operator)
           :arg-list (trans-exprs ARGS)))
        ((or (eq (car operator) ^dynamic)
             (eq (car operator) ^lambda))
         (make-instance <app>
           :function (trans operator)
           :arg-list (trans-exprs ARGS)))
        (t (trans-appl (cons operator ARGS) 
                       (make-instance <local-static> :identifier nil)))))

(defun trans-appl (expr var)
  (make-instance <let*-form>
    :var-list (list var)
    :init-list (list (trans (first expr)))
    :body (make-instance <app>
            :function (make-instance <var-ref> :var var)
            :arg-list (trans-exprs (rest expr)))))

(defun trans-function (fun) 
  ; avoids () in functional position for non-existing function-objects during
  ; testing 
  (or (trans fun)
      (make-undefined-function fun)))

;(deftrans (apply FUN . ARGS)
;  (make-instance <apply-app> :function (trans FUN) :arg-list (trans ARGS)))

;;; -----------------------------------------------------------------------------------
;;; unwind-protect
;;; -----------------------------------------------------------------------------------
;*C*|# (in-package el2lzs-rules)
(deftrans (unwind-protect protected-forms . cleanup-forms)
  (make-uwp (trans protected-forms)
            (mapcar #'trans cleanup-forms)))

(defun make-var-ref (var)
  (make-instance <var-ref> :var var))

(defun make-local-static (id type)
  (make-instance <local-static> 
    :identifier id
    :type type))

(defun make-setq (var val)
  (make-instance <setq-form>
    :location (make-var-ref var)
    :form val))

(defun make-progn forms
  (make-instance <progn-form>
    :form-list (el2lzs-main::splice-lists forms)))

(defun make-app (fun . args)
  (make-instance <app>
    :function fun
    :arg-list args))

(defun make-uwp (protected-forms cleanup-forms)
  (let* ((v-buffer (make-local-static ^jmp-buffer %jmpbuf))
         (v-current-unwind (make-local-static ^current-unwind %pjmpbuf))
         (v-current-dynamic (make-local-static ^current-dynamic %object))
         (v-current-letcc-result (make-local-static ^current-letcc-result %object))
         (v-result (make-local-static ^result %object))
         )
    (make-instance <let*-form> 
      :var-list (list v-buffer
                      v-current-unwind
                      v-current-dynamic)
      :type-list (list %object       
                       %dynamic 
                       %jmpbuf)
      :init-list (list ^unknown
                       (make-var-ref %unwind)
                       (make-var-ref %top-dynamic))
      :body 
      (make-instance <if-form>
        :pred 
        (in-lex-env (cons v-buffer apply-environment)
                    (trans ^(%eq (%setjmp jmp-buffer)
                                 (%literal %signed-word-integer 0))))
        :then 
        (make-instance <let*-form>
          :var-list (list v-result)
          :type-list (list %object) 
          :init-list (list (make-progn 
                            (make-setq %unwind
                                       (make-app %pointer-of-variable
                                                 (make-var-ref v-buffer)))
                            protected-forms))
          :body
          (make-progn (make-setq %unwind (make-var-ref v-current-unwind))
                      cleanup-forms
                      (make-var-ref v-result)))
        :else 
        (make-instance <let*-form> 
          :var-list (list v-current-letcc-result)
          :type-list (list %object) 
          :init-list (list (make-var-ref %letcc-result))
          :body
          (make-progn
           (make-setq %top-dynamic (make-var-ref v-current-dynamic))
           cleanup-forms
           (make-setq %letcc-result (make-var-ref v-current-letcc-result))
           (make-app %unwind-continue
                     (make-var-ref v-current-unwind))))))))

;#|*C*
;;; -----------------------------------------------------------------------------------
;;; method combination
;;; -----------------------------------------------------------------------------------

;call-next-method
;next-method-p

;;; -----------------------------------------------------------------------------------
;;; condition handling
;;; -----------------------------------------------------------------------------------

;with-handler

;;; -----------------------------------------------------------------------------------
;;; dynamic bindings
;;; -----------------------------------------------------------------------------------

#| (defvar ...) -> <dynamic>

(defun trans-dvar (ID)
(let ((VAR (find-in-dynamic-env ID)))
  (unless VAR
    (setq VAR (make-instance <dynamic>
                :sym (make-defined-sym ID)
                :identifier ID))
    (add-to-dynamic-env VAR))
  VAR))

(deftrans (dynamic ID)
  (make-instance <var-ref> :var (trans-dvar ID)))

(deftrans (dynamic-setq ID FORM)
  (make-instance <setq-form> 
    :location (make-instance <var-ref> :var (trans-dvar ID))
    :form (trans FORM)))

(deftrans (dynamic-let VARS BODY)
  (trans-dlet BODY (trans-dvars VARS () () )))

(defun trans-dlet (BODY params)
    (make-instance <let*-form> 
      :var-list (vars params)
      :init-list (inits params)
      :body (trans BODY)))

(defun trans-dvars (VARLIST vars inits)
(if (null VARLIST)
    (cons (reverse vars) (reverse inits))
    (let ((ID (first VARLIST))
          (EXPR ())
	  (MORE (rest VARLIST)))
      (when (consp ID)
        (setq EXPR (second ID))
        (setq ID (first ID)))
      (trans-dvars MORE
                   (cons (trans-dvar ID) vars)
                   (cons (if (null EXPR) ()
                             (trans EXPR))
                         inits)))))
|#

(deftrans (dynamic ID)
  (make-instance <app>
    :function %get-dynamic
    :arg-list (list (make-defined-sym ID))))

(deftrans (dynamic-setq ID FORM)
  (make-instance <app>
    :function %set-dynamic
    :arg-list (list (make-defined-sym ID)
                    (trans FORM))))

(deftrans (dynamic-let VARS BODY)
  (trans-dlet BODY (trans-dvars VARS)))

(defun trans-dlet (BODY vars)
  (let ((v-current-dynamic (make-instance <local-static> 
                             :identifier ^current-dynamic))
	(v-temp (make-instance <local-static>
		  :identifier ^tmp-dlet)))
    (make-instance <let*-form> 
      :var-list (list v-current-dynamic v-temp)
      :init-list (list (make-instance <var-ref> :var %top-dynamic)
		       ())
      :type-list (list %dynamic %object)
      :body 
      (make-instance <progn-form>
        :form-list 
        (append vars
                (list (make-instance <setq-form>
			:location (make-instance <var-ref> :var v-temp)
			:form (trans BODY))
                      (make-instance <setq-form>
                        :location (make-instance <var-ref> :var %top-dynamic)
                        :form (make-instance <var-ref> :var v-current-dynamic)
                        )
		      (make-instance <var-ref> :var v-temp)))))))

(defun trans-dvars (VARLIST)
  (if (null VARLIST)
    ()
    (let ((ID (first VARLIST))
          (EXPR ())
	  (MORE (rest VARLIST)))
      (when (consp ID)
        (setq EXPR (second ID))
        (setq ID (first ID)))
      (cons 
       (make-instance <setq-form>
         :location (make-instance <var-ref> :var %top-dynamic)
         :form (make-instance <app>
                 :function %make-dynamic
                 :arg-list (list (make-defined-sym ID)
                                 (trans EXPR)
                                 (make-instance <var-ref> :var %top-dynamic))))
       (trans-dvars MORE)))))

;;; -----------------------------------------------------------------------------------
;;; TAIL: %define-variable, %define-constant
;;; -----------------------------------------------------------------------------------

(deftranssyn (%define-variable ID TYPE . INIT)
  (progn 
    (when INIT (setf (cdr (cddr (whole-form)))
                     (list (transsyn (car INIT)))))
    (whole-form)))

(deftransmod (%define-variable ID TYPE . INIT)
  (add-var
   (make-instance <global-static>
     :identifier id)))

(deftransdef (%define-variable ID TYPE . INIT)
  (let ((var (find-in-lex-env ID)))
    (setf (?type var) (trans TYPE))
    (setf (?initial-value var) 
          (if INIT (trans (car INIT))
              ^unknown))
    nil))

(deftranssyn (%define-constant ID VALUE)
  (progn (setf (third (whole-form)) (transsyn (third (whole-form)))) 
         (whole-form)))

(deftransmod (%define-constant ID VALUE)
  (add-const
   (make-instance <defined-named-const>
     :identifier id)))

(deftransdef (%define-constant ID VALUE)
  (let ((init-value (trans VALUE))
        (const (find-in-lex-env ID))) 
    (setf (?value const)
          init-value) ; this must be a literal, which means that if value is
                      ; a constant then its initial value must be
                      ; already computed and known at compile time
         (when (literal-instance-p init-value)
           (setf (?type const)
                 (?class init-value)))
         nil))

;;; -----------------------------------------------------------------------------------
;;; TAIL: %declare-external-variable/constant
;;; -----------------------------------------------------------------------------------

(deftranssyn (%declare-external-variable NAME TYPE . OPTIONS)
  (progn (check-options () ^(external-name language) () options)
         (whole-form)))

(deftranssyn (%declare-external-constant NAME TYPE . OPTIONS)
  (progn (check-options () ^(external-name language) () options)
         (whole-form)))

(deftransmod (%declare-external-variable NAME TYPE . OPTIONS)
  (add-var
   (make-instance <imported-static>
     :identifier NAME)))

(deftransmod (%declare-external-constant NAME TYPE . OPTIONS)
  (add-const
   (make-instance <imported-named-const>
     :identifier NAME)))

(deftransdef (%declare-external-variable NAME TYPE . OPTIONS)
  (let ((var (find-in-lex-env NAME))
        (external-name (get-option ^external-name OPTIONS nil))
        (language (get-option ^language OPTIONS nil))) 
    (setf (?type var) (trans TYPE))
    (setf (?code-identifier var) 
          (make-external-name (or external-name NAME) language))
    nil))

(deftransdef (%declare-external-constant NAME TYPE . OPTIONS)
  (let ((const (find-in-lex-env NAME))
        (external-name (get-option ^external-name OPTIONS nil))
        (language (get-option ^language OPTIONS nil)))
    (setf (?value const) ^unknown)
    (setf (?type const) (trans TYPE))
    (setf (?code-identifier const) 
          (make-external-name (or external-name NAME) language))
    nil))

;;; -----------------------------------------------------------------------------------
;;; TAIL: %declare-external-function
;;; -----------------------------------------------------------------------------------

; the following function depends on the used compiler and should be placed in a
; machine-dependent module
(defun make-external-name (name language)
  name)
;  (if (eq language ^C)
;    (format nil "_~A" name)
;    name)

(deftranssyn (%declare-external-function fun-spec params . options)
 (progn (check-options () ^(external-name language) () options)
        (whole-form)))

(deftranssyn (declare-c-function name result-type args)
  (let ((name (if (consp name) (car name) name))
        (external-name (if (consp name) (cadr name) name)))
    `(,^%declare-external-function (,name ,result-type) ,args
          ,^language ^c
          ,^external-name ,(string-downcase (string external-name)))))

(deftransmod (%declare-external-function fun-spec params . options)
  (let ((ID (first fun-spec)))
    (add-function (make-instance <imported-fun> :identifier ID))))

(deftransdef (%declare-external-function fun-spec PARAMETERS . OPTIONS)
  (let* ((ID (first fun-spec))
         (TYPE (second fun-spec))
         (fun (find-in-lex-env ID))
         (external-name (get-option ^external-name OPTIONS nil))
         (language (get-option ^language OPTIONS nil)))
    (setf (?params fun) 
          (trans-params (lambda-parameters PARAMETERS) nil))
    (setf (?range-and-domain fun) 
          (apply #'vector (trans TYPE) 
                          (lambda-specializers PARAMETERS)))
    (setf (?code-identifier fun) 
          (make-external-name (or external-name ID) language))
    nil))

;;; -----------------------------------------------------------------------------------
;;; TAIL: %define-function
;;; -----------------------------------------------------------------------------------

;Syntax expansion
;================

(deftranssyn (%define-function fun-spec parameters . body)
  (progn (setf (cdddr (whole-form)) (list (transsyn-progn body)))
         (whole-form)))

;module top-level handling
;=========================

(deftransmod (%define-function fun-spec PARAMETERS BODY)
  (let ((ID (first fun-spec)))
    (add-function (make-instance <global-fun> :identifier ID))))

;transformation of defining forms
;================================

(deftransdef (%define-function fun-spec PARAMETERS BODY)
  (let* ((ID (first fun-spec))
         (TYPE (second fun-spec))
         (fun (find-in-lex-env ID)))
    (trans-lambda ;sets params and body in fun
     BODY
     fun
     (trans-params (lambda-parameters PARAMETERS) nil))
    (setf (?range-and-domain fun) 
          (apply #'vector (trans TYPE) 
                          (lambda-specializers PARAMETERS)))
    nil))

(defun lambda-specializers (lambda-list)
  ; extracts a list of classes from a specialized lambda-list
  ; in case of a rest parameter the list is extended
  ; by an additional class: %list
  (cond ((null lambda-list) nil)
        ((symbolp lambda-list)          ; rest parameter
         (list %list))
        ((symbolp (car lambda-list))    ; unspecialized parameter
         (cons %object
               (lambda-specializers (cdr lambda-list))))
        (t                              ; specialized parameter
         (cons (trans (cadr (car lambda-list)))
               (lambda-specializers (cdr lambda-list))))))

(defun lambda-parameters (lambda-list)
  ; extracts the parameter-names from specialized lambda-list
  ; returns a true list or if a rest parameter occurs a dotted list of symbols 
  (cond ((null lambda-list) nil)
        ((symbolp lambda-list)          ; rest parameter
         lambda-list)
        ((symbolp (car lambda-list))    ; unspecialized parameter
         (cons (car lambda-list)
               (lambda-parameters (cdr lambda-list))))
        (t                              ; specialized parameter
         (cons (car (car lambda-list))
               (lambda-parameters (cdr lambda-list))))))

;;; -----------------------------------------------------------------------------------
;;;  TAIL: %let and %let*
;;; -----------------------------------------------------------------------------------

;Syntax expansion
;================

(deftranssyn (%let VARS . BODY)
  (transsyn-%let-forms ^%let VARS BODY))

(deftranssyn (%let* VARS . BODY)
  (transsyn-%let-forms ^%let* VARS BODY))

(defun transsyn-%let-forms (let-symbol vars body)
  (if (null vars)
    (transsyn-progn body)
    (list let-symbol 
          (transsyn-%vars vars)
          (transsyn-progn body))))

(defun transsyn-%vars (vars)
  (cond ((null vars) nil)
        (t (setf (third (first vars)) (transsyn (third (first vars))))
           (setf (cdr vars) (transsyn-%vars (rest vars)))
           vars)))


;expression transformation
;=========================

(deftrans (%let VARS BODY)
  (trans-%let BODY (trans-%vars VARS () () () #'cenv)))

(deftrans (%let* VARS BODY)
  (trans-%let BODY (trans-%vars VARS () () () #'xenv)))

(defun trans-%let (BODY v)
  (make-instance <let*-form> 
                 :var-list (%vars v) 
                 :init-list (%inits v)
                 :type-list (%types v)
                 :body (in-lex-env (append (%vars v) lex-env)
                                   (trans BODY))))

(defun trans-%vars (varlist vars inits types ecomb)
(cond ((null varlist) (list (reverse vars) (reverse inits) (reverse types)))
      (t (trans-%vars (rest varlist)
                     (cons (make-instance <local-static> 
                                          :identifier (first (first varlist)))
                           vars)
                     (cons (in-lex-env (funcall ecomb lex-env vars)
                                       (trans (third (first varlist))))
                           inits)
                     (cons (find-in-lex-env (second (first varlist)))
                           types)
                     ecomb))))

(defun %vars (vars-inits-types) (first vars-inits-types))
(defun %inits (vars-inits-types) (second vars-inits-types))
(defun %types (vars-inits-types) (third vars-inits-types))

;;; -----------------------------------------------------------------------------------
;;; TAIL: %select, %preselect  %view
;;; -----------------------------------------------------------------------------------
;;; These three basic access functions of TAIL must be implemented as special
;;; forms because the slot/variant-name component must not evaluated. The
;;; slot/variant-name component is represented in the LZS as an identifier (a
;;; symbol, not a LZS-symbol-structure!). Its destination can be resolved only
;;; after type inference, whereas this sort of identifiers must survive the
;;; transformation to the LZS. The whole %select, %preselect and
;;; %view forms are represented as applications of special-sys-fun's.

(deftranssyn (%select structure slot-id)
  (transsyn-accessors (whole-form) structure))

(deftranssyn (%preselect structure slot-id)
  (transsyn-accessors (whole-form) structure))

(deftranssyn (%view union variant-id)
  (transsyn-accessors (whole-form) union))

(defun transsyn-accessors (whole-form obj)
  (setf (second whole-form) (transsyn obj))
  whole-form)

(deftrans (%select structure slot-id)
  (trans-accessors %select structure slot-id))

(deftrans (%pre-select structure slot-id)
  (trans-accessors %preselect structure slot-id))

(deftrans (%view union variant-id)
  (trans-accessors %view union variant-id))

(defun trans-accessors (accessor obj slot-id)
  (make-instance <app>
    :function accessor
    :arg-list (list (trans obj)
                    slot-id)))

;;; -----------------------------------------------------------------------------------
;;; TAIL: %setf and %pointer-of???
;;; -----------------------------------------------------------------------------------

(deftrans (%pointer-of entity)
  (trans-%pointer-of (trans entity)))

(defgeneric trans-%pointer-of (transformed-entity))

(defmethod trans-%pointer-of ((transformed-entity <var-ref>))
  (make-instance <app> 
    :function %pointer-of-variable
    :arg-list (list transformed-entity)))

(defmethod trans-%pointer-of ((transformed-entity <fun>))
  (make-instance <app> 
    :function %pointer-of-function
    :arg-list (list transformed-entity)))

(defmethod trans-%pointer-of ((transformed-entity <app>))
  (let ((operator (?function transformed-entity)))
    (setf (?function transformed-entity)
          (cond ((eq operator %extract) %pointer-of-extract)
                ((eq operator %select) %pointer-of-select)))
    transformed-entity))

;;; a syntax-transformation-rule for %setf isn't necessary because the
;;; destination may be also a macro call expanding to one of the allowed
;;; destination specifications

(deftrans (%setf destination source)
  (or 
   (trans-%setf (trans destination) (trans source))
   (progn (error-invalid-assignment destination)
          nil)))

(defgeneric trans-%setf (transformed-destination source))

(defmethod trans-%setf ((transformed-destination <var-ref>) source)
  (make-instance <setq-form>
    :location transformed-destination
    :form source))

(defmethod trans-%setf ((transformed-destination <app>) source)
  (let ((reader-fun (?function transformed-destination)))
    (setf (?function transformed-destination)
          (cond ((eq reader-fun %ref)     %setf-ref)
                ((eq reader-fun %extract) %setf-extract)
                ((eq reader-fun %select)  %setf-select)
                ((eq reader-fun %view)    %setf-view)
                ((eq reader-fun %cast)    %setf-cast)
                (t nil))) ; all other cases are an error
    (setf (?arg-list transformed-destination)
          (nconc (?arg-list transformed-destination)
                 (list source)))
    (and (?function transformed-destination) ;has the cond above detected an error?
         transformed-destination)))

(defmethod trans-%setf (transformed-destination source)
  ; all other cases for destinations are an error
  nil)

#module-end

;*C*|#