;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs-generic -*-
#|
-----------------------------------------------------------------------------------
TITLE: Transformation of generic function definitions into LZS
-----------------------------------------------------------------------------------
File:    el2lzs-generic.em
Version: 1.11 (last modification on Tue Dec 14 14:34:12 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /tmp_mnt/home/saturn/ukriegel/Dist/Apply/el2lzs-generic.em[1.0]
	Wed Mar 24 13:45:16 1993 imohr@isst proposed $
 classes and generic functions ok
 
el2lzs-generic.em[1.1] Fri Apr 16 14:58:34 1993 imohr@isst proposed $
 error in modulename removed
 
el2lzs-generic.em[1.2] Wed Sep 15 11:56:37 1993 imohr@isst proposed $
 [Mon Sep 13 08:28:19 1993] Intention for change:
 complete generic functions
 
el2lzs-generic.em[1.3] Mon Sep 20 13:19:24 1993 imohr@isst proposed $
 handling of specialized lambda-lists moved to el2lzs-rules.em
 
el2lzs-generic.em[1.4] Tue Sep 21 14:51:26 1993 imohr@isst proposed $
 [Mon Sep 20 13:20:52 1993] Intention for change:
 --- no intent expressed ---defgeneric and defmethod with setter and converter
 
el2lzs-generic.em[1.5] Wed Sep 22 08:40:05 1993 imohr@isst proposed $
 [Wed Sep 22 08:39:15 1993] Intention for change:
 removing simple bug
 
el2lzs-generic.em[1.6] Fri Sep 24 14:57:53 1993 imohr@isst proposed $
 [Fri Sep 24 14:49:43 1993] Intention for change:
 method-functions into function list of module
 
el2lzs-generic.em[1.7] Fri Sep 24 15:14:11 1993 imohr@isst proposed $
 [Fri Sep 24 15:11:37 1993] Intention for change:
 import listp
 
el2lzs-generic.em[1.8] Fri Sep 24 15:56:18 1993 imohr@isst proposed $
 [Fri Sep 24 15:55:45 1993] Intention for change:
 
el2lzs-generic.em[1.9] Wed Oct 20 18:44:34 1993 imohr@isst published $
 [Wed Oct 20 17:12:24 1993] Intention for change:
 improve error handling
 
el2lzs-generic.em[1.10] Tue Nov  9 11:35:16 1993 imohr@isst proposed $
 [Mon Nov  8 12:54:17 1993] Intention for change:
 new style module header
 .,
 
el2lzs-generic.em[1.11] Tue Dec 14 17:18:36 1993 imohr@isst proposed $
 [Tue Dec 14 12:48:20 1993] Intention for change:
 add inheritance of converters
 

-----------------------------------------------------------------------------------
|#

#module el2lzs-generic
(import (level-1-eulisp 
         el2lzs-rules
         el2lzs-error
         pair-ext 
         list-ext
         tail-module
         lzs-mop
         quasiquote
         (only (warn listp) 
           common-lisp))
 syntax (level-1-eulisp 
         el2lzs-main)
 )
;;; -----------------------------------------------------------------------------------
;;; defgeneric
;;; -----------------------------------------------------------------------------------

(deftranssyn (defgeneric gf-spec lambda-list . options)
  (with-defining-form
    (when options
           (warn-defgeneric-options-not-analyzed options))
         (setf (cdr (cddr (whole-form))) nil)
         (whole-form)))

(deftransmod (defgeneric gf-spec lambda-list . options)
  (cond ((symbolp gf-spec)
         (add-function (make-instance <global-generic-fun>
                         :identifier gf-spec)))
        ; otherwise no binding must be generated
        (t nil)))

(deftransdef (defgeneric gf-spec lambda-list . options)
  (with-defining-form
  (let* ((name (fun-spec-name gf-spec))
         (type (fun-spec-type gf-spec)) 
         (gf (find-in-lex-env name))) 
    (cond ((null type))
          ((eq type ^setter)
           (setq gf (set-setter gf gf-spec)))
          ((eq type ^converter)
           ;ATTN: in this case gf is a class from which the converter gf must be
           ;taken 
           (setq gf (set-converter gf gf-spec)))
          (t (error-invalid-generic-function-spec gf-spec)
             (setq gf nil)))
    (~initialize gf
                 (list ^name gf-spec
                       ^domain (lambda-specializers lambda-list)
                       ^range %object
                       ;^method-class
                       ^parameters (trans-params 
                                    (lambda-parameters lambda-list) 
                                    nil)
                       ))
    nil)))

(defun set-converter (class-def gf-spec)
  (if (class-def-p class-def)
    (if (?converter class-def)
      (error-converter-redefinition class-def)
      (setf (?converter class-def)
            (add-function 
             (make-instance <global-generic-fun>))))
    (error-class-required-in-converter-spec gf-spec)))

(defun set-setter (fun gf-spec)
  (if (fun-p fun)
    (if (?setter fun)
      (error-setter-redefinition fun)
      (setf (?setter fun)
            (add-function 
             (make-instance <global-generic-fun>))))
    (error-function-required-in-setter-spec gf-spec)))


;;; -----------------------------------------------------------------------------------
;;; defmethod
;;; -----------------------------------------------------------------------------------

(deftranssyn (defmethod gf-spec lambda-list . body)
  (with-defining-form
    (setf (cdr (cddr (whole-form)))
          (list (transsyn-progn body)))
    (whole-form)))

;; transmod isn't necessary because no top level binding must be created

(deftransdef (defmethod gf-spec lambda-list body)
  (with-defining-form
    (let* ((name (fun-spec-name gf-spec))
           (type (fun-spec-type gf-spec))
           (gf (find-in-lex-env name)))
      (cond ((null type))
            ((eq type ^setter)
             (setq gf (get-setter gf gf-spec)))
            ((eq type ^converter)
             ;ATTN: in this case gf is a class from which the converter gf must be
             ;taken 
             (setq gf (get-converter gf gf-spec)))
            (t (error-invalid-generic-function-spec gf-spec)
               (setq gf nil)))
      (when gf
        (~add-method gf 
                     (~initialize (make-instance <method-def>)
                                  (list   ^domain (lambda-specializers lambda-list)
                                          ^range %object
                                          ^function (trans-method-function-lambda
                                                     gf
                                                     <global-fun>
                                                     (lambda-parameters lambda-list)
                                                     body)
                                          ^generic-function gf))))
      nil)))

(defun get-converter (class-def gf-spec)
  (if (class-def-p class-def)
    (or (?converter class-def)
        (and (error-no-converter class-def) nil))
    (progn (error-class-required-in-converter-spec gf-spec)
           nil)))

(defun get-setter (fun gf-spec)
  (if (fun-p fun)
    (or (?setter fun)
        (and (error-no-setter fun) nil))
    (progn (error-function-required-in-setter-spec gf-spec)
           nil)))

;;; -----------------------------------------------------------------------------------
;;; method-function-lambda
;;; -----------------------------------------------------------------------------------

(defun trans-method-function-lambda (gf function-class lambda-list body)
  (let ((gf-id (?identifier gf)))
    (unless (listp gf-id) (setq gf-id (list gf-id)))
    (trans-lambda body
                  (add-function
                   (make-instance function-class
                     :identifier (cons ^method gf-id)))
                  (trans-params lambda-list nil))))

;;; -----------------------------------------------------------------------------------
;;; TAIL: %define-generic
;;; -----------------------------------------------------------------------------------

;(deftranssyn (%define-generic genfun-spec spec-lambda-list)
;  (progn (mapc (lambda (slot-description)
;                 (setf (third slot-description)
;                       (transsyn (third slot-description)))) 
;               slot-descriptions)
;         (whole-form)))
;
;(deftransmod (%define-generic genfun-spec spec-lambda-list)
;  (let* ((ID (first class-spec))
;         (class (make-instance <standard-class-def>
;                  :identifier ID)))
;    (add-class class)
;    (nconc (list class) 
;           (transmod-slot-descriptions slot-descriptions)
;           (transmod-class-options class-options))))
;
;
;(deftransdef (%define-generic genfun-spec spec-lambda-list)
;  (let* ((id (first class-spec))
;         (metaclass (second class-spec))
;         (class-def (find-in-lex-env id))
;         (supers (list (find-in-lex-env superclass))))
;    (setf (?class class-def) (find-in-lex-env metaclass))
;;???    (transdef-slot-descriptions slot-descriptions (?direct-slots class-def) class-def)
;    (~initialize class-def
;       (list* ^name id
;              ^direct-superclasses supers
;              ^direct-slot-descriptions (mapcar #'slot-name-type-init 
;                                                slot-descriptions)
;              class-options))
;    (bind-slot-accessors class-def slot-descriptions)
;    (bind-class-functions class-def class-options)
;    nil))


#module-end
