;;;-*- Mode: Lisp; Package: user -*-

(in-package user)
(import '(el-modules::module-package 
          el-modules::module-path
          el-modules::*eulisp-modules*))

(defun compile-apply-compiler ()
  (mapc #'compile-eulisp-module *eulisp-modules*))

(defun compile-eulisp-module (module)
  (when (module-path module)
    ;then it is not a module made from a CL package
    (compile-eulisp-module-package (module-package module))))

(defun compile-eulisp-module-package (package)
  (do-symbols (s package)
    ;(compile-el2lzs-transformations s)
    (when (and (fboundp s)
               (null (macro-function s))
               (eq package (symbol-package s)))
      (compile-function-or-method s)
      )))

(defun compile-function-or-method (s)
  (let ((fcn (symbol-function s)))
    (if (subtypep (class-of fcn) 'standard-generic-function)
      ;;method branch
      (dolist (method (clos:generic-function-methods fcn))
        (when (not (compiled-function-p (clos:method-function method)))
          (compile (clos::method-to-definition-spec method)))
        )
      ;;simple function
      (when (not (compiled-function-p (symbol-function s)))
        (compile s)))))

(defun compile-el2lzs-transformations (s)
  (mapc #'(lambda (ind)
            (let ((fun (get s ind nil)))
            (when (and fun
                       (functionp fun)
                       (not (compiled-function-p fun)))
              (setf (get s ind)
                    (compile fun)))))
        ^(trans transmod transdef transsyn)))

(format t "~2%********** compiling the apply compiler ***********~%")

(compile-apply-compiler)

