;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: c-code-*-
#|
-----------------------------------------------------------------------------------
TITLE: A Code Generator for (specialized) LZS to C
-----------------------------------------------------------------------------------
File:    c-code.em
Version: 1.29 (last modification on Fri Dec 10 11:50:14 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:
The special merits of the C-programs generated by this code generator are as
follows: 

* Every Lisp-function is mapped to a C-function with the same number of required
parameters. Lisp functions with a rest-parameter are transformed into functions
with required parameters only in a preceding compilation step. I.e.
Lisp-functions with rest-parameter are mapped to C-functions with an additional
parameter. 
* Every class of Lisp is mapped to an appropriate C-type. Abstract classes are
mapped to void*. Structure classes are mapped to a pointer to a C-structure.
vector classes are mapped to a pointer to its element class.
* The C-code appears in a pretty but very compact style. This is done using the
pretty printing mechanism of CLtL2.
* Parantheses appear only in such places where they are needed to represent the
evaluation order of Lisp in C.
* Casts are inserted only if they are needed. For example if an instance of a
class C1 was given but a superclass of C1 was needed and if C1 and the
superclass are not abstract classes. This feature can be switched off.
* The parantheses {...} for compound statements are inserted only if it is
necessary. 
* Identifiers of the Lisp-program are transformed to C-identifiers using the
following mechanism:
1. delete all non-alpha characters from the beginning
2. replace word-delimiters like -, ., $, ! and so on by an underscore (_).
3. delete all characters which are not alpha, digits or underscore
4. identifiers for class objects are preceded by 'c_' and the types defined for
classes are preceded by 't_'
5. if the resulting identifier is the second one in the appropriate scope extend
it on the end by an underscore and a unique number.
* The empty list is placed in a register and is accessed by NIL. This feature
can be switched off.

All this makes the generated C-code very readable, such that a Lisp-programmer
can find its program again in its C-version.

NOTES:
It works only for application compilation. For module compilation some
extensions are needed.

REQUIRES:

PROBLEMS:
It must be ensured that the C-identifier of <null> is t_Null because of its usage
in eu2c-sys.h.
The symbols EXPR and STMT are imported explicitely from package USER to make them
available for the ~/.../-directive of format.

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /tmp_mnt/home/saturn/imohr/Lisp/Apply/c-code.em[1.0]
	Thu Aug  5 10:00:47 1993 imohr@isst proposed $
 C-code generator
 
c-code.em[1.1] Fri Aug  6 15:55:33 1993 imohr@isst proposed $
 [Fri Aug  6 14:54:25 1993] Intention for change:
 braces around else-clauses
 
c-code.em[1.2] Mon Aug  9 09:06:57 1993 imohr@isst save $
 ok
 
c-code.em[1.3] Tue Aug 10 16:10:26 1993 imohr@isst proposed $
 vectors and %extract ok
 
c-code.em[1.4] Wed Aug 11 15:36:21 1993 imohr@isst proposed $
 with shift-operations
 
c-code.em[1.5] Tue Aug 17 14:23:55 1993 imohr@isst proposed $
 
c-code.em[1.6] Thu Aug 26 09:52:31 1993 imohr@isst proposed $
 c-code for data
 
c-code.em[1.7] Fri Aug 27 17:07:52 1993 imohr@isst save $
 [Thu Aug 26 09:54:58 1993] Intention for change:
 --- no intent expressed ---+ function objects
 
c-code.em[1.8] Mon Aug 30 07:49:48 1993 imohr@isst save $
 some bugs removed
 
c-code.em[1.9] Mon Aug 30 13:52:04 1993 imohr@isst save $
 collection of GC root addresses simplified
 collection of literals ok
 
c-code.em[1.10] Mon Aug 30 16:42:51 1993 imohr@isst save $
 
c-code.em[1.11] Wed Sep  1 18:11:22 1993 imohr@isst proposed $
 
c-code.em[1.12] Fri Sep  3 12:56:32 1993 imohr@isst proposed $
 a hack for %function for funcall
 
c-code.em[1.13] Fri Sep  3 14:53:23 1993 imohr@isst proposed $
 vector access corrected
 
c-code.em[1.14] Tue Sep  7 12:00:39 1993 imohr@isst published $
 printing a * on screen when generating code for a function
 
c-code.em[1.15] Fri Sep 10 11:19:56 1993 imohr@isst proposed $
 length of vector literals now in bytes
 
c-code.em[1.16] Wed Sep 15 11:57:29 1993 imohr@isst save $
 [Fri Sep 10 11:20:53 1993] Intention for change:
 --- no intent expressed ---calls of generic functions and methods
 
c-code.em[1.17] Wed Sep 15 13:15:27 1993 imohr@isst save $
 some changes in name-global-objects
 no attempt to generate a function prototype for generic functions
 .-
 
c-code.em[1.18] Thu Sep 16 16:42:11 1993 imohr@isst proposed $
 + conversion operators
 
c-code.em[1.19] Fri Sep 17 16:01:44 1993 imohr@isst proposed $
 naming for global objects moved to code-identifier.em
 
c-code.em[1.20] Fri Oct  1 18:47:47 1993 imohr@isst proposed $
 [Fri Oct  1 16:43:48 1993] Intention for change:
 longjmp
 
c-code.em[1.21] Wed Oct  6 14:35:44 1993 hfried@isst proposed $
 [Tue Oct  5 18:43:37 1993] Intention for change:
 
c-code.em[1.22] Wed Oct 13 15:43:39 1993 imohr@isst proposed $
 casts for variable initializations
 
c-code.em[1.23] Wed Oct 13 16:12:18 1993 imohr@isst save $
 suppress generation of function prototypes for imported functions
 
c-code.em[1.24] Fri Oct 15 17:32:07 1993 imohr@isst proposed $
 + #include for c-imports
 generation of slot names debugged
 
c-code.em[1.25] Mon Oct 18 16:55:47 1993 imohr@isst published $
 [Mon Oct 18 11:44:57 1993] Intention for change:
 more pretty c-code
 
c-code.em[1.26] Mon Nov  8 08:53:45 1993 imohr@isst proposed $
 size-of -> size-of-instance, size-as-component
 
c-code.em[1.27] Tue Nov  9 11:40:46 1993 imohr@isst proposed $
 [Tue Nov  9 11:40:33 1993] Intention for change:
 --- no intent expressed ---
c-code.em[1.28] Mon Dec  6 15:36:08 1993 imohr@isst proposed $
 %eq and %neq are now working on Lisp-Objects also if instances of
 subclasses are compared with instances of superclasses
 
c-code.em[1.29] Mon Dec 13 11:55:15 1993 imohr@isst proposed $
 [Mon Dec  6 15:53:07 1993] Intention for change:
 --- no intent expressed ---generation of h-file for modules with export interface
 

-----------------------------------------------------------------------------------
|#

#module c-code
(import (level-0-eulisp
         lzs
         accessors
         list-ext
         class-ext
         whc-classes
         tail-module
         lzs-mop
         expand-literal
         code-identifier
         c-typing
         c-data
         (only (<tempvar>) mzs) ; to avoid compiler errors
         (only (mapc mapcar mapcan 
                     svref vector string stringp string-equal
                     assoc reverse list* copy-list remove-duplicates subseq 
                     copy-pprint-dispatch set-pprint-dispatch
                     write format write-string princ
                     make-instance neq
                     *error-output*
                     )
           common-lisp))
 syntax (level-0-eulisp 
         dynamic
         code-identifier
         c-code-syntax
         (only (when unless)
           common-lisp))
 export (generate-c-code))

;;; -----------------------------------------------------------------------------------
;;; Specials for Printing Code
;;; -----------------------------------------------------------------------------------

(cl:import 'user::stmt) ; makes STMT available for ~/.../

(cl:import 'user::expr) ; makes EXPR available for ~/.../

;;; -----------------------------------------------------------------------------------
;;; switches and variables
;;; -----------------------------------------------------------------------------------

(defvar *empty-list-in-register* t)

(defvar *no-cast-if-compatible-representation* t)

(defconstant $last-pass 100)

;;; -----------------------------------------------------------------------------------
;;; Main Functions
;;; -----------------------------------------------------------------------------------
(defun map-modules (fun accessor module-list)
  (mapc (lambda (module)
          (mapc fun
                (funcall accessor module)))
        module-list))

(defun generate-c-code (main-module module-list)
  (let ((cl:*print-pretty* t)
        (cl:*print-right-margin* 75))
    (reset-c-code)
    (princ #\*)
    (mapc #'name-global-objects module-list)
    (princ #\*)
    (map-modules #'expand-literal #'?class-def-list module-list)
    (princ #\*)
    (map-modules #'disable-gc #'?class-def-list module-list)
    (princ #\*)
    (map-modules #'expand-literal #'?sym-list module-list)
    (princ #\*)
    (generate-includes module-list)
    (princ #\*)
    (generate-default-declarations)
    (princ #\*)
    (map-modules #'generate-type-declaration #'?class-def-list 
                 (reverse module-list)) ; to get the right order for typedefs
    (princ #\*)
    (map-modules #'generate-struct-declaration #'?class-def-list module-list)
    (princ #\*)
    (map-modules #'generate-function-protype #'?fun-list module-list)
    (princ #\*)
    (mapc #'generate-initfunction-prototype module-list)
    (princ #\*)
    (map-modules #'generate-extern-declaration #'?named-const-list module-list)
    (princ #\*)
    (map-modules #'generate-extern-declaration #'?var-list module-list)
    ;(map-modules #'generate-definition #'?class-def-list module-list)
    (princ #\*)
    (write-code "~2%#include \"eu2c-~:[total~;mod~].h\""
                (?exports main-module)
                (?identifier main-module))
    (princ #\*)
    (write-code "~2%#include \"~(~A~).inst\"" (?identifier main-module))
    (princ #\*)
    (generate-default-definitions main-module)
    (princ #\*)
    (map-modules #'generate-definition #'?named-const-list module-list)
    (princ #\*)
    (map-modules #'generate-definition #'?var-list module-list)
    (princ #\*)
    (map-modules #'generate-definition #'?fun-list module-list)
    (princ #\*)
    (mapc (lambda (module)
            (generate-definition (?toplevel-forms module)))
          module-list)
    (write-code "~2%void *VARIABLE_ROOTS[~A] = {~{~%~A,~} 0};"
                (+ (length *variable-roots*) 1)
                *variable-roots*)
    (generate-main main-module)
    ))

(defun name-global-objects (module)
  (name-global-object ())
  (when (?toplevel-forms module)
    (name-global-object (?toplevel-forms module)))
  (mapc #'name-global-object (?class-def-list module))
  (mapc (lambda (con)
          (when (or (null (fun-p (?value con)))
                    (function-needed-p (?value con)))
            (name-global-object con))) 
        (?named-const-list module))
  (mapc (lambda (fun)
          (when (function-needed-p fun)
            (name-global-object fun)))
        (?fun-list module))
  (mapc #'name-global-object (?var-list module))
  (mapc #'name-global-object (?sym-list module))
  )

(defun generate-default-declarations()
  (write-code "~2%typedef void* (*function)();")
  )

(defun generate-default-definitions (main-module)
  (write-code "~2%void add_to_root_set(void *pointer);")
  )

(defconstant $main 
; Arguments: 
;- name of main function
;- name of initfunction
"~2%~
~A()
{void **p;
 struct VECTOR_ROOTS *v;
 int i;
 SET_NIL;
 p=STRUCTURE_ROOTS;
 while (*p!=0) 
  {add_to_root_set(*p);
   p+=1;}
 v=VECTOR_ROOTS;
 while ((*v).length!=0) 
  {for (i=0;i<(*v).length;i++) add_to_root_set((*v).pointer+i);
   v+=1;}
 p=VARIABLE_ROOTS;
 while (*p!=0) 
  {add_to_root_set(*p);
   p+=1;}
 ~A();}
")

(defun generate-main (main-module)
  (write-code $main 
              (if (?exports main-module) 
                (?code-identifier main-module)
                "main")
              (c-identifier (?toplevel-forms main-module))
              ))

(defun reset-c-code ()
  (reset-code-identifier)
  (reset-c-data)
  (setq *variable-roots* nil))

(defun generate-includes (modules)
  (mapc #'generate-include
        (remove-duplicates
         (mapcan (lambda (module)
                   (copy-list (?c-imports module)))
                 modules)
         :key #'get-file-spec
         :test #'string-equal)))

(defun generate-include (filespec)
  (write-code (if (stringp filespec)
                "~%#include ~S"
                "~%#include ~(~A~)") 
              filespec))

(defun get-file-spec (include-spec)
  (if (stringp include-spec)
    include-spec
    (let ((file-spec (string include-spec)))
      (subseq file-spec 1 (- (length file-spec) 1)))))

;;; -----------------------------------------------------------------------------------
;;; Type Declarations
;;; -----------------------------------------------------------------------------------

(defun generate-type-declaration (class-def)
  (type-declaration class-def (?representation class-def)))

(defgeneric type-declaration (class-def representation))

(defmethod type-declaration (class-def (representation <%pointer-to-struct>))
  (write-code "~%~@<typedef ~;~Istruct ~A ~:_*~:*~A~;;~:>" 
          (type-identifier class-def)))

(defmethod type-declaration (class-def (representation <%pointer-to-vector>))
  (write-code "~%~@<typedef ~;~I~A ~:_*~A~;;~:>" 
          (type-identifier (~vector-class-element-type class-def))
          (type-identifier class-def)))

(defmethod type-declaration (class-def (representation <%pointer-to-void>))
  (write-code "~%typedef void* ~A;" (type-identifier class-def)))

(defmethod type-declaration (class-def (representation <%direct>))
  (write-code "~%~@<typedef ~;~I~A ~:_~A~;;~:>" 
          (type-identifier (get-referred-class representation class-def))
          (type-identifier class-def)))

(defmethod type-declaration ((class-def <basic-class-def>) representation)
  ; basic types are mapped directly to their C counterparts
  nil)

(defgeneric get-referred-class (representation class))

(defmethod get-referred-class (representation class) class)

(defmethod get-referred-class ((representation <%direct>) class)
  (let ((ref-class (~slot-description-type 
                    (car (~class-slot-descriptions class)))))
    (get-referred-class (?representation ref-class)
                        ref-class)))

;;; -----------------------------------------------------------------------------------
;;; Structure Declarations
;;; -----------------------------------------------------------------------------------

(defun generate-struct-declaration (class-def)
  (struct-declaration class-def (?representation class-def)))

(defgeneric struct-declaration (class-def representation))

(defmethod struct-declaration (class-def representation) 
  nil)

(defmethod struct-declaration (class-def (rep <%pointer-to-struct>)) 
  (with-local-identifiers
    (write-code "~2%~@<struct ~;~:I~A ~:_{~:I~:{~A ~A;~:^ ~_~}~;};~:>" 
                (type-identifier class-def)
                (mapcar (lambda (slot)
                          (list (type-identifier (~slot-description-type slot))
                                (local-c-identifier slot)))
                        (~class-slot-descriptions class-def)))))

;;; -----------------------------------------------------------------------------------
;;; 'extern'-Declarations for Variables and Constants
;;; -----------------------------------------------------------------------------------

(defun generate-extern-declaration (var)
  (when (and (null (fun-p (initial-value var)))
             (c-extern-p var))
    (write-code "~%extern ~A ~A;"
                (type-identifier (global-var-type var))
                (c-identifier var))))

;;; -----------------------------------------------------------------------------------
;;; Function Prototypes
;;; -----------------------------------------------------------------------------------

(defgeneric generate-function-protype (object))

(defmethod generate-function-protype ((object <generic-fun>)) 
  ; do nothing
  nil)

(defmethod generate-function-protype ((fun <special-sys-fun>))
  ; do nothing
  nil)				

(defun function-needed-p (fun)
  (>= (?pass fun) $last-pass))

(defmethod generate-function-protype ((fun <defined-fun>))
  ; all global objects already must be named
  (when (function-needed-p fun)
    (with-local-identifiers
      (generate-function-header fun t)    ; with storage class
      (write-code ";")
      ; reset generated code-identifiers of parameters
      ; they are recreated when generating function definitions
      ; this is because function header and body must be handled in the same
      ; 'with-local-identifier'-context 
      (mapc (lambda (var)
              (setf (?code-identifier var) nil)) 
            (?var-list (?params fun))))))

(defmethod generate-function-protype ((fun <imported-fun>))
  ; all global objects already must be named
  ; don`t generate prototypes
  ; 1. to avoid warnings by the C-compiler if there are some differences in the
  ;    signature 
  ; 2. to allow overloading for Lisp (for example in the case of printf, which
  ;    can be declared now as different external functions with the same
  ;    C-identifier but with different argument types
  ())
;old variant:
;  (with-local-identifiers
;    (generate-function-header fun t)    ; with storage class
;    (write-code ";")))

(defun generate-function-header (fun with-storage-class?)
  (write-code "~%~@<~:[~;static ~]~A ~:I~A~:_(~:I~{~A ~A~^, ~_~})~:>"
              (and with-storage-class?
	           (null (c-extern-p fun)))
	      (type-identifier (result-type fun))
	      (c-identifier fun)
	      (types-and-parameters fun)))

(defun generate-initfunction-prototype (module)
  (when (?toplevel-forms module)
    (generate-function-protype (?toplevel-forms module))))

;;; -----------------------------------------------------------------------------------
;;; Definitions of Functions, Variables, Constants and Class Objects
;;; -----------------------------------------------------------------------------------

(defgeneric generate-definition (object))

(defmethod generate-definition (object) 
  ; the default case for imported objects and so on
  nil)

(defvar *function* nil)

(defmethod generate-definition ((fun <defined-fun>))
  ; parameters already should have a code identifier
  (when (function-needed-p fun)
    (dynamic-let ((*return* (result-type fun))
                  (*function* fun))
       (generate-function-comment fun)
       (with-local-identifiers
         (generate-function-header fun nil)       ; without storage class
         (write-code "~%~:[{~;~]~@/STMT/~@*~:[}~;~]" 
                     (block-form-p (?body fun))
                     (?body fun))))))

(defun block-form-p (form)
  (or (progn-form-p form)
      (let*-form-p form)
      (labels-form-p form)
      (let/cc-form-p form)
      (tagbody-form-p form)
      ))

(defgeneric generate-function-comment (fun))
(defmethod generate-function-comment (fun)
  (write-code "~2%/*function ~A (~A)*/"
              (?identifier fun)
              (?module-id fun)))
(defmethod generate-function-comment ((fun <slot-accessor-fun>))
  (write-code "~2%/*slot accessor~:[~*~;~:* ~A (~A)~%  ~]~
                    for slot ~A of class ~A*/"
              (?identifier fun)
              (?module-id fun)
              (?identifier (?slot fun))
              (?identifier (?slot-of (?slot fun)))))
(defmethod generate-function-comment ((fun <slot-init-fun>))
  (write-code "~2%/*slot initfunction~:[~*~;~:* ~A (~A)~%  ~] ~
                    for slot ~A of class ~A*/"
              (?identifier fun)
              (?module-id fun)
              (?identifier (?slot fun))
              (?identifier (?slot-of (?slot fun)))))
(defmethod generate-function-comment ((fun <constructor-fun>))
  (write-code "~2%/*constructor~:[~*~;~:* ~A (~A)~%  ~] ~
                    of class ~A*/"
              (?identifier fun)
              (?module-id fun)
              (?identifier (?constructor-for fun))))

;(defmethod generate-definition ((class <class-def>))
;  (write-code "~%extern struct ~A ~A;"
;          (type-identifier (~class-of class))
;          (c-identifier class)))
;

(defmethod generate-definition ((const <defined-named-const>))
  ; imported named constants are declared in .h-files
  (if (fun-p (?value const))
    #|
    (write-code "~%#define ~A ~A"
            (c-identifier const)
            (c-identifier (?value const)))
   |#
    nil
    ;*10*
    (generate-var-definition const (?value const))))

(defmethod generate-definition ((var <static>))
  (generate-var-definition var (?initial-value var)))

(defmethod generate-definition ((var <imported-static>))
  ; imported variables are declared in .h-files, no definition is necessary
  nil)

(deflocal *variable-roots* nil)

(defun generate-var-definition (var init-value)
  (when (is-pointer (global-var-type var))
    (push (format nil "&~A" (c-identifier var))
          *variable-roots*))
  (write-code "~%~A ~A~:[= ~:/EXPR/~;~];"
              (type-identifier (global-var-type var))
              (c-identifier var)
              (eq init-value ^unknown)
              (unless (eq init-value ^unknown)
                (type-expr-for-c (global-var-type var) init-value))))

;;; -----------------------------------------------------------------------------------
;;; Statements
;;; -----------------------------------------------------------------------------------
#|
Format-directive ~/STMT/ prints its argument as a C-statement with
terminating semicolon if needed. The argument must be an LZS-expression
usable as a C-statement, which are: ...-form, app, or any expression in
return-context. STMT calls a generic function write-stmt which prints the
equivalent C-statement.
~/STMT/   Print statement not in return context; 
          (dynamic *return*) = nil during the call of write-stmt.
~@/STMT/  Print statement in return context (the value of the LZS-expression
          given as argument must be returned with C-return).
          (dynamic *return*) = return-type during the call of write-stmt
~n:/STMT/ Print statement in a special context determined by n:
          For write-stmt (dynamic *context*) is set to a non-nil value. 

          n omitted: context is a compound statement i.e. surrounding {...} 
          may be omitted if the argument is for example a progn-form. 
          (dynamic *context*) is set to :block. This context is handled by
          write-block. 

          n=other value: not yet needed
|#

(defun stmt (stream object colon? atsign? . args)
  (dynamic-let ((*return* (if atsign? 
                            (dynamic *return*)
                            nil))
                (*context* 
                 (cond ((null colon?) nil)
                       ((null args) :block)
                       (t nil))))
    (write-stmt object stream)))

(defvar *return* nil)
; *return* says for STMT: return a value if it the last expression
;               for EXPR: return a value of this type

(defvar *context* nil)

(defun default-write (object stream)
  (write object 
         :stream stream 
         :pretty nil
         :readably nil
         :pprint-dispatch nil))

(defgeneric write-stmt (object stream))

(defmethod write-stmt (object stream)
  (if (dynamic *return*)
    (write-return (dynamic *return*) object stream)
    (progn
      ;(write-expr object stream)
      (write-string ";" stream))))

(defmethod write-stmt ((form <if-form>) stream) 
  (format stream 
          "~@<if (~/EXPR/) ~3I~:_~@/STMT/~I~:@_~
           ~{~#[~;else ~@/STMT/~
           ~:;else if (~/EXPR/) ~3I~:_~@/STMT/~I~:@_~]~}~:>"
          (?pred form) 
          (?then form)
          (else-forms (?else form))))

(defun else-forms (form)
  (if (if-form-p form)
    (list* (?pred form)
           (?then form)
           (else-forms (?else form)))
    (list form)))

(defmethod write-stmt ((form <setq-form>) stream)
  (if (dynamic *return*)
    (write-return (dynamic *return*) form stream)
    (format stream "~/EXPR/;"
            form)))

(defmethod write-stmt ((form <progn-form>) stream)
  (write-block stream 
               "~@<~{~#[~;~:@/STMT/~:;~:/STMT/~:@_~]~}~:>"
               ;                last     others
               (?form-list form)))

(defmethod write-stmt ((form <switch-form>) stream)
  (default-write form stream))

(defmethod write-stmt ((form <labeled-form>) stream)
  (default-write form stream))

(defmethod write-stmt ((form <let*-form>) stream)
  (format stream "~@<{~;~:{~A ~A~:[~; = ~/EXPR/~];~:@_~}~:@/STMT/~;}~:>"
          (type-var-init-list (?var-list form)
                              (?init-list form)
                              (?type-list form))
          (?body form))
  )

(defmethod write-stmt ((form <labels-form>) stream)
  (default-write form stream))

(defmethod write-stmt ((form <let/cc-form>) stream)
  (default-write form stream))

(defmethod write-stmt ((form <tagbody-form>) stream)
  (write-block stream 
               "~@<~I~@[~:/STMT/~]~
                   ~{~#[~;~{~:@_~A:~:@_~:@/STMT/~}~
                       ~:;~{~:@_~A:~:@_~:/STMT/~}~]~}~
                ~:>"
          (?first-form form)
          (mapcar #'label-and-form (?tagged-form-list form))))

(defmethod write-stmt ((form <tagged-form>) stream)
  (format stream "goto ~A;"
          (?label form)))

(defmethod write-stmt ((app <app>) stream)
  (if (dynamic *return*)
    (write-return (dynamic *return*) app stream)
    (progn 
      (write-call (?function app) (?arg-list app) (?type-descr app) stream)
      (write-string ";" stream))))

(defgeneric write-return (type expr stream))
(defmethod write-return ((type <%void>) expr stream)
  (format stream "~/EXPR/;"
          expr))
(defmethod write-return (type expr stream)
  (format stream "return ~/EXPR/;" 
          (type-expr-for-c (dynamic *return*) expr)))

(defun write-block (stream format . args) 
  (format stream "~:[{~;~]~?~@*~:[}~;~]" 
          (eq (dynamic *context*) :block) 
          format args))

;;; -----------------------------------------------------------------------------------
;;; instance access
;;; -----------------------------------------------------------------------------------

(defgeneric instance-access (representation class instance stream))

(defmethod instance-access ((representation <%machine-type>) 
                            class instance stream)
  (format stream "~A" (car (?value-list instance))))

(defmethod instance-access ((representation <%machine-type>) 
                            (class <%function>) 
                            instance stream)
  (format stream "~A" (c-identifier (car (?value-list instance)))))

(defmethod instance-access ((representation <%pointer-to-struct>)
                            class instance stream)
  (if (dynamic *no-pointer*)
    (format stream "~A.I" (c-identifier instance))
    (write-enveloped-expr stream 13 "&~A.I" (c-identifier instance))))

(defmethod instance-access ((representation <%pointer-to-vector>) 
                            class instance stream)
  (write-enveloped-expr stream 14 "~A.I" (c-identifier instance)))

(defmethod instance-access ((representation <%direct>) class instance stream)
  (instance-access 
   (?representation 
    (~slot-description-type 
     (car (~class-slot-descriptions (?class instance)))))
   class instance stream))

(defmethod instance-access ((representation <%pointer-to-struct>)
                            (class <tail-class-def>) instance stream)
  (if (dynamic *no-pointer*)
    (format stream "~A" (c-identifier instance))
    (write-enveloped-expr stream 13 "&~A" (c-identifier instance))))

;tail vectors are stored like lisp vectors to make the length available
;(defmethod instance-access ((representation <%pointer-to-vector>) 
;                            (class <tail-class-def>) instance stream)
;  (write-enveloped-expr stream 13 "~A" (c-identifier instance)))

(defmethod instance-access ((representation <%pointer-to-vector>) 
                            (class <%string>) instance stream)
  (format stream "\"~A\"" 
          (make-c-string instance)))

;;; -----------------------------------------------------------------------------------
;;; function calls
;;; -----------------------------------------------------------------------------------
(defgeneric write-call (fun args types stream)
  ; fun: the function called
  ; args: its arguments
  ; types: a vector #(return-type type-of-arg-1 type-of-arg-2 ...)
  ; stream: the stream for code output
  )

(defmethod write-call ((fun <defined-fun>) args types stream)
  (format stream "~@<~A(~:I~{~/EXPR/~^, ~_~})~:>"
          (c-identifier fun)
          (type-args-for-c (function-signature fun)
                           args)))

(defmethod write-call ((fun <imported-fun>) args types stream)
  (if (null (dynamic *empty-list-in-register*))
    (format stream "~@<~A(~:I~{~/EXPR/~^, ~_~})~:>"
            (c-identifier fun)
            (type-args-for-c (function-signature fun)
                             args))
    (format stream 
            "~@<~:[XCALL~;YCALL~](~A(~:I~{~/EXPR/~^, ~_~}))~:>"
            (function-with-no-return fun)
            (c-identifier fun)
            (type-args-for-c (function-signature fun)
                             args))))

(defun function-with-no-return (fun)
  (eq %void (result-type fun)))

(defmethod write-call ((fun <generic-fun>) args types stream)
  (write-call (~generic-function-discriminating-function fun)
              args types stream))

(defmethod write-call ((fun <method-def>) args types stream)
  (write-call (~method-function fun)
              args types stream))

#|
Precedence and Associativity of C-Operators (ANSI-C)
prec assoc operators
  0   ->   ,
  1   <-   = += -= *= /= %= &= ^= |= <<= >>=
  2   <-   ?:
  3   ->   ||
  4   ->   &&
  5   ->   | 
  6   ->   ^
  7   ->   &
  8   ->   == !=
  9   ->   < <= > >=
 10   ->   << >>
 11   ->   + -
 12   ->   * / %
 13   ->   ! ~ ++ -- + - * & (type) sizeof
 14   ->   () [] -> .
|#

(defconstant $sys-fun-table `(
  ;structure of an element:
  ;(special-sysfun format-string C-operator-precedence)
  ;comparision
  ;(,%eq "~8/EXPR/ == ~9/EXPR/" 8)
  ;(,%neq "~8/EXPR/ != ~9/EXPR/" 8)
  (,%gt "~9/EXPR/ > ~10/EXPR/" 9)
  (,%lt "~9/EXPR/ < ~10/EXPR/" 9)
  (,%ge "~9/EXPR/ >= ~10/EXPR/" 9)
  (,%le "~9/EXPR/ <= ~10/EXPR/" 9)
  ;arithmetic
  (,%plus "~11/EXPR/ + ~12/EXPR/" 11)
  (,%minus "~11/EXPR/ - ~12/EXPR/" 11)
  (,%neg "- ~14/EXPR/" 13)
  (,%mult "~12/EXPR/ * ~13/EXPR/" 12)
  (,%div "~12/EXPR/ / ~13/EXPR/" 12)
  (,%mod "~12/EXPR/ % ~13/EXPR/" 12)
  (,%abs "abs(~/EXPR/)" 14)
  ;bitwise logical
  (,%not "~~~14/EXPR/" 13)
  (,%and "~7/EXPR/ & ~8/EXPR/" 7)
  (,%or "~5/EXPR/ | ~6/EXPR/" 5)
  (,%xor "~6/EXPR/ ^ ~7/EXPR/" 6)
  (,%lshiftl "~10/EXPR/ << ~11/EXPR/" 10)
  (,%lshiftr "LSHIFTR(~/EXPR/, ~/EXPR/)" 14)
  (,%ashiftr "ASHIFTR(~/EXPR/, ~/EXPR/)" 14)
  ;conversions
  (,%citos "(float)~14/EXPR/" 13)
  (,%citod "(double)~14/EXPR/" 13)
  (,%cstoi "(signed long)~14/EXPR/" 13)
  (,%cstod "(double)~14/EXPR/" 13)
  (,%cdtoi "(signed long)~14/EXPR/" 13)
  (,%cdtos "(float)~14/EXPR/" 13)
  ;others
  (,%funcall "~@<(*~13/EXPR/)(~:I~@{~/EXPR/~^, ~_~})~:>" 14)
  (,%setjmp "setjmp(~/EXPR/)" 14)
  (,%longjmp "longjmp(~/EXPR/)" 14)
  (,%pointer-of-variable "&~14/EXPR/" 13)
  ))

(defun sys-fun-format (fun)
  (or (second (cl:assoc fun $sys-fun-table))
      (cl:string (?identifier fun))))

(defun sys-fun-precedence (fun)
  (or (third (cl:assoc fun $sys-fun-table))
      100))

(defmethod write-call ((fun <special-sys-fun>) args types stream)
  ; casts should not be necessary because basic tail functions only operate on
  ; basic tail types
  (cl:apply #'write-enveloped-expr 
            stream (sys-fun-precedence fun) (sys-fun-format fun) args))

;;; ------------
;;; %eq and %neq must be handled in a special way because their arguments may be
;;; any Lisp- or Tail-Object, in the case of a class-subclass comparision the
;;; balancing of the types is needed (cast to the higher class)

(defmethod write-call ((fun <%eq>) args types stream)
  (write-comparision-call "~8/EXPR/ == ~9/EXPR/" args types stream))

(defmethod write-call ((fun <%neq>) args types stream)
  (write-comparision-call "~8/EXPR/ != ~9/EXPR/" args types stream))

(defun write-comparision-call (format args types stream)
  (let ((args (balance-c-types args types)))
    (write-enveloped-expr stream 8 format 
                          (first args) (second args))))

; ATTN: this function should be moved to c-typing
(defun  balance-c-types (args types)
  ; this function only handles the arguments of binary function
  ; it returns casted arguments if a cast is needed because of a subclass
  ; relation between the two types and if the types have no compatible
  ; representation 
  ; in all other cases the arguments are returned unchanged
  (let ((arg1 (first args))
        (arg2 (second args))
        (type1 (svref types 1))
        (type2 (svref types 2)))
    (cond ((eq type1 type2) args) ; to make the most simple case fast
          ((c-typing::compatible-representation-p type1
                                                  (~class-representation type1)
                                                  type2
                                                  (~class-representation type2))
           args) ; C needs no cast
          ((c-typing::is-subclass type1 type2)
           (list (type-expr-for-c type2 arg1)
                 arg2))
          ((c-typing::is-subclass type2 type1)
           (list arg1
                 (type-expr-for-c type1 arg2)))
          (t args) ; try it with unchanged arguments
          )))

;;; ------------

(defmethod write-call ((fun <%cast>) args types stream)
  (write-enveloped-expr 
   stream 13
   "~@<~3I(~A)~:_~14/EXPR/~:>" 
   (type-identifier (cl:slot-value (first args) 'analyse-h::type)) ;*3*
   (second args)))

(defmethod write-call ((fun <%size-of-instance>) args types stream)
  ; produces wrong code for non-structures
  (write-enveloped-expr 
   stream 13
   "sizeof(struct ~A)" 
   (type-identifier (first args))))

(defmethod write-call ((fun <%size-as-component>) args types stream)
  (write-enveloped-expr 
   stream 13
   "sizeof(~A)" 
   (type-identifier (first args))))

(defmethod write-call ((fun <%select>) args types stream)
  (let ((slot (~find-slot-description (svref types 1)
                                      (second args))))
    (if slot
      (write-enveloped-expr 
       stream 14
       "~@<~:[~14/EXPR/~:_->~;~14@/EXPR/~:_.~]~A~:>"
       (instance-p (first args))
       (dynamic-let ((*no-cast-if-compatible-representation* nil))
          (type-expr-for-c (svref types 1) (first args)))
       (c-identifier slot))
      (progn
        (message "~%error in %select: no slot ~A in class ~A"
                (second args)
                (?identifier (svref types 1)))
        (format stream "~:[~/EXPR/->~;~@/EXPR/.~]<undefined slot ~A>"
                (instance-p (first args))
                (first args)
                (second args))))))

(defmethod write-call ((fun <%setf-select>) args types stream)
  (let ((slot (~find-slot-description (svref types 1)
                                      (second args))))
    (if slot
      (write-enveloped-expr 
       stream 1
       "~@<~:[~14/EXPR/~:_->~;~14@/EXPR/~:_.~]~A ~:_= ~1/EXPR/~:>"
       (instance-p (first args))
       (dynamic-let ((*no-cast-if-compatible-representation* nil))
          (type-expr-for-c (svref types 1) (first args)))
       (c-identifier slot)
       (type-expr-for-c (?type slot)
                        (third args)))
      (progn
        (message "~%error in %select: no slot ~A in class ~A"
                (second args)
                (?identifier (svref types 1)))
        (format stream "~:[~/EXPR/->~;~@/EXPR/.~]<undefined slot ~A> = ~/EXPR/"
                (instance-p (first args))
                (first args)
                (second args)
                (third args))))))

(defmethod write-call ((fun <%extract>) args types stream)
  (write-enveloped-expr 
   stream 14
   "~14/EXPR/[~/EXPR/]"
   (dynamic-let ((*no-cast-if-compatible-representation* nil))
       (type-expr-for-c (svref types 1) (first args)))
   (second args)))

(defmethod write-call ((fun <%setf-extract>) args types stream)
  (write-enveloped-expr 
   stream 14
   "~@<~14/EXPR/[~/EXPR/] ~:_= ~1/EXPR/~:>"
   (dynamic-let ((*no-cast-if-compatible-representation* nil))
       (type-expr-for-c (svref types 1) (first args)))
   (second args)
   (type-expr-for-c  (~vector-class-element-type (svref types 1))
                     (third args))))

(defmethod write-call ((fun <local-fun>) args types stream)
  (default-write (cons fun args) stream))

(defmethod write-call ((const <named-const>) args types stream)
  (if (fun-p (?value const))
    ;(write-call (?value const) args stream)
    (format stream "~@<~A(~:I~{~/EXPR/~^, ~:_~})~:>"
            (c-identifier const)
            args)
    (default-write (cons const args) stream)))

(defmethod write-call (object args types stream)
  (default-write (cons object args) stream))

;;; -----------------------------------------------------------------------------------
;;; Expressions
;;; -----------------------------------------------------------------------------------
#|
Format-directive ~/EXPR/ prints its argument as a C-expression. The argument
must be an LZS-expression usable as a C-expression, which are: app, var-ref,
named-const, any literal incl. classes, fun, or setq-form. EXPR calls a
generic function write-expr which prints the equivalent C-expression. A
numeric argument ~n/EXPR/ says that no parantheses are needed to get the right
evaluation order if the operator precedence of the expression to be printed is
greater than or equal to n. The function write-enveloped-expr prints an
expression with or without parantheses dependent on the precedences.

~n/EXPR/   Print expression. Print with parantheses if the precedence of the
           argument is lower than n. In write-expr n is the value of 
           (dynamic *min-precedence*). The default for n is 0.
~:/EXPR/   If the argument is () then don't use the empty-list-register even if
           (dynamic *empty-list-in-register*) is true.
~@/EXPR/   The pointer reference is done outside, therefore use 'instance' instead
           of '&instance'. 
|#

(defun expr (stream object colon? atsign? . args)
  (dynamic-let ((*no-pointer* 
                 (if atsign? t (dynamic *no-pointer*)))
                (*empty-list-in-register* 
                 (if colon? nil (dynamic *empty-list-in-register*)))
                (*min-precedence* (if args (car args) 0)))
     (write-expr object stream)))

(defvar *no-pointer* nil) ; necessary for literals, t means that the literal
                          ; itself must be used instead of its pointer

(defvar *min-precedence* 0)

(defgeneric write-expr (object stream))

(defmethod write-expr (object stream) 
  (let ((instance (expand-literal object)))
    (instance-access (?representation (?class instance))
                     (?class instance)
                     instance
                     stream)))

(defmethod write-expr ((object <null>) stream) 
  (if (dynamic *empty-list-in-register*)
    (format stream "NIL")
    (let ((instance (expand-literal object)))
      (instance-access (?representation (?class instance))
                       (?class instance)
                       instance
                       stream))))

(defmethod write-expr ((object <fun>) stream)
  (write-string (c-identifier object) stream))

(defmethod write-expr ((object <class-def>) stream)
  (if (dynamic *no-pointer*)
    (format stream "~A.I" (c-identifier object))
    (write-enveloped-expr stream 13 "&~A.I" (c-identifier object))))

(defmethod write-expr ((app <app>) stream)
  (write-call (?function app) (?arg-list app) (?type-descr app) stream))

(defmethod write-expr ((var-ref <var-ref>) stream)
  (write-string (c-identifier (?var var-ref)) stream))

(defmethod write-expr ((const <named-const>) stream)
  (if (eq (?value const) ^unknown)
    (write-string (c-identifier const) stream)
    (write-expr (?value const) stream)))

;*6*
(defmethod write-expr ((var <static>) stream)
  (write-string (c-identifier var) stream))

(defmethod write-expr ((var <tempvar>) stream)
  (write-string "TEMPVAR" stream))

(defmethod write-expr ((expr <cast>) stream)
  (write-enveloped-expr stream 13 
                        "~@<~3I(~A)~:_~14/EXPR/~:>" 
                        (type-identifier (?type expr))
                        (?expression expr)))

(defmethod write-expr ((form <setq-form>) stream)
  ;*the following line should be removed because the setq-source can't be
  ;^unknown in the LZS
  ;the mzs->lzs-Pass must generate an init-form for this case and must remove
  ;the assignment *
  (if (eq (?form form) ^unknown) ()
  (format stream "~@<~A ~:_= ~/EXPR/~:>"
          (c-identifier (if (var-ref-p (?location form)) ;*5*
                          (?var (?location form))
                          (?location form)))
          (type-expr-for-c (get-type form)
                           (?form form))))
  )

(defun write-enveloped-expr (stream precedence format . args)
  (if (>= precedence (dynamic *min-precedence*))
    (apply #'format stream format args)
    (format stream "(~?)" format args)))

;;; -----------------------------------------------------------------------------------
;;; Information about LZS-Objects
;;; -----------------------------------------------------------------------------------

(defgeneric c-extern-p (obj))

(defmethod c-extern-p (obj)
  (or (imported-p obj)
       (?exported obj)))

(defmethod c-extern-p ((obj <fun>))
  (or t  ; at this place it should be proved whether the functions pointer is
         ; used (function as data) or not (test result T resp. NIL) *11*
      (imported-p obj)
      (?exported obj)))

(defun types-and-parameters (fun)
  ; only required parameters must be considered, because functions with other
  ; parameters are mapped to functions which have required parameters only
  (types-and-parameters-1 (?var-list (?params fun)) 
                          (function-signature fun) 
                          1))

(defun types-and-parameters-1 (required function-signature i)
  (if (null required) 
    nil
    (progn 
      (setf (?type (car required))
            (svref function-signature i))
      (list* (type-identifier (svref function-signature i))
             (local-c-identifier (car required))
             (types-and-parameters-1 (cdr required) 
                                     function-signature
                                     (+ i 1))))))

(defun type-var-init-list (vars inits types)
  (if (null vars) nil
      (progn
        (unless (?type (car vars)) ;*4*
          (setf (?type (car vars)) (or (car types)
                                       %object)))
        (cons (list (type-identifier (?type (car vars)))
                    (local-c-identifier (car vars))
                    (null (eq (car inits) ^unknown))
                    (car inits))
              (type-var-init-list (cdr vars) (cdr inits) (cdr types)))
        )))

(defvar *label-index* 0)

(defun label-and-form (tagged-form)
  (setf (?label tagged-form)
        (format nil "L~D" (dynamic *label-index*)))
  (dynamic-setq *label-index* (+ 1 (dynamic *label-index*)))
  (list (?label tagged-form)
        (?form tagged-form)))

(defun instance-p (object)
  (or (sym-p object)
      (literal-instance-p object)
      (class-def-p object)
      (null (lzs-object-p object))))

(defgeneric initial-value (var))
(defmethod initial-value ((var <global-static>)) (?initial-value var))
(defmethod initial-value ((var <imported-static>)) ^unknown)
(defmethod initial-value ((var <named-const>)) (?value var))

;;; -----------------------------------------------------------------------------------
;;; Printing Error Messages
;;; -----------------------------------------------------------------------------------

(defun message (format . args)
  (apply #'format *error-output* format args))

#module-end


