;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: binding -*-
#|
-----------------------------------------------------------------------------------
TITLE: 
-----------------------------------------------------------------------------------
File:    binding.em
Version: 1.0 (last modification on Tue Dec  7 16:35:26 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/binding.em[1.0]
	Tue Dec  7 17:08:20 1993 imohr@isst proposed $
 

-----------------------------------------------------------------------------------
|#

#module binding
(import (level-0-eulisp
         apply-standard
         accessors
         (only (make-instance call-next-method)
           common-lisp))
 syntax (level-0-eulisp
         apply-standard)
 export (<binding>
         binding-p
         make-binding
         finally-refered-object 
         get-lzs-object)
 )

;;; -----------------------------------------------------------------------------------
;;; bindings
;;; -----------------------------------------------------------------------------------

(defstandardclass <binding> ()
  (identifier :reader :initarg)
  (code-identifier :accessor :initform ())
  (refers-to :reader :initarg)
  (refers-finally-to :accessor)
  :predicate)

(defun make-binding options
  (let ((binding (apply #'make-instance <binding> options)))
    (setf (?refers-finally-to binding) 
          (finally-refered-object (?refers-to binding)))
    binding))

(defgeneric finally-refered-object (obj))
(defmethod finally-refered-object (obj) obj)
(defmethod finally-refered-object ((obj <binding>))
  (?refers-to obj))

(defmethod ?exported ((ref <binding>))
  (?exported (?refers-finally-to ref)))

(defun get-lzs-object (object)
  ;; get-lzs-object returns the object finally refered to if object is a
  ;; renamed object or otherwise returns its argument 
  (if (binding-p object)
    (?refers-finally-to object)
    object))


#module-end
