;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: annotate -*-
#|
-----------------------------------------------------------------------------------
TITLE: Transformation of %annotate-forms to LZS
-----------------------------------------------------------------------------------
File:    annotate.em
Version: 1.10 (last modification on Mon Nov  8 14:20:17 1993)
State:   proposed

DESCRIPTION:
This module defines the transformation of %annotate-forms of TAIL to the LZS.
The handlers for the keywords of %annotate-function are defined in the a-list
*annotate-function-handlers*. The handlers are functions of three arguments:
1. the function object (instance of LZS-class <fun>)
2. the annotate-keyword
3. the form after the keyword (a list or a symbol in most cases)

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/annotate.em[1.0]
	Fri Mar 12 16:36:04 1993 imohr@isst save $
 Transformation of %annotate-forms to LZS
 
annotate.em[1.1] Thu Mar 18 09:26:07 1993 hfried@isst proposed $
 [Fri Mar 12 17:23:03 1993] Intention for change:
 hinzufuegen inline 
 done
 
annotate.em[1.2] Wed Mar 24 13:53:31 1993 hfried@isst proposed $
 [Mon Mar 22 16:03:07 1993] Intention for change:
 add annotations for side-effects
 
annotate.em[1.3] Wed Apr  7 16:12:30 1993 akind@isst proposed $
 Included type inference handler to read in signatures.
 
annotate.em[1.4] Wed Apr 14 12:03:58 1993 imohr@isst save $
 + handling of constants with function values
 
annotate.em[1.5] Wed Apr 14 13:44:31 1993 imohr@isst save $
 
annotate.em[1.6] Fri Apr 16 17:01:11 1993 akind@isst proposed $
 [Fri Apr 16 16:59:57 1993] Intention for change:
 Added handler functions new-signature and extend-signature.
 
annotate.em[1.7] Wed Sep 15 11:56:30 1993 imohr@isst proposed $
 [Tue Sep 14 08:07:26 1993] Intention for change:
 annotate-function: + is-standard-discriminator
 
annotate.em[1.8] Wed Sep 22 17:09:25 1993 akind@isst proposed $
 [Wed Sep 22 17:06:36 1993] Intention for change:
 new handler (renew-signature)
 
annotate.em[1.9] Mon Oct 11 08:47:33 1993 hfried@isst published $
 [Fri Oct  8 10:51:07 1993] Intention for change:
 + -> binary+
 
annotate.em[1.10] Tue Nov  9 11:33:43 1993 imohr@isst proposed $
 [Mon Nov  8 14:18:40 1993] Intention for change:
 new style module header
 

-----------------------------------------------------------------------------------
|#

#module annotate
(import (level-1-eulisp
         LZS
         el2lzs-main
         accessors
         (only (set-interpreter call) eval)
         (only (set-read-side-effect set-write-side-effect) side-effects-h)
         (only (new-signature extend-signature renew-signature) ti-signature)
         (only (set-std-discr-fun) generic-dispatch)
         (only (warn error assoc cddr cadr) common-lisp))
 syntax (level-1-eulisp
         el2lzs-main)
)

;;; -----------------------------------------------------------------------------------
;;; Handler functions for %annotate-function on end of this file !!
;;; -----------------------------------------------------------------------------------

;;; -----------------------------------------------------------------------------------
;;; TAIL: %annotate-function
;;; -----------------------------------------------------------------------------------
;;; syntax: (%annotate-function <function-id> {<key> <description>}*)
;;; <function-id> : global function binding
;;; <key> : symbol
;;; <description> : any literal
;;; %describe-function provides some informations about functions, which are needed
;;; by the compiler but are not computable

(defgeneric get-function (lzs-object))

(defmethod get-function ((object <fun>)) object)
(defmethod get-function ((object <defined-named-const>))
  (if (eq (?value object) ^unknown)
    (error-invalid-function-object object)
    (get-function (?value object))))
(defmethod get-function (object)
  (error-invalid-function-object object))

(defun error-invalid-function-object (object)
  (warn "~A was given where a function was expected" object))

(deftranssyn (%annotate-function id . options) (whole-form))

(deftransdef (%annotate-function id . options)
  (transdef-%annotate-function (get-function (find-in-lex-env id)) 
                               options))

(defun transdef-%annotate-function (fun options)
  (if (null options) 
    nil
    (let ((key (car options)))
      (funcall (find-annotate-function-handler key) 
               fun key (cadr options))
      (transdef-%annotate-function fun (cddr options)))))

(defun find-annotate-function-handler (key)
  (let ((entry (assoc key *annotate-function-handlers*)))
    (if entry
      (cdr entry)
      (error "undefined key for %annotate-function: ~A" key))))
;;; -----------------------------------------------------------------------------------
;;; Handler 
;;; -----------------------------------------------------------------------------------

(defun set-inline (fun key value)
  (setf (?inline fun) value))

(defun set-reduce (fun key value)
  ;
  ; syntax of value:
  ;                   ( /binary-function/ 
  ;                     /one-argument-translation/
  ;                     /zero-argument-translation/
  ;                     /translation-type/)
  ; /one-argument-translation/ = self | t | (/function/ /args/*)
  ; args = /constant/ | self
  ; /zero-argument-translation/ = /constant/ | error
  ; /translation-type/ = acc | logical | select1 | select2
  ;
  (setf (car value) (get-function (find-in-lex-env (car value))))
  (if (consp (car (cdr value)))
    (setf (car (car (cdr value)))
          (get-function (find-in-lex-env (car (car (cdr value))))))
    ())
  (setf (?reduce fun) value))

;;; -----------------------------------------------------------------------------------
;;; Handler functions for %annotate-function
;;; -----------------------------------------------------------------------------------

(deflocal *annotate-function-handlers*
  `(;(keyword . function)
    (,^interpreter . ,#'set-interpreter)
    (,^inline . ,#'set-inline)
    (,^read-location . ,#'set-read-side-effect)
    (,^write-location . ,#'set-write-side-effect)
    (,^new-signature . ,#'new-signature)
    (,^extend-signature . ,#'extend-signature)
    (,^renew-signature . ,#'renew-signature)
    (,^is-standard-discriminator . ,#'set-std-discr-fun)
    (,^reduce . ,#'set-reduce)
    ))


#module-end
