;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el-conditions-0 -*-
#|
-----------------------------------------------------------------------------------
TITLE: el-conditions in cl
-----------------------------------------------------------------------------------
File:    el-conditions-0.em
Version: 1.0 (last modification on Thu Sep  2 14:36:46 1993)
State:   published

DESCRIPTION:
fake of the EL-Condition system

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
system rised conditions cannot have a continuation
here one can only accept a condition
Error and cerror not exported because of package conflicts in n-1 files
AUTHOR:
e.u.kriegel

CONTACT: 
e.u.kriegel

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/EulispModules/el-conditions-0.em[1.0]
	Thu Sep  2 14:40:19 1993 ukriegel@isst published $
 el-conditions because of name clash with cmucl
 

-----------------------------------------------------------------------------------
|#

#module-name el-conditions-0
#module-import
(eulisp-kernel
 (only (class-of) common-lisp);;to make ingo's emulator happy
 (rename ((signal cl:signal)
          (error cl:error)
          (make-condition cl:make-condition)
          (make-instance cl:make-instance)
          (mapcar cl:mapcar)
          (append cl:append)
	  (gensym cl:gensym)
          (find-class cl:find-class)
          (condition cl:condition)
          (block cl:block)
          (return-from cl:return-from)
          (subtypep cl:subtypep)
          (format cl:format)
          (division-by-zero cl:division-by-zero))
   (only (apply error mapcar gensym signal make-condition make-instance append find-class condition
                  block subtypep return-from format subtypep class-of) common-lisp)))
#module-syntax-import 
(eulisp-kernel
 (rename ((defmacro cl:defmacro)
          (handler-bind cl:handler-bind)) 
   (only (handler-bind defmacro) common-lisp)))
#module-syntax-definitions




;;; -----------------------------------------------------------------------------------
;;; faked eulisp version
;;; -----------------------------------------------------------------------------------

(defmacro defcondition (name supers slots)
`(defconstant ,name (cl:defclass ,name ,supers ,slots )))

(defmacro with-handled-conditions
             (condition-variable-action-list . forms)
  (let* ((handler-bind-list 
          (cl:mapcar (lambda(x)
                       (let* ((condition (car x))
                              (lambda-list (if (null (car(cdr x)))
                                             (list (cl:gensym)(cl:gensym))
                                             (car (cdr x))))
                              (forms (cdr (cdr x)))
                              (cond-var (car lambda-list))
                              (lambda1 
                               (cl:append (list 'lambda lambda-list) forms)))
                         
                         (list 
                          condition                        
                          (cl:append 
                           (list 'lambda
                                 (list cond-var)) 
                           (list 
                            (list 'funcall lambda1
                                  cond-var
                                  (list 'if (list 'cl:subtypep (list 'cl:class-of cond-var) (list
                                                                                       'cl:find-class ''<condition>))
                                        (list
                                         'condition-continuation cond-var) '())))))
                         
                         ))
                     condition-variable-action-list)))
    `(cl:handler-bind ,handler-bind-list ,@forms)))


(defmacro let/cc (name . forms)
  (let ((tmp (cl:gensym)))
        `(cl:block ,name
           (let ((,name (lambda(,tmp)(cl:return-from ,name ,tmp))))
             ,@forms))))

;; local macro definitions

#module-header-end

;;exports
(export-syntax let/cc with-handled-conditions defcondition)
(export  ;error cerror no-handler
        condition-message
)


;;definitions and init-forms


(defun signal
       (condition continuation)
  (if (cl:subtypep (class-of condition) <condition>)
    (setf (condition-continuation condition) continuation))
  (cl:signal condition))

(defun error 
       (error-message condition . init-args)
  (print error-message)
  (let ((c (apply #'cl:make-instance condition init-args)))
    (signal c ())
    (no-handler c ())))

(defun cerror
       (error-message condition . init-args)
  (print error-message)
  (let/cc cerror-fixed-up
          (let ((c (apply #'cl:make-instance condition init-args)))
            (signal c cerror-fixed-up)
            (no-handler c cerror-fixed-up))))

(defun no-handler
       (condition continuation)
  (cl:error condition))


#module-end


