;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: dynamic -*-
#|
-----------------------------------------------------------------------------------
TITLE: EL-in-CL: dynamic bindings for Level1
-----------------------------------------------------------------------------------
File:    dynamic.em
Version: 1.1 (last modification on Mon Mar  8 15:11:31 1993)
State:   published

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/EulispModules/dynamic.em[1.0]
	Fri Mar  5 15:40:09 1993 imohr@isst proposed $
 
dynamic.em[1.1] Wed Mar 10 13:11:52 1993 imohr@isst published $
 [Mon Mar  8 14:34:41 1993] Intention for change:
 Log not inside comments
 - with new file header
 - Log-message inside balanced comment
 

-----------------------------------------------------------------------------------
|#

#module-name dynamic
#module-import
(eulisp-kernel pair symbol null pair-ext)
#module-syntax-import 
(eulisp-kernel
 list-ext
 (only (declare special) common-lisp)
 (rename ((defvar cl:defvar)) common-lisp))
#module-syntax-definitions

#module-header-end

;defined macros: defvar dynamic dynamic-let dynamic-setq

(defun make-dynamic-id (id)
(make-eulisp-symbol id))

(defmacro defvar (id init)
`(progn 
   (cl:defvar ,(make-dynamic-id id))
   (setq ,(make-dynamic-id id) ,init)))

(defmacro dynamic (id) (make-dynamic-id id))

(cl:defvar *dynamics* nil)

(defun make-and-collect-dynamic-id (id)
(let ((dyn-id (make-dynamic-id id)))
   (push dyn-id *dynamics*)
   dyn-id))

(defmacro dynamic-let (vars . body)
(let ((*dynamics* nil))
  `(let ,(make-dynamic-let-vars vars)
	(declare (special ,@*dynamics*))
	,@body)))

(defun make-dynamic-let-vars (vars)
(cond ((null vars) nil)
      ((symbolp (car vars))
	 (cons (make-and-collect-dynamic-id (car vars))
	       (make-dynamic-let-vars (cdr vars))))
      (t (cons `(,(make-and-collect-dynamic-id (caar vars)) ,(cadar vars))
	       (make-dynamic-let-vars (cdr vars))))))

(defmacro dynamic-setq (var form)
`(setq ,(make-dynamic-id var) ,form))

#module-end
