/*									     *
*			basic header file:  xalloc_misc.h		     *
*									     *
*****************************************************************************/
#ifndef	xalloc_misc_h
#define xalloc_misc_h

#include "xalloc_conf.h"

/* Some simple sizes and macros to be found anywhere */

#ifndef	NULL
#define	NULL	0
#endif
#define WORD_SIZE 32
#define LOG_WORD_SIZE 5
#define BITS_PER_BYTE 8
#define LOG_BITS_PER_BYTE 3
#define LOG_BYTES_PER_WORD (LOG_WORD_SIZE - LOG_BITS_PER_BYTE)

#define byte2word(s) (((s) + 3)>>2)
#define word2byte(s) ((s) << 2)

#define	isset(w,b)	((w) & (1<<(b)))
#define	set(w,b)	((w) |= (1<<(b)))
#define	reset(w,b)	((w) &= ~(1<<(b)))

#define	max(x,y)	(((x) > (y))? (x) : (y))
#define min(x,y)	(((x) < (y))? (x) : (y))

/* ---------------- Sizes to be used here, type-definitions ---------------- */

#define CARDMASK	(CARDSIZE - 1)
#define CARD_ADDR(p)	((card *) ((long)(p) & ~CARDMASK))

#define NB_OF_MARK_WORDS (byte2word(CARDSIZE)/WORD_SIZE)

typedef struct _CardHeader {
	struct _Card	**card_index;		/* ptr to card reference-list*/
	long 		object_size;		/* size in words */
	long 		object_byte_size;	/* object-size in bytes */
	long 		card_nb;		/* nb of basic cards */
	long 		type_descriptor;
	long 		object_mask;		/* mask for fast pointer test */
	struct _Card 	*next_card;		/* to link cards together */
	long 		markbits[NB_OF_MARK_WORDS];
	} CardHeader;

#define root 		header.card_index
#define size 		header.object_size
#define bytesize 	header.object_byte_size
#define cardnum		header.card_nb
#define type_dscr 	header.type_descriptor
#define mask 		header.object_mask
#define next 		header.next_card 
#define	mkarea		header.markbits

#define USERSPACE	(byte2word(CARDSIZE - sizeof(CardHeader)))

typedef struct _Card {
		CardHeader header;
	        long	userspace[USERSPACE];
		} card;

#define	basiccards(s)	(((s) <= USERSPACE) ? 1 \
			: (((s) - USERSPACE) / (byte2word(CARDSIZE)) + 2))

/* some macros to handle information on cards */

#define	get_size(c)	((c)->size)
#define	get_mask(c)	((c)->mask)
#define get_tdscr(c)	((c)->type_dscr)
#define get_cardnum(c)	((c)->cardnum)

#define	ms_card(c)	(get_size(c) == 0)
#define	mt_card(c)	(get_tdscr(c) == 0)

#define	get_ms_real_size(p)	(word2byte(*((long *)(p)-1)-1))
#define get_real_size(c)	((c)->bytesize)

#define	put_size(c,s)		((c)->size = (s))
#define	put_tdscr(c,t)		((c)->type_dscr = (t))
#define put_cardnum(c,n)	((c)->cardnum = (n))
#define	put_real_size(c,s)	((c)->bytesize = (s))

#define	into_card_list(cd,c)	((c)->next = get_card_d(cd), store_card_d(cd,c))

/* we need information about marking in xalloc.c, too,
 * because we use markbits another way on STMS */

#define	markword(c,p)	(((c)->mkarea)[((long)(p) & CARDMASK)>>\
				(LOG_WORD_SIZE+LOG_BYTES_PER_WORD)])
#define markbit(p)	(((long)(p)>>LOG_BYTES_PER_WORD) & (WORD_SIZE-1))

#define	ismarked(c,p)	isset(markword(c,p), markbit(p))
#define mark(c,p)	set(markword(c,p), markbit(p))
#define	unmark(c,p)	reset(markword(c,p), markbit(p))

#define large_unmark(c)	((c)->mkarea[0] = 0)	/* faster than mask first bit */


#define clear_marks(c)	bzero((c)->mkarea, NB_OF_MARK_WORDS * sizeof(long))

/* some macros to test values to be pointers */

#define	is_pointer(p)	(((long)(p) > 0) && (((long)(p) & 3) == 0))

#define	p_in_heap(p)	(((((long)(p)) & 3) == 0)\
			&& ((p) > HEAPBEGIN)\
			&& ((p) < HEAPEND))

#define	living_card(c)	(((long)((c)->root) >= (long)first_card_index)\
			 && ((long)((c)->root) < (long)last_card_index)\
			 && (*((c)->root) == (c)))


#ifdef USE_LARGE
#ifdef OPTIMIZED_POINTER_TESTS
#define consistent_pointer(c,p,s,m) (((p) >= ((c)->userspace)) &&	\
				     ((((long)(p) & (m)) == 0) ||	\
	((((long *)(c) + byte2word(CARDSIZE) - (p)) % (s)) == 0) ||	\
			(((s) > USERSPACE) && ((p) == ((c)->userspace)))))
#else	/* argument m is never used */
#define consistent_pointer(c,p,s,m) (((p) >= ((c)->userspace)) &&	\
		(((((long *)(c) + byte2word(CARDSIZE) - (p)) % (s)) == 0) || \
			(((s) > USERSPACE) && ((p) == ((c)->userspace)))))
#endif 	/* OPTIMIZED_POINTER_TESTS */

#else	/* no large objects */

#ifdef OPTIMIZED_POINTER_TESTS
#define consistent_pointer(c,p,s,m) (((p) >= ((c)->userspace)) &&	\
				     ((((long)(p) & (m)) == 0) ||	\
		((((long *)(c) + byte2word(CARDSIZE) - (p)) % (s)) == 0)))
#else	/* argument m is never used */
#define consistent_pointer(c,p,s,m) (((p) >= ((c)->userspace)) &&	\
		((((long *)(c) + byte2word(CARDSIZE) - (p)) % (s)) == 0))
#endif 	/* OPTIMIZED_POINTER_TESTS */

#endif 	/* USE_LARGE */

#ifdef	USE_STMS
#define consistent_ms_pointer(c,p)	ismarked((c),(p)-1)
#endif	/* USE_STMS */

/* for importer here the defs of our arrays. don't want to deal with them
 * during garbage_collections, so enabling to skip them easily. B/W again...
 */

struct _gcarrays {
	card           *S_Cards[HIGHEST_CARDDSCR + 1];
	long           *S_Freepts[HIGHEST_CARDDSCR + 1];
	TypeDscr        S_Types[HIGHEST_CARDDSCR + 1];
	long            S_Sizes[HIGHEST_CARDDSCR + 1];

	unsigned long	S_UTypes[HIGHEST_TYPEDSCR + 1];
	void            (*S_MkFcns[HIGHEST_TYPEDSCR + 1]) ();

	card           *S_usedcards[MAX_NUM_OF_CARDS];
} gcarrays;

#define Cards		gcarrays.S_Cards
#define Freepts		gcarrays.S_Freepts
#define Types		gcarrays.S_Types
#define Sizes		gcarrays.S_Sizes
#define UTypes		gcarrays.S_UTypes
#define	MkFcns		gcarrays.S_MkFcns
#define usedcards	gcarrays.S_usedcards

#define	gcarraybegin	(long *)(&gcarrays)
#define	gcarrayend	(long *)((char *)(&gcarrays) + sizeof(gcarrays))

card	      **used_cards_end;

CardDscr	last_used_card;
TypeDscr	last_used_type;

#define is_tdscr(td)	(((td)>0) && ((td)<last_used_type))
#define is_cdscr(cd)	(((cd)>=0) && ((cd)<last_used_card))

/* some macros to handle information hold in these arrays */

#define	get_free_object(cd)	(Freepts[cd])
#define	get_freept_addr(cd)	(&Freepts[cd])
#define	get_type_d(cd)		(Types[cd])	
#define	get_size_d(cd)		(Sizes[cd])
#define	get_card_d(cd)		(Cards[cd])

#define	ms_card_d(cd)		(! get_size_d(cd))
#define mt_card_d(cd)		(! get_type_d(cd))

#define	store_free_object(cd,o)	Freepts[cd] = (o)
#define	store_type_d(cd,t)	Types[cd] = (t)
#define	store_size_d(cd,s)	Sizes[cd] = (s)
#define	store_card_d(cd,c)	Cards[cd] = (c)

#define	store_mark_fcn(td,f)	(MkFcns[td] = f)
#define	store_user_type(td, t)	(UTypes[td] = t)

#define	get_mark_fcn(td)	(MkFcns[td])
#define	get_user_type(td)	(UTypes[td])

#define	first_card_index	usedcards
#define last_card_index		used_cards_end
#define next_card_index(c)	++c
#define	prev_card_index(c)	--c

/* Macros to do some jobs needed in different functions */

#define	register_card(c)	(c)->root = last_card_index, \
				*last_card_index = (c), \
				next_card_index(last_card_index)

#define	DEFAULT_MASK	-1
#define	set_default_mask(c)	((c)->mask = DEFAULT_MASK)

#ifdef OPTIMIZED_POINTER_TESTS
#define set_mask(c)	    \
{  switch(get_size(c))      \
     { case 1:              \
	 c->mask = 0x3;     \
	 break;             \
       case 2:              \
	 c->mask = 0x7;     \
	 break;             \
       case 4:              \
	 c->mask = 0xf;     \
	 break;             \
       case 8:              \
	 c->mask = 0x1f;    \
	 break;             \
       default:             \
	 set_default_mask(c);}     \
}
#else
#define set_mask(c)	set_default_mask(c)
#endif

#ifdef	USE_STMS
/* variable spaces contain pointer to next space and their own length.
 * variable objects of size 1 are not allowed */
typedef	struct _vobject {
		struct _vobject *vnext;
		long		vlength;
		} vobject;

#endif

/* ------------------ vars and prototypes from heap-module ----------------- */

long	*HEAPBEGIN, *HEAPEND;
long	hincr, curnumcard;
#ifdef KRC
/*Version for Kenighan Ritchie */
long	inc_heap_size();
#else
/* ANSI C */
long	inc_heap_size(int noc);
#endif
#define	inc_heap()	inc_heap_size(hincr)

void	initialize_heap();

long	*new_card();
long	*new_large_card();

void	reclaim_card();

/* --- a function that is defined in xalloc.c and used in card.c as well --- */

long * build_free_list();
long stacktop;


/* --- support for __hp9000s700 requires a macro to be called in main --- */

#ifdef __hp9000s700
#define INITIALIZE_GC	{int i; stacktop = (long) &i;}
#else
	/* in any other case comment it out */
#define INITIALIZE_GC	/* */
#endif

#endif	/* ! xalloc_misc_h */



