;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: WHC-DEFINITIONS -*-
#|
-----------------------------------------------------------------------------------
TITLE: module for the definition of tail data types
-----------------------------------------------------------------------------------
File:    whc-definitions.em
Version: 1.25 (last modification on Tue Oct 12 14:11:46 1993)
State:   proposed

DESCRIPTION:
the definition functions for tail data types

DOCUMENTATION:
see in the APPLY-paper TAIL:eine getypte implementationssprache fuer APPLY

NOTES:
the new types %pointer-to-struct, %pointer-to-vector, ???
are are not contained

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
w. heicking, e.u.kriegel

CONTACT: 
e.u.kriegel

HISTORY: 
Log for /tmp_mnt/home/saturn/akind/Lisp/Apply/whc-definitions.em[1.0]
	Tue Mar 16 09:45:42 1993 wheick@isst save $
 
whc-definitions.em[1.1] Tue Mar 23 10:54:22 1993 wheick@isst save $
 new for ingos initialize
 
whc-definitions.em[1.2] Tue Mar 23 12:48:38 1993 wheick@isst save $
 
whc-definitions.em[1.3] Tue Mar 23 13:16:39 1993 wheick@isst save $
 
whc-definitions.em[1.4] Mon Mar 29 17:19:11 1993 wheick@isst save $
 
whc-definitions.em[1.5] Thu Apr  1 08:14:19 1993 wheick@isst save $
 
whc-definitions.em[1.6] Fri Apr  2 13:35:28 1993 wheick@isst proposed $
 
whc-definitions.em[1.7] Mon Apr  5 08:32:36 1993 wheick@isst proposed $
 with new mm-type
 
whc-definitions.em[1.8] Mon Apr  5 11:23:20 1993 wheick@isst proposed $
 
whc-definitions.em[1.9] Mon Apr  5 11:28:10 1993 wheick@isst proposed $
 + import of warn from CL
 
whc-definitions.em[1.10] Wed Apr  7 15:34:52 1993 wheick@isst save $
 add method for generate-intern-name from whc-gen-code
 
whc-definitions.em[1.11] Thu Apr  8 10:36:09 1993 wheick@isst save $
 
whc-definitions.em[1.12] Tue Apr 13 16:38:37 1993 wheick@isst save $
 [Thu Apr  8 15:18:09 1993] Intention for change:
  remove all wrong characters for label
 
whc-definitions.em[1.13] Tue Apr 13 16:46:06 1993 imohr@isst proposed $
 [Tue Apr 13 16:41:24 1993] Intention for change:
 error in compute-representation
 removed
 
whc-definitions.em[1.14] Mon Apr 19 12:58:17 1993 wheick@isst proposed $
 new function function-direct for representation direct
 
whc-definitions.em[1.15] Tue Apr 20 14:23:33 1993 wheick@isst save $
 error in type-direct removed
 
whc-definitions.em[1.16] Tue Apr 20 14:45:29 1993 wheick@isst save $
 
whc-definitions.em[1.17] Tue Apr 20 16:09:16 1993 wheick@isst proposed $
 
whc-definitions.em[1.18] Wed Apr 28 09:09:14 1993 wheick@isst save $
 new intern labels
 
whc-definitions.em[1.19] Thu Apr 29 09:08:16 1993 wheick@isst save $
 new methods for generate-intern-name
 
whc-definitions.em[1.20] Fri Apr 30 16:00:50 1993 wheick@isst save $
 
whc-definitions.em[1.21] Tue May  4 09:21:55 1993 wheick@isst proposed $
 
whc-definitions.em[1.22] Wed May  5 13:45:08 1993 wheick@isst proposed $
 
whc-definitions.em[1.23] Wed May 12 16:34:52 1993 wheick@isst published $
 
whc-definitions.em[1.24] Tue Oct 12 13:05:56 1993 ukriegel@isst save $
 [Mon Oct 11 10:43:14 1993] Intention for change:
 .length* for <pointer-to-vector>
 cleaned
 
whc-definitions.em[1.25] Tue Oct 12 15:36:13 1993 ukriegel@isst proposed $
 [Tue Oct 12 13:19:11 1993] Intention for change:
 typing error
 

-----------------------------------------------------------------------------------
|#
;;;begin module whc-definitions

#module-name whc-definitions


#module-import
(accessors
 level-1-eulisp
 LZS
 MZS
 mm-initialize
 lzs-mop
;;only to test data types take:
;;tail-types
 machine-description; for the whole machine-description
 debugging
 (only (
        assoc
        case
        cadr
        cerror
        mapcan
        dolist
        make-instance
        dotimes
        ;elt
        reverse
        setf
        ;typecase
        ;gentemp
        ;mapcan
        warn
        format
                ) common-lisp)
)

#module-syntax-import

(level-1-eulisp apply-standard debugging)


#module-syntax-definitions

;--- defmacro forms

#module-header-end

;--- exports

; (export )
(export 

;  set-representation
;  generate-intern-name
;  generate-reference-name
  type-pointer-to-struct 
  type-pointer-to-vector 
  type-pointer-to-void 
;  type-pointer 
;  type-vector
;  type-struct 
;  type-union 
;  type-prestruct
  type-direct

;;;the table to hold the reference between names and instances
;;;for types, variables, constants and for rainer
;;;table-of-class-instances

  %pointer
  %pointer-to-struct
  %pointer-to-vector
; %function
; %vector
; %struct
; %union
; %prestruct
; extern
; local
; global
; %string
  )




;;;%define-type like TAIL
;;;similar to the basic data types a new class for each data type is
;;;created. The one and only instance of this class is holded in
;;;the table table-of-class-instances




;-------------------------------------------------------------
;!!!!!
;
(defmethod ~compute-representation ((class-object <class-def>)
                                    representation-spec
                                    allocation-spec
                                    mm-type)
;  ; representation-spec (symbol) = %pointer-to-struct | %pointer-to-void ...
;  ; if representation-spec is () then take the value from the superclass
  (let (representation-object)
    (setq representation-object 
          (if representation-spec
            (funcall (case representation-spec
                       (es::pointer-to-struct #'type-pointer-to-struct) 
                       (es::pointer-to-vector #'type-pointer-to-vector)
                       (es::pointer-to-void #'type-pointer-to-void) 
                       (es::direct #'type-direct) 
                       (t (lambda ignore 
                            (warn "unknown representation: ~S " representation-spec))))
                     class-object allocation-spec mm-type)
            (~class-representation (cadr (~class-precedence-list class-object)))))
    
    (mm-initialize class-object 
                   representation-object allocation-spec mm-type)
    representation-object))


(defun type-pointer-to-struct (class-obj allocation mm-type)
  (let* ((slot-descr-list (~class-slot-descriptions class-obj))
        (first-type (?type (car slot-descr-list)))
        (byte-length 0)
        slot-and-type-names
        offsets)

;take the following to sort the slot list with decremt alignment
;    (setq type-descr (list-with-desc-alignment type-descr))

    (dolist (slot-descr slot-descr-list)
      ;compute offsets as a-list ((slot1 . offset1) (slot2 . offset2)...)
      (when (assoc (~slot-description-name slot-descr) offsets)
        (cerror "" " multiple usage of slot names: ~S " 
                (~slot-description-name slot-descr)))
      (setq offsets (cons 
                     (cons 
                      (~slot-description-name slot-descr) byte-length) 
                     offsets))
      ;compute byte-length, the whole size of the type
      (setq byte-length 
            (compute-byte-length byte-length 
                                 (?representation (?type slot-descr))))
      (setq slot-and-type-names 
            (cons (list (~slot-description-name slot-descr)
                        (?type slot-descr)) 
                  slot-and-type-names))
      )
    (setq slot-and-type-names (reverse slot-and-type-names))
    (make-instance
      <%pointer-to-struct>
      :slot-and-type-names slot-and-type-names
      :offset offsets
      :byte-length byte-length
      :allocation allocation 
      :mm-type mm-type
      :class class-obj
      ) 
    ))



(defun type-pointer-to-void (class-obj allocation mm-type) 
;      ------------ 
  (make-instance
            <%pointer-to-void>
    :allocation allocation
    :mm-type mm-type
    :class class-obj
    )
  )

(defun type-direct (class-obj allocation mm-type) 
;      ------------
  (let ((type (?type (car (~class-slot-descriptions class-obj))))) 
    (make-instance
      <%direct>
      :allocation allocation
      :type type
      :byte-length (?byte-length (?representation type))
      :mm-type mm-type
      :class class-obj
      )
    ))


(defun type-pointer-to-vector (class-obj allocation mm-type)
  (let* ((type (~vector-class-element-type class-obj))
         (length-slot (~vector-class-instance-length class-obj))
         (length  (if length-slot
                    (car (?value-list length-slot))
		    ())))
    (make-instance
      <%pointer-to-vector>
      :byte-length (compute-byte-length* length (?representation type))
      :type type
      :length-of-vector length
      :class class-obj
      )))


(defgeneric compute-byte-length* (length representation))


(defmethod compute-byte-length* (length (representation <%pointer>))
  (* length (?byte-length (?representation %unsigned-word-integer))))

(defmethod compute-byte-length* (length (representation <%pointer-to-vector>))
  (* (car (?value-list length)) (?byte-length (?representation %unsigned-word-integer))))

(defmethod compute-byte-length* (length (representation <%machine-type>))
  (* length (?byte-length representation)))



(defmethod compute-byte-length* ((length <null>) representation)
  nil)



;(defun remove-characters-for-label (str)
;    (dotimes (i (length str))
;      (when (char-test (elt str i))
;        (setf (elt str i) #\_))
;      )
;    str)
;
;(defun char-test (char)
;  (member char '(#\< #\> #\- #\% #\+ #\*  #\/ #\| #\&)))


;
;;??module-name
;;      ####################
;(defmethod generate-intern-name ((var-inst <global-static>))
;  ;      ####################
;  (let (
;        ;(module-name (?module-id var-inst))
;        (ident (?identifier var-inst)))
;    (remove-characters-for-label 
;     (string-append "_" 
;                    (string-append (symbol-name ident)
;                                   (string-append "_"
;                                                  (symbol-name (gensym)))))) 
;    ))
;
;
;  ;        ####################
;(defmethod generate-intern-name ((fun <slot-accessor-fun>))
;  ;        ####################
;  (let ((ident (?identifier fun))
;        (slot-name "slot")
;;        (slot-name (?identifier (?slot fun)))
;        (class-name "class")
;;        (class-name (?identifier (?slot-of (?slot fun))))
;        )
;    (remove-characters-for-label
;     (format nil "_~:[A_~A_~A~;~:*~A~2*~]_~A" 
;             ident slot-name class-name (gensym))
;     ) 
;    ))
;
;  ;        ####################
;(defmethod generate-intern-name ((fun <slot-init-fun>))
;  ;        ####################
;  (let ((ident (?identifier fun))
;        (slot-name "slot")
;;        (slot-name (?identifier (?slot fun)))
;        (class-name "class")
;;        (class-name (?identifier (?slot-of (?slot fun))))
;        )
;    (remove-characters-for-label
;     (format nil "_~:[I_~A_~A~;~:*~A~2*~]_~A" 
;             ident slot-name class-name (gensym))
;     ) 
;    ))
;
;  ;        ####################
;(defmethod generate-intern-name ((fun <constructor-fun>))
;  ;        ####################
;  (let ((ident (?identifier fun))
;        (class-name "class")
;;        (class-name (?identifier (?constructor-for fun)))
;        )
;    (remove-characters-for-label
;     (format nil "_~:[C_~A~;~:*~A~*~]_~A" 
;             ident class-name (gensym))
;     ) 
;    ))
;
;
;;          ####################
;(defmethod generate-intern-name ((fun <fun>))
;  ;        ####################
;  (let (
;        ;(module-name (?module-id fun))
;        (ident (?identifier fun)))
;    (remove-characters-for-label 
;     (string-append "_" 
;                    (string-append (symbol-name ident)
;                                   (string-append "_"
;                                                  (symbol-name (gensym)))))) 
;    ))
;
;;          ####################
;(defmethod generate-intern-name ((var-inst <defined-class>))
;  ;        ####################
;  (let (
;        ;(module-name (gensym))
;         ;(?module-id var-inst))
;        (ident (?identifier var-inst)))
;    (remove-characters-for-label 
;     (string-append "_" 
;                    (string-append (symbol-name ident)
;                                   (string-append "_"
;                                                  (symbol-name (gensym)))))) 
;    ))
;
;
;;         ####################
;(defmethod generate-intern-name ((var-inst <defined-named-const>))
;  ;         ####################
;  (let (
;        ;(module-name (?module-id var-inst))
;        (ident (?identifier var-inst)))
;    (remove-characters-for-label
;     (string-append "_" 
;                    (string-append (symbol-name ident)
;                                   (string-append "_"
;                                                  (symbol-name (gensym)))))) 
;    ))
;
;
; ;        ####################
;(defmethod generate-intern-name ((literal <literal-instance>))
;  ;      ####################
;  (let (
;        ;(module-name (?module-id literal))
;        (ident (?identifier literal)))
;    (remove-characters-for-label
;     (string-append "_" 
;                    (string-append (symbol-name ident)
;                                   (string-append "_"
;                                                  (symbol-name (gensym)))))) 
;    ))
;
;
;
;;           ####################
;(defmethod generate-intern-name ((literal <null>))
;;          ####################
;  (let (
;        ;(module-name (?module-id literal))
;        (ident "nil"))
;    (warn "generate-intern-name from nil!! ")
;    (remove-characters-for-label
;     (string-append "_" 
;                    (string-append (symbol-name ident)
;                                   (string-append "_"
;                                                  (symbol-name (gensym)))))) 
;    ))
;
;
;
;
;;           ####################
;(defmethod generate-intern-name (literal)
;;          ####################
;  (let (
;        ;(module-name (?module-id literal))
;        (ident (?identifier literal)))
;    (remove-characters-for-label
;     (string-append "_" 
;                    (string-append (symbol-name ident)
;                                   (string-append "_"
;                                                  (symbol-name (gensym)))))) 
;    ))
;
;
;;       ######################
;(defun generate-reference-name (var-inst)
;;      #######################
;  (let ((module-name (?module-id var-inst))
;        (ident (gentemp)))
;    (string-append "_" 
;                   (string-append (symbol-name module-name)
;                                 (string-append "_"
;                                                 (symbol-name ident)))) 
;    ));



(defmethod compute-byte-length (bytes (representation <%pointer>))
  (+ bytes (?byte-length (?representation %unsigned-word-integer))))

(defmethod compute-byte-length (bytes representation)
  (+ bytes (?byte-length representation)))




;;      -------
;(defun scope-p (scope)
;;      -------
;  (case scope 
;    (extern 'extern)
;    (local 'local)
;    (global 'global)
;    (t (cerror "" " ~S ist kein zugelassener scope " scope))))



#module-end
;;;eof  whc-definitions.lisp