;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: whc-basic-data-types -*-
#|
-----------------------------------------------------------------------------------
TITLE: macros and aux functions to read in the basic data types
-----------------------------------------------------------------------------------
File:    whc-basic-data-types.em
Version: 1.8 (last modification on Fri Apr  2 13:50:45 1993)
State:   save

DESCRIPTION:
macros and aux functions to read in the basic data types

DOCUMENTATION:
see in the APPLY-paper TAIL:eine getypte implementationssprache fuer APPLY

NOTES:
here with define-tail for the aux-data-types too

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
w. heicking

CONTACT: 
w. heicking

HISTORY: 

-----------------------------------------------------------------------------------
|#
;;; begin  whc-basic-data-types.em
;;; -----------------------------------------------------------------------------------
;;; functions for Building up the machine data types and basic data types
;;; 


;first the machine data types of the machine, 
;define-machine-data-types reads in the list of machine data types 
;(from the machine-file) 
;and set these to the Constant machine-dates


#module-name whc-basic-data-types


#module-import
(accessors
 lzs
 level-1-eulisp
 (only (<tail-class-def>) lzs-mop)
 (only (dolist assoc cadr make-instance mapcan intern setf) common-lisp)
 whc-classes
 class-ext
 whc-aux)

#module-syntax-import 
(level-1-eulisp 
 apply-standard
 (only (setf) common-lisp)
 el2lzs       ; only define-tail is needed
 class-ext
 )

#module-syntax-definitions

#module-header-end

(expose class-ext)

(export 
  <basic-class-def>
  <%integer>
  <%signed>
  <%unsigned>
  <%float>
;  <%prestruct>
;  <%struct>
;  <%vector>
;  <%union>
  <%pointer>
  <%pointer-to-struct>
  <%pointer-to-vector>
  <%pointer-to-void>
  <%aux-type>
  <%representation>
  <%machine-type>
  <%direct>
  <%STRING-ASCIZ>
  <address-expr>

  table-of-class-instances  ;;our table

;  type-instance-put
;  type-instance-put-with-test
;  type-instance-get
;  type-instance-rem
;  give-data-type
;  give-basic-data-type
;  give-pointer-data-type
;  give-prestruct-data-type
;  give-union-data-type
;  give-variable
;  give-constant
;  give-variable-or-constant
;  data-type-p
;  data-float-p
;  data-integer-p

  )

(export-syntax 
  define-machine-data-types 
  define-basic-data-types ;data types with export
  define-aux-data-types   ;data types whithout export
  define-tail-sys-functions ;tail functions with export
  define-tail-aux-sys-functions;tail aux functions without export
)



;define-machine-data-types like in TAIL


;(defmacro define-machine-data-types  lists
;  `(define-machine-data-types1 ',lists))
;
;(defun define-machine-data-types1 (lists)
;  (defconstant machine-dates lists))

;;try to take a class for machine-data-types
(defmacro define-machine-data-types  machine-datas 
  (let (classes)
    (setq classes 
          (mapcan (lambda (li)
                    (list
                     `(setq ,(car li) 
                        (make-instance <%machine-type>
                        
                        ;:bit-length ,(cadr (cl:member :bit-length li)) 
                                      
                        :byte-length ,(cadr (cl:member :byte-length li))
                                       
                        ;:alignment ,(cadr (cl:member :alignment li))
                                     
                        :var-code ,(cadr (cl:member :var-code li)) 
                                     
                        ))))
                  machine-datas))
    `(progn ,@classes)))


;the list of these machine data types is used by the definition of 
;basic data types 
;the basic data types are in the machine-file also
 

     
;define-basic-data-types takes the predifined basic-data-types from
;the machine file, generates for each data type a class (there are the
;classes %unsigned-word-integer) and makes for this class one
;instance. This instance is set to value of the class name (the value
;%unsigned-word-integer is a instance of the class %unsigned-word-integer)  

;define-basic-data-types like in TAIL


;;;read-in the tail functions like %ref... 
;;;in define-tail with export export (like the real data types)

(defun make-instance-symbol (sym) 
  (intern (string-append "$" (symbol-name sym))))

(defmacro define-tail-sys-functions funs
  (let (progbody)
    (dolist (fun funs)
;;entry in our table?? I dont think so!!
;      (setq progbody 
;            (cons `(type-instance-put-with-test ',fun ,fun)
;                  progbody))
      (setq progbody 
                  (cons
                   `(define-tail ,fun 
                      export; wh 
                      (special-sys-fun)
                      :protocol-type nil; wh
                      :arg-num nil; wh
                      :match-list nil; wh
                      :inline nil; wh
                      )
                   progbody))
      )
     `(progn ,@progbody)))


(defmacro define-tail-aux-sys-functions funs
  (let (progbody)
    (dolist (fun funs)
;;entry in our table?? I dont think so!!
;      (setq progbody 
;            (cons `(type-instance-put-with-test ',fun ,fun)
;                  progbody))
      (setq progbody 
                  (cons
                   `(define-tail ,fun 
                      nil; wh 
                      (special-sys-fun)
                      :protocol-type nil; wh
                      :arg-num nil; wh
                      :match-list nil; wh
                      :inline nil; wh
                      )
                   progbody))
      )
     `(progn ,@progbody)))


(defmacro define-basic-data-types  basic-data-types 
  (let (classes)
    (setq classes 
          (mapcan (lambda (li)
                    (list
                     `(define-tail ,(car li) 
                        export ,(cadr (cl:member :supers li))
                        
;                        :integer ,(cadr (cl:member :integer li))
;                        :signed ,(cadr (cl:member :signed li))
                        
;                        :var-code ',(cadr (cl:member :var-code li))
;                        :allocation ()
;                        :mm-type 1
                        :representation ,(cadr (cl:member :machine li))
                        )
                     `(type-instance-put-with-test ',(car li) ,(car li))
                     )) 
                  basic-data-types))
    `(progn ,@classes)))


(defmacro define-aux-pointer-data-types  basic-data-types 
  (let (classes)
    (dolist (li basic-data-types)
      (setq classes 
            (cons
;             `(define-tail ,(car li) nil (%pointer %unsigned-word-integer)
             `(define-singleton-apply-class ,(car li) (%pointer %unsigned-word-integer)
                :byte-length 4
;                :alignment 4
                :type ',(cadr (cadr li))
;                :allocation ()
;                :mm-type 1
                :representation 
                ,(make-instance <%machine-type>
;                   :bit-length 32
                   :byte-length 4
;                   :alignment 4

;;;if it is not possible to bootstrap, take the following
;;;                        :bit-length 32 
;;;                        :byte-length 4 
;;;                        :alignment 4 
;;;                        :var-code "~%      .word ~D"
                        )
                
                )
             classes))
      )
    `(progn ,@classes))))


(defmacro define-aux-data-types  basic-data-types 
  (let (classes)
    (setq classes 
          (mapcan (lambda (li)
                    (list
                     `(
;                       define-tail
                       define-singleton-apply-class 
                        ,(car li) 
;                        nil;remove if define-singleton-apply-class is used 
                        (%aux-type)
                        
;                        :bit-length ,(give-type-size 
;                                      basic-data-types (car li) :bit-length)
;                        :byte-length ,(give-type-size 
;                                       basic-data-types (car li) :byte-length) 
;                        :alignment ,(give-type-size 
;                                     basic-data-types (car li) :alignment)
;                        :integer ,(give-type-descr 
;                                   basic-data-types (car li) :integer)
;                        :signed ,(give-type-descr 
;                                  basic-data-types (car li) :signed)
;                        :const-code ',(give-type-descr 
;                                       basic-data-types (car li) :const-code)

                        :var-code ,(cadr (cl:member :var-code li))
                        )
                     `(type-instance-put-with-test ',(car li) ,(car li))
                     )) 
                  basic-data-types))
    `(progn ,@classes)))

;-------------------------------------------------
;aux functions for define-basic-data-types

;;; fuer Schluesselwoerter auf Ebene der machine-dates
;;; also fuer 
;;; basic-type = basic-data-type
;;; what = :bit-length, :byte-length, :alignment
 
;(defun give-type-size (basic-data-types basic-type what)
;  (cadr
;   (cl:member what 
;           (assoc (cadr 
;                   (cl:member :machine 
;                           (assoc basic-type basic-data-types))) 
;                  machine-dates))))

;;; fuer Schluesselwoerter auf der Eben der basic-data-types
;;; also fuer 
;;; key = :integer, :signed, :machine (wenn noetig), :const-code, 
;;;       :var-code
;;; basic-type = basic-data-type
;(defun give-type-descr (basic-data-types basic-type key)
;  (cadr (cl:member key (assoc basic-type basic-data-types))))


;-----------------------------------------------------

#module-end

;;; eof machine data types and basic data types