;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-write -*-
#|
-------------------------------------------------------------------------------
TITLE: Formatting Type Inference Objects
-------------------------------------------------------------------------------
File:    ti-write.em
Version: 1.17 (last modification on Thu Sep 30 15:06:12 1993)
State:   save

DESCRIPTION:
This modules provides generic functions to write and print all kinds
of objects that are concerned during the type inference process.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /tmp_mnt/home/saturn/akind/Lisp/ti-write.em[1.0]
	Tue Apr  6 13:23:28 1993 akind@isst proposed $
 
ti-write.em[1.1] Tue Apr 13 14:33:47 1993 akind@isst proposed $
 
ti-write.em[1.2] Tue Apr 13 18:39:22 1993 akind@isst proposed $
 
ti-write.em[1.3] Wed Apr 14 11:46:29 1993 akind@isst proposed $
 
ti-write.em[1.4] Mon Apr 19 18:05:10 1993 akind@isst proposed $
 
ti-write.em[1.5] Wed Apr 21 16:35:21 1993 akind@isst proposed $
 
ti-write.em[1.6] Fri May  7 21:22:52 1993 akind@isst proposed $
 
ti-write.em[1.7] Tue May 25 17:28:06 1993 akind@isst proposed $
 
ti-write.em[1.8] Thu May 27 10:12:12 1993 akind@isst proposed $
 
ti-write.em[1.9] Wed Jun  2 17:11:45 1993 akind@isst proposed $
 
ti-write.em[1.10] Tue Jul  6 16:14:54 1993 akind@isst proposed $
 
ti-write.em[1.11] Tue Jul  6 16:48:51 1993 akind@isst proposed $
 
ti-write.em[1.12] Tue Aug  3 11:47:25 1993 akind@isst proposed $
 
ti-write.em[1.13] Tue Aug 24 16:26:13 1993 akind@isst proposed $
 
ti-write.em[1.14] Wed Aug 25 17:39:20 1993 akind@isst published $
 
ti-write.em[1.15] Tue Sep 14 12:40:58 1993 akind@isst save $
 
ti-write.em[1.16] Thu Sep 23 14:33:59 1993 akind@isst proposed $
 [Tue Sep 14 15:16:49 1993] Intention for change:
 
ti-write.em[1.17] Fri Oct  1 14:41:55 1993 akind@isst save $
 [Thu Sep 23 15:44:59 1993] Intention for change:
 

-------------------------------------------------------------------------------
|#

#module-name ti-write
#module-import (ti ti-lattice ti-exprs ti-meet-join ti-eqs mzs lzs
		   (only (name-of funtype-of) name-of-fun)
		   (only (<binding>) el2lzs)
		   (only (stream make-string-output-stream
				 get-output-stream-string maphash format)
			 common-lisp))
#module-syntax-import (ti ti-exprs)
#module-syntax-definitions
#module-header-end

;;; ---------------------------------------------------------------------------
;;; EXPORT
;;; ---------------------------------------------------------------------------

(EXPORT ti-write-list
	ti-write-vector
	ti-def-write-list
	ti-def-write-vector
	ti-write
	ti-print-string
	ti-print-string-no-cr
	ti-print
	ti-def-write
	ti-def-print-string
	ti-def-print
	ti-print-fun
	ti-short-write-string)

;;; ---------------------------------------------------------------------------
;;; WRITING LISTS AND VECTORS
;;; ---------------------------------------------------------------------------

(DEFUN ti-write-list (stream list)
  (cond (list
	 (ti-write stream (car list))
	 (cond ((> (length list) 1)
		(format stream " ")
		(ti-write-list stream (cdr list)))))))
		  

(DEFUN ti-write-eqs (stream list)
  (cond (list
	 (ti-write-eq stream (car list))
	 (cond ((> (length list) 1)
		(format stream "~%          ")
		(ti-write-eqs stream (cdr list)))))))
      
(DEFUN ti-write-vector (stream vec index)
  (cond ((> (length vec) index)
	 (ti-write stream (vector-ref vec index))
	 (cond ((> (length vec) 1)
		(format stream " ")
		(ti-write-vector stream vec (+ 1 index)))))))

(DEFUN ti-def-write-list (stream list)
  (cond (list
	 (ti-def-write stream (car list))
	 (cond ((> (length list) 1)
		(format stream " ")
		(ti-def-write-list stream (cdr list)))))))

(DEFUN ti-def-write-eqs (stream list)
  (cond (list
	 (ti-def-write-eq stream (car list))
	 (cond ((> (length list) 1)
		(format stream "~%    ")
		(ti-def-write-eqs stream (cdr list)))))))
      
(DEFUN ti-def-write-vector (stream vec index)
  (cond ((> (length vec) index)
	 (ti-def-write stream (vector-ref vec index))
	 (cond ((> (length vec) 1)
		(format stream " ")
		(ti-def-write-vector stream vec (+ 1 index)))))))

;;; ---------------------------------------------------------------------------
;;; PRINT STRINGS AND PRINTING FOR ANY KIND OF OBJECTS
;;; ---------------------------------------------------------------------------

(DEFUN ti-print (obj)
  (ti-format t "~%~A" (ti-print-string obj)))

(DEFUN ti-print-string (obj)
  (let ((stream (make-string-output-stream)))
    (format stream "~%")
    (ti-write stream obj)
    (get-output-stream-string stream)))

(DEFUN ti-print-string-no-cr (obj)
  (let ((stream (make-string-output-stream)))
    (ti-write stream obj)
    (get-output-stream-string stream)))

;;; ---------------------------------------------------------------------------
;;; DEFINITION PRINT STRINGS AND DEFINITION PRINTING FOR ANY KIND OF OBJECTS
;;; ---------------------------------------------------------------------------

(DEFUN ti-def-print (obj)
  (format t "~%~A" (ti-def-print-string obj)))

(DEFUN ti-def-print-string (obj)
  (let ((stream (make-string-output-stream)))
    (format stream "~%")
    (ti-def-write stream obj)
    (get-output-stream-string stream)))

;;; ---------------------------------------------------------------------------
;;; Write a definition string to given character stream.
(DEFGENERIC ti-def-write (stream expr))

;;; ---------------------------------------------------------------------------
;;; WRITE A PRETTY PRINT STRING TO GIVEN CHARACTER STREAM
;;; ---------------------------------------------------------------------------

(DEFGENERIC ti-write (stream expr))

(DEFMETHOD ti-write (stream expr)
  (format stream "~A" expr))

(DEFMETHOD ti-write (stream (expr <symbol>))
  (format stream "~A" expr))

(DEFMETHOD ti-write (stream (expr <pair>))
  (ti-write-list stream expr))

(DEFMETHOD ti-write (stream (expr <vector>))
  (ti-write-vector stream expr 0))

;; Attention: %object is displayed as <object>; %class is displayed as <class>.
(DEFMETHOD ti-write (stream (expr <atomic-type>))
  (let ((name (?name expr)))
    (if (consp name)
	(ti-write-list-enclosed stream (?name expr) t)
      (cond ((and *%object* (%object-type-p expr))
	     (format stream "<OBJECT>"))
	    ((and *%class* (%class-type-p expr))
	     (format stream "<CLASS>"))
	    (t (ti-write stream name))))))

(DEFMETHOD ti-write (stream (expr <type-var>))  
  (let ((id (?id expr)))
    (if (symbolp id)
	(format stream "~A" id)
      (format stream "var~A" (?id expr)))))

(DEFMETHOD ti-write (stream (id <slot-id>))  
  (format stream "(slot ~A)" (?slot-name id)))

;;; ---------------------------------------------------------------------------
;;; WRITE A DEFINITION STRING TO GIVEN CHARACTER STREAM
;;; ---------------------------------------------------------------------------

(DEFMETHOD ti-def-write (stream obj))

(DEFMETHOD ti-def-write (stream (expr <pair>))
  (ti-def-write-list stream expr))

(DEFUN ti-write-list-enclosed (stream list start)
  (if list
      (let ((first (car list)))
	(if start (format stream "("))
	(if (consp first)
	    (ti-write-list-enclosed stream first t)
	  (ti-write stream first))
	(if (cdr list)
	    (format stream " "))
	(ti-write-list-enclosed stream (cdr list) nil))
    (format stream ")")))

(DEFMETHOD ti-def-write (stream (expr <vector>))
  (ti-def-write-vector stream expr 0))

(DEFMETHOD ti-def-write (stream (expr <atomic-type>))
  (format stream "(atom ")
  (let ((name (?name expr)))
    (if (consp name)
	(ti-write-list-enclosed stream (?name expr) t)
      (ti-write stream name)))
  (format stream ")"))

(DEFMETHOD ti-def-write (stream (expr <type-var>))
  (let ((id (?id expr)))
    (if (symbolp id)
	(format stream "(var ~A)" id)
      (format stream "(var var~A)" (?id expr)))))

;;; ---------------------------------------------------------------------------
;;; WRITING TYPE EQUATIONS AND SUBSTITUTIONS
;;; ---------------------------------------------------------------------------

(DEFUN ti-write-eq (stream eq)
  (format stream "(")
  (ti-write stream (?left-expr eq))
  (format stream " = ")
  (ti-write stream (?right-expr eq))
  (format stream ")"))

(DEFUN ti-def-write-eq (stream eq)
  (format stream "(")
  (ti-def-write stream (?left-expr eq))
  (format stream " ")
  (ti-def-write stream (?right-expr eq))
  (format stream ")"))
  
(DEFMETHOD ti-write (stream (eqs <type-equation-stack>))
  (ti-write-eqs stream (?equations eqs)))
  
(DEFMETHOD ti-def-write (stream (eqs <type-equation-stack>))
  (ti-def-write-eqs stream (?equations eqs)))

;;; ---------------------------------------------------------------------------
;;; WRITING TYPE DESCRIPTORS
;;; ---------------------------------------------------------------------------

(DEFMETHOD ti-write (stream (descr <type-descr>))
  (format stream "~%  :descr <")
  (ti-write stream (?type-vec descr))
  (format stream ">~%          ")
  (ti-write stream (?type-vars descr)))

(DEFMETHOD ti-def-write (stream (descr <type-descr>))
  (format stream "~%  ((")
  (ti-write stream (?type-vec descr))
  (format stream ")~%   (")
  (ti-def-write stream (?type-vars descr))
  (format stream "))"))

(DEFMETHOD ti-write (stream (fun <fun>))
  (let ((sig (?signature fun)))
    (cond (sig
	   (format stream "(~A:~A::~A"
		   (funtype-of fun)
		   (?module-id fun)
		   (name-of fun))
	   (ti-write stream sig)
	   (format stream ")"))
	  (t
	   (ti-format t
		      "~%Warning: no type scheme for function ~A"
		      (?identifier fun))))))

(DEFMETHOD ti-def-write (stream (fun <fun>))
  (let ((sig (?signature fun)))
    (cond (sig
	   (format stream "~2%(%annotate-function~% ~A " (?identifier fun))
	   (format stream "new-signature (")
	   (ti-def-write stream sig)
	   (format stream "))"))
	  (t 
	   (format stream "~2%\;\;\;Warning: no type scheme for function ~A"
		   (?identifier fun))))))

(DEFMETHOD ti-def-write (stream (fun <named-const>)))

;;; ---------------------------------------------------------------------------
;;; WRITING LATTICES
;;; ---------------------------------------------------------------------------

(DEFMETHOD ti-write (stream (lattice <lattice>))
  (ti-write-lattice stream (?top lattice) " ")
  (maphash (lambda (key x)
	      (ti-write-lattice-type stream x))
	    (?table lattice)))
   
(DEFMETHOD ti-write (stream (lattice-type <lattice-type>))
  (cond ((and *%object* (eq-lattice-type lattice-type *%object*))
	 (format stream "<OBJECT>"))
	((and *%class* (eq-lattice-type lattice-type *%class*))
	 (format stream "<CLASS>"))
	(t (format stream "~A" (?name lattice-type)))))
   
(DEFUN ti-write-lattice-type (stream lattice-type)
  (let ((class (?class lattice-type)))
    (format stream "~%~%| ~A" (?name lattice-type))
    (format stream "~%| strategic: ~A" (?strategic lattice-type))
    (format stream "~%| compound: ~A" (?compound lattice-type))
    (format stream "~%| write-access-stamp: ~A"
	    (?write-access-stamp lattice-type))
    (format stream "~%| class: ~A" (if class (?identifier class) nil))
    (format stream "~%| supertypes: ")
    (dolist (x (?supertypes lattice-type))
      (format stream "~A " (?name x)))
    (format stream "~%| subtypes: ")
    (dolist (x (?subtypes lattice-type))
      (format stream "~A " (?name x)))))

(DEFUN ti-write-lattice (stream lattice-type indent)
  (cond ((?subtypes lattice-type)
	 (format stream "~%~70B~A~A [~A]"
		 (?code lattice-type)
		 indent
		 (?name lattice-type)
		 (?write-access-stamp lattice-type))
	 (dolist (x (?subtypes lattice-type))
	   (ti-write-lattice stream x (format nil " ~A" indent))))))

(DEFUN ti-print-fun (fun)
  (ti-print fun)
  (dolist (descr (?type-descr-s fun))
    (format t "~%T-DESCR-BEFORE") (ti-print-t-descrs-before descr)))

(DEFUN ti-print-t-descrs-before (descr)
  (cond (descr
	 (ti-print descr)
	 (ti-print-t-descrs-before (?t-descr-before descr)))))


#module-end