;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-signature -*-
#|
-------------------------------------------------------------------------------
TITLE: Handling Type Schemes (Signatures)
-------------------------------------------------------------------------------
File:    ti-signature.em
Version: 1.78 (last modification on Tue Oct 12 10:12:49 1993)
State:   proposed

DESCRIPTION:
Type schemes (signatures) describe the range and domain of a
function. Type schemes are generic, i.e. they may have more than one
line (descriptor). The type schemes contain type expressions (see
ti-exprs.em). Generic type schemes for standard functions are
predefined; for defined functions they are inferred by a modified
unification algorithm (see ti-unify.em).

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /tmp_mnt/home/saturn/wheick/Lisp/Apply/ti-signature.em[1.0]
	Tue Apr  6 13:23:07 1993 akind@isst save $
 
ti-signature.em[1.1] Tue Apr  6 13:31:30 1993 akind@isst save $
 [Tue Apr  6 13:26:52 1993] Intention for change:
 
ti-signature.em[1.2] Wed Apr  7 10:49:46 1993 akind@isst save $
 
ti-signature.em[1.3] Wed Apr  7 11:46:28 1993 akind@isst save $
 
ti-signature.em[1.4] Wed Apr  7 11:56:21 1993 akind@isst proposed $
 
ti-signature.em[1.5] Wed Apr  7 14:06:07 1993 akind@isst proposed $
 
ti-signature.em[1.6] Wed Apr  7 15:11:22 1993 akind@isst proposed $
 
ti-signature.em[1.7] Wed Apr  7 16:12:01 1993 akind@isst save $
 
ti-signature.em[1.8] Wed Apr  7 18:07:39 1993 akind@isst proposed $
 
ti-signature.em[1.9] Thu Apr  8 08:24:00 1993 wheick@isst proposed $
 [Thu Apr  8 08:16:56 1993] Intention for change:
 Error in add-signature
 
ti-signature.em[1.10] Tue Apr 13 14:35:10 1993 akind@isst proposed $
 ,
 
ti-signature.em[1.11] Tue Apr 13 15:22:17 1993 akind@isst proposed $
 
ti-signature.em[1.12] Tue Apr 13 15:25:59 1993 akind@isst proposed $
 
ti-signature.em[1.13] Wed Apr 14 13:30:32 1993 akind@isst proposed $
 
ti-signature.em[1.14] Wed Apr 14 13:55:19 1993 akind@isst proposed $
 
ti-signature.em[1.15] Wed Apr 14 16:43:18 1993 akind@isst proposed $
 
ti-signature.em[1.16] Wed Apr 14 20:11:17 1993 akind@isst proposed $
 
ti-signature.em[1.17] Thu Apr 15 10:00:24 1993 akind@isst proposed $
 
ti-signature.em[1.18] Fri Apr 16 18:18:21 1993 akind@isst proposed $
 
ti-signature.em[1.19] Mon Apr 19 09:21:16 1993 ukriegel@isst proposed $
 [Mon Apr 19 09:11:21 1993] Intention for change:
 
ti-signature.em[1.20] Mon Apr 19 18:04:53 1993 akind@isst proposed $
 
ti-signature.em[1.21] Tue Apr 20 17:37:41 1993 akind@isst proposed $
 
ti-signature.em[1.22] Wed Apr 21 16:39:15 1993 akind@isst save $
 
ti-signature.em[1.23] Fri Apr 23 09:52:47 1993 akind@isst proposed $
 
ti-signature.em[1.24] Thu Apr 29 17:21:56 1993 akind@isst proposed $
 
ti-signature.em[1.25] Wed May  5 11:25:50 1993 akind@isst save $
 
ti-signature.em[1.26] Wed May  5 17:03:03 1993 akind@isst save $
 
ti-signature.em[1.27] Thu May  6 17:27:56 1993 akind@isst proposed $
 
ti-signature.em[1.28] Fri May  7 21:22:40 1993 akind@isst proposed $
 
ti-signature.em[1.29] Wed May 12 14:17:31 1993 ukriegel@isst save $
 [Mon May 10 15:34:19 1993] Intention for change:
 slot-name
 done
 
ti-signature.em[1.30] Wed May 12 16:11:40 1993 imohr@isst proposed $
 [Wed May 12 14:31:06 1993] Intention for change:
 error in unify-descr&descr
 ok
 
ti-signature.em[1.31] Tue May 18 12:02:45 1993 akind@isst save $
 
ti-signature.em[1.32] Tue May 18 13:20:59 1993 akind@isst save $
 
ti-signature.em[1.33] Tue May 18 17:22:02 1993 akind@isst proposed $
 
ti-signature.em[1.34] Wed May 19 12:02:14 1993 akind@isst proposed $
 
ti-signature.em[1.35] Mon May 24 12:08:47 1993 akind@isst proposed $
 
ti-signature.em[1.36] Mon May 24 14:25:58 1993 akind@isst proposed $
 
ti-signature.em[1.37] Mon May 24 15:31:23 1993 akind@isst proposed $
 
ti-signature.em[1.38] Tue May 25 11:08:27 1993 akind@isst proposed $
 
ti-signature.em[1.39] Tue May 25 17:27:50 1993 akind@isst proposed $
 
ti-signature.em[1.40] Wed May 26 10:09:30 1993 akind@isst proposed $
 
ti-signature.em[1.41] Wed May 26 11:55:08 1993 akind@isst proposed $
 
ti-signature.em[1.42] Fri May 28 14:26:07 1993 akind@isst proposed $
 
ti-signature.em[1.43] Fri May 28 16:31:10 1993 akind@isst proposed $
 
ti-signature.em[1.44] Tue Jun  1 09:56:17 1993 ukriegel@isst proposed $
 class-as-type-expr fo null
 
ti-signature.em[1.45] Tue Jun  1 17:45:48 1993 akind@isst proposed $
 
ti-signature.em[1.46] Wed Jun  2 17:11:33 1993 akind@isst proposed $
 
ti-signature.em[1.47] Thu Jun  3 16:01:15 1993 akind@isst proposed $
 
ti-signature.em[1.48] Wed Jun 30 14:00:42 1993 akind@isst save $
 
ti-signature.em[1.49] Wed Jun 30 14:38:09 1993 akind@isst save $
 
ti-signature.em[1.50] Tue Jul  6 16:13:59 1993 akind@isst proposed $
 
ti-signature.em[1.51] Tue Jul  6 16:14:45 1993 akind@isst proposed $
 
ti-signature.em[1.52] Tue Jul 20 15:44:31 1993 akind@isst proposed $
 
ti-signature.em[1.53] Tue Jul 20 16:15:39 1993 akind@isst proposed $
 
ti-signature.em[1.54] Thu Jul 22 13:44:02 1993 akind@isst proposed $
 
ti-signature.em[1.55] Mon Aug  9 16:11:29 1993 akind@isst proposed $
 
ti-signature.em[1.56] Tue Aug 10 10:24:31 1993 akind@isst proposed $
 
ti-signature.em[1.57] Wed Aug 11 13:35:12 1993 akind@isst proposed $
 
ti-signature.em[1.58] Wed Aug 11 13:55:47 1993 akind@isst proposed $
 
ti-signature.em[1.59] Wed Aug 18 16:10:09 1993 akind@isst proposed $
 
ti-signature.em[1.60] Wed Aug 18 16:16:15 1993 akind@isst proposed $
 
ti-signature.em[1.61] Thu Aug 19 10:20:43 1993 akind@isst proposed $
 
ti-signature.em[1.62] Fri Aug 20 14:21:12 1993 akind@isst proposed $
 
ti-signature.em[1.63] Fri Aug 20 17:23:29 1993 akind@isst proposed $
 
ti-signature.em[1.64] Tue Aug 24 09:32:25 1993 akind@isst proposed $
 
ti-signature.em[1.65] Tue Aug 24 16:26:03 1993 akind@isst proposed $
 
ti-signature.em[1.66] Wed Aug 25 17:39:11 1993 akind@isst proposed $
 
ti-signature.em[1.67] Fri Aug 27 17:30:06 1993 akind@isst proposed $
 
ti-signature.em[1.68] Mon Aug 30 09:13:25 1993 akind@isst proposed $
 
ti-signature.em[1.69] Wed Sep  1 10:27:58 1993 hfried@isst proposed $
 [Wed Sep  1 08:42:00 1993] Intention for change:
 arg-num
 
ti-signature.em[1.70] Fri Sep  3 10:27:39 1993 imohr@isst published $
 [Fri Sep  3 09:36:14 1993] Intention for change:
 type specification (%function return-class)
 in convert-to-formal-descrs-%funcall (list formal-descr)
 
ti-signature.em[1.71] Tue Sep 21 09:13:13 1993 akind@isst save $
 [Tue Sep 21 09:06:52 1993] Intention for change:
 
ti-signature.em[1.72] Tue Sep 21 14:45:38 1993 akind@isst proposed $
 [Tue Sep 21 14:43:45 1993] Intention for change:
 
ti-signature.em[1.73] Thu Sep 23 14:33:38 1993 akind@isst proposed $
 
ti-signature.em[1.74] Fri Sep 24 10:04:42 1993 akind@isst proposed $
 
ti-signature.em[1.75] Mon Sep 27 09:23:58 1993 akind@isst proposed $
 
ti-signature.em[1.76] Fri Oct  1 14:42:39 1993 akind@isst save $
 
ti-signature.em[1.77] Mon Oct 11 10:30:44 1993 akind@isst save $
 
ti-signature.em[1.78] Tue Oct 12 10:32:25 1993 akind@isst proposed $
 

-------------------------------------------------------------------------------
|#


#module-name ti-signature
#module-import (lzs lzs-mop mzs lzs-modules tail-module machine-description
		    ti ti-codes  ti-lattice ti-exprs ti-eqs ti-write ti-copy 
		    ti-meet-join ti-unify ti-descrs ti-comp debugging
		    (only (name-of funtype-of) name-of-fun)
		    (only (vector remove-if-not format dotimes) common-lisp))
#module-syntax-import (ti)
#module-syntax-definitions
#module-header-end

;;; ---------------------------------------------------------------------------
;;; EXPORT
;;; ---------------------------------------------------------------------------

(EXPORT new-signature extend-signature renew-signature
	reset-funs-with-defined-signatures funs-with-defined-signatures
	convert-to-sys-type-vec class-as-type-expr type-expr-to-class
	unify-descrs join-descrs join-descrs-min select-methods
	reduce-descr convert-to-atomic-descr
	set-descr-type get-descr-type get-arg-type get-previous-subs
	set-signature set-signature-from-classes
	check-result-subtypes check-subtype-exprs
	set-predicate-signature set-joined-result-types)

;;; ---------------------------------------------------------------------------
;;; READING TYPE SIGNATURES
;;; ---------------------------------------------------------------------------

;; Functions with defined type schemes.
(DEFLOCAL *funs-with-defined-signatures* '())

(DEFUN funs-with-defined-signatures ()
  *funs-with-defined-signatures*)

(DEFUN reset-funs-with-defined-signatures ()
  (ti-format t "~%Reset *funs-with-defined-signatures*.")
  (setq *funs-with-defined-signatures* '()))

(DEFUN new-fun-with-defined-signatures (fun)
  (setq *funs-with-defined-signatures*
    (cons fun *funs-with-defined-signatures*)))

(DEFUN new-signature (fun key descrs-def)
  (if (eq key ^new-signature)		; new signature
      (let ((new-descrs (def-descrs descrs-def)))
	(new-fun-with-defined-signatures fun)
	(if (null *use-compound-types*)
	    (mapc #'convert-all-compound-types new-descrs))
	(setf (?signature fun) new-descrs)
	(ti-format t "~%New type scheme of ~A function ~A::~A."
		   (funtype-of fun)
		   (?module-id fun)
		   (name-of fun)))
    (ti-format t "~%Warning: wrong key to add type scheme ~A" key)))

(DEFUN renew-signature (fun key descrs-def)
  (if (eq key ^renew-signature)		; renew signature
      (if (null *use-compound-types*)
	  (ti-format t "~%Warning: type scheme of ~A function ~A::~A ignored"
		     (funtype-of fun)
		     (?module-id fun)
		     (name-of fun))
	(let ((new-descrs (def-descrs descrs-def)))
	  (new-fun-with-defined-signatures fun)
	  (setf (?signature fun) new-descrs)
	  (ti-format t "~%Renew type scheme of ~A function ~A::~A."
		     (funtype-of fun)
		     (?module-id fun)
		     (name-of fun))))
    (ti-format t "~%Warning: wrong key to add type scheme ~A" key)))

(DEFUN extend-signature (fun key descrs-def)
  (if (eq key ^extend-signature)	; extend signature
      (let ((new-descrs (def-descrs descrs-def))
	    (signature (?signature fun)))
	(if (null signature)
	    (new-fun-with-defined-signatures fun))
	(if (null *use-compound-types*)
	    (mapc #'convert-all-compound-types new-descrs))
	(setf (?signature fun) (append signature new-descrs))
	(ti-format t "~%Extend type scheme of ~A function ~A::~A."
		   (funtype-of fun)
		   (?module-id fun)
		   (name-of fun)))
    (ti-format t "~%Warning: wrong key to extend type scheme ~A" key)))

(DEFUN def-descrs (descrs-def)
  (mapcar #'def-descr descrs-def))

(DEFUN def-descr (descr-def)
  (let ((vec (apply #'vector (mapcar (lambda (id)
				       (make <type-var> :id id))
				     (car descr-def))))
	(subs (mapcar #'eval-to-equation (cdr descr-def))))
    (make <formal-type-descr>
	  :type-vec vec
	  :type-vars (make <type-var-substitutions> :equations subs)
	  :stat nil
	  :t-descr-before nil
	  :type-spec 0)))
 
;;; ---------------------------------------------------------------------------
;;; UNIFICATION OF TYPE DESCRIPTORS
;;; ---------------------------------------------------------------------------

(DEFUN unify-descr&descr (actual-descr formal-descr)
  (let* ((formal-subs (application-subs-check-%void formal-descr actual-descr))
	 (subs (ti-copy-subs (previous-subs actual-descr)))
	 (stack (append-substitutions formal-subs (?type-vars actual-descr))))
    (ti-format2 t "~%-- Start unification ...")
    (ti-format2 t "~%substitutions before ~A" (ti-print-string subs))
    (ti-format2 t "~%stack~A" (ti-print-string stack))
    (cond ((unify (?equations stack) subs)
	   (setf (?type-vars actual-descr) subs)
	   (ti-format2 t "~%substitutions after ~A" (ti-print-string subs))
;	   (set-previous-subs actual-descr)
	   (ti-format2 t "~%-- ... unification succeeded.")
	   actual-descr)
	  (t 
	   (ti-format2 t "~%-- ... unification failed.")
	   nil))))

(DEFUN unify-descr&descrs (actual-descr formal-descrs)
  (let ((result-descrs ()))
    (dolist (descr formal-descrs)
      (let ((new-descr (unify-descr&descr (ti-copy-descr actual-descr) descr)))
	(if new-descr
	    (setq result-descrs (cons new-descr result-descrs)))))
    result-descrs))

(DEFUN unify-descrs&descrs (actual-descrs formal-descrs)
  (let ((result-descrs ()))
    (dolist (descr actual-descrs)
      (let ((new-descrs (unify-descr&descrs descr formal-descrs)))
	(if new-descrs
	    (setq result-descrs (append result-descrs new-descrs)))))
    result-descrs))

(DEFUN unify-descrs-1-to-1 (actual-descrs formal-descrs)
  (let ((result-descrs ()))
    (mapc (lambda (actual-descr formal-descr)
	    (let ((new-descr (unify-descr&descr actual-descr formal-descr)))
	      (if new-descr
		  (setq result-descrs (cons new-descr result-descrs)))))
	  actual-descrs formal-descrs)
    result-descrs))

(DEFUN unify-descrs (fun actual-descrs formal-descrs . special)
  (let ((reduced-descrs actual-descrs))
    (if (> (length actual-descrs) *max-call-descrs*)
	(let ((first-descr (ti-copy-descr (car actual-descrs))))
	  (join-descrs first-descr (cdr reduced-descrs))
	  (ti-statistics *joined-call-descrs-key*)
	  (setq reduced-descrs (list first-descr))))
    (let ((new-descrs (if special
			  (unify-descrs-1-to-1 reduced-descrs formal-descrs)
			(unify-descrs&descrs reduced-descrs formal-descrs))))
      (cond ((null new-descrs)
	     (let* ((return-descrs
		     (mapcar #'get-previous-subs reduced-descrs))
		    (error-descrs
		     (mapcar (lambda (descr)
			       (reduce-descr (ti-copy-descr descr)))
			     return-descrs)))
	       (notify-type-clash1 fun error-descrs)
	       return-descrs))
	    (t new-descrs)))))

(DEFGENERIC application-subs-check-%void (formal-descr actual-descr))

(DEFMETHOD application-subs-check-%void ((formal-descr <type-descr>)
					 (actual-descr <type-descr>))
  (let ((subs (application-subs formal-descr actual-descr)))
    (if (%void-type-p (get-result-type actual-descr))
	(let ((equ (get-substitution subs
				     (vector-ref (?type-vec actual-descr) 0))))
	  (ti-format t "~%Notice: formal result type converted to %void")
	  (if (null equ) (ti-error))
	  (set-right-expr equ (%void-type))))
    subs))

(DEFGENERIC select-methods (fun descrs))

(DEFMETHOD select-methods ((fun <defined-generic-fun>)
			   actual-descrs)
  (remove-if-not (lambda (method)
		   (unify-descrs&descrs actual-descrs (?signature method)))
		 (?method-list fun)))

;;; ---------------------------------------------------------------------------
;;; CONVERSIONS
;;; ---------------------------------------------------------------------------

(DEFGENERIC convert-to-sys-type-vec (descr))

(DEFMETHOD convert-to-sys-type-vec ((descr <type-descr>))
  (let ((vec (?type-vec descr))
	(subs (?type-vars descr)))
    (dovector (var i vec)
      (setf (vector-ref vec i)
	(check-if-abstract-class (type-expr-to-class var subs))))
    (setf (?type-vars descr) '())
    vec))

(DEFGENERIC type-expr-to-class (expr subs))

(DEFMETHOD type-expr-to-class (expr subs)
  (ti-format t "~%Warning: vector elements are already converted to classes")
  expr)

(DEFMETHOD type-expr-to-class ((expr <type-var>)
			       (subs <type-var-substitutions>))
  (type-expr-to-class (convert-to-atomic-type expr subs) nil))

(DEFMETHOD type-expr-to-class ((expr <slot-id>)
			       subs)
  (?slot-name expr))

(DEFMETHOD type-expr-to-class ((expr <atomic-type>)
			       subs)
  (let ((lattice-type (compute-normalized-lattice-type (?name expr))))
    (cond (lattice-type
	   (let ((class (get-lattice-type-class lattice-type)))
	     (if class
		 (get-most-specialized-class class)
	       %object)))
	  (t (ti-format t "~%Warning: can't find class to atom ~A"
			(ti-print-string-no-cr expr))
	     %object))))

(DEFGENERIC get-most-specialized-class (class))

(DEFMETHOD get-most-specialized-class ((class <class-def>))
  class)
  
(DEFMETHOD get-most-specialized-class ((class <abstract-class-def>))
  (let ((subs (~class-subclasses class)))
    (if (= (length subs) 1)		; one subclass?
	(get-most-specialized-class (car subs))
      class)))

;; Call different statistics-function for abstract and non-abstract classes.
(DEFGENERIC check-if-abstract-class (class))

;; Just return the slot name.
(DEFMETHOD check-if-abstract-class ((obj <symbol>))
  obj)

(DEFMETHOD check-if-abstract-class ((class <class-def>))
  (ti-statistics *inferred-classes-key*)
  class)

(DEFMETHOD check-if-abstract-class ((class <abstract-class-def>))
  (call-next-method)
  (ti-statistics *inferred-abstract-classes-key*)
  class)

;; Substitute all type vars in the arg/result type vec by atomic types.
(DEFGENERIC convert-to-atomic-descr (descr))

(DEFMETHOD convert-to-atomic-descr ((descr <type-descr>))
  (let* ((vec (?type-vec descr))
	 (subs (?type-vars descr)))
    (dovector (var i vec)
      (setf (vector-ref vec i)
	(convert-to-atomic-type var subs)))
    (setf (?type-vars descr) nil))	; substitutions no longer used
  descr)

;; Remove all indirect references via type variables.
(DEFGENERIC convert-to-atomic-subs (descr))

(DEFMETHOD convert-to-atomic-subs ((descr <type-descr>))
  (let ((subs (?type-vars descr))
	(new-subs (make <type-var-substitutions>)))
    (dolist (equ (?equations subs))
      (let* ((var (?left-expr equ))
	     (expr (if (get-substitution subs var)
		       (convert-to-atomic-type var subs)
		     (convert-to-atomic-type var (previous-subs descr)))))
	(add-substitution new-subs var expr)))
    (setf (?type-vars descr) new-subs)
    descr))

;; Remove all indirect references via type variables and remove all variables
;; that do not occur in the type vec.
(DEFGENERIC convert-to-atomic-subs-min (descr))

(DEFMETHOD convert-to-atomic-subs-min ((descr <type-descr>))
  (let ((subs (?type-vars descr))
	(new-subs (make <type-var-substitutions>))
	(vec (?type-vec descr)))
    (dovector (vec-var i vec)
      (let ((expr
	     (if (get-substitution subs vec-var)
		 (convert-to-atomic-type vec-var subs)
	       (convert-to-atomic-type vec-var (previous-subs descr)))))
	(add-substitution new-subs vec-var expr)))
    (setf (?type-vars descr) new-subs)
    descr))

(DEFMETHOD convert-general-to-%object-type (descrs)
  (if descrs
      (let ((subs (?type-vars (car descrs))))
	(convert-general-to-%object-type subs)
	(convert-general-to-%object-type (cdr descrs)))))

;;; ---------------------------------------------------------------------------
;;; CHECKING RESULT TYPE
;;; ---------------------------------------------------------------------------

;;; Check if result type of descr is supertype of all result types of descrs.
(DEFGENERIC check-result-subtypes (descrs descr))

(DEFMETHOD check-result-subtypes (descrs
				  (descr <type-descr>))
  (dolist (descr1 descrs)
    (if (null (meet-result-types-p descr1 descr))
	(notify-type-clash2 (get-result-type descr)
			    (get-result-type descr1)))))

;;; Answer whether result type of descr1 is subtype of result type of descr2.
(DEFGENERIC meet-result-types-p (descr1 descr2))

(DEFMETHOD meet-result-types-p ((descr1 <type-descr>)
				(descr2 <type-descr>))
  (let ((result1 (get-result-type descr1))
	(result2 (get-result-type descr2)))
    (or (subtype-expr-p result2 (%void-type)) ; void fits to all types
	(or (subtype-expr-p result1 result2)
	    (cond ((meet-type-exprs-p result1 result2)
		   (let ((fun (analysed-fun)))
		     (ti-format
		      t
		      "~%Warning: type check necessary for ~A function ~A:~A)"
		      (funtype-of fun) (?module-id fun) (name-of fun))
		     (ti-format t "~%Result type ~A more general than ~A."
				(ti-print-string-no-cr result1)
				(ti-print-string-no-cr result2)))
		   t)
		  (t ()))))))
 
;;; Check if first type expression is subtype of second type expression.
(DEFGENERIC check-subtype-exprs (expr1 expr2))

(DEFMETHOD check-subtype-exprs ((expr1 <type-expr>)
				(expr2 <type-expr>))
  (if (subtype-expr-p expr1 expr2)
      expr1
    (notify-type-clash3 expr1 expr2)))
 
;;; ---------------------------------------------------------------------------
;;; JOIN RESULT TYPES
;;; ---------------------------------------------------------------------------

;; Answer the joined types of the result types of a list of type descrs.
(DEFUN join-result-types (descrs)
  (if descrs
      (let ((result-type (get-result-type (car descrs))))
	(dolist (descr (cdr descrs))
	  (setq result-type
	    (join-type-exprs result-type (get-result-type descr))))
	result-type)
    (progn
      (ti-format t "~%Warning: trying to join an empty list of descripors")
      (general-type))))
    
;;; Set the result types of a type descriptor to a union of all result types.
(DEFUN set-joined-result-types (descrs)
  (let ((new-result-type (join-result-types descrs)))
    (dolist (descr descrs)
      (set-result-type descr new-result-type)))
  descrs)
    
;;; ---------------------------------------------------------------------------
;;; ACCESSING TYPE DESCRIPTORS
;;; ---------------------------------------------------------------------------

(DEFGENERIC get-descr-type (descr index))

(DEFMETHOD get-descr-type ((descr <type-descr>)
			   (index <spint>))
  (vector-ref (?type-vec descr) index))

(DEFGENERIC set-descr-type (descr index new-expr))
  
(DEFMETHOD set-descr-type ((descr <type-descr>)
			   (index <spint>)
			   (new-expr <type-expr>))
  (let ((new-var (new-type-var)))
    (setf (vector-ref (?type-vec descr) index) new-var)
    (add-substitution (?type-vars descr) new-var new-expr)))
  
(DEFMETHOD set-descr-type ((descr <type-descr>)
			   (index <spint>)
			   (new-expr <type-var>))
  (let ((vec (?type-vec descr)))
    (if (contains-type-var-p vec new-expr)
	(call-next-method)
      (setf (vector-ref vec index) new-expr))))

;; Set the result type of a type descriptor.
(DEFGENERIC set-result-type (descr new-expr))

(DEFMETHOD set-result-type ((descr <type-descr>)
			    (new-expr <atomic-type>))
  (let ((new-result-var (new-type-var)))
    (setf (vector-ref (?type-vec descr) 0) new-result-var)
    (add-substitution (?type-vars descr) new-result-var new-expr))
  descr)

;; Set the result type of a type descriptor and remove unused type vars.
(DEFGENERIC set-result-type-min (descr new-expr))

(DEFMETHOD set-result-type-min ((descr <type-descr>)
				(new-expr <atomic-type>))
  (set-result-type descr new-expr)
  (reduce-descr descr)
  descr)

;; Get the atomic result type of a type descriptor.
(DEFGENERIC get-arg-type (descr index))

(DEFMETHOD get-arg-type ((descr <type-descr>)
			 (index <spint>))
  (let ((prev-descr (?t-descr-before descr)))
    (if (and prev-descr (null (consp prev-descr)))
	(convert-to-atomic-type (vector-ref (?type-vec descr) index)
				(?type-vars descr)
				(?type-vars prev-descr))
      (convert-to-atomic-type (vector-ref (?type-vec descr) index)
			      (?type-vars descr)))))

;; Get the atomic result type of a type descriptor.
(DEFGENERIC get-result-type (descr))

(DEFMETHOD get-result-type ((descr <type-descr>))
  (get-arg-type descr 0))

;; Answer the substitutions of the previous type descriptor.
(DEFGENERIC previous-subs (descr))

(DEFMETHOD previous-subs ((descr <type-descr>))
  (let ((prev-descr (?t-descr-before descr)))
    (if (or (null prev-descr)		; no prev descr?
	    (consp prev-descr))		; more than one prev descr?
	(make <type-var-substitutions>)	; prev subs already used
      (?type-vars prev-descr))))

;;; Set the type var substitutions of the type descriptor before in descr.
(DEFGENERIC get-previous-subs (descr))

(DEFMETHOD get-previous-subs ((descr <type-descr>))
  (let ((prev-descr (?t-descr-before descr)))
    (if prev-descr
	(if (atom prev-descr)
	    (let ((prev-subs (ti-copy-subs (?type-vars prev-descr))))
	      (append-substitutions (?type-vars descr) prev-subs))
	  (ti-format t "~%Notice: more than one previous descriptor"))
      (ti-format2 t "~%Notice: no previous descriptor available (get)")))
  descr)

;;; Set one of the new type var substitutions of the type descriptor before.
(DEFGENERIC set-previous-subs (descr))

(DEFMETHOD set-previous-subs ((descr <type-descr>))
  (let ((prev-descr (?t-descr-before descr)))
    (if prev-descr
	(setf (?new-type-vars prev-descr)
	  (cons (?type-vars descr) (?new-type-vars prev-descr)))
      (ti-format t "~%Warning: no previous descriptor available (set)")))
  descr)

;;; Set signature of a function and reduce/join it if necessary.
(DEFGENERIC set-signature (fun descrs))

(DEFMETHOD set-signature ((fun <fun>)
			  descrs)
  (ti-statistics *inferred-signature-key*)
  (specialize-recursive-descrs descrs)
  (let ((copied-descrs (mapcar #'ti-copy-descr descrs)))
    (if (or (> (length copied-descrs) *max-signature-descrs*)
;	    (> 1 (?arg-num fun))     ; this or the next line!
	    (> 2 (length (?type-vec (car descrs)))))
	(let ((first-descr (car copied-descrs)))
	  (join-descrs-min first-descr (cdr copied-descrs))
	  (ti-statistics *joined-signature-descrs-key*)
	  (setf (?t-descr-before first-descr) nil)
	  (setq copied-descrs (list first-descr))))
    (let ((range&domain (?range-and-domain fun))
	  (max-domain-type ()))
      (cond ((null range&domain)
	     (convert-general-to-%object-type copied-descrs) ; EuLisp function
	     (setq max-domain-type (%object-type)))
	    (t				                     ; Tail function
	     (setq max-domain-type
	       (class-as-type-expr (vector-ref range&domain 0)))))
      (dolist (descr copied-descrs)
	(specialize-result-type descr max-domain-type)))
    (if *use-compound-types*
	(mapc #'reset-write-access-stamps copied-descrs)
      (mapc #'convert-all-compound-types copied-descrs))
    (setf (?signature fun) copied-descrs)
    (ti-format t "~%~%-- NEW SIGNATURE~A" (ti-print-string fun))))

;;; Set signature of a function from a list of classes.
(DEFGENERIC set-signature-from-classes (fun classes))

(DEFMETHOD set-signature-from-classes ((fun <fun>)
				       classes)
  (new-fun-with-defined-signatures fun)
  (setf (?signature fun)
    (list (apply #'filled-formal-descr (mapcar #'class-as-type-expr classes))))
  (ti-format t "~%~%-- NEW SIGNATURE~A" (ti-print-string fun)))

;;; Set signature of a function from a list of classes.
(DEFGENERIC set-predicate-signature (fun class))

(DEFMETHOD set-predicate-signature ((fun <fun>)
				    (class <class-def>))
  (new-fun-with-defined-signatures fun)
  ;; The code of the default atomic expr of lattice type %object has to
  ;; be updated because set-predicate-signature may be called before all
  ;; modules are loaded (i.e. before all defined classes are included
  ;; into the lattice).
  (setf (?code  (%object-type)) (?code *%object*))
  (let ((class-type (class-as-type-expr class))
	(not-class-type
	 (compute-to-atom (list ^and *%object*
				(list ^not (?lattice-type class)))))
	(<null>-type (<null>-type))
	(not-<null>-type
	 (compute-to-atom (list ^and *%object*
				(list ^not (get-lattice-type ^<null>))))))
    (setf (?signature fun)
      (list (filled-formal-descr <null>-type not-class-type)
	    (filled-formal-descr not-<null>-type class-type))))
  (ti-format t "~%~%-- NEW (predicate) SIGNATURE~A" (ti-print-string fun)))

;;; ---------------------------------------------------------------------------
;;; Answer a corresponding type expr to a application class (lzs-class).
(DEFGENERIC class-as-type-expr (class))
  
(DEFMETHOD class-as-type-expr ((class <named-const>))
  (class-as-type-expr (?value class)))
  
(DEFMETHOD class-as-type-expr ((class <null>))
  (ti-format t "Warning: no class for class-as-type-expr")
  (ti-error)
  (general-type))
  
(DEFMETHOD class-as-type-expr ((class <class-def>))
  (let ((lattice-type (?lattice-type class)))
    (if (null lattice-type)
	(ti-format t  "Warning: Can't find lattice type for class ~A" class)
      (lattice-type-to-atomic-type lattice-type))))

;; Remove all unused type var substitutions of a given descr.
(DEFGENERIC reduce-descr (descr))

(DEFMETHOD reduce-descr ((descr <type-descr>))
  (let ((new-subs (make <type-var-substitutions>)))
    (ti-format2 t "~%before reduce ~A " (ti-print-string descr))
    (reduce-substitutions (?type-vars descr) new-subs (?type-vec descr))
    (setf (?type-vars descr) new-subs)
    (ti-format2 t "~%after reduce ~A " (ti-print-string descr)))
  descr)

;;; Specialize recursive result types with joined non-recursive result types.
(DEFGENERIC specialize-recursive-descrs (descrs))

(DEFMETHOD specialize-recursive-descrs (descrs)
  (let* ((selection (select-recursive-descrs descrs))
	 (rec-descrs (car selection))
	 (non-rec-descrs (cdr selection)))
    (if (and rec-descrs non-rec-descrs)
	(let ((new-result-type (join-result-types (cdr selection))))
	  (dolist (descr rec-descrs)
	    (set-result-type-min descr new-result-type)))))
  descrs)

;; Answer a pair with recursive descrs as car and non-recursive descrs as cdr.
(DEFUN select-recursive-descrs (descrs)
  (let ((rec-descrs ())
	(non-rec-descrs ()))
    (dolist (descr descrs)
      (if (recursive-descr-p descr)
	  (setq rec-descrs (cons descr rec-descrs))
	(setq non-rec-descrs (cons descr non-rec-descrs))))
    (cons rec-descrs non-rec-descrs)))

;; Answer whether a type descriptor is recursive or not.
(DEFGENERIC recursive-descr-p (descr))

(DEFMETHOD recursive-descr-p ((descr <type-descr>))
  nil)

(DEFMETHOD recursive-descr-p ((descr <recursive-type-descr>))
  t)

;; Join a type descriptor with a list of type descriptors.
(DEFGENERIC join-descrs (descr descrs))

(DEFMETHOD join-descrs ((descr <type-descr>)
			descrs)
  (get-previous-subs descr)
  (ti-format2 t "~%before join ~A " (ti-print-string (list descr descrs)))
  (convert-to-atomic-subs descr)
  (ti-format2 t "~%before join+ ~A " (ti-print-string (list descr descrs)))
  (dolist (descr2 descrs)
    (get-previous-subs descr2)
    (convert-to-atomic-subs descr2)
    (join-two-descrs descr descr2))
  (setf (?t-descr-before descr)
    (cons (?t-descr-before descr) (mapcar #'?t-descr-before descrs)))
  (ti-format2 t "~%after join ~A " (ti-print-string descr))
  descr)

;; Join two type descriptors with atomic substitutions.
(DEFGENERIC join-two-descrs (descr1 descr2))

(DEFMETHOD join-two-descrs ((descr1 <type-descr>)
			    (descr2 <type-descr>))
  (setf (?type-vars descr1)
    (join-substitutions (application-subs descr2 descr1 t)
			(?type-vars descr1)))
  descr1)

;; Join a type descriptor with a list of type descriptors; the type 
;; substitutions contain only those variables that occur in the type vec.
(DEFGENERIC join-descrs-min (descr descrs))

(DEFMETHOD join-descrs-min ((descr <type-descr>)
			    descrs)
  (get-previous-subs descr)
  (ti-format2 t "~%before join ~A " (ti-print-string (list descr descrs)))
  (convert-to-atomic-subs-min descr)
  (dolist (descr2 descrs)
    (get-previous-subs descr2)
    (convert-to-atomic-subs-min descr2)
    (join-two-descrs-min descr descr2 0))
  (ti-format2 t "~%after join ~A " (ti-print-string descr))
  descr)

;; Join two type descriptors with atomic substitutions; the type substitutions
;; contain only those variables that occur in the type vec.
(DEFGENERIC join-two-descrs-min (descr1 descr2 index))

(DEFMETHOD join-two-descrs-min ((descr1 <type-descr>)
				(descr2 <type-descr>)
				(index <spint>))
  (if (< index (length (?type-vec descr1)))
      (let* ((var1 (vector-ref (?type-vec descr1) index))
	     (var2 (vector-ref (?type-vec descr2) index))
	     (equ1 (get-substitution (?type-vars descr1) var1))
	     (equ2 (get-substitution (?type-vars descr2) var2)))
	(if (and equ1 equ2)
	    (let ((expr1 (?right-expr equ1))
		  (expr2 (?right-expr equ2)))
	      (if (null (%void-type-p expr1))
		  (set-right-expr equ1 (join-type-exprs expr1 expr2)))
	      (join-two-descrs-min descr1 descr2 (+ index 1))))))
  descr1)

;; Check whether the result type of a descriptor corresponds to the defined
;; result type (type-expr). If the defined result type in %void update the
;; descriptor.
(DEFGENERIC specialize-result-type (descr type-expr))

(DEFMETHOD specialize-result-type ((descr <formal-type-descr>)
				   (type-expr <atomic-type>))
  (let* ((result-equ (get-last-substitution (?type-vars descr)
					    (vector-ref (?type-vec descr) 0)))
	 (result-type (?right-expr result-equ)))
    (if (null (subtype-expr-p result-type type-expr))
	(if (%void-type-p type-expr)
	    (set-result-type-min descr type-expr)
	  (let ((domain-type
		 (meet-type-exprs result-type type-expr)))
	    (cond (domain-type
		   (set-right-expr result-equ domain-type)
		   (format t "!")
		   (ti-format t "~%Warning: result type check necessary?"))
		  (t
		   (notify-type-clash2 type-expr (get-result-type descr))
		   (set-right-expr result-equ type-expr))))))))

;;; ---------------------------------------------------------------------------
;;; NOTIFYING TYPE CLASHES
;;; ---------------------------------------------------------------------------

(DEFUN notify-type-clash1 (fun error-descrs)
  (let ((tab-string "         ")
	(signature (or (?signature fun) (?type-descr fun))))
    (format t "~%-------------------------------------------------")
    (format t "------------------------------")
    (format t "~%Warning: Type clash analysing ~A function ~A::~A~%"
	    (funtype-of (analysed-fun))
	    (?module-id (analysed-fun))
	    (name-of (analysed-fun)))
    (format t "~AThe ~A function ~A::~A with range and domain types~%~A   "
	    tab-string
	    (funtype-of fun)
	    (?module-id fun)
	    (name-of fun)
	    tab-string)
    (ti-short-write t signature)
    (format t "~%~Ais called with ~%~A   "
	    tab-string
	    tab-string)
    (ti-short-write t error-descrs)
    (format t "~%~Acontinuing with~%~A   "
	    tab-string
	    tab-string)
    (ti-short-write t signature)
    (format t "~%-------------------------------------------------")
    (format t "------------------------------")
    (format t "~%There might be some constraints on argument and ")
    (format t "result types via type variables")
    (format t "~%that are not displayed here; see compiler options.")
    (format t "~%-------------------------------------------------")
    (format t "------------------------------"))
  (ti-error))

(DEFUN notify-type-clash2 (defined-result-type result-type)
  (format t "~%-------------------------------------------------")
  (format t "-----------------------------")
  (format t "~%Warning: User defined result type of ~A function "
	  (funtype-of (analysed-fun)))
  (format t "~A::~A"
	  (?module-id (analysed-fun))
	  (name-of (analysed-fun)))
  (format t "~%            ~A" (ti-print-string-no-cr defined-result-type))
  (format t "~%         does not correspond to the analysed result type")
  (format t "~%            ~A" (ti-print-string-no-cr result-type))
  (format t "~%         continuing with result type")
  (format t "~%            ~A" (ti-print-string-no-cr defined-result-type))
  (format t "~%-------------------------------------------------")
  (format t "-----------------------------~%")
  (ti-error))
      
(DEFUN notify-type-clash3 (type-expr1 type-expr2)
  (format t "~%-------------------------------------------------")
  (format t "-----------------------------")
  (format t "~%Warning: Assignment in ~A function "
	  (funtype-of (analysed-fun)))
  (format t "~A::~A"
	  (?module-id (analysed-fun))
	  (name-of (analysed-fun)))
  (format t "~%~%        with following types")
  (format t "~%            ~A <-> ~A"
	  (ti-print-string-no-cr type-expr1)
	  (ti-print-string-no-cr type-expr2))
  (format t "~%-------------------------------------------------")
  (format t "-----------------------------")
  (ti-error))
 
;;; ---------------------------------------------------------------------------
;;; WRITING TYPE DESCRIPTORS SHORTLY
;;; ---------------------------------------------------------------------------

(DEFGENERIC ti-short-write (stream obj))

(DEFMETHOD ti-short-write (stream descrs)
  (if (and *ti-short-print* (consp descrs))
      (ti-short-write stream (join-descrs-min (ti-copy-descr (car descrs))
					      (cdr descrs)))
    (ti-write stream obj)))

(DEFMETHOD ti-short-write (stream
			   (descr <type-descr>))
  (let ((arity (- (length (?type-vec descr)) 1)))
    (dotimes (i arity)
      (let ((expr (get-arg-type descr (+ i 1))))
	(ti-write stream expr)
	(if (< i (- arity 1))
	    (format stream " * ")))))
  (format stream " -> ")
  (ti-write stream (get-arg-type descr 0)))

(DEFMETHOD ti-short-write (stream
			   (fun <fun>))
  (format stream "~A::~A : " (?module-id fun) (name-of fun))
  (ti-short-write stream (?signature fun)))


#module-end