;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-const -*-
#|
-------------------------------------------------------------------------------
TITLE: Type Inference of Constants
-------------------------------------------------------------------------------
File:    ti-const.em
Version: 1.7 (last modification on Fri Sep 17 10:22:06 1993)
State:   proposed

DESCRIPTION:
Link between EuLisp constants and type expressions.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /tmp_mnt/home/saturn/wheick/Lisp/Apply/ti-const.em[1.0]
	Wed Apr 21 16:33:35 1993 akind@isst proposed $
 
ti-const.em[1.1] Wed May  5 11:24:52 1993 akind@isst proposed $
 
ti-const.em[1.2] Thu Jun  3 11:42:12 1993 akind@isst proposed $
 
ti-const.em[1.3] Wed Aug 18 16:09:27 1993 akind@isst proposed $
 
ti-const.em[1.4] Fri Aug 27 17:29:27 1993 akind@isst proposed $
 
ti-const.em[1.5] Wed Sep  8 09:37:55 1993 akind@isst published $
 
ti-const.em[1.6] Thu Sep 23 14:32:31 1993 akind@isst proposed $
 [Tue Sep 14 15:16:03 1993] Intention for change:
 
ti-const.em[1.7] Mon Oct 11 10:29:38 1993 akind@isst proposed $
 

-------------------------------------------------------------------------------
|#

#module-name ti-const
#module-import (ti lzs ti-lattice ti-exprs ti-signature
		   (only (~class-of) lzs-mop)
		   (only (expand-literal) expand-literal)) 
#module-syntax-import (ti)
#module-syntax-definitions
#module-header-end

;;; ---------------------------------------------------------------------------
;;; EXPORT
;;; ---------------------------------------------------------------------------

(EXPORT constant-type)

;;; ---------------------------------------------------------------------------
;;; CONSTANT TYPE EXPRESSIONS
;;; ---------------------------------------------------------------------------

(DEFGENERIC constant-type (value))

(DEFMETHOD constant-type (value)	; may be already a <literal-instance>
  (let* ((expanded-literal (expand-literal value))
	 (lattice-type (find-lattice-type-for-literal expanded-literal)))
    (if (null lattice-type)
	(setq lattice-type (?lattice-type (~class-of expanded-literal))))
    (lattice-type-to-atomic-type lattice-type)))

(DEFMETHOD constant-type ((value <null>))
  (<null>-type))

;;; Handling slot names.
(DEFMETHOD constant-type ((value <symbol>))
  (make <slot-id> :slot-name value))

;;; Handling function objects.
(DEFMETHOD constant-type ((value <fun>))
  (general-type))

(DEFMETHOD constant-type ((value <named-const>))
  (lattice-type-to-atomic-type (?lattice-type (?type value))))

#module-end