;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: ti-codes -*-
#|
-------------------------------------------------------------------------------
TITLE: Encoding Lattice Types
-------------------------------------------------------------------------------
File:    ti-codes.em
Version: 1.8 (last modification on Tue Oct 12 10:11:07 1993)
State:   proposed

DESCRIPTION:
Bit codes are assigned to lattice types in order to use fast low-level
bit operations to implement the lattice operations meet, join, and
complement. This modules provides the bit codes and operations on
them.

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
a.kind

CONTACT: 
a.kind (andreas.kind@isst.fhg.de)

HISTORY: 
Log for /tmp_mnt/home/saturn/wheick/Lisp/Apply/ti-codes.em[1.0]
	Tue Apr  6 13:22:14 1993 akind@isst proposed $
 
ti-codes.em[1.1] Wed Apr  7 18:04:57 1993 akind@isst proposed $
 
ti-codes.em[1.2] Wed Apr 21 16:33:27 1993 akind@isst proposed $
 
ti-codes.em[1.3] Tue Aug  3 11:46:42 1993 akind@isst proposed $
 
ti-codes.em[1.4] Wed Aug 11 13:34:30 1993 akind@isst proposed $
 
ti-codes.em[1.5] Wed Aug 18 16:09:20 1993 akind@isst published $
 
ti-codes.em[1.6] Thu Sep 23 14:32:21 1993 akind@isst proposed $
 [Tue Sep 14 15:15:47 1993] Intention for change:
 
ti-codes.em[1.7] Mon Oct 11 10:29:17 1993 akind@isst save $
 
ti-codes.em[1.8] Tue Oct 12 10:31:49 1993 akind@isst proposed $
 

-------------------------------------------------------------------------------
|#


#module-name ti-codes
#module-import (ti
		(only (logand logior logxor logandc2 expt minusp) common-lisp))
#module-syntax-import (ti)
#module-syntax-definitions
#module-header-end

;;; ---------------------------------------------------------------------------
;;; EXPORT
;;; ---------------------------------------------------------------------------

(EXPORT bottom-code
	reset-used-codes
	next-code 
	join-codes
	meet-codes
	complement-code
	substract-codes
	xor-codes
	eq-code-p
	meet-codes-p
	subcode-p
	bottom-code-p
	complement-codes-p)

;;; ---------------------------------------------------------------------------
;;; GENERATING NEW LATTICE TYPE CODES
;;; ---------------------------------------------------------------------------

;;; Answer the constant bottom code.
(DEFUN bottom-code ()
  0)

(DEFLOCAL *used-codes* (bottom-code))

(DEFUN reset-used-codes () (setq *used-codes* (bottom-code)))

;;; Answer a new type code; increment number of used codes.
(DEFUN next-code ()
  (let ((new-code (expt 2 *used-codes*)))
    (setf *used-codes* (+ 1 *used-codes*))
    new-code))

;;; Meet lattice type codes.
(DEFUN join-codes (code1 code2)
  (if (minusp code1)
      (if (minusp code2)
	  (- (logand (abs code1) (abs code2)))
	(- (logandc2 (abs code1) code2)))
    (if (minusp code2)
	(- (logandc2 (abs code2) code1))
      (logior code1 code2))))

;;; Meet lattice type codes.
(DEFUN meet-codes (code1 code2)
  (if (minusp code1)
      (if (minusp code2)
	  (- (logior (abs code1) (abs code2)))
	(logandc2 code2 (abs code1)))
    (if (minusp code2)
	(logandc2 code1 (abs code2))
      (logand code1 code2))))

;;; Complement lattice type codes.
(DEFUN complement-code (code)
  (- code))

;;; Xor lattice type codes.
(DEFUN xor-codes (code1 code2)
  (logxor code1 code2))

;;; Substract lattice type codes.
(DEFUN substract-codes (code1 code2)
  (logandc2 code1 code2))

;;; ---------------------------------------------------------------------------
;;; TYPE CODE PREDICATES
;;; ---------------------------------------------------------------------------

;;; Answer whether two type codes are equal.
(DEFUN eq-code-p (code1 code2)
  (= code1 code2))

;;; Answer whether a type code is the bottom type code.
(DEFUN bottom-code-p (code)
  (eq-code-p code (bottom-code)))

;;; Answer whether two type codes do meet, e.g. do have set the same bits.
(DEFUN meet-codes-p (code1 code2)
  (null (bottom-code-p (meet-codes code1 code2))))

;;; Answer whether one type code is a subcode of another.
(DEFUN subcode-p (code1 code2)
  (eq-code-p (meet-codes code1 code2) code1))

;;; Answer whether two lattice type codes are complementary.
(DEFUN complement-codes-p (code1 code2)
  (zerop (+ code1 code2)))

#module-end