;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: standard-init -*-
#|
-----------------------------------------------------------------------------------
TITLE: initialization protocol of the compile time MOP for standard classes
-----------------------------------------------------------------------------------
File:    standard-init.em
Version: 1.22 (last modification on Tue Oct 19 09:13:21 1993)
State:   proposed

DESCRIPTION:
The methods for <standard-class-def> implement the single inheritance case which
is the default for the predefined EuLisp class <class>.


DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
Ingo Mohr

HISTORY: 
Log for /export/home/saturn/hfried/Lisp/Apply/standard-init.em[1.0]
	Mon Mar 22 16:36:17 1993 imohr@isst save $
 compile time MOP for standard classes
 
standard-init.em[1.1] Tue Mar 23 09:45:35 1993 wheick@isst save $
 [Mon Mar 22 17:28:19 1993] Intention for change:
 compute-representation and import for functions from whc-definitions inserted
 and export
 
standard-init.em[1.2] Wed Mar 24 13:47:30 1993 imohr@isst proposed $
 classes and generic functions ok
 
standard-init.em[1.3] Wed Mar 24 16:48:58 1993 imohr@isst proposed $
 class options representation. ok
 
standard-init.em[1.4] Thu Mar 25 14:10:39 1993 wheick@isst save $
 [Thu Mar 25 08:59:44 1993] Intention for change:
 two new paramerts for type. functions in initialize
 
standard-init.em[1.5] Wed Mar 31 10:40:57 1993 imohr@isst proposed $
 literals for structures, literal expanders and expose ok
 
standard-init.em[1.6] Fri Apr  2 16:04:01 1993 imohr@isst proposed $
 [Thu Apr  1 14:35:43 1993] Intention for change:
 + method ~compute-class-precedence-list for empty superclass list
 
standard-init.em[1.7] Tue Apr  6 16:11:00 1993 imohr@isst save $
 + stuff for lattice types
 
standard-init.em[1.8] Tue Apr  6 16:40:04 1993 imohr@isst proposed $
 
standard-init.em[1.9] Thu Apr  8 15:20:49 1993 imohr@isst proposed $
 code generation for classes ok
 
standard-init.em[1.10] Wed Apr 14 13:21:08 1993 imohr@isst proposed $
 methods for ~compute-representation/predicate/constructor deleted
 
standard-init.em[1.11] Wed Apr 28 09:58:50 1993 imohr@isst save $
 slot-accessor-fun's and slot-init-fun's with annotation slot
 
standard-init.em[1.12] Mon May  3 13:32:43 1993 imohr@isst proposed $
 + lists for statically allocated instances
 
standard-init.em[1.13] Thu May  6 10:41:35 1993 imohr@isst proposed $
 ~compute-reader/writer moved to mm-initialize.em
 
standard-init.em[1.14] Thu May  6 12:05:29 1993 imohr@isst proposed $
 now ignoring method definitions when no generic function exist
 
standard-init.em[1.15] Tue Jun  1 13:53:30 1993 imohr@isst proposed $
 + list of all slot descriptions (for type inference)
 
standard-init.em[1.16] Mon Aug 30 15:25:27 1993 imohr@isst proposed $
 [Mon Aug 30 14:01:19 1993] Intention for change:
 collecting subclasses in a class
 
standard-init.em[1.17] Wed Sep  8 13:23:36 1993 imohr@isst proposed $
 [Wed Sep  8 11:59:46 1993] Intention for change:
 - import of el2lzs-rules
 
standard-init.em[1.18] Wed Sep 15 11:56:45 1993 imohr@isst proposed $
 [Mon Sep 13 08:28:40 1993] Intention for change:
 complete generic functions
 
standard-init.em[1.19] Fri Oct  1 18:49:36 1993 imohr@isst proposed $
 [Fri Oct  1 10:18:02 1993] Intention for change:
 allow creation of slot accessors for %string
 
standard-init.em[1.20] Wed Oct 13 15:45:17 1993 imohr@isst proposed $
 [Mon Oct 11 13:34:56 1993] Intention for change:
 + initarg-option for slots
 
standard-init.em[1.21] Fri Oct 15 17:34:38 1993 imohr@isst proposed $
 [Fri Oct 15 08:28:41 1993] Intention for change:
 creation of slot accessors for tail-classes only if required
 
standard-init.em[1.22] Tue Oct 19 09:13:45 1993 hfried@isst proposed $
 [Tue Oct 19 09:10:31 1993] Intention for change:
 ausschriften
 

-----------------------------------------------------------------------------------
|#

#module-name standard-init
#module-import
(level-1-eulisp
 lzs-mop
 accessors
 lzs
 option-lists
 tail-module

 (only (APPEND REMOVE-DUPLICATES SUBSTITUTE MAPC MAPCAR mapcan FIND WARN 
               MAKE-INSTANCE
               nconc vector format) 
   common-lisp))
#module-syntax-import 
(level-1-eulisp
 (only (case push) common-lisp))
#module-syntax-definitions

#module-header-end

(export *list-of-new-slot-descriptions*)

;;; -----------------------------------------------------------------------------------
;;; initialization of class definitions
;;; -----------------------------------------------------------------------------------
;;; The methods for <standard-class-def> implement the compile time MOP for the
;;; single inheritance case like the application MOP defined for <class>

(defmethod ~initialize ((class <standard-class-def>) initlist)
;options in initlist are: name direct-superclasses direct-slot-specs 
;direct-initargs representation allocation mm-type
  (let ((name (get-option ^name initlist nil))
        (direct-superclasses (get-option ^direct-superclasses initlist nil))
        (direct-slot-specs (get-option ^direct-slot-descriptions initlist nil))
        (direct-initargs (get-option ^direct-initargs initlist nil))
        (representation (get-option ^representation initlist nil))
        (allocation (get-option ^allocation initlist t))
        (mm-type (get-option ^mm-type initlist nil))
        (direct-super-lattice-types (get-option ^direct-super-lattice-types 
                                                initlist nil))
        effective-slots inherited-slots
        )

  ; resetting of annotations holding intermediate informations during
  ; compilation 
  (setf (?place class) nil)
  (setf (?expanded-literal class) nil)
  (setf (?initialization class) nil)
  
  (cond ((null (?identifier class)) 
         (setf (?identifier class) name))
        ((eq (?identifier class) name))
        (t (warn "identifiers for class name (~A) and binding (~A) are not the same"
                 name (?identifier class))))
  (setf (?supers class) direct-superclasses)
  (mapc (lambda (superclass)
          (push class (?subclasses superclass)))
        direct-superclasses)
  (setf (?lattice-type class) (~compute-lattice-type class direct-superclasses
                                                     direct-super-lattice-types))
  (setf (?class-precedence-list class) 
        (~compute-class-precedence-list class direct-superclasses))
  (setf (?initargs class)
        (~compute-initargs class direct-initargs
                           (~compute-inherited-initargs class direct-superclasses)))
  (setq inherited-slots 
        (~compute-inherited-slot-descriptions class direct-superclasses))
  (setq effective-slots
        (~compute-slot-descriptions class direct-slot-specs
                                    inherited-slots))
  (setf (?effective-slots class) effective-slots)
  (setf (?representation class)
        (~compute-representation class representation allocation mm-type))
  (~compute-and-ensure-slot-accessors class effective-slots inherited-slots)
  class))

(defmethod ~initialize ((class <tail-class-def>) initlist)
  ;recognized options in initlist are: name direct-slot-specs 
  ;direct-initargs representation allocation mm-type
  (let ((name (get-option ^name initlist nil))
        (direct-slot-specs (get-option ^direct-slot-descriptions initlist nil))
        (direct-initargs (get-option ^direct-initargs initlist nil))
        (representation (get-option ^representation initlist nil))
        (allocation (get-option ^allocation initlist t))
        (mm-type (get-option ^mm-type initlist nil))
        (direct-super-lattice-types (get-option ^direct-super-lattice-types 
                                                initlist nil))
        effective-slots
        )
    
    ; resetting of annotations holding intermediate informations during
    ; compilation 
    (setf (?place class) nil)
    (setf (?expanded-literal class) nil)
    (setf (?initialization class) nil)
    
    (cond ((null (?identifier class)) 
           (setf (?identifier class) name))
          ((eq (?identifier class) name))
          (t (warn "identifiers for class name (~A) and binding (~A) are not the same"
                   name (?identifier class))))
    (setf (?supers class) nil)
    (setf (?lattice-type class) (~compute-lattice-type class direct-superclasses
                                                       direct-super-lattice-types))
    (setf (?class-precedence-list class)  (list class))
    (setf (?initargs class) direct-initargs)
    (setq effective-slots (create-tail-slot-defs class direct-slot-specs))
    (setf (?effective-slots class) effective-slots)
    (setf (?representation class)
          (~compute-representation class representation allocation mm-type))
    (compute-and-ensure-tail-slot-accessors class effective-slots)
    class))

;;; -----------------------------------------------------------------------------------
;;; ~compute-class-precedence-list
;;; -----------------------------------------------------------------------------------
(defmethod ~compute-class-precedence-list ((class <standard-class-def>)
                                           direct-superclasses)
  (cons class (~class-precedence-list (car direct-superclasses))))

(defmethod ~compute-class-precedence-list ((class <standard-class-def>)
                                           (direct-superclasses <null>))
  (list class))

;;; -----------------------------------------------------------------------------------
;;; ~compute-inherited-slot-descriptions, ~compute-slot-descriptions
;;; -----------------------------------------------------------------------------------


; *list-of-new-slot-descriptions* contains the collection of all new slot
; descriptions of all classes of all modules 
; "new slot description" is a slot description for a slot which doesn't
; specialize a slot of its superclasses
(deflocal *list-of-new-slot-descriptions* ())

(defmethod ~compute-inherited-slot-descriptions ((class <standard-class-def>) 
                                                 direct-superclasses)
  (list (~class-slot-descriptions (car direct-superclasses))))

(defmethod ~compute-inherited-slot-descriptions ((class <standard-class-def>) 
                                                 (direct-superclasses <null>))
  (list nil))


(defmethod ~compute-slot-descriptions ((class <standard-class-def>) 
                                       direct-slot-specs 
                                       inherited-slot-descriptions)
  (nconc (mapcar (lambda (inherited-slot)
                   (create-specialized-slot class inherited-slot direct-slot-specs))
                 (car inherited-slot-descriptions))
         (create-slot-defs class direct-slot-specs (car
                                                    inherited-slot-descriptions))))

(defun create-specialized-slot (class inherited-slot direct-slot-specs)
  (let* ((specialized-slot (make-instance <slot-desc> 
                             :identifier (~slot-description-name inherited-slot)
                             :specializes inherited-slot
                             :slot-of class))
         (slot-spec (find (~slot-description-name inherited-slot) direct-slot-specs
                          :key (lambda (slot-spec) (get-option ^name slot-spec nil))))
         (initfunction (get-option ^initfunction slot-spec nil))
         (type (get-option ^type slot-spec nil))
         (initarg (get-option ^initarg slot-spec nil))
         )
    (when initfunction
      (setf (?slot initfunction) specialized-slot))
    (setf (?initfunction specialized-slot) 
          (or initfunction (?initfunction inherited-slot)))
    (setf (?type specialized-slot) 
          (or type (?type inherited-slot)))
    (setf (?initarg specialized-slot)
          (if (and initarg
                   (?initarg inherited-slot))
            (progn
              (format t "~% -------------------- error ------------------------")
              (format t "~% attempt to add a second initarg for an inherited slot: ~
                         ignoring new initarg ~A for slot ~A"
                      initarg (get-option ^name slot-spec nil))
              (format t "~% ---------------------------------------------------~%")
              (?initarg inherited-slot))
            (or initarg (?initarg inherited-slot))))
    specialized-slot))

(defun create-slot-defs (class direct-slot-specs inherited-slot-descriptions)
  (if (null direct-slot-specs) 
    nil
    (let* ((slot-spec (car direct-slot-specs))
           (name (get-option ^name slot-spec nil))
           (initfunction (get-option ^initfunction slot-spec nil))
           (initarg (get-option ^initarg slot-spec nil)))
      (if (find name inherited-slot-descriptions
                :key #'~slot-description-name)
        ; it was a slot specialization
        (create-slot-defs class (cdr direct-slot-specs)
                          inherited-slot-descriptions)
        ; it was a slot definition, a new slot-description must be created 
        (let ((slot (make-instance <slot-desc>
                      :identifier name
                      :initfunction initfunction
                      :initarg initarg
                      :type (get-option ^type slot-spec %object)
                      :slot-of class)))
          (push slot *list-of-new-slot-descriptions*)
          (when initfunction
            (setf (?slot initfunction) slot))
          (cons slot
                (create-slot-defs class (cdr direct-slot-specs)
                                  inherited-slot-descriptions)))))))

(defun create-tail-slot-defs (class slot-specs)
  (if (null slot-specs) 
    nil
    (let* ((slot-spec (car slot-specs))
           (name (get-option ^name slot-spec nil))
           (initfunction (get-option ^initfunction slot-spec nil))
           (initarg (get-option ^initarg slot-spec nil))
           (reader? (get-option ^reader slot-spec nil))
           (writer? (get-option ^writer slot-spec nil))
           (slot (make-instance <slot-desc>
                   :identifier name
                   :initfunction initfunction
                   :initarg initarg
                   :type (get-option ^type slot-spec %object)
                   :slot-of class)))
      (push slot *list-of-new-slot-descriptions*)
      (when initfunction
        (setf (?slot initfunction) slot))
      (when reader? (setf (?reader slot) t))
      (when writer? (setf (?writer slot) t))
      (cons slot
            (create-tail-slot-defs class (cdr slot-specs))))))
  
;;; -----------------------------------------------------------------------------------
;;; ~compute-inherited-initargs, ~compute-initargs
;;; -----------------------------------------------------------------------------------
(defmethod ~compute-inherited-initargs ((class <standard-class-def>)
                                        direct-superclasses)
  (list (?initargs (car direct-superclasses))))

(defmethod ~compute-inherited-initargs ((class <standard-class-def>)
                                        (direct-superclasses <null>))
  (list nil))


(defmethod ~compute-initargs ((class <standard-class-def>)
                              initargs inherited-initarg-lists)
  (remove-duplicates (append initargs (car inherited-initarg-lists))))

;;; -----------------------------------------------------------------------------------
;;; ~compute-representation defined in whc-definitions.em
;;; ~compute-constructor defined in mm-initialize.em
;;; ~compute-predicate defined in mm-initialize.em
;;; -----------------------------------------------------------------------------------

;;; -----------------------------------------------------------------------------------
;;; Initialization of the Slot Access Protocol
;;; -----------------------------------------------------------------------------------

(defmethod ~compute-and-ensure-slot-accessors 
           ((class <standard-class-def>) effective-slots inherited-slots) 
  (mapc (lambda (slot)
          (unless (?specializes slot)
            (setf (?reader slot) 
                  (~compute-slot-reader class slot effective-slots))
            (setf (?writer slot) 
                  (~compute-slot-writer class slot effective-slots))))
        effective-slots)
  effective-slots)

;(defmethod ~compute-and-ensure-slot-accessors 
;           ((class <%string>) effective-slots inherited-slots) 
;  ; to avoid creation of accessors for slot 'length' of %string because this is
;  ; not allowed before apply-level-2
;  (mapc (lambda (slot)
;          (unless (eq ^length (~slot-description-name slot))
;            (setf (?reader slot) 
;                  (~compute-slot-reader class slot effective-slots))
;            (setf (?writer slot) 
;                  (~compute-slot-writer class slot effective-slots))))
;        effective-slots)
;  effective-slots)

(defun compute-and-ensure-tail-slot-accessors (class slots) 
  (mapc (lambda (slot)
            (when (?reader slot)
              (setf (?reader slot) (~compute-slot-reader class slot slots)))
            (when (?writer slot)
              (setf (?writer slot) (~compute-slot-writer class slot slots))))
        slots)
  slots)

; The methods for ~compute-slot-reader and ~compute-slot-writer are defined in
; mm-initialize.em 

;;; -----------------------------------------------------------------------------------
;;; Initialization of Generic Functions and Methods
;;; -----------------------------------------------------------------------------------

(defmethod ~initialize ((gf <defined-generic-fun>) options)
  ;options are: name domain range method-class method*
  ;additional option for the compiler: parameters
  (let ((name (get-option ^name options nil))
        (domain (get-option ^domain options nil))
        (range (get-option ^range options nil))
        (method-class (get-option ^method-class options nil))
        (params (get-option ^parameters options nil)))
    (cond ((null (?identifier gf)) 
           (setf (?identifier gf) name))
          ((eq (?identifier gf) name))
          (t (warn "identifiers for generic function name (~A) and binding (~A) are not the same"
                   name (?identifier gf))))
    (setf (?domain gf) domain)
    (setf (?params gf) params)
    (setf (?range-and-domain gf)
          (apply #'vector range domain))    
    gf))

(defmethod ~initialize ((method <method-def>) options)
  ;options are: domain range function generic-function
  (let ((domain (get-option ^domain options nil))
        (range (get-option ^range options nil))
        (function (get-option ^function options nil))
        (generic-function (get-option ^generic-function options nil)))
    (setf (?domain method) domain)
    (setf (?fun method) function)
    (setf (?generic-fun method) generic-function)
    (setf (?range-and-domain function)
          (apply #'vector range domain))
    method))

(defmethod ~add-method ((gf <global-generic-fun>) (method <method-def>))
  (push method (?method-list gf))
  gf)

(defmethod ~add-method (gf (method <method-def>))
  ; it is not allowed to add a method to other things than generic functions
  (format t "~% -------------------- error ------------------------")
  (format t "~% ~A was given to add-method instead of a generic function"
          gf)
  (format t "~% ---------------------------------------------------~%")
  nil)

#module-end
