;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: machine-description -*-
#|
-----------------------------------------------------------------------------------
TITLE: Mashine-description of Register, Location and Parameter-passing
-----------------------------------------------------------------------------------
File:    machine-description.em
Version: 1.10 (last modification on Mon Apr 19 14:42:52 1993)
State:   proposed

DESCRIPTION:
the definition functions for tail data types

DOCUMENTATION:
see in the APPLY-paper machine description

NOTES:


REQUIRES:

PROBLEMS:

AUTHOR:
r. rosenmueller, w. heicking

CONTACT: 
r. rosenmueller, w. heicking

HISTORY: 
-----------------------------------------------------------------------------------
|#

#module-name machine-description

#module-import
(level-1-eulisp
 LZS
 MZS
 whc-basic-data-types ;from *wh*
; WHC
 RR-MD-READ
 accessors
; lzs-modules
 el2lzs
 expand-literal
 (only (load           ; nur zum laden unten
        ;boundp concatenate string intern 
        symbol-value 
        truncate 
        ceiling
        cadr reverse ;listp mapc mapcar 
        ;delete subst append remove every make-array aref 
        make-instance 
        ;princ prin1 pprint 
        format 
        error 
        ;cerror warn 
        first 
        ;second third fourth fifth sixth seventh eighth nth slot-boundp slot-value 
        not 
        ;return 
        prog1 
        warn
        expt rem
        ) common-lisp)
)

#module-syntax-import
(level-1-eulisp 
 apply-standard
 whc-basic-data-types ;from *wh*
 rr-md-read
 lzs-modules
 (only (dolist  ;dotimes
         setf
         ) common-lisp)
) ; macros used here

#module-syntax-definitions

;--- defmacro forms

#module-header-end

;--- exports

(export get-argument-places get-parameter-places 
         get-result-place get-return-place
         %%add-registers
         %GENERAL-REGISTER-PLACE
         stack-register-argument-save-length
         %fp %sp

         ;;;now to export from *wh*
;         <%types>
;         <%basic-data-type>
         <basic-class-def>

         <%aux-type>
         <%representation>
         <%machine-type>
         
         <%prestruct>
         <%struct>
         <%vector>
         <%union>
         <%pointer>

         <%pointer-to-struct>
         <%pointer-to-vector>
         <%pointer-to-void>
         <%direct>
         <%function>

;         <%variable-or-%constant>
;         <%variable>
;         <%constant>
         
         ;is used as class for method in %extract
         %STRING-ASCIZ
         
         ;the aux data types only for intern usage (for wh)
         %memory-free
         %string-ascii 
         %alignment 
         %global 
         %local 
         %comment
         %label-aux
         %machine-pointer
         %function
         
         <address-expr>
         
         ;the following exports are done by define-tail
         ;the <...> class definitions also!!
         ;  %byte-integer %half-integer %word-integer
         ;  %unsigned-byte-integer %signed-byte-integer 
         ;  %unsigned-half-integer %signed-half-integer
         ;  %unsigned-word-integer %signed-word-integer
         ;  %direct-integer %signed-direct-integer
         ;  %single-float %double-float %extended-float 
         ;  %void %function %string
         
         table-of-class-instances;;our table
         
;         type-instance-put
;         type-instance-put-with-test
;         type-instance-get
;         type-instance-rem
;         data-type-p
;         give-data-type
;         give-basic-data-type
;         give-pointer-data-type
;         give-prestruct-data-type
;         give-union-data-type
;         give-variable
;         give-constant
;         give-variable-or-constant
;         data-float-p
;         data-integer-p
;         direct-value-p
         ?actually-byte-length
         )

(export-syntax 
  define-tail-sys-functions ;tail functions with export
  define-tail-aux-sys-functions;tail aux functions without export
)

; (expose ) ; export without import

; macros:
; names for export

; definitions, exportations(?), initialization forms

; ######## mark of an exported name
; ------------ mark of a not exported name
; (deflocal ) ; definition of a global variable
; (defvar ) ; definition of a dynamic variable
; (defun )
; (defmacro ) ; only for export
;


;(defmethod direct-value-p-using-class (x (class <%integer>))
;  (< (abs (car (?value-list x))) 
;     (expt 2 
;           (?bit-length (?representation %direct-integer)))))
;
;(defmethod direct-value-p-using-class (x class)
; nil)
;
;
;(defun direct-value-p (x)
;  (if (or (global-static-p x)
;          (imported-static-p x))
;    ()
;    (let ((literal (expand-literal x)))
;      (direct-value-p-using-class literal (?class literal)))))

;; -----------------------------------------------------------------------------------
;; data type description for a concrete machine (SUN 4) 
;; the macros and functions for define-machine-data-types and
;; define-basic-data-types 
;; are in the modules whc-basic-data-types, whc-aux and whc-classes
;; -----------------------------------------------------------------------------------

(define-machine-data-types
;  (%bit 
;   :bit-length 1 :byte-length 0 :alignment 0 
;   :var-code "~%      .byte ~D")
  (%direct-value 
   ;:bit-length 13 
   :byte-length 0 ;:alignment 0 
   ;:var-code "~%      .word ~D"
   )
  (%byte 
   ;:bit-length 8 
   :byte-length 1 ;:alignment 1 
   ;:var-code "~%      .byte ~D"
   )
  (%half-word 
   ;:bit-length 16 
   :byte-length 2 ;:alignment 2 
   ;:var-code "~%      .half ~D"
   )
  (%word 
   ;:bit-length 32 
   :byte-length 4 ;:alignment 4 
   ;:var-code "~%      .word ~D"
   )
  (%machine-pointer 
   ;:bit-length 32 
   :byte-length 4 ;:alignment 4 
   ;:var-code "~%      .word ~D"
   )
  (%double-word 
   ;:bit-length 64 
   :byte-length 8 ;:alignment 8 
   ;:var-code "~%      .double ~D"
   )
  (%triple-word 
   ;:bit-length 96 
   :byte-length 12 ;:alignment 8
   ;:var-code "~%      .quad ~D"
   )
  (%quad-word 
   ;:bit-length 128 
   :byte-length 16 ;:alignment 8
   ;:var-code "~%      .quad ~D"
   )
  )

(define-basic-data-types

  (%word-integer 
   :machine %word
   :supers (%integer)
   )

  (%signed-word-integer 
   :machine %word
   :supers (%word-integer %signed)
   )

  (%unsigned-word-integer 
   :machine %word
   :supers (%word-integer %unsigned)
   )

  (%half-integer 
   :machine %half-word
   :supers (%word-integer)
   )

  (%signed-half-integer 
   :machine %half-word
   :supers (%half-integer %signed-word-integer)
   )

  (%unsigned-half-integer 
   :machine %half-word
   :supers (%half-integer %unsigned-word-integer)
   )

  (%direct-integer 
   :machine %direct-value
   :supers (%half-integer)
   )

  (%signed-direct-integer 
   :machine %direct-value
   :supers (%direct-integer %signed-half-integer)
   )

  (%unsigned-direct-integer 
   :machine %direct-value
   :supers (%direct-integer %unsigned-half-integer)
   )
 
  (%byte-integer 
   :machine %byte
   :supers (%direct-integer)
   )

  (%signed-byte-integer 
   :machine %byte
   :supers (%byte-integer %signed-direct-integer)
   )

  (%unsigned-byte-integer 
   :machine %byte
   :supers (%byte-integer %unsigned-direct-integer)
   )

  (%single-float 
   :machine %word
   :supers (%float)
   )

  (%double-float 
   :machine %double-word
   :supers (%float)
   )

  (%extended-float 
   :machine %triple-word
   :supers (%float)
)

  (%void
  :machine %word ;!!!to give any representation for void !!! 
  :supers (basic-class-def))

  (%function
   :machine %word
   :supers (basic-class-def))

  (%string
   :machine %byte
   :supers (basic-class-def)
   )

  (%jmpbuf
   :machine %word                       ; this isn't true, but the length should
                                        ; not be used
   :supers (basic-class-def))

  (%pjmpbuf
   :machine %word
   :supers (basic-class-def))

  ) 


;;;here only a defstandardclass and type-instance-put-with-test
;;;but not define-tail is made
;(define-aux-data-types
;        (%memory-free 
;         :var-code "~%      .skip ~D")
;
;        (%string-asciz
;         ;:alignment 1
;         :machine %byte
;         :var-code "~%      .asciz \"~A\"")
;
;        (%string-ascii 
;         :machine %byte
;         :var-code "~%      .ascii \"~D\"")
;
;         (%alignment 
;          :var-code "~%      .align ~D")
;
;        (%global 
;         :var-code "~%      .global ~s")
;
;        (%global1 
;         :var-code "~%      .global ~a")
;
;        (%local  
;         :var-code "~%      .local ~s")
;
;        (%local1  
;         :var-code "~%      .local ~a")
;
;        (%comment 
;         :var-code "        ! ~s")
;        
;        (%label-aux 
;         :var-code "~% ~a:")
;        
;        )

;(setf (?alignment %string-asciz) 1)

;;;I have to to define here the following data types because rainer needs 
;;;this data types for define-protocol!!!

(define-aux-pointer-data-types
 
  (%general-pointer (%pointer %word-integer))

  (%pointer-byte-integer (%pointer %byte-integer))

  (%pointer-signed-byte-integer (%pointer %signed-byte-integer))

  (%pointer-unsigned-byte-integer (%pointer %unsigned-byte-integer))

  (%pointer-half-integer (%pointer %half-integer))

  (%pointer-signed-half-integer (%pointer %signed-half-integer))

  (%pointer-unsigned-half-integer (%pointer %unsigned-half-integer)))

  






(defgeneric ?actually-byte-length (pobj))

(defmethod ?actually-byte-length ((pobj <class-def>))
  (if (?representation pobj)
  (?actually-byte-length1 (?representation pobj))
  (progn 
    (warn "error ~a von <class-def> hat keine representation" pobj)
    4)))

(defmethod ?actually-byte-length ((pobj <%representation>))
  (?actually-byte-length1 pobj))

(defmethod ?actually-byte-length ((pobj t))
  ;(print 'actually-byte-length-t)
  ;(print pobj)
  (if (expand-literal pobj)
    (if (?class (expand-literal pobj))
      (?actually-byte-length (?class (expand-literal pobj)))
      4)
    4))

(defgeneric ?actually-byte-length1 (pobj))

(defmethod ?actually-byte-length1 ((pobj <%pointer>))
  ;(print 'actually-byte-length1)(print pobj)
  (?byte-length (?representation %signed-word-integer))
  )

(defmethod ?actually-byte-length1 ((pobj t))
  ;(print 'actually-byte-length1)(print pobj)
  (?byte-length pobj)
  )

 

;;; Instruction Quantity

; Definition of Abbreviations

;nach rr-md-read, dort nicht mglich wegen symbole!!
(defconstant I  '<%word-integer>)                     ; ohne spitze klammer
                                                    ; symbol der instance
                                                    ; fr subtypep-bdt
                                                    ; mit spitze klammer
                                                    ; symbol der klasse
                                                    ; fr echte subtypep
(defconstant SI '<%signed-word-integer>) 
(defconstant UI '<%unsigned-word-integer>) 
(defconstant ID '<%direct-integer>)
(defconstant BI '<%byte-integer>)
(defconstant HI '<%half-integer>)
(defconstant SF '<%single-float>)
(defconstant DF '<%double-float>)
(defconstant XF '<%extended-float>)
(defconstant P  '<%pointer>)                  
(defconstant GP  '<%general-pointer>)                  

(defconstant SBI '<%signed-byte-integer>)
(defconstant UBI '<%unsigned-byte-integer>)		
(defconstant SHI '<%signed-half-integer>)
(defconstant UHI '<%unsigned-half-integer>)  ; bis hier hin s.o.

(defconstant p-BI  '<%pointer-byte-integer>)		
(defconstant p-SBI '<%pointer-signed-byte-integer>)
(defconstant p-UBI '<%pointer-unsigned-byte-integer>)		
(defconstant p-HI  '<%pointer-half-integer>)
(defconstant p-SHI '<%pointer-signed-half-integer>)
(defconstant p-UHI '<%pointer-unsigned-half-integer>)  ; bis hier hin s.o.

(defconstant r      '%general-register-place)
(defconstant rd     '%double-general-register-place)
(defconstant d      '<%direct-value-place>)
(defconstant fr     '%f-register-place)
(defconstant frd    '%double-float-register-place)
(defconstant frt    '%quad-float-register-place)
(defconstant ADR    '<mplace>)
(defconstant ADR1  '<address-expr1>)
(defconstant ADR1I  '<address-expr1-identifier>)
(defconstant ADROFI '<address-of-identifier>)

(defconstant pjmpbuf '<%pjmpbuf>)
(defconstant void '<%void>)

(defconstant %o0-grp
 ()) 
;;;  (make-instance '%general-register-place :rnumber %R8))   ;;**!!**
(defconstant %o1-grp 
  ())
;;; (make-instance '%general-register-place :rnumber %R9))   ;;**!!**

; Definition der Abkuerzungen fuer die zusammengesetzten
; Argumente befinden sich im File cdgprotin:
; l1part1 l2part1 lrpart1 l1part2 l2part2 lrpart2
; l1part3 l2part3 lrpart3 


; Begin Machine Description Call Protocols

(define-protocol

  ; setjmp and longjmp

  (%setjmp ((pjmpbuf) I) ((%o0-grp) %o0-grp) (? 1) (T ()) asm () 
        ("") ())
  (%longjmp ((pjmpbuf) void) ((%o0-grp) %o0-grp) (? 1) (T ()) asm () 
        ("") ())

  ; asm-operationen

  (%plus ((i i) i) ((r r) r) (1 1) (t ()) asm () 
         ("~%add ~A,~A,~A" l1 l2 lr) ())

  (%minus ((I I) I) ((R R) R) (1 1) (T ()) asm () 
          ("~%sub ~A,~A,~A" l1 l2 lr) ())

  (%neg ((I) I) ((R) R) (1 1) (T ()) asm () 
        ("~%sub %g0,~A,~A" l1 lr) ())

  (%mult ((i i) i) ((%o0-grp %o1-grp) %o0-grp) (? 2) (t ()) asm () 
         ("~%call .mul,2~%nop") ())

  (%div ((I I) I) ((%o0-grp %o1-grp) %o0-grp) (? 2) (T ()) asm () 
        ("~%call .div,2~%nop") ())

  (%mod ((I I) I) ((%o0-grp %o1-grp) %o0-grp) (? 1) (T ()) asm () 
        ("~%call .rem,2~%nop") ())

  (%not ((I) I) ((R) R) (1 1) (T ()) asm () 
        ("~%xor ~A,-1,~A" l1 lr) ())

  (%and ((I I) I) ((R R) R) (1 1) (T ()) asm () 
        ("~%and ~A,~A,~A" l1 l2 lr) ())

  (%or ((I I) I) ((R R) R) (1 1) (T ()) asm () 
       ("~%or ~A,~A,~A" l1 l2 lr) ())

  (%xor ((I I) I) ((R R) R) (1 1) (T ()) asm () 
        ("~%xor ~A,~A,~A" l1 l2 lr) ())

  (%lshiftl ((I I) I) ((R R) R) (1 1) (T ()) asm () 
            ("~%sll ~A,~A,~A" l1 l2 lr) ())
  
  (%ashiftl ((I I) I) ((R R) R) (1 1) (T ()) asm () 
            ("~%sll ~A,~A,~A" l1 l2 lr) ())

  (%lshiftr ((I I) I) ((R R) R) (1 1) (T ()) asm () 
            ("~%srl ~A,~A,~A" l1 l2 lr) ())
  
  (%ashiftr ((I I) I) ((R R) R) (1 1) (T ()) asm () 
            ("~%sra ~A,~A,~A" l1 l2 lr) ())

  (%rotatel ((I I) I) ((R R) R) (5 5) (T ()) asm () 
            ("~%sll ~A,~A,~A~%sub ~A,32,~A~%sub %g0,~A,~A~
              ~%srl ~A,~A,~A~%or ~A,~A,~A" 
             l1 l2 lr l2 l2 l2 l2 l1 l2 l1 l1 lr lr) ())

  (%rotater ((I I) I) ((R R) R) (5 5) (T ()) asm () 
            ("~%srl ~A,~A,~A~%sub ~A,32,~A~%sub %g0,~A,~A~
	      ~%sll ~A,~A,~A~%or ~A,~A,~A"
             l1 l2 lr l2 l2 l2 l2 l1 l2 l1 l1 12 l1 l1 lr lr) ())

  (%abs ((I) I) ((%o0-grp) %o0-grp) (? 1) (T ()) asm () 
        ("~%call _absi,1~%nop") ())


  (%sign-extend ((BI) I) ((R) R) (2 2) (T ()) asm () 
         ("~%sll ~A,24,~A~%sra ~A,24,~A" l1 lr lr lr) ())

  (%zero-extend ((BI) I) ((R) R) (2 2) (T ()) asm () 
         ("~%sll ~A,24,~A~%srl ~A,24,~A" l1 lr lr lr) ())

  (%citos ((I) SF) ((FR) FR) (9 1) (T ()) asm () 
          ("~%fitos ~A,~A" l1 lr) ())
  (%citod ((I) DF) ((FR) FRD) (5 1) (T ()) asm () 
          ("~%fitod ~A,~A" l1 lr) ())
  (%citox ((I) XF) ((FR) FRT) (? 1) (T ()) asm () 
          ("~%fitox ~A,~A" l1 lr) ())
  
  (%cstoi ((SF) I) ((FR) FR) (5 1) (T ()) asm () 
          ("~%fstoi ~A,~A" l1 lr) ())
  (%cstod ((SF) DF) ((FR) FRD) (5 1) (T ()) asm () 
          ("~%fstod ~A,~A" l1 lr) ())
  (%cstox ((SF) XF) ((FR) FRT) (? 1) (T ()) asm () 
          ("~%fstox ~A,~A" l1 lr) ())

  (%cdtoi ((DF) I) ((FRD) FR) (5 1) (T ()) asm () 
          ("~%fdtoi ~A,~A" l1 lr) ())
  (%cdtos ((DF) SF) ((FRD) FR) (5 1) (T ()) asm () 
          ("~%fdtos ~A,~A" l1 lr) ())
  (%cdtox ((DF) XF) ((FRD) FRT) (? 1) (T ()) asm () 
          ("~%fdtox ~A,~A" l1 lr) ())
  
  (%cxtoi ((XF) I) ((FRT) FR) (? 1) (T ()) asm () 
          ("~%fxtoi ~A,~A" l1 lr) ())
  (%cxtos ((XF) SF) ((FRT) FR) (? 1) (T ()) asm () 
          ("~%fxtos ~A,~A" l1 lr) ())
  (%cxtod ((XF) DF) ((FRT) FRD) (? 1) (T ()) asm () 
          ("~%fxtod ~A,~A" l1 lr) ())

  (%eq ((i i) ()) ((r r) ()) (3 3) (t ()) tasm () 
         ("~%subcc ~A,~A,%g0~%bne ~A~%nop" l1 l2 label) ())

  ; as default method !
  (%neq ((t t) ()) ((r r) ()) (3 3) (t ()) tasm () 
         ("~%subcc ~A,~A,%g0~%be ~A~%nop" l1 l2 label) ())

;  (%neq ((i i) ()) ((r r) ()) (3 3) (t ()) tasm () 
;         ("~%subcc ~A,~A,%g0~%be ~A~%nop" l1 l2 label) ())
;  ;inserted 1.6. *wh*
;  (%neq ((p p) ()) ((r r) ()) (3 3) (t ()) tasm () 
;        ("~%subcc ~A,~A,%g0~%be ~A~%nop" l1 l2 label) ())
;
;     ("~%fcmpx ~A,~A~%fbe ~A~%nop" l1 l2 label) ())

  (%gt ((i i) ()) ((r r) ()) (3 3) (t ()) tasm () 
         ("~%subcc ~A,~A,%g0~%ble ~A~%nop" l1 l2 label) ())
  ;inserted 1.6. *wh*
;  (%gt ((p p) ()) ((r r) ()) (3 3) (t ()) tasm () 
;       ("~%subcc ~A,~A,%g0~%ble ~A~%nop" l1 l2 label) ())
;
;  (%gt ((ui ui) ()) ((r r) ()) (3 3) (t ()) tasm () 
;         ("~%subcc ~A,~A,%g0~%bleu ~A~%nop" l1 l2 label) ())

  (%lt ((i i) ()) ((r r) ()) (3 3) (t ()) tasm () 
         ("~%subcc ~A,~A,%g0~%bge ~A~%nop" l1 l2 label) ())
       ;inserted 1.6. *wh*

  (%ge ((i i) ()) ((r r) ()) (3 3) (t ()) tasm () 
         ("~%subcc ~A,~A,%g0~%bl ~A~%nop" l1 l2 label) ())
  ;inserted 1.6. *wh*

  (%le ((i i) ()) ((r r) ()) (3 3) (t ()) tasm () 
         ("~%subcc ~A,~A,%g0~%bg ~A~%nop" l1 l2 label) ())
  ;inserted 1.6.*wh*
  (%le ((p p) ()) ((r r) ()) (3 3) (t ()) tasm () 
       ("~%subcc ~A,~A,%g0~%bg ~A~%nop" l1 l2 label) ())

  (%le ((ui ui) ()) ((r r) ()) (3 3) (t ()) tasm () 
         ("~%subcc ~A,~A,%g0~%bgu ~A~%nop" l1 l2 label) ())

  ; siehe Bemerkungen zu address-expr (Adresskonstanten)!
  (%move ((p) p) ((R) R) (3 1) (T ()) asm () 
         ("~%add %g0,~A,~A" l1 lr) ())


  
  ; p(seudo-)asm-operationen

  (%move-block ((P P I) ()) ((%o0-grp %o1-grp %o2-grp) ()) 
               (? 1) (T ()) pasm () 
               ("~%call _movebl,3~%nop") ())
  
  (%jmpl ((;function-pointer
           ) ()) (() ()) (3 1) (T ()) pasm () 
         ("~%jmpl ~A,15~%nop" (car arglist)) ())
  
  (%call ((;intern-name arg-counter
           ) ()) (() ()) (? 2) () pasm () 
         ("~%call ~A,~A~%nop" (car arglist) ; intern-name
                         (cadr arglist) ; arg-counter
                         ) ())
  (%make-commentline ((;comment-string
                       ) ()) (() ()) (0 0) 
                     () pasm () 
         ("~%! ~A" (car arglist) ; comment
                         ) ())
  (%make-code-segment (() ()) (() ()) (0 0) () pasm () 
         ("~%.seg \"text\"" ) ())
  (%make-data-segment (() ()) (() ()) (0 0) () pasm () 
         ("~%.seg \"data\"" ) ())
  (%make-proc-prolog ((;intern-name frame-length
                       ) 
                      ()) (() ()) (? 1) () pasm () 
         ("~%~%! function~%.align 4~%.proc 1~%~
             .global  ~A~%~A:~%save %sp,-~A,%sp"
          (car arglist) ;intern-name
          (car arglist) ;intern-name
          (cadr arglist);frame-lengt
          ) ())
  (%make-proc-epilog ((;return-label-name
                       ) ()) (() ()) (? 2) 
                     () pasm () 
         ("~%~A:~%ret~%restore"
          (car arglist) ;return-label-name
          ) ())
  (%label ((;name
            ) ()) (() ()) (0 0) () pasm () 
         ("~%~A:" (car arglist) ;name
          ) ())
  (%goto ((;name
           ) ()) (() ()) (2 1) () pasm () 
         ("~%b ~A~%nop" (car arglist) ;name
          ) ())
  )





#module-end





