;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: el2lzs-error -*-
#|
-----------------------------------------------------------------------------------
TITLE: Signalling errors, warnings and infos for specific situations detected by
       the frontend
-----------------------------------------------------------------------------------
File:    el2lzs-error.em
Version: 1.2 (last modification on Wed Oct 20 17:33:52 1993)
State:   proposed

DESCRIPTION:

DOCUMENTATION:

NOTES:

REQUIRES:

PROBLEMS:

AUTHOR:
Ingo Mohr

CONTACT: 
ingo.mohr@isst.fhg.de

HISTORY: 
Log for /tmp_mnt/net/saturn/apply/Dist/Apply/el2lzs-error.em[1.0]
	Wed Oct 20 14:04:17 1993 imohr@isst proposed $
 errors for the frontend
 
el2lzs-error.em[1.1] Wed Oct 20 14:23:57 1993 imohr@isst proposed $
 
el2lzs-error.em[1.2] Wed Oct 20 18:45:34 1993 imohr@isst proposed $
 

-----------------------------------------------------------------------------------
|#

;#|
#module-name el2lzs-error
#module-import
(level-1-eulisp
 lzs accessors
 debugging
 (only (error warn format
        floor length string
        initialize-instance)
   common-lisp))
#module-syntax-import 
(level-1-eulisp
 apply-standard)
#module-syntax-definitions

#module-header-end
;|# (in-package el2lzs-error)

;;; -----------------------------------------------------------------------------------
;;; 
;;; -----------------------------------------------------------------------------------
(export
  *frontend-errors*
  new-frontend-error
  reset-frontend-errors)

(defvar frontend-info-level 2)
(defvar frontend-system-info-level 1)
; 0 no infos, very short warnings and errors
; 1 very short infos
; 2 some infos
; 3 max number of infos

(deflocal *frontend-errors* 0)

(defun new-frontend-error ()
  (setq *frontend-errors* (+ 1 *frontend-errors*)))

(defun reset-frontend-errors ()
  (setq *frontend-errors* 0))

(defvar current-defining-form nil)

;;; -----------------------------------------------------------------------------------
;;; bindings
;;; -----------------------------------------------------------------------------------

(export 
  <binding>
  finally-refered-object
  get-lzs-object
  )

(defstandardclass <binding> ()
  (identifier :reader :initarg)
  (refers-to :reader :initarg)
  (refers-finally-to :accessor)
  :predicate)

(defmethod initialize-instance ((ref <binding>) . more)
  (call-next-method)
  (setf (?refers-finally-to ref) 
        (finally-refered-object (?refers-to ref)))
  ref)

(defgeneric finally-refered-object (obj))
(defmethod finally-refered-object (obj) obj)
(defmethod finally-refered-object ((obj <binding>))
  (?refers-to obj))

(defmethod ?exported ((ref <binding>))
  (?exported (?refers-finally-to ref)))

(defun get-lzs-object (object)
  ;; get-lzs-object returns the object finally refered to if object is a
  ;; renamed object or otherwise returns its argument 
  (if (binding-p object)
    (?refers-finally-to object)
    object))

;;; -----------------------------------------------------------------------------------
;;; general
;;; -----------------------------------------------------------------------------------

(deflocal *line-length* 75)

(defun write-message (key message . args)
  (when (eq key ^error) (new-frontend-error))
  (when key
    (let ((header 
           (format nil "~A~@[ in module '~(~A~)'~]~@[ in ~((~2{~A ~} ...)~)~]"
                   key
                   (if (dynamic *current-module*)
                     (?identifier (dynamic *current-module*))
                     nil)
                   (dynamic current-defining-form))))
      (format t "~%~3{-~} ~A ~V{-~}~%"
            '(())
            header
            (- *line-length* (length header) 5)
            '(())
            )))
  (format t "~?" message args)
  (when key (format t "~%~V{-~}" *line-length* '(()))))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-main
;;; -----------------------------------------------------------------------------------

(export 
  error-bad-c-import-spec
  error-bad-module-directive 
  error-no-lexical-binding
  error-name-clash
  error-bad-old-style-syntax-import 
  info-old-style-module-header
  error-invalid-syntax)

(defvar error-if-no-lexical-found t)

(defun error-no-lexical-binding (id)
  (when (dynamic error-if-no-lexical-found)
    (write-message ^error "no lexical binding found for ~A" id)) 
  nil)

(defun error-bad-c-import-spec (file)
  (write-message ^error "bad filespec in c-import directive: ~S" file))

(defun error-bad-module-directive (key value)
  (write-message ^error "bad module directive: ~A ~@[~A~]" key value))

(defun error-bad-old-style-syntax-import (import-spec)
  (write-message ^error "bad old style syntax import specification: ~A" import-spec))

(defgeneric error-name-clash (binding1 binding2))
(defmethod error-name-clash (binding1 binding2)
  (write-message ^error "name clash: attempt to import ~A ~@
                         from modules ~A and ~A"
                 (?identifier binding1)
                 (?module-id binding1)
                 (?module-id binding2)))
(defmethod error-name-clash ((binding1 <binding>) (binding2 <binding>))
  (write-message ^error "name clash: attempt to import under ~A~@
                         ~A from ~A and ~@
                         ~A from ~A"
                 (?identifier binding2)
                 (?identifier (?refers-finally-to binding1))
                 (?module-id (?refers-finally-to binding1))
                 (?identifier (?refers-finally-to binding2))
                 (?module-id (?refers-finally-to binding2))
                 ))
(defmethod error-name-clash ((binding1 <binding>) binding2)
  (write-message ^error "name clash: attempt to import under ~A~@
                         ~A from ~A and ~@
                         ~A from ~A"
                 (?identifier binding2)
                 (?identifier (?refers-finally-to binding1))
                 (?module-id (?refers-finally-to binding1))
                 (?identifier binding2)
                 (?module-id binding2)
                 ))
(defmethod error-name-clash (binding1 (binding2 <binding>))
  (error-name-clash binding2 binding1))

(defmethod info-old-style-module-header (module-def)
  (write-message nil "~[~;~:;[old style]~]" (dynamic frontend-info-level)))

(defun error-invalid-syntax (syntax expr)
  (write-message ^error "invalid syntax for '~(~A~)':~%~(~A~)" 
                 (car syntax) expr))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-load
;;; -----------------------------------------------------------------------------------
(export 
  error-invalid-module-definition
  warning-differing-names-for-module-and-file
  info-loading-module
  info-module-loaded
  error-connot-find-file
  error-connot-load-file
  error-connot-open-file)

(defun error-invalid-module-definition (object path)
  (write-message ^error "invalid module definition in ~A" path))

(defun warning-differing-names-for-module-and-file (module-name path)
  (write-message ^warning "modulename ~A differs from filename ~A" 
               (second module-source)
               path))

(defvar *load-level* 0)

(defun info-loading-module (path)
  (write-message nil 
                 "~[~;.~:;~%;~V@{.~}loading module ~A~]" 
                 (dynamic frontend-info-level)
                 (- (dynamic *load-level*) 1) path))

(defun info-module-loaded (module-name)
  (write-message nil
                 "~[~;~;~;~%;~V@{.~}apply module ~A loaded~]" 
                 (dynamic frontend-info-level)
                 (- (dynamic *load-level*) 1) 
                 module-name))

(defun error-connot-find-file (name)
  (write-message ^error "can't find Apply module ~A" name))

(defun error-connot-load-file (path)
  (write-message ^error "can't load Apply module ~A" path))

(defun error-connot-open-file (path)
  (write-message ^error "can't open Apply module ~A" path))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-classes
;;; -----------------------------------------------------------------------------------
(export 
  error-bad-class-options
  error-mm-type-unknown-at-compile-time
  error-invalid-mm-type
  error-class-equal-lattice-type 
  error-neither-class-nor-lattice-type)

(defun error-bad-class-options (options)
  (write-message ^error "bad class option in ~A" options))

(defun error-mm-type-unknown-at-compile-time (value)
  (write-message ^error 
                 "Value of ~A must be known at compile time ~
                  when used for class option 'mm-type'" value))

(defun error-invalid-mm-type (value)
  (write-message ^error 
                 "Bad value for class option 'mm-type': ~A" value))

(defun error-class-equal-lattice-type (id)
  (write-message ^error 
                 "A class and a lattice type with the name ~A are found.~
                  Using the class." id))

(defun error-neither-class-nor-lattice-type (id)
  (write-message 
   ^error 
   "Neither a class nor a lattice type with the name ~A are found."
   id))

;;; -----------------------------------------------------------------------------------
;;; used by el2lzs-generic
;;; -----------------------------------------------------------------------------------
(export warn-defgeneric-options-not-analyzed)

(defun warn-defgeneric-options-not-analyzed (options)
  (write-message ^warn 
                 "options in defgeneric not yet analyzed: ~A" 
                 options))



#module-end
