;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: code-generator -*-
#|
-----------------------------------------------------------------------------------
TITLE: a very short characterisation of the content
-----------------------------------------------------------------------------------
File:    code-generator.em
Version: 1.9 (last modification on Fri Sep 24 11:12:27 1993)
State:   proposed

DESCRIPTION:
the description of the content

DOCUMENTATION:
where an external documentation can be found (filename and format, title of a
paper ...)

NOTES:
remarks about future extensions ...

REQUIRES:
ressources which are used but can't be declared in the import section

PROBLEMS:
known problems or errors that are not yet eliminated

AUTHOR:
the original author

CONTACT: 
the person which is currently responsible for this file

HISTORY: 
Log for /export/home/saturn/imohr/Lisp/Apply/code-generator.em[1.0]
	Fri May 21 12:41:35 1993 imohr@isst save $
 general part of a simple code generator for SPARC
 
code-generator.em[1.1] Thu May 27 14:43:41 1993 hfried@isst proposed $
 [Thu May 27 12:57:29 1993] Intention for change:
 + code generation for functions oder so wat
 aaa
 done
 
code-generator.em[1.2] Thu Jun  3 09:10:08 1993 imohr@isst proposed $
 [Thu Jun  3 08:18:38 1993] Intention for change:
 code output on screen when debugging
 
code-generator.em[1.3] Thu Jun  3 10:28:11 1993 imohr@isst proposed $
 [Thu Jun  3 10:24:32 1993] Intention for change:
 close of .s-file only when not in debugging mode
 
code-generator.em[1.4] Thu Aug  5 09:36:58 1993 imohr@isst proposed $
 [Mon Jul 19 08:26:31 1993] Intention for change:
 + c-code generation
 C-code generation
 
code-generator.em[1.5] Tue Aug 17 14:24:14 1993 imohr@isst proposed $
 
code-generator.em[1.6] Fri Aug 20 07:57:40 1993 imohr@isst proposed $
 [Tue Aug 17 14:30:02 1993] Intention for change:
 --- no intent expressed ---import of apply-configuration
 
code-generator.em[1.7] Thu Aug 26 09:51:30 1993 imohr@isst proposed $
 [Tue Aug 24 11:40:26 1993] Intention for change:
 c-code for data
 ok
 
code-generator.em[1.8] Mon Aug 30 16:45:28 1993 imohr@isst published $
 [Mon Aug 30 13:58:15 1993] Intention for change:
 - reset-c-data
 + configuration
 configuration not yet included
 
code-generator.em[1.9] Mon Sep 27 11:17:49 1993 imohr@isst proposed $
 [Fri Sep 24 11:09:25 1993] Intention for change:
 deactivate asm-code generation
 

-----------------------------------------------------------------------------------
|#

#module-name code-generator
#module-import
(level-1-eulisp
 apply-configuration
 accessors lzs
 c-code
 c-data
#| temporary not activated
 asm-ops
 codegen-data
 static-allocation
 program-code
|#
 debugging
 (only (*print-circle* *print-pretty*
        open make-pathname string-downcase string mapc)
   common-lisp))
#module-syntax-import 
(level-1-eulisp)
#module-syntax-definitions

;; local macro definitions

#module-header-end

(export generate-code)

(defvar code-output t)

(defun generate-code (main-module modules)
  (let ((*print-circle* nil)
        (*print-pretty* nil))
    (dynamic-let ((code-output
                   (if (code-debug) t
                       (open (make-pathname :name (string-downcase 
                                                   (string 
                                                    (?identifier main-module)))
                                            :type (if (eq *code-generation* :c)
                                                    "c" "s"))
                         :direction :output :if-exists :new-version)))
                  (*label* nil)
                  (*comment* nil)
                  (*label-comment* nil)
                  (*align* nil)
                  (*alignment* 1)
                  )
       (unwind-protect 
         (if (eq *code-generation* :c)
           (progn                                       ;generate C-code
             (generate-c-code main-module modules)
             (unless (code-debug)
               (close (dynamic code-output))
               (dynamic-setq code-output
                             (open (make-pathname :name (string-downcase 
                                                         (string 
                                                          (?identifier main-module)))
                                                  :type "inst")
                                   :direction :output :if-exists :new-version)))
             (generate-c-data)
             )
#| temporary not activated
           (progn                                       ;generate asm-code
             (mapc #'generate-code-for-module-data      ; writes code for variables to
                   modules)                             ; code-output and collects
                                                        ; data definitions using
                                                        ; static-allocate 
             (mapc #'generate-code-for-module-functions ; writes code for functions
                   modules)                             ; to code-output
             (comment-line "static instances")
             (write-static-cards)                       ; writes code for static
                                                        ; instances collected during the
                                                        ; preceding two steps
             )
|#         nil
           )
         (unless (eq (dynamic code-output) t) 
           (close (dynamic code-output)))))))

#| temporary not activated

(defun generate-code-for-module-data (module)
  (mapc #'generate-code-for-global-data (?class-def-list module))
  (mapc #'generate-code-for-global-data (?sym-list module))
  (when (?named-const-list module)
    (comment-line "named-constants of module ~A" (?identifier module))
    (.seg ^data)
    (mapc #'generate-code-for-global-data (?named-const-list module)))
  (when (?var-list module)
    (comment-line "global-variables of module ~A" (?identifier module))
    (.seg ^data)
    (mapc #'generate-code-for-global-data (?var-list module)))
  )

(defun generate-code-for-module-functions (module)
  (.seg ^text)
  (comment-line "functions of module ~A" (?identifier module))
  (generate-program-code-4-module module)
  )

|#

#module-end ; code-generator
