;;;-*- Mode: Lisp; Syntax: Common-Lisp; Base: 10; Package: cleartypes -*-
#|
-----------------------------------------------------------------------------------
TITLE: balanced all types and add types to move-statements 
-----------------------------------------------------------------------------------
File:    cleartypes.em
Version: 1.16 (last modification on Thu Oct 14 09:08:42 1993)
State:   proposed

DESCRIPTION:
DOCUMENTATION:
NOTES:
REQUIRES:
PROBLEMS:
AUTHOR: Dr. Horst Friedrich
CONTACT: horst.friedrich@isst.fhg.de

HISTORY: 
Log for /tmp_mnt/home/saturn/akind/Lisp/Apply/cleartypes.em[1.0]
	Fri Mar  5 13:01:10 1993 hfried@isst save $
 text
 
cleartypes.em[1.1] Thu Mar 18 08:59:29 1993 hfried@isst proposed $
 [Fri Mar  5 13:03:15 1993] Intention for change:
 
cleartypes.em[1.2] Wed Mar 24 13:48:03 1993 hfried@isst proposed $
 [Thu Mar 18 09:10:58 1993] Intention for change:
 + glob anna
 
cleartypes.em[1.3] Thu Mar 25 11:19:03 1993 hfried@isst proposed $
 [Wed Mar 24 14:52:55 1993] Intention for change:
 + gen-fun
 new head
 
cleartypes.em[1.4] Fri Mar 26 09:24:58 1993 hfried@isst proposed $
 [Thu Mar 25 11:53:49 1993] Intention for change:
 generic-function wird uebergangen !!
 
cleartypes.em[1.5] Tue Apr 13 14:08:47 1993 hfried@isst proposed $
 [Fri Mar 26 09:26:12 1993] Intention for change:
 
cleartypes.em[1.6] Tue Apr 27 09:34:28 1993 hfried@isst proposed $
 [Tue Apr 13 14:15:06 1993] Intention for change:
 balance umgeschrieben
 
cleartypes.em[1.7] Tue Apr 27 13:20:04 1993 hfried@isst proposed $
 [Tue Apr 27 09:35:34 1993] Intention for change:
 !! balance umgeschrieben
 balance bei moves eingefuegt
 
cleartypes.em[1.8] Thu May 27 09:37:19 1993 hfried@isst proposed $
 [Thu May 27 09:21:44 1993] Intention for change:
 moves
 
cleartypes.em[1.9] Fri May 28 08:29:25 1993 hfried@isst proposed $
 [Fri May 28 08:09:08 1993] Intention for change:
 ) zuviel
 ) entfernt
 
cleartypes.em[1.10] Wed Jun  2 09:07:25 1993 hfried@isst proposed $
 [Wed Jun  2 08:53:57 1993] Intention for change:
 prints einbauen
 druch .
 
cleartypes.em[1.11] Mon Jun 21 11:39:20 1993 hfried@isst save $
 [Fri Jun 18 15:39:39 1993] Intention for change:
 
cleartypes.em[1.12] Tue Jun 29 10:49:05 1993 hfried@isst proposed $
 [Tue Jun 29 10:47:41 1993] Intention for change:
 balance auch auf Funktionen!
 
cleartypes.em[1.13] Wed Aug 18 11:47:02 1993 hfried@isst published $
 [Tue Aug 10 08:29:23 1993] Intention for change:
 get-move-var-type entfernen
 
cleartypes.em[1.14] Tue Sep 21 13:09:06 1993 hfried@isst proposed $
 [Mon Sep 20 07:58:53 1993] Intention for change:
 multiple assignment
 
cleartypes.em[1.15] Tue Sep 21 13:38:41 1993 hfried@isst proposed $
 [Tue Sep 21 13:38:24 1993] Intention for change:
 
cleartypes.em[1.16] Fri Oct 15 07:43:15 1993 hfried@isst proposed $
 [Wed Oct 13 07:54:08 1993] Intention for change:
 add convert-to-sys-type-vec
 

-----------------------------------------------------------------------------------
|#

#module-name cleartypes
#module-import 
( level-1-eulisp
  LZS
  MZS
  type-inference
  ti-signature ; convert-to-sys-type-vec
  vector
  (only (mapc format) common-lisp)
 )


#module-syntax-import 
( level-1-eulisp )
#module-syntax-definitions

;--- defmacro forms

#module-header-end

;       ###########
(export clear-types)
;       ###########

(defvar move-vars ())
(defvar generic-calls ())

(defun clear-types (fun)
  (if (and (simple-fun-p fun) (= (?pass fun) 3))
    (let ((calls (?calls fun))
          (tests (?tests fun))
          (moves (?moves fun)))
      (format t ".") ; for debug
      (if (?type-descr-s fun)
        (setf (?type-descr fun)
              (balance (car (?type-descr-s fun))
                        (cdr (?type-descr-s fun))))
        ())
      (dynamic-let ((move-vars ())
                    (generic-calls ()))
                   (mapc #'balance-and-clear-types-calls calls)
                   (mapc #'balance-and-clear-types tests)
                   (mapc #'handle-moves moves)
                   (balance-multiple-assignment (dynamic move-vars))
                   (optimize-generic-calls (dynamic generic-calls)))
      ; convert to sys-types
      (setf (?type-descr fun)
            (if (?range-and-domain fun)
              (?range-and-domain fun)
              (convert-to-sys-type-vec (?type-descr fun))))
      (mapc #'convert-types calls)
      (mapc #'convert-types tests)
      (mapc #'convert-types moves)
      )
    ())
)

(defun convert-types (stat)
  (setf (?type-descr stat)
        (convert-to-sys-type-vec
         (?type-descr stat))))

(defun optimize-generic-calls (call-list)
  (if call-list
      call-list
    ; (format t "~% Generic-calls ~s" call-list)
    ()))

(defun balance-multiple-assignment (vars)
  (if vars
    (progn
      (balance-multiple-assignment-var (car vars))
      (balance-multiple-assignment (cdr vars)))
    ()))

(defun balance-multiple-assignment-var (var)
  (set-joined-result-types (collect-assignment (?link var))))

;(defun union-result-types (list-of-td)
;  (format t "~% Union ~s " list-of-td))

(defun collect-assignment (link)
  (if link
    (if (eq (cdr (car link)) 0)
      (cons (?type-descr (car (car link)))
            (collect-assignment (cdr link)))
      (collect-assignment (cdr link)))
    ()))
      

(defun balance-and-clear-types (stat)
  (setf (?type-descr stat)
         (balance (car (?type-descr-s stat)) 
                  (cdr (?type-descr-s stat))))
  (setf (?type-descr-s stat) ())
)

(defun balance-and-clear-types-calls (call)
  (setf (?type-descr call)
         (balance (car (?type-descr-s call)) 
                  (cdr (?type-descr-s call))))
  (if (and (generic-fun-p (?function call))
           (null (member call (dynamic generic-calls))))
    (dynamic-setq generic-calls (cons call (dynamic generic-calls)))
    ())
  (setf (?type-descr-s call) ())
)

(defun handle-moves (move) ; *hf* 27.05
  (let ((tds (?type-descr-s move))
        (td (?type-descr move))
        (var (vector-ref (?var-vec (?var-descr move)) 0)))
    (if tds
      (setf (?type-descr move)
            (balance (car tds) (cdr tds)))
      (setf (?type-descr move)
            (balance td ())))
    (if (and (or (tempvar-p var)
                 (local-static-p var))
             (null (member var (dynamic move-vars)))
             (more-than-one-assignment (?link var)))
      (dynamic-setq move-vars (cons var (dynamic move-vars)))
      ()))
  (setf (?type-descr-s move) ())
)

(defun more-than-one-assignment (link)
  (if link
    (if (eq (cdr (car link)) 0)
      (more-than-one-assignment-aux (cdr link))
      (more-than-one-assignment (cdr link)))
    ()))

(defun more-than-one-assignment-aux (link)
  (if link
    (if (eq (cdr (car link)) 0)
      t
      (more-than-one-assignment-aux (cdr link)))
    ()))
                    
#module-end