/*

   sys.c

   Copyright, 1994, Joseph N. Wilson.  All Rights Reserved.
   
   Permission to use, copy, and modify this software and its
   documentation is hereby granted only under the following terms and
   conditions.  Both the above copyright notice and this permission
   notice must appear in all copies of the software, derivative works
   or modified version, and both notices must appear in supporting
   documentation.  Users of this software agree to the terms and
   conditions set forth in this notice.

*/

#include "prim.h"
#include "number.h"
#include "string.h"
#include "sys.h"
#include "values.h"



Object get_ctime();
Object get_time();
Object get_clock();
static struct primitive sys_prims[] =
{
    {"ctime", prim_0, get_ctime},
    {"time", prim_0, get_time},
    {"clock", prim_0, get_clock},
};

void 
init_sys_prims (void)
{
  int num;

  num = sizeof (sys_prims) / sizeof (struct primitive);
  init_prims (num, sys_prims);
}

Object get_ctime()
{
    time_t time_loc;
    (void)time(&time_loc);
    return make_byte_string (ctime (&time_loc));
}

Object get_time()
{
    time_t time_loc;

    (void)time(&time_loc);
    
#ifndef SMALL_OBJECTS
    time_loc = abs((int)time_loc);
#else
    time_loc = abs((int)(time_loc <<2)) >> 2;
#endif

    return make_integer (time_loc);
}

Object get_clock()
{
    clock_t clock_val;
    clock_val = clock();

#ifndef SMALL_OBJECTS
    clock_val = abs((int)clock_val);
#else
    clock_val = abs((int)(clock_val<< 2)) >>2;
#endif

    return make_integer (clock_val);
}

