/*
   
   foreign.c - foreign function interface

   Copyright, 1993, Brent Benson.  All Rights Reserved.
   
   Permission to use, copy, and modify this software and its
   documentation is hereby granted only under the following terms and
   conditions.  Both the above copyright notice and this permission
   notice must appear in all copies of the software, derivative works
   or modified version, and both notices must appear in supporting
   documentation.  Users of this software agree to the terms and
   conditions set forth in this notice.

*/

#include "foreign.h"
#include "prim.h"

static Object load_foreign (Object name);

static struct primitive foreign_prims[] =
{
  {"%load_foreign", prim_1, load_foreign},
}

void 
init_foreign_prims (void)
{
  int num;

  num = sizeof (foreign_prims) / sizeof (struct primitive);
  init_prims (num, foreign_prims);
}

#ifdef DLOPEN
#include <dlfcn.h>

static Object 
load_foreign (Object name)
{
  char *filename;
  void *handle;

  filename = BYTESTRVAL (name);
  handle = dlopen (filename, RTLD_LAZY);
  if (! handle)
    {
      error ("load-foreign: could not load file", name, NULL);
    }
  return (make_integer ((int)handle));
}
#endif /* DLOPEN */
