/*

   eval.c

   Copyright, 1993, Brent Benson.  All Rights Reserved.
   0.4 Revisions Copyright 1994, Joseph N. Wilson.  All Rights Reserved.
   
   Permission to use, copy, and modify this software and its
   documentation is hereby granted only under the following terms and
   conditions.  Both the above copyright notice and this permission
   notice must appear in all copies of the software, derivative works
   or modified version, and both notices must appear in supporting
   documentation.  Users of this software agree to the terms and
   conditions set forth in this notice.

*/

#include "eval.h"
#include "env.h"
#include "syntax.h"
#include "apply.h"
#include "list.h"
#include "error.h"

/* local function prototypes */
static Object eval_combination (Object obj);

/* function definitions */

Object 
eval (Object obj)
{
  Object val;

#ifdef SMALL_OBJECTS
  if (INTEGERP(obj) || IMMEDP(obj))
    {
      return (obj);
    }
#endif

#ifdef SMALL_OBJECTS
  switch (POINTERTYPE (obj))
#else
  switch (TYPE (obj))
#endif
    {
    case True:
    case False:
    case Integer:
    case Ratio:
    case SingleFloat:
    case DoubleFloat:
    case ByteString:
    case SimpleObjectVector:
    case Keyword:
    case Character:
    case EndOfFile:
    case EmptyList:		/* is this right? */
      return (obj);
    case Symbol:
      val = symbol_value (obj);
      if (! val)
	{
	  error ("unbound variable", obj, NULL);
	}
      return (val);
    case Pair:
      return (eval_combination (obj));
    default:
      error ("eval: do not know how to eval object", obj, NULL);
    }
}

static Object
eval_combination (Object obj)
{
  Object op;
  syntax_fun sf;
  Object fun, args;

  op = CAR (obj);
  if (sf = syntax_function (op))
    {
      return ((*sf)(obj));
    }
  else
    {
      fun = eval (CAR (obj));
      args = map (eval, CDR (obj));
      return (apply (fun, args));
    }
}
