/* Header File for Territory Handling
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: territory.h,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/28 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.3 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

typedef struct _territory_entry	territory_entry;
typedef struct _territory_entry	TERRITORY;

typedef struct _x_color_entry	x_color_entry;
struct _x_color_entry {
    bool xcUsePixel;
    x_color xcPixel;
    Pixmap xcPixmap;
} ;

struct _root_territory_entry {
    territory_entry *rtSelectedTerritory;
    territory_entry *rtCurrentCursor;
};

struct _cursor_ent {
    Cursor csFont;
    Pixmap csPattern;
    Pixmap csMask;
    int hot_x, hot_y;
};

struct _territory_keyin_entry {
    int kiFree;
} ;
struct _keyin_buf {
    struct _keyin_buf *kiNext;
    int kiFree;
    int kiLeng;
    char *kiCur;
    char kiBuf[KEYINPUTBUFLEN];
} ;

struct _keyin_entry {
    bool inSelected;
    struct _keyin_buf inRawData;
    struct _keyin_buf inCookData;
} ;

/************************************************
 ************************************************/

typedef u_int	TRID;
typedef u_int	TREVENTMASK;

struct _territory_type {
    bool ttVisible;
    bool ttDrawable;
    int ttTRMode;
    int ttTRType;
} ;
typedef struct _territory_type	TRTYPE;

#define TR_TYPE		0377
#define TR_NONE		0001
#define TR_PAGE		0002
#define TR_VIEWPORT	0004
#define TR_FENCE	0010
#define TR_SPLITE	0020
#define TR_CURSOR	0040
#define TR_ALL		(TR_NONE|TR_PAGE|TR_VIEWPORT|TR_FENCE|TR_SPLITE|TR_CURSOR)
#define TR_VISIBLE	(TR_NONE|TR_PAGE|TR_VIEWPORT|TR_FENCE|TR_SPLITE)
#define TR_DRAWABLE	(TR_PAGE|TR_VIEWPORT|TR_SPLITE|TR_CURSOR)


struct _territory_control_func_table {
    int TerritoryType;
    void (*TerritoryCreateFunc)();
    void (*TerritoryMoveFunc)();
    void (*TerritoryResizeFunc)();
    void (*TerritoryReparentFunc)();
    void (*TerritoryClearFunc)();
} ;
typedef struct _territory_control_func_table	CTRLFUNCS;

#ifdef NO_IPA

struct _territory_splite_control {
    int dummy;
} ;
typedef struct _territory_splite_control	TERRITORY_SPLITE;

#endif

#ifndef IPA
#include "splite.h"
#endif

struct _territory_cursor_control {
    Cursor ccCursor;	/* Cursor Font */
    Pixmap ccPattern;	/* Cursor Pattern */
    Pixmap ccMask;	/* Cursor Pattern Mask */
    int ccHotX, ccHotY;	/* Hot Spot */
} ;
typedef struct _territory_cursor_control	TERRITORY_CURSOR;

typedef struct _yy_font_info YYFONT;
struct keyin_control {
    int kcLeng;
    char *kcStr;
} ;

#include "page.h"

struct _territory_fence_control {
    int dummy;
} ;
typedef struct _territory_fence_control		TERRITORY_FENCE;

#include "animation.h"
struct _territory_viewport_control {
    YYANIMATIONFRAMEFOLDER *vcFrameFolder;
} ;
typedef struct _territory_viewport_control	TERRITORY_VIEWPORT;

struct _territory_entry {
    TRID teID;
    TRTYPE teType;
    struct _territory_control {
	int tcWidth, tcHeight;
	int tcXOrigin, tcYOrigin;
	int tcXforParent, tcYforParent;	/* Location of LT-Edge for Parent */
	int tcXforRoot, tcYforRoot;	/* Location of LT-Edge for Root */
	TREVENTMASK tcEventMask;
	CTRLFUNCS *tcCtrlFuncs;
	/* Relationship with other territories */
	TERRITORY *tcParent;
	TERRITORY *tcChildren;
	TERRITORY *tcNextGen;
	TERRITORY *tcPrevGen;
    } teControlEnt;
    struct _territory_X_entry {
	Window txWindow;
	Pixmap txPixmap;
	GC txGC;
	Cursor txDefCursor;
	x_color_entry txForeGroundColor;
	x_color_entry txBackGroundColor;
	/* ĤΥȥϥޥܥ Press/Release Ͽ */
	int txEventNum;			/* Press/Release Ͽ */
	XEvent txEventRecord[8];	/* Press/Release εϿ */
    } teXEnt;
    union {
	struct _territory_splite_control tSpliteControl;
	struct _territory_cursor_control tCursorControl;
	struct _territory_page_control tPageControl;
	struct _territory_fence_control tFenceControl;
	struct _territory_viewport_control tViewPortControl;
    } teModeEnt;
    struct _territory_keyin_entry teKeyInput;	/* KeyIN Queue */
    /* The following Two Entries are Active on the Root Territory */
    TERRITORY *teActiveTerritory;
    TERRITORY *teActiveCursor;
    /* Link Entry */
    TERRITORY *teNext;
    TERRITORY *tePrev;
} ;
typedef struct _territory_X_entry	TERRITORY_X_ENTRY;

#define XEntry(tr)		(&((tr)->teXEnt))
#define GetTerritoryXEntry(tr)	(XEntry(tr))
#define GetParentTerritory(tr)	((tr)->teControlEnt.tcParent)

#define GetSpliteTerritoryEnt(tr)	(&(tr)->teModeEnt.tSpliteControl)
#define GetCursorTerritoryEnt(tr)	(&(tr)->teModeEnt.tCursorControl)
#define GetPageTerritoryEnt(tr)		(&(tr)->teModeEnt.tPageControl)
#define GetFenceTerritoryEnt(tr)	(&(tr)->teModeEnt.tFenceControl)
#define GetViewPortTerritoryEnt(tr)	(&(tr)->teModeEnt.tViewPortControl)

#define teX			teControlEnt.tcXforParent
#define teY			teControlEnt.tcYforParent
#define teXOrigin		teControlEnt.tcXOrigin
#define teYOrigin		teControlEnt.tcYOrigin
#define teWidth			teControlEnt.tcWidth
#define teHeight		teControlEnt.tcHeight
#define teEventMask		teControlEnt.tcEventMask
#define teCtrlFuncs		teControlEnt.tcCtrlFuncs
#define teParent		teControlEnt.tcParent
#define teChildren		teControlEnt.tcChildren
#define teNextGen		teControlEnt.tcNextGen
#define tePrevGen		teControlEnt.tcPrevGen

#define teDefCursor		teXEnt.txDefCursor
#define teEventNum		teXEnt.txEventNum
#define teEventRecord		teXEnt.txEventRecord

#define teTRType		teType.ttTRType
#define teDrawable		teType.ttDrawable
#define IsDrawableTerritory(TR)	((TR)->teType.ttDrawable)
#define IsDrawable(TR)		((TR)->teType.ttDrawable)
#define teVisible		teType.ttVisible
#define IsVisibleTerritory(TR)	((TR)->teType.ttVisible)
#define IsVisible(TR)		((TR)->teType.ttVisible)

TERRITORY *create_territory();
void display_territory();
void move_territory();
void resize_territory();
bool destroy_territory();
void reparent_territory();
void raise_territory();
void lower_territory();
void clear_territory();
void draw_background();

#define NULLTERRITORY(tr)	((tr) == (territory_entry *)NULL)

extern territory_entry *search_territory();
extern territory_entry *search_territory_from_win();
extern territory_entry *change_selected_territory();
extern territory_entry *selected_territory();
extern territory_entry *get_specified_territory();
extern territory_entry *catch_territory();

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
