/*
 */


#ifndef lint
static char *RcsId =
    "$Id: schedule.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
****************************************************************************/

/****************************************************************************
#
# $Revision: 3.0 $
#			$Date: 1992/10/08 04:59:44 $
# Log:
#  Version 1.0 is written by Keisuke 'Keiko' Tanaka
#					(keisuke@csrl.aoyama.ac.jp)
# 
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include "yydefs.h"
#include "yydefault.h"
#include "yypacket.h"
#include "sched.h"



/**********************************************************************
 *****
 ***** YYonX 塼ˤΤΥȥ
 *****
 **********************************************************************/



struct yysched_ctrl_table {
    struct yysched_ctrl_block *sctCtrlBlock;
    YYSCHED sctSchedEnt;
};
struct yysched_ctrl_block {
    struct yysched_ctrl_block *scbPrev, *scbNext;
    int scbUsedNum;
    struct yysched_ctrl_table *scbFreeTop;
    struct yysched_ctrl_table scbEntries[15];
};

static struct yysched_ctrl_block *YYSchedControlBlock
    = (struct yysched_ctrl_block *)NULL;

static struct yysched_ctrl_block *yysched_alloc_ctrl_block()
{
    struct yysched_ctrl_block *n; /* դ ControlBlock */
    register struct yysched_ctrl_table *t;
    register int loop;
    n = (struct yysched_ctrl_block *)
	calloc(1,sizeof(struct yysched_ctrl_block));
    t = n->scbFreeTop = &n->scbEntries[0];
    for (loop = 14; loop > 0 ; loop--, t++) {
	t->sctCtrlBlock = n;
	t->sctSchedEnt.shNext = (YYSCHED *)(t+1);
    }
    t->sctCtrlBlock = n;
    return n;
}

static YYSCHED *yysched_alloc_entry()
{
    register struct yysched_ctrl_block *blk;
    register struct yysched_ctrl_table *tbl;

    /* ControlBlock ̤ξ翷˳Ƥ */
    if ((blk = YYSchedControlBlock) == (struct yysched_ctrl_block *)NULL)
	blk = YYSchedControlBlock = yysched_alloc_ctrl_block();
    /* ̤ΰäƤ ControlBlock õ */
    for ( ; blk->scbFreeTop == (struct yysched_ctrl_table *)NULL;
	 blk = blk->scbNext) {
	if (blk->scbNext == (struct yysched_ctrl_block *)NULL) {
	    blk->scbNext = yysched_alloc_ctrl_block();
	    blk->scbNext->scbPrev = blk;
	}
    }
    /* Free ƬФ */
    tbl = blk->scbFreeTop;
    blk->scbFreeTop = (struct yysched_ctrl_table *)tbl->sctSchedEnt.shNext;
    blk->scbUsedNum++;
    return &tbl->sctSchedEnt;
}

/* void yysched_free_entry(p)
 *
 * p Ǽ륹塼楨ȥ̤Ѿ֤ˤ
 */
static void yysched_free_entry(p)
    YYSCHED *p;
{
    register struct yysched_ctrl_block *blk;
    register struct yysched_ctrl_table *tbl;

    /* p 餳ΰ ControlTable Ȥ
     * ControlBlock  */
    tbl = (struct yysched_ctrl_table *)((char *)p - sizeof(tbl->sctCtrlBlock));
    blk = tbl->sctCtrlBlock;

    /* ControlTable ̤ΰȤ
     * η̤ȤơControlBlock ٤̤ΰȤʤäˤϡ
     *  ControlBlock  free Ƥޤ
     * â ControlBlock ǸΰĤǤˤ
     * free ϹԤʤ鷺 alloc_entry 
     */
    blk->scbUsedNum--;
    if (blk->scbUsedNum > 0) {
	/* p  FreeList Ƭ֤ */
	p->shNext = (YYSCHED *)blk->scbFreeTop;
	blk->scbFreeTop = tbl;
    } else if (YYSchedControlBlock->scbNext != NULL) {
	if (blk->scbNext != NULL) blk->scbNext->scbPrev = blk->scbPrev;
	if (blk->scbPrev != NULL) blk->scbPrev->scbNext = blk->scbNext;
	else			YYSchedControlBlock = blk->scbNext;
	cfree((char *)blk);
    }
    /*NoReturnValue*/
}


/**********************************************************************
 *****
 ***** ̥塼ؿ
 *****
 **********************************************************************/

/* a  b ȤκƤ msec ɽ
 */
static long tv_sub(a,b)
    register struct timeval *a, *b;
{
    register long delay;
    DebugSetFunc("schedule", "tv_sub");
    delay = a->tv_sec - b->tv_sec;
    if (delay > 0) {
	/* 餫 a  b 礭 */
	register long udelay;
	udelay = a->tv_usec - b->tv_usec;
	if (udelay < 0)	delay = ((delay-1)*1000) + (udelay+1000000)/1000;
	else		delay = delay*1000 + udelay/1000;
    } else if (delay == 0) {
	/* a  b κ usec ʬǤޤ */
	delay = (a->tv_usec - b->tv_usec)/1000;
    } else {
	/* a  b ⾮ */
	register long udelay;
	udelay = a->tv_usec - b->tv_usec;
	if (udelay > 0)	delay = ((delay-1)*1000) + (udelay+1000000)/1000;
	else		delay = delay*1000 + udelay/1000;
    }
    DebugPrint5(5, "tv_sub(%ld.%ld-%ld.%ld) = %ld\n",
	       a->tv_sec, a->tv_usec, b->tv_sec, b->tv_usec, delay);
    DebugEndFunc("schedule", "tv_sub");
    return delay;
}

/* εư֤򼨤
 * ߻֤ФƼ˵ưޤǤλ֤ tp Ǽ
 * ¤Τꤷtp ͤΤΤ֤
 *
 * Ԥ֤ˤ륨ȥ꤬¸ߤʤϡNULL ֤
 */
struct timeval *yysched_get_next_time(ch, tp)
    yy_comm_channel *ch;
    register struct timeval *tp;
{
    register YYSCHED *sent;
    DebugSetFunc("schedule", "yysched_get_next_time");
    if ((sent = ch->ccSchedQueue) != (YYSCHED *)NULL) {
	struct timeval curtime;
	gettimeofday(&curtime,(struct timezone *)NULL);
	tp->tv_usec = sent->shTime.tv_usec - curtime.tv_usec;
	if (tp->tv_usec < 0) {
	    tp->tv_sec = sent->shTime.tv_sec - curtime.tv_sec - 1;
	    tp->tv_usec += 1000000;
	} else {
	    tp->tv_sec = sent->shTime.tv_sec - curtime.tv_sec;
	}
	if (tp->tv_sec < 0) {
	    /* äƤ֤˻֤᤮Ƥޤä... ;-( */
	    tp->tv_sec = 0; tp->tv_usec = 1000;
	}
	DebugPrint2(5, "Scheduler Timeout %ld.%ld\n",
		    tp->tv_sec, tp->tv_usec);
    } else {
	tp = (struct timeval *)NULL;
    }
    DebugEndFunc("schedule", "yysched_get_next_time");
    return tp;
}


/*
 */
void yysched_addque(ch, func, id, type, flag, tp, next_t)
    yy_comm_channel *ch;
    void (*func)();	/*ƤӽФؿ */
    int id;		/*оݥƥȥ*/
    int type;		/* YYSCHED_XXX */
    int flag;		/* ɤۤβ */
    struct timeval *tp;	/* ƤӽФ */
    long next_t;	/* msec ñ (tp  NULL λͭ) */
{
    YYSCHED *sent, *p, *n, *s;
    struct timeval curtime;

    DebugSetFunc("schedule", "yysched_addque");
    /* tp ꤵƤʤˤϸ߻֤ next_t (msec) 
     * ٤줿֤ꤹ */
    if (tp == (struct timeval *)NULL) {
	/* 1000 ˤ֤Ȥ⤬.. */
	gettimeofday((tp = &curtime),(struct timezone *)NULL);
	if (next_t >= 1000) {
	    tp->tv_sec += (next_t/1000);
	    tp->tv_usec += (next_t%1000)*1000;
	} else {
	    tp->tv_usec += (next_t*1000);
	}
    }
    DebugPrint2(5, "Event on %ld.%ld\n", tp->tv_sec, tp->tv_usec);

    /* ƾ */
    sent = yysched_alloc_entry();
    sent->shFunc = func;
    sent->shID = id;
    sent->shFlag = ((type&YYSCHED_TYPE_ALL)|(flag&YYSCHED_FLAG_ALL));
    memcpy(&sent->shTime, tp, sizeof(struct timeval));

    /* 塼˻֤ν */
    n = ch->ccSchedQueue; /*  YY-server ˸ͭ?? */
    p = s = (YYSCHED *)NULL;
    for ( ; n != (YYSCHED *)NULL ; n = (p=n)->shNext) {
	if (tv_sub(&n->shTime, &sent->shTime) > 0) break;
	if (n->shID == sent->shID &&
	    ((n->shFlag&YYSCHED_TYPE_ALL) == (sent->shFlag&YYSCHED_TYPE_ALL)))
	    s = n;
    }
    /* p  n δ֤ sent  */
    sent->shNext = n;
    if (p != (YYSCHED *)NULL)	p->shNext = sent;
    else			ch->ccSchedQueue = sent;
    /* Ʊ쥿פ¸ߤʤ餽Υ󥯤Ω */
    if (s != (YYSCHED *)NULL) {
	sent->shSameNext = s->shSameNext;
	s->shSameNext = sent;
    } else {
	sent->shSameNext = (YYSCHED *)NULL;
    }
    DebugEndFunc("schedule", "yysched_addque");
    /*NoReturnValue*/
}

/*
 *
 * ߻֤
 * Queue Υȥǵư֤Τ(٤)ư
 * ʤ
 *   1) ƱΥ٥Ȥ push Ƥơ
 *   2) ⵯưξ郎ä(֤᤮)ơ
 *   3) ӱۤǽʾ
 * λƤϤΥ٥Ȥ̵뤹 (del )
 */
void yysched_popque(ch)
    yy_comm_channel *ch;
{
    /**/
    register YYSCHED *sent;
    struct timeval curtime;
    DebugSetFunc("schedule", "yysched_popque");
    gettimeofday(&curtime,(struct timezone *)NULL);
    while ((sent = ch->ccSchedQueue) != (YYSCHED *)NULL) {
	register long delay = tv_sub(&curtime, &sent->shTime);
	if (delay < 0) break; /* ¹ԤǤ륨ȥ꤬¸ߤʤ */
	/* sent 򥭥塼ƬϤƤ */
	ch->ccSchedQueue = sent->shNext;
	DebugPrint2(5, "Event on %ld.%ld is checked..\n",
		    sent->shTime.tv_sec, sent->shTime.tv_usec);
	/* ؿƤӽФ郎äƤʤƤӽФ
	 * Ԥʤ */
	if (sent->shSameNext == (YYSCHED *)NULL ||
	    !(sent->shFlag & YYSCHED_FLAG_SKIP) ||
	    tv_sub(&curtime, &sent->shSameNext->shTime) < 0) {
	    /* ؿεưѹǽΤ
	     * save ȤѿƳ */
	    struct timeval save;
	    memcpy(&save, &sent->shTime, sizeof(struct timeval));
	    (*sent->shFunc)(ch, sent->shFunc, sent->shID,
			    (sent->shFlag&YYSCHED_TYPE_ALL),
			    (sent->shFlag&YYSCHED_FLAG_ALL), &save, delay);
	}
	yysched_free_entry(sent);
    }
    DebugEndFunc("schedule", "yysched_popque");
    /*NoReturnValue*/
}

/*
 *
 * id  type Ŭ礹륨ȥ num Ĥ
 * num  (-1) ǤʤŬ礹Τ٤Ƥ
 */
void yysched_delque(ch, id, type, num)
    yy_comm_channel *ch;
    int id, type;
    int num;
{
    /**/
    register YYSCHED *sent, *last;
    DebugSetFunc("schedule", "yysched_delque");
    sent = ch->ccSchedQueue;
    last = (YYSCHED *)NULL;
    while (num != 0 && sent != (YYSCHED *)NULL) {
	if ((id < 0 || sent->shID == id) &&
	    (sent->shFlag&YYSCHED_TYPE_ALL)==type) {
	    register YYSCHED *next = sent->shNext;
	    if (last != (YYSCHED *)NULL)	last->shNext = next;
	    else				ch->ccSchedQueue = next;
	    yysched_free_entry(sent);
	    if (num > 0) num--;
	    sent = next;
	} else {
	    sent = (last=sent)->shNext;
	}
    }
    DebugEndFunc("schedule", "yysched_delque");
    /*NoReturnValue*/
}


void null_sched_func(ch, myself, id, type, flag, tp, delay)
    int (*myself)();		/* ʬ */
    int id;			/* оݥƥȥ ID */
    int type;			/* ؿΥ */
    int flag;			/* ­ */
    struct timeval *tp;		/* 赯ưϤλ */
    long delay;			/* εư֤٤ */
{
}

/**********************************************************************
 *****   ޤ
 **********************************************************************/

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
