/* Packets for YY-protocol
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: packet.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

#ifndef lint
static char *RcsId
    = "$Id: packet.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.1 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"


/*
 * Packet consists ..
 */

/*
 *
 *    1 2 3 4 5 6 7 8  1 2 3 4 5 6 7 8  1 2 3 4 5 6 7 8  1 2 3 4 5 6 7 8
 *   +----------------+----------------+----------------+----------------+
 * 0 | Command        |      Packet Length                               |
 *   +----------------+----------------+----------------+----------------+
 * 1 | -------------- | -------------- | -------------- | Packet Type    |
 *   +----------------+----------------+----------------+----------------+
 * 2 |    Data ...                                                       |
 *
 */

/*
 * Packet Type:
 *  1 2 3 4 5 6 7 8
 *  X X X X X X      - Data Class
 *  0 0 0 0 0 0      - ignore data class
 *  0 0 0 0 0 1      - Command
 *  0 0 0 0 1 0      - Syncronous Packet
 *  0 0 0 1 0 0      - Reply for Command (ACK)
 *  0 0 0 1 1 1      - Reply for Command (NACK)
 *  0 0 1 0 0 0      - Event on Server
 *  1 0 0 0 0 0      - Error on Server
 *              X X  - Type
 *              0 0  - Only this one packet
 *              0 1  - this is a first packet of sequence
 *              1 0  - this is a middle packet of sequence
 *              1 1  - this is a last packet of sequence
 */

extern int YYPacketBlockSize;

#define YYPACKET_LENGTH(pkt)	((pkt)->pktLength)

#define YYPACKET_READ_PTR(pkt)	((pkt)->pktRWPtr)
#define YYPACKET_WRITE_PTR(pkt)	((pkt)->pktRWPtr)
#define YYPACKET_CUR_BLOCK(pkt)	((pkt)->pktRWBlock)
#define YYPACKET_NEXT_BLOCK(pkt)	((pkt)->pktRWBlock->pbNextBlock)

#define YYPACKET_LENGTH_INBLOCK(pkt) ((pkt)->pktRWBlock->pbLength)
#define YYPACKET_BLOCKSIZE(pkt)	((pkt)->pktRWBlock->pbBlockSize)
#define YYPACKET_FILLEDSIZE_INBLOCK(pkt)	\
	((pkt)->pktRWBlock->pbBlockSize - (pkt)->pktRWBlock->pbFreeSize)
#define YYPACKET_FREESIZE_INBLOCK(pkt) ((pkt)->pktRWBlock->pbFreeSize)
#define YYPACKET_UNREADLENGTH_INBLOCK(pkt)	\
	((pkt)->pktRWBlock->pbUnreadLength)
#define YYPACKET_READLENGTH_INBLOCK(pkt)	\
	((pkt)->pktRWBlock->pbLength - (pkt)->pktRWBlock->pbUnreadLength)

static void alloc_new_packet_block();
static int goto_next_packet_block();


/***************************************************************************
 *****
 *****  ѥåȥ塼ΤΥؿ
 *****
 ***************************************************************************/

static YYPKTQUEENT *FreeQueueEntList
    = (YYPKTQUEENT *)NULL;

/*
 * YYPKTQUEENT *alloc_packet_queue_ent()
 *
 * 塼ȥƤ
 */
static YYPKTQUEENT *alloc_packet_queue_ent()
{
    register YYPKTQUEENT *qent;
    DebugSetFunc("packet", "alloc_packet_queue_ent");
    if (FreeQueueEntList != (YYPKTQUEENT *)NULL) {
	DebugPrint0(5, "Get Entry from Free-List\n");
	qent = FreeQueueEntList;
	FreeQueueEntList = FreeQueueEntList->pqNextPacket;
    } else {
	DebugPrint0(5, "Allocate New Area\n");
	qent = (YYPKTQUEENT *)memALLOC(sizeof(YYPKTQUEENT));
    }
    bzero((char *)qent, sizeof(YYPKTQUEENT));
    DebugEndFunc("packet", "alloc_packet_queue_ent");
    return qent;
}

/*
 * void free_packet_queue_ent(qent)
 *
 * 塼ȥ qent  Free-List ˲äѤǤ褦ˤ
 */
static void free_packet_queue_ent(qent)
    register YYPKTQUEENT *qent;
{
    qent->pqNextPacket = FreeQueueEntList;
    FreeQueueEntList = qent;
}

/*
 * YYPKTQUEENT *append_queent_from_packet_queue(top, qent)
 *
 * 塼ȥ qent  top ƬȤ륭塼ȥꥹȤ
 * Ǹɲä
 * top  NULL ǤСqent ꥹȤƬˤʤ
 *
 * Return Value:
 *  塼ꥹȤƬɥ쥹
 */
static YYPKTQUEENT *append_queent_from_packet_queue(top, qent)
    YYPKTQUEENT *top;
    register YYPKTQUEENT *qent;
{
    register YYPKTQUEENT *last = top;
    DebugSetFunc("packet", "append_queent_from_packet_queue");
    qent->pqNextPacket = (YYPKTQUEENT *)NULL;
    if (last == (YYPKTQUEENT *)NULL) {
	top = qent;
    } else {
	while (last->pqNextPacket != (YYPKTQUEENT *)NULL)
	    last = last->pqNextPacket;
	last->pqNextPacket = qent;
    }
    qent->pqPrevPacket = last;
    DebugEndFunc("packet", "append_queent_from_packet_queue");
    return top;
}

/*
 * YYPKTQUEENT *pick_queent_from_packet_queue(top, qent)
 *
 * 塼ȥ qent  top ƬȤ륭塼ȥꥹȤ
 * 椫Ф
 *
 * Return Value:
 *  塼ꥹȤƬɥ쥹
 */
static YYPKTQUEENT *pick_queent_from_packet_queue(top, qent)
    YYPKTQUEENT *top;
    YYPKTQUEENT *qent;
{
    if (qent->pqPrevPacket != (YYPKTQUEENT *)NULL)
	qent->pqPrevPacket->pqNextPacket = qent->pqNextPacket;
    else
	top = qent->pqNextPacket;
    if (qent->pqNextPacket != (YYPKTQUEENT *)NULL)
	qent->pqNextPacket->pqPrevPacket = qent->pqPrevPacket;
    qent->pqNextPacket = qent->pqPrevPacket = (YYPKTQUEENT *)NULL;
    return top;
}

/***************************************************************************
 * Packet Data Area Control
 *
 * ѥåȥǡꥢϥѥåȾμºݤΥǡǼΰ
 *  ȤǤ
 * ǡǼϹѿ YYPacketBlockSize ǼХȿ
 *  ΰǤ롣
 ***************************************************************************/

#ifndef nonono
struct _yy_packet_data_area_entry_ {
    struct _yy_packet_data_area_control_ *ctrl;
    struct _yy_packet_data_area_entry_ *next;
    byte buf[1];	/* ꥢΤΤ򼨤 */
} ;

/* ѥåȥǡΰ֥å */
struct _yy_packet_data_area_control_ {
    struct _yy_packet_data_area_control_ *next;
    struct _yy_packet_data_area_entry_ *top;
    int active;
    struct _yy_packet_data_area_entry_ *free;
} ;

#define MAXDATAAREANUM		5
#define PKTAREAENT	struct _yy_packet_data_area_entry_
#define PKTAREACTRL	struct _yy_packet_data_area_control_

PKTAREACTRL *PktAreaCtrlList = (PKTAREACTRL *)NULL;

/* byte *alloc_packet_data_area()
 *
 * ѥåȥǡΰƤ
 *  Ƥ
 *   1) PacketAreaControlList ¸ߤѥåȥǡΰ֥å
 *      ̤ѥꥢ¸ߤФȤ
 *   2) ʤ PacketAreaControlList Ƭ˿ѥåȥǡΰ
 *      ֥åƤ̤ѥꥢ MAXDATAAREANUM 
 *      դƤ
 */
byte *alloc_packet_data_area()
{
    static int blocksize = 0;
    byte *ptr = (byte *)NULL;
    PKTAREACTRL *ctrl;
    DebugSetFunc("packet", "alloc_packet_data_area");

    if (PktAreaCtrlList == (PKTAREACTRL *)NULL) {
	/* ֥åγ */
	PktAreaCtrlList = (PKTAREACTRL *)memCALLOC(1,sizeof(PKTAREACTRL));
	/* blocksize  */
	blocksize = (YYPacketBlockSize & ~((int)3));
    }
    /* ctrl ˥ꥢƤƤʤ֥å
     * 뤤 free äƤ֥å
     */
    ctrl = PktAreaCtrlList;
    for (;;) {
	if (ctrl->free != (PKTAREAENT *)NULL) break;
	if (ctrl->top == (PKTAREAENT *)NULL) {
	    PKTAREAENT *ent;
	    register int loop;
	    ent = ctrl->top = ctrl->free = (PKTAREAENT *)
		memCALLOC(MAXDATAAREANUM,sizeof(PKTAREAENT)+blocksize);
	    /* դ̤ѥꥢξ */
	    for (loop = MAXDATAAREANUM-1; loop > 0; loop--) {
		register PKTAREAENT *next;
		next = (PKTAREAENT *)(((byte *)(ent+1))+blocksize);
		ent->ctrl = ctrl; ent->next = next;
		ent = next;
	    }
	    ent->ctrl = ctrl; ent->next = (PKTAREAENT *)NULL;
	    break;
	}
	if (ctrl->next == (PKTAREACTRL *)NULL) {
	    /* ֥åγ */
	    ctrl->next = (PKTAREACTRL *)memCALLOC(1,sizeof(PKTAREACTRL));
	}
	ctrl = ctrl->next;
    }

    /* ctrl ϾʤȤĤ̤ΰ */
    ptr = ctrl->free->buf;
    ctrl->free = ctrl->free->next;
    ctrl->active++;

    DebugEndFunc("packet", "alloc_packet_data_area");
    return ptr;
}


/* void free_packet_data_area(ptr)
 *
 * ѥåȥǡΰ ptr ̤ѥǡΰΥꥹȤ˲ä
 */
void free_packet_data_area(ptr)
    register byte *ptr;
{
    PKTAREACTRL *c;
    PKTAREAENT *ent;
    DebugSetFunc("packet", "free_packet_data_area");
    ent = (PKTAREAENT *)(ptr - (ent->buf - (byte *)(&ent->ctrl)));
    /*printf("Free at %x (b = %x)\n", ent, ptr);*/

    c = ent->ctrl;
    /* ̤ѥꥢȤϿ */
    ent->next = c->free;
    c->free = ent;
    if (--c->active <= 0) {
	/* ٤ free ˤʤäƤޤä
	 *  ֥åǤС˼ alloc_ 
	 *  ⤦ malloc 뤳ȤˤʤΤǡξ
	 *  ̤ѥꥢ free Ƥޤ
	 */
	if (PktAreaCtrlList->next != (PKTAREACTRL *)NULL) {
	    memFREE((char *)c->top);
	    c->top = c->free = (PKTAREAENT *)NULL;
	}
    }
    DebugEndFunc("packet", "free_packet_data_area");
    /*NoReturnValue*/
}

#else /*!nonono*/
struct _yy_packet_data_area_ent_ {
    byte *Ptr;
    struct _yy_packet_data_area_ent_ *Next;
} ;
typedef struct _yy_packet_data_area_ent_ YYPKTDAREAENT;


/* FreePktDataAreaList ̤ѤΥѥåȥǡꥢΥꥹȤǤ
 * UnusedPktDAreaEntList ϶ѥåȥǡꥢݻ뤿
 * ǡꥢζꥹȤǤ
 */
static YYPKTDAREAENT *FreePktDataAreaList
    = (YYPKTDAREAENT *)NULL;
static YYPKTDAREAENT *UnusedPktDAreaEntList
    = (YYPKTDAREAENT *)NULL;

/*
 * byte *alloc_packet_data_area()
 *
 * ѥåȥǡΰƤ
 */
byte *alloc_packet_data_area()
{
    register byte *ptr;
    DebugSetFunc("packet", "alloc_packet_data_area");
    if (FreePktDataAreaList != (YYPKTDAREAENT *)NULL) {
	register YYPKTDAREAENT *dent;
	DebugPrint0(9, "Get %dbytes area from free-list\n", YYPacketBlockSize);
	ptr = FreePktDataAreaList->Ptr;
	/* ȥȥΥꥹȤ */
	dent = FreePktDataAreaList;
	FreePktDataAreaList = FreePktDataAreaList->Next;
	dent->Next = UnusedPktDAreaEntList;
	UnusedPktDAreaEntList = dent;
    } else {
	DebugPrint0(9, "Allocate %dbytes area\n", YYPacketBlockSize);
	ptr = (byte *)memALLOC(YYPacketBlockSize);
    }
    DebugPrint0(9, "ADDRESS for PacketDataArea:0x%x\n", ptr);
    DebugEndFunc("packet", "alloc_packet_data_area");
    return ptr;
}

/*
 * void free_packet_data_area(ptr)
 *
 * ѥåȥǡΰ ptr ̤ѥǡΰΥꥹȤ˲ä
 */
void free_packet_data_area(ptr)
    register byte *ptr;
{
    register YYPKTDAREAENT *dent;
    DebugSetFunc("packet", "free_packet_data_area");
    DebugPrint0(9, "ADDRESS for PacketDataArea:0x%x\n", ptr);
    if (UnusedPktDAreaEntList != (YYPKTDAREAENT *)NULL) {
	dent = UnusedPktDAreaEntList;
	UnusedPktDAreaEntList = UnusedPktDAreaEntList->Next;
    } else {
	DebugPrint0(9, "Allocate %dbytes area\n", sizeof(YYPKTDAREAENT));
	dent = (YYPKTDAREAENT *)memALLOC(sizeof(YYPKTDAREAENT));
    }
    dent->Ptr = ptr;
    dent->Next = FreePktDataAreaList;
    DebugEndFunc("packet", "free_packet_data_area");
    /*NoReturnValue*/
}

#endif /* nonono */





/***************************************************************************
 *
 ***************************************************************************/



/*
 * int fix_yy_packet(pkt)
 *
 * ѥåȥƥ֥åͭĹ fix
 * إåǼ
 */

fix_yy_packet(pkt)
    register yy_packet *pkt;
{
    register yy_packet_block *pb = &pkt->pktFirstBlock;
    register yy_packet_header *hp;
    register bool num = 0;

    DebugSetFunc("packet", "fix_yy_packet");
    DebugPrint1(1, "Command: %d\n", pkt->pktCommand);
    pkt->pktLength = 0;
    for (pb = &pkt->pktFirstBlock;
	 pb != (yy_packet_block *)NULL; pb = pb->pbNextBlock, num++) {
	int leng;
	/* Fix Length of Block */
	leng = pb->pbLength = pb->pbBlockSize - pb->pbFreeSize;
	pkt->pktLength += leng;
	/* Fix Header */
	hp = (yy_packet_header *)pb->pbBuf;
	hp->hdCommand = pkt->pktCommand;
	leng >>= 2;
	bcopy(((byte *)&leng)+1, hp->hdPacketLength, 3);
	hp->hdPacketType = pkt->pktType;
	hp->hdBlockType = (num > 0? YYPACKET_BLOCKTYPE_CONTINUE:
			   YYPACKET_BLOCKTYPE_FIRSTBLOCK);
    }
    hp->hdBlockType = (num > 1? YYPACKET_BLOCKTYPE_LASTBLOCK:
		       YYPACKET_BLOCKTYPE_ONLYONE);
    YYPACKET_CUR_BLOCK(pkt) = &pkt->pktFirstBlock;
    DebugEndFunc("packet", "fix_yy_packet");
}

/*
 * yy_packet *alloc_new_yy_packet(command, type, priority, block, leng)
 *
 * ѥåΰݤ
 * command, type, priority Ϥ̤ΤΤꤵ
 * block  NULL ǤʤС줬ǽΥ֥åƤȤƺѤ
 * block  NULL ʤ YYPacketBlockSize ΰ褬ݤ
 */
yy_packet *alloc_new_yy_packet(command, type, priority, block, leng)
    int command;
    int type;
    int priority;
    byte *block; int leng;
{
    register yy_packet *pkt = (yy_packet *)memALLOC(sizeof(yy_packet));
    DebugSetFunc("packet", "alloc_new_yy_packet");
    DebugPrint2(1, "Command: %d(%x)\n", command, command);
    if (pkt == (yy_packet *)NULL)
	return (yy_packet *)NULL;
    pkt->pktCommand = (command & 0377);
    pkt->pktType = type;
    pkt->pktPriority = priority;
    pkt->pktLength = 0;
    pkt->pktReadFlag = FALSE;
    pkt->pktRWBlock = &pkt->pktFirstBlock;
    if (block != (byte *)NULL) {
	pkt->pktFirstBlock.pbBuf = block;
	pkt->pktFirstBlock.pbBlockSize = leng;
	pkt->pktFirstBlock.pbFreeSize = sizeof(yy_packet_header);
	pkt->pktFirstBlock.pbLength = leng;
    } else {
	pkt->pktFirstBlock.pbBuf = alloc_packet_data_area();
	pkt->pktFirstBlock.pbBlockSize = YYPacketBlockSize;
	pkt->pktFirstBlock.pbFreeSize = YYPacketBlockSize;
	pkt->pktFirstBlock.pbLength = 0;
    }
    pkt->pktFirstBlock.pbUnreadLength = 0;
    pkt->pktFirstBlock.pbNextBlock = (yy_packet_block *)NULL;
    pkt->pktFirstBlock.pbPrevBlock = (yy_packet_block *)NULL;
    /* Skip Header Area */
    pkt->pktRWPtr = pkt->pktFirstBlock.pbBuf + sizeof(yy_packet_header);
    pkt->pktFirstBlock.pbFreeSize -= sizeof(yy_packet_header);
    DebugEndFunc("packet", "alloc_new_yy_packet");
    return pkt;
}



void remove_yy_packet(pkt)
    yy_packet *pkt;
{
    register yy_packet_block *pb = &pkt->pktFirstBlock;
    register yy_packet_block *next;
    DebugSetFunc("packet", "remove_yy_packet");
    free_packet_data_area(pb->pbBuf);
    for (pb = pb->pbNextBlock; pb != (yy_packet_block *)NULL; pb = next) {
	next = pb->pbNextBlock;
	free_packet_data_area(pb->pbBuf);
	/*free((char *)pb);*/
    }
    /*(void)xfree((char *)pkt);*/
    DebugEndFunc("packet", "remove_yy_packet");
}

/*
 * append_packet_entry_integer(pkt, value)
 *
 * pkt ǼѥåȤ value ɲä
 * ɲð֤򼨤ݥ󥿤ѹ
 * ɲð֤4δ֤ǤʤϤ
 */
void append_packet_entry_integer(pkt, value)
    yy_packet *pkt;
    int value;
{
#ifdef FOURBYTESINT
    register int l;
    DebugSetFunc("packet", "append_packet_entry_interger");
    DebugPrint2(1, "Block Length = %d/%d\n",
		YYPACKET_FILLEDSIZE_INBLOCK(pkt), YYPACKET_BLOCKSIZE(pkt));
    if ((l = (YYPACKET_FILLEDSIZE_INBLOCK(pkt)&03)) > 0) {
	l = 4 - l;
	YYPACKET_FREESIZE_INBLOCK(pkt) -= l;
	while (l-- > 0)
	    *YYPACKET_WRITE_PTR(pkt)++ = (byte)EOS;
    }
    if (YYPACKET_FREESIZE_INBLOCK(pkt) <= 0)
	alloc_new_packet_block(pkt, (byte *)NULL);
    (void) bcopy((byte *)&value, YYPACKET_WRITE_PTR(pkt), 4);
    YYPACKET_WRITE_PTR(pkt) += 4;
    YYPACKET_FREESIZE_INBLOCK(pkt) -= 4;
    DebugEndFunc("packet", "append_packet_entry_interger");
#else
    NOT YET;
#endif
}

/*
 * append_packet_entry_color(pkt, value)
 *
 * pkt ǼѥåȤ X Υ顼 value ɲä
 * ɲð֤򼨤ݥ󥿤ѹ
 * ɲð֤4δ֤ǤʤϤ
 *
 * ʳǤ integer ȤʤäƤ롥
 *
 */
void append_packet_entry_color(pkt, color)
    yy_packet *pkt;
    x_color color;
{
#ifdef FOURBYTESINT
    register int l;
    DebugSetFunc("packet", "append_packet_entry_color");
    append_packet_entry_integer(pkt, color);
    DebugEndFunc("packet", "append_packet_entry_color");
#else
    NOT YET;
#endif
}

/*
 * append_packet_entry_bytes(pkt, value, count)
 *
 * pkt ǼѥåȤ value β count ХȤɲä
 * ɲð֤򼨤ݥ󥿤ѹ
 * ɲð֤ϹԤʤʤ
 * count ϥåʤ
 */
void append_packet_entry_bytes(pkt, value, count)
    yy_packet *pkt;
    int value;
    int count;
{
#ifdef FOURBYTESINT
    byte *vp = (byte *)&value;
    vp += (4-count);
    while (count-- > 0) {
	if (YYPACKET_FREESIZE_INBLOCK(pkt) <= 0)
	    alloc_new_packet_block(pkt, (byte *)NULL);
	*YYPACKET_WRITE_PTR(pkt)++ = *vp++;
	YYPACKET_FREESIZE_INBLOCK(pkt)--;
    }
#else
    NOT YET;
#endif
}

/*
 * append_packet_entry_onebyte(pkt, value)
 *
 * pkt ǼѥåȤ value ɲä
 * ɲð֤򼨤ݥ󥿤ѹ
 * ɲð֤ϹԤʤʤ
 */
void append_packet_entry_onebyte(pkt, value)
    yy_packet *pkt;
    byte value;
{
#ifdef FOURBYTESINT
    if (YYPACKET_FREESIZE_INBLOCK(pkt) <= 0)
	alloc_new_packet_block(pkt, (byte *)NULL);
    *YYPACKET_WRITE_PTR(pkt)++ = value;
    YYPACKET_FREESIZE_INBLOCK(pkt)--;
#else
    NOT YET;
#endif
}

/*
 * append_packet_entry_string(pkt, size, string)
 *
 * pkt ǼѥåȤʸ str ɲä
 * str ͭʸ size ݻƤ
 * ɲð֤򼨤ݥ󥿤ѹ
 * ɲð֤4δ֤ǤʤϤ
 *	(append_packet_entry_integer ˤ)
 */
void append_packet_entry_string_with_length(pkt, size, str)
    yy_packet *pkt;
    int size;
    byte *str;
{
#ifdef FOURBYTESINT
    append_packet_entry_integer(pkt, size);
    while (size > 3) {
	size -= 4;
	if (YYPACKET_FREESIZE_INBLOCK(pkt) <= 0)
	    alloc_new_packet_block(pkt, (byte *)NULL);
	bcopy(str, YYPACKET_WRITE_PTR(pkt), 4);
	str += 4;
	YYPACKET_WRITE_PTR(pkt) += 4;
	YYPACKET_FREESIZE_INBLOCK(pkt) -= 4;
    }
    if (size > 0) {
	int rest = 4 - size;
	if (YYPACKET_FREESIZE_INBLOCK(pkt) <= 0)
	    alloc_new_packet_block(pkt, (byte *)NULL);
	while (size-- > 0)
	    *YYPACKET_WRITE_PTR(pkt)++ = *str++;
	while (rest-- > 0)
	    *YYPACKET_WRITE_PTR(pkt)++ = (byte)EOS;
	YYPACKET_FREESIZE_INBLOCK(pkt) -= 4;
    }
#else
    NOT YET;
#endif
}

/*
 * void alloc_new_packet_block(pkt, block, leng)
 *
 * pkt θߤΥ fix 
 * pkt ˿ʥ֥åɲä
 * block  NULL ǤʤХ֥åƤȤƻȤ
 * block  NULL ʤ鿷ΰ
 */
static void alloc_new_packet_block(pkt, block, leng)
    yy_packet *pkt;
    byte *block;
    int leng;
{
    register yy_packet_block *last;
    register yy_packet_block *new;
    DebugSetFunc("packet", "alloc_new_packet_block");
    new = (yy_packet_block *)memALLOC(sizeof(yy_packet_block));
    for (last = &pkt->pktFirstBlock;
	 last->pbNextBlock != (yy_packet_block *)NULL;
	 last = last->pbNextBlock)
	;
    DebugPrint3(5, "Command on Last Block %d(0x%x) -- %x\n",
		last->pbBuf, last->pbBuf, *((int *)last->pbBuf));
    last->pbNextBlock = new;
    new->pbPrevBlock = last;
    new->pbNextBlock = (yy_packet_block *)NULL;
    if (block != (byte *)NULL) {
	new->pbLength = leng;
	new->pbBuf = block;
	new->pbBlockSize = leng;
	new->pbFreeSize = 0;
    } else {
	new->pbLength = 0;
	new->pbBuf = alloc_packet_data_area();
	new->pbBlockSize = YYPacketBlockSize;
	new->pbFreeSize = new->pbBlockSize - sizeof(yy_packet_header);
    }
    /* fix ptr - Skip Header */
    YYPACKET_CUR_BLOCK(pkt) = new;
    YYPACKET_WRITE_PTR(pkt) = new->pbBuf + sizeof(yy_packet_header);
    /* Skip Header */
    DebugEndFunc("packet", "alloc_new_packet_block");
    /*NoReturnValue*/
}

/*********************************************************************
 * Read Packet Entry..
 *
 * read_packet_entry_ ꡼Ϥ٤ɤߤ֤ΰưԤʤ
 *********************************************************************/

/*
 * reset_packet_read_ptr(pkt)
 */
void reset_packet_read_ptr(pkt)
    yy_packet *pkt;
{
    yy_packet_block *pb;
    yy_packet_header *hp;
    int leng;
    int num;
    DebugSetFunc("packet", "reset_packet_read_ptr");
    pb = &pkt->pktFirstBlock;
    pkt->pktRWBlock = pb;
    pkt->pktRWPtr = pb->pbBuf + sizeof(yy_packet_header);
    pb->pbUnreadLength = pb->pbLength - sizeof(yy_packet_header);
    /* Get Header Info. */
    hp = (yy_packet_header *)(pb->pbBuf);
    /*pkt->pktCommand = (int)(hp->hdCommand);*/
    DebugPrint2(1, "Command:%d(0x%x)\n", pkt->pktCommand, pkt->pktCommand);
    pkt->pktType = hp->hdPacketType;
    pkt->pktLength = 0;
    for (num = 0; pb != (yy_packet_block *)NULL; pb = pb->pbNextBlock, num++) {
	pkt->pktLength += pb->pbLength;
	DebugPrint2(1, "PKT#%d <Length=%d>\n", num, pb->pbLength);
    }
    DebugPrint1(1, "Packet Length = %d\n", pkt->pktLength);
    DebugEndFunc("packet", "reset_packet_read_ptr");
}

/*
 * int read_packet_entry_integer(pkt)
 *
 * pkt ͤɤ߹
 * ɤ߹֤4δ֤ǤʤϤ
 */

int read_packet_entry_integer(pkt)
    yy_packet *pkt;
{
#ifdef FOURBYTESINT
    int val, l;
    if ((l = (YYPACKET_READLENGTH_INBLOCK(pkt)&3)) > 0) {
	l = 4 - l;
	YYPACKET_READ_PTR(pkt) += l;
	YYPACKET_UNREADLENGTH_INBLOCK(pkt) -= l;
    }
    if (YYPACKET_UNREADLENGTH_INBLOCK(pkt) <= 0)
	if (goto_next_packet_block(pkt) < 0)
	    return -1;
    (void) bcopy(YYPACKET_READ_PTR(pkt), (byte *)&val, 4);
    YYPACKET_READ_PTR(pkt) += 4;
    YYPACKET_UNREADLENGTH_INBLOCK(pkt) -= 4;
    return val;
#else
    NOT YET;
#endif
}

/*
 * u_long read_packet_entry_color(pkt)
 *
 * pkt  X Υ顼ͤɤ߹
 * ɤ߹֤4δ֤ǤʤϤ
 *
 */

#ifdef COLORNAME
char *read_packet_entry_color(pkt)
#else
x_color read_packet_entry_color(pkt)
#endif
	yy_packet *pkt;
{
#ifdef FOURBYTESINT
#ifdef COLORNAME
	int l;
	static char name[256];
	l = read_packet_entry_integer(pkt);
	read_packet_entry_string(pkt, l, name);
	return name;
#else /* !COLORNAME */
	x_color color;
	color = read_packet_entry_integer(pkt);
	return color;
#endif
#else
	NOT YET;
#endif
}

/*
 * int read_packet_entry_bytes(pkt, count)
 *
 * pkt ǼѥåȤ count ХȤФ
 * ɤߤϰ֤ϹԤʤʤ
 * count ϥåʤ
 */

int read_packet_entry_bytes(pkt, count)
	yy_packet *pkt;
	int count;
{
#ifdef FOURBYTESINT
	int val = 0;
	register byte *vp = (byte *)&val;
	vp += (4-count);
	while (count-- > 0) {
		if (YYPACKET_UNREADLENGTH_INBLOCK(pkt) <= 0)
			if (goto_next_packet_block(pkt) < 0)
				return -1;
		*vp++ = *YYPACKET_READ_PTR(pkt)++;
		YYPACKET_UNREADLENGTH_INBLOCK(pkt)--;
	}
	return val;
#else
	NOT YET;
#endif
}

/*
 * int read_packet_entry_onebyte(pkt)
 *
 * pkt ǼѥåȤ 1ХȤФ
 * ɤߤϰ֤ϹԤʤʤ
 */

int read_packet_entry_onebyte(pkt)
	yy_packet *pkt;
{
#ifdef FOURBYTESINT
	register int val;
	if (YYPACKET_UNREADLENGTH_INBLOCK(pkt) <= 0)
		if (goto_next_packet_block(pkt) < 0)
			return -1;
	val = *YYPACKET_READ_PTR(pkt)++;
	YYPACKET_UNREADLENGTH_INBLOCK(pkt)--;
	return val;
#else
	NOT YET;
#endif
}

/*
 * int read_packet_entry_string(pkt, size, buf)
 *
 * pkt ǼѥåȤ size ХȤʸФ
 * buf  size+1 ʾ礭ĤȲꤹ
 * ɤߤϰ֤ϹԤʤ
 */

int read_packet_entry_string(pkt, size, buf)
	yy_packet *pkt;
	register int size;
	register byte *buf;
{
#ifdef FOURBYTESINT
	int val, l, rest;
	if ((l = (YYPACKET_READLENGTH_INBLOCK(pkt)&3)) > 0) {
		l = 4 - l;
		YYPACKET_READ_PTR(pkt) += l;
		YYPACKET_UNREADLENGTH_INBLOCK(pkt) -= l;
	}
	for (rest = (size & 3), size -= 4; size >= 0; size -= 4) {
		if (YYPACKET_UNREADLENGTH_INBLOCK(pkt) <= 0)
			if (goto_next_packet_block(pkt) < 0)
				return -1;
		(void) bcopy(YYPACKET_READ_PTR(pkt), buf, 4);
		YYPACKET_READ_PTR(pkt) += 4;
		buf += 4;
		YYPACKET_UNREADLENGTH_INBLOCK(pkt) -= 4;
	}
	if (YYPACKET_UNREADLENGTH_INBLOCK(pkt) <= 0)
		if (goto_next_packet_block(pkt) < 0)
			return -1;
	(void) bcopy(YYPACKET_READ_PTR(pkt), buf, rest);
	YYPACKET_READ_PTR(pkt) += rest;
	buf += rest;
	YYPACKET_UNREADLENGTH_INBLOCK(pkt) -= rest;
	*buf = (byte)EOS;
	return 0;
#else
	NOT YET;
#endif
}

/*
 * int goto_next_packet_block(pkt)
 *
 * pkt ˤƼΥ֥åɤ߽Ф򤹤
 */

static int goto_next_packet_block(pkt)
    yy_packet *pkt;
{
    register yy_packet_block *new = YYPACKET_NEXT_BLOCK(pkt);
    DebugSetFunc("packet", "goto_next_packet_block");
    if (new == (yy_packet_block *)NULL)
	return -1;
    YYPACKET_CUR_BLOCK(pkt) = new;
    /* Skip Header */
    YYPACKET_READ_PTR(pkt) = new->pbBuf + sizeof(yy_packet_header);
    new->pbUnreadLength = new->pbLength - sizeof(yy_packet_header);
    DebugEndFunc("packet", "goto_next_packet_block");
    return 0;
}

/************************************************************************
 * Queue
 ***********************************************************************/

/*
 * yy_packet *get_packet_from_readq(queue)
 *
 * ReadQueue ѥåȤļФ
 * ФѥåȤ queue ϤϤ졤ɤ߽ФѤꤵ
 */

yy_packet *get_packet_from_readq(queue)
    yy_packet_system_queue *queue;
{
    YYPKTQUEENT *oldq;
    yy_packet *pkt;
    DebugSetFunc("packet", "get_packet_from_readq");
    if ((oldq = queue->sysqRead) == (YYPKTQUEENT *)NULL)
	return (yy_packet *)NULL;
    pkt = oldq->pqPacketBody;
    if ((queue->sysqRead = oldq->pqNextPacket) != (YYPKTQUEENT *)NULL)
	queue->sysqRead->pqPrevPacket = (YYPKTQUEENT *)NULL;
    reset_packet_read_ptr(pkt);
    if(DebugON(8))
	dump_yy_packet(pkt);
    free_packet_queue_ent(oldq);
    DebugEndFunc("packet", "get_packet_from_readq");
    return pkt;
}

/*
 * void put_block_on_recvq(queue, block)
 *
 * block  recv_queue Ͽ
 * ϿˤѥåȤä鼫ưŪ
 * recv_queue  read_queue ˤޤ魯
 */

void put_block_on_recvq(queue, block, leng)
    yy_packet_system_queue *queue;
    byte *block;
    int leng;
{
    YYPKTQUEENT *qent, *last_qent;
    int command;
    yy_packet_header *hp = (yy_packet_header *)block;
    DebugSetFunc("packet", "put_block_on_recvq");
    if (block != (byte *)NULL) {
	command = (int)(hp->hdCommand);
    } else
	command = -1;
    DebugPrint3(5, "Command:%d(0x%x), Block Length = %d\n",
		command, command, leng);

    /* Search Packet Entry and Register this block */
    for (qent = queue->sysqRecv, last_qent = (YYPKTQUEENT *)NULL;
	 qent != (YYPKTQUEENT *)NULL; qent = (last_qent = qent)->pqNextPacket)
	if (qent->pqPacketBody->pktCommand == command)
	    break;
    if (qent != (YYPKTQUEENT *)NULL) {
	alloc_new_packet_block(qent->pqPacketBody, block, leng);
    } else {
	qent = alloc_packet_queue_ent();
	qent->pqPacketBody
	    = alloc_new_yy_packet(command, 0, 0, block, leng);
	qent->pqNextPacket = (YYPKTQUEENT *)NULL;
	qent->pqPrevPacket = last_qent;
	if (last_qent != (YYPKTQUEENT *)NULL)
	    last_qent->pqNextPacket = qent;
	else
	    queue->sysqRecv = qent;
    }

    /* If this packet has been completed, move it into Read Queue */
    if (hp->hdBlockType == YYPACKET_BLOCKTYPE_ONLYONE
	|| hp->hdBlockType == YYPACKET_BLOCKTYPE_LASTBLOCK) {
	DebugPrint0(8, " Move Packet from recvq to readq\n");
	/* remove this packet from RecvQueue */
	if (qent->pqNextPacket != (YYPKTQUEENT *)NULL)
	    qent->pqNextPacket->pqPrevPacket = qent->pqPrevPacket;
	if (qent->pqPrevPacket != (YYPKTQUEENT *)NULL)
	    qent->pqPrevPacket->pqNextPacket = qent->pqNextPacket;
	else
	    queue->sysqRecv = qent->pqNextPacket;
	/* Register it on Readq */
	if (queue->sysqRead == (YYPKTQUEENT *)NULL) {
	    queue->sysqRead = qent;
	    qent->pqPrevPacket = (YYPKTQUEENT *)NULL;
	    qent->pqNextPacket = (YYPKTQUEENT *)NULL;
	} else {
	    register YYPKTQUEENT *rq = queue->sysqRead;
	    while (rq->pqNextPacket != (YYPKTQUEENT *)NULL)
		rq = rq->pqNextPacket;
	    DebugPrint0(8, " Put Packet on tail of readq\n");
	    rq->pqNextPacket = qent;
	    qent->pqPrevPacket = rq;
	    qent->pqNextPacket = (YYPKTQUEENT *)NULL;
	}
    }
    DebugEndFunc("packet", "put_block_on_recvq");
    /*NoReturnValue*/
}

int get_block_from_sendq(queue, bpp, lengp)
    yy_packet_system_queue *queue;
    byte **bpp;
    int *lengp;
{
    yy_packet *pkt;
    DebugSetFunc("packet", "get_block_from_sendq");
    if (queue->sysqSend == (YYPKTQUEENT *)NULL) {
	DebugPrint0(5, "SendQ has no packet\n");
	DebugEndFunc("packet", "get_block_from_sendq");
	return 0;
    }
    pkt = queue->sysqSend->pqPacketBody;
    DebugPrint0(3, "Take One Block from Packet\n");
    DebugPrint2(5, "Command Number#%d, Packet Type 0%o\n",
		pkt->pktCommand, pkt->pktType);
    if (YYPACKET_CUR_BLOCK(pkt) == (yy_packet_block *)NULL) {
	/* free area for this packet */
	YYPKTQUEENT *old = queue->sysqSend;
	YYPKTQUEENT *new = queue->sysqSend->pqNextPacket;
	DebugPrint0(3, "Aha! This Packet has no more block..\n");
	remove_yy_packet(pkt);
	free_packet_queue_ent(old);
	if ((queue->sysqSend = new) == (YYPKTQUEENT *)NULL) {
	    DebugPrint0(5, "SendQ has no packet\n");
	    DebugEndFunc("packet", "get_block_from_sendq");
	    return 0;
	}
	new->pqPrevPacket = (YYPKTQUEENT *)NULL;
	pkt = new->pqPacketBody;
	DebugPrint0(3, "Take One Block from Packet\n");
	DebugPrint2(5, "Command Number#%d, Packet Type 0%o\n",
		    pkt->pktCommand, pkt->pktType);
    }
    *lengp = YYPACKET_LENGTH_INBLOCK(pkt);
    *bpp = YYPACKET_CUR_BLOCK(pkt)->pbBuf;
    YYPACKET_CUR_BLOCK(pkt) = YYPACKET_NEXT_BLOCK(pkt);
    DebugEndFunc("packet", "get_block_from_sendq");
    return *lengp;
}

int get_block_from_eventq(queue, bpp, lengp)
    yy_packet_system_queue *queue;
    byte **bpp;
    int *lengp;
{
    yy_packet *pkt;
    DebugSetFunc("packet", "get_block_from_eventq");
    if (queue->sysqEvent == (YYPKTQUEENT *)NULL) {
	DebugPrint0(5, "EventQ has no packet\n");
	DebugEndFunc("packet", "get_block_from_eventq");
	return 0;
    }
    pkt = queue->sysqEvent->pqPacketBody;
    DebugPrint0(3, "Take One Block from Packet\n");
    DebugPrint2(5, "Command Number#%d, Packet Type 0%o\n",
		pkt->pktCommand, pkt->pktType);
    if (YYPACKET_CUR_BLOCK(pkt) == (yy_packet_block *)NULL) {
	/* free area for this packet */
	YYPKTQUEENT *old = queue->sysqEvent;
	YYPKTQUEENT *new = queue->sysqEvent->pqNextPacket;
	DebugPrint0(3, "Aha! This Packet has no more block..\n");
	remove_yy_packet(pkt);
	free_packet_queue_ent(old);
	if ((queue->sysqEvent = new) == (YYPKTQUEENT *)NULL) {
	    DebugPrint0(5, "EventQ has no packet\n");
	    DebugEndFunc("packet", "get_block_from_eventq");
	    return 0;
	}
	new->pqPrevPacket = (YYPKTQUEENT *)NULL;
	pkt = new->pqPacketBody;
	DebugPrint0(3, "Take One Block from Packet\n");
	DebugPrint2(5, "Command Number#%d, Packet Type 0%o\n",
		    pkt->pktCommand, pkt->pktType);
    }
    *lengp = YYPACKET_LENGTH_INBLOCK(pkt);
    *bpp = YYPACKET_CUR_BLOCK(pkt)->pbBuf;
    YYPACKET_CUR_BLOCK(pkt) = YYPACKET_NEXT_BLOCK(pkt);
    DebugEndFunc("packet", "get_block_from_eventq");
    return *lengp;
}

void put_packet_on_sendq(queue, pkt)
    yy_packet_system_queue *queue;
    yy_packet *pkt;
{
    register YYPKTQUEENT *cur;
    register YYPKTQUEENT **qp;

    DebugSetFunc("packet", "put_packet_on_sendq");
    fix_yy_packet(pkt);
    if (DebugON(8))
	dump_yy_packet(pkt);
    qp = ((pkt->pktType == YYPACKETTYPE_EVENT)?
	  &queue->sysqEvent: &queue->sysqSend);
#ifdef KEISUKEDEBUG
    if (pkt->pktType == YYPACKETTYPE_EVENT)
	printf(">> Event Packet<%d> is put in SendQ\n", pkt->pktCommand);
#endif /*KEISUKEDEBUG*/
    if ((cur = *qp) == (YYPKTQUEENT *)NULL) {
	cur = *qp = alloc_packet_queue_ent();
	cur->pqPacketBody = pkt;
	cur->pqNextPacket = (YYPKTQUEENT *)NULL;
	cur->pqPrevPacket = (YYPKTQUEENT *)NULL;
    } else {
	register YYPKTQUEENT *new = alloc_packet_queue_ent();
	while (cur->pqNextPacket != (YYPKTQUEENT *)NULL)
	    cur = cur->pqNextPacket;
	cur->pqNextPacket = new;
	new->pqPacketBody = pkt;
	new->pqPrevPacket = cur;
	new->pqNextPacket = (YYPKTQUEENT *)NULL;
    }
    DebugEndFunc("packet", "put_packet_on_sendq");
}

void dump_yy_packet(pkt)
    yy_packet *pkt;
{
    int num = 1;
    yy_packet_block *pb;
    DebugSetFunc("packet", "dump_yy_packet");
    DebugPrint1(1, "PacketLength: %d\n", YYPACKET_LENGTH(pkt));
    pb = &pkt->pktFirstBlock;
    for ( ; pb != (yy_packet_block *)NULL; pb = pb->pbNextBlock, num++) {
	byte *vp;
	int line, size;
	size = pb->pbBlockSize - pb->pbFreeSize;
	DebugPrint3(2, "Block #%d - Block Size: %d, Length: %d\n",
		    num, pb->pbBlockSize, size);
	DebugPrint0(3, "     0  1  2  3  4  5  6  7\n");
	vp = pb->pbBuf;
	line = 0;
	while (size > 0) {
	    byte *p;
	    int col, len;
	    DebugPrint1(3, "%3d", line); line++;
	    for (p = vp, col = 8, len = size;
		 len > 0 && col > 0; len--, col--, p++)
		DebugPrint1(3, " %02x", (int)*p);
	    while (col-- > 0)
		DebugPrint0(3, "   ");
	    DebugPrint0(3, "   ");
	    for (p = vp, col = 8, len = size;
		 len > 0 && col > 0; len--, col--, p++)
		DebugPrint1(3, "%c",
			    (*p > ' ' && *p < 0177? *p: ' '));
	    vp = p;
	    size = len;
	    DebugPrint0(3, "\n");
	}
    }
    DebugEndFunc("packet", "dump_yy_packet");
}

#ifdef notdef

typedef struct _yy_packet_block_ YYPACKETBLOCK;
struct _yy_packet_block_ {
    int pbSize;		/* (Max) Size of Data Area */
    int pbLeng;		/* Length of Active Data */
    byte *pbBuf;	/* Data Area */
    struct _yy_packet_block_ *pbNextBlock;
    struct _yy_packet_block_ *pbPrevBlock;
} ;

#define YYPKTOP_NONE		0	/* ⤷ʤ (顼) */
#define YYPKTOP_READ		1	/* ѥåȹ¤ǡɤߤ */
#define YYPKTOP_WRITE		2	/* ѥåȹ¤ؤΥǡν񤭹 */
#define YYPKTOP_RECV		3	/* ѥåȥǡμ */
#define YYPKTOP_SEND		4	/* ѥåȥǡ */
#define YYPKTOP_ALLOC		5	/* ΰγ */
#define YYPKTOP_FREE		6	/* ΰγ */

struct _yy_packet_ {
    /* Packet Control Information */
    int pktOPType;			/* Operation Type */
    int pktPriority;			/* Priority */
    /* Packet Header Information */
    int pktYYOpe;			/* YY-Operation Number */
    int pktType;			/* Type of Packet */
    int pktLeng;			/* Total Size of this packet */
    YYPACKETBLOCK pktFirstBlock;	/* First Block of this packet */
    /* Packet Read/Write Control */
    YYPACKETBLOCK *pktCurBlock;		/* Current Block */
    union {
	byte *rwRead;			/* Read PTR */
	byte *rwWrite;			/* Write PTR */
    } pktRWPtrEnt;
    int pktActiveInBlock;		/* Length of Written Data in Block */
    int pktFreeInBlock;			/* Length of Room in Block */
    int pktReadInBlock;			/* Read Data in Block */
    int pktUnreadInBlock;		/* Unread Data in Block */
} ;
#define pktReadPtr	pktRWPtrEnt.rwRead
#define pktWritePtr	pktRWPtrEnt.rwWrite


/*
 * void goto_next_read_packet(pkt)
 *
 * YY ˤѥå pkt ˤơߤΥ֥å
 * Υ֥åɤ߽Ф褦ꤹ
 */
static void goto_next_read_packet(pkt)
    register YYPACKET *pkt;
{
    register YYPACKETBLOCK *next;
    DebugSetFunc("packet", "goto_next_read_packet");
    /* fix length of unread data in Packet */
    pkt->pktUnreadLength -= YYPACKET_CURBLOCK(pkt)->pbUnreadLength;
    YYPACKET_CURBLOCK(pkt)->pbUnreadLength = 0;
    next = YYPACKET_CURBLOCK(pkt)->pbNextBlock;
    if (next != (YYPACKETBLOCK *)NULL) {
	next->pbReadPtr = next->pbBuf + sizeof(YYPACKETHEADER);
	next->pbUnreadLength = next->pbLength - sizeof(YYPACKETHEADER);
	YYPACKET_CURBLOCK(pkt) = next;
    } else {
	pkt->pktUnreadLength = 0;
    }
    DebugEndFunc("packet", "goto_next_read_packet");
    /*NoReturnValue*/
}

/*
 * void skip_packet_read_ptr(pkt, bytes)
 *
 * ѥå pkt ɤߤ֤ bytes 
 * bytes ʤ֤˥֥åΰ褬äƤޤä
 * Υ֥å˿ʤ
 */
static void skip_packet_read_ptr(pkt, bytes)
    register YYPACKET *pkt;
    register int bytes;
{
    DebugSetFunc("packet", "skip_packet_read_ptr");
    if (YYPACKET_CURBLOCK(pkt)->pbUnreadLength < bytes) {
	bytes -= YYPACKET_CURBLOCK(pkt)->pbUnreadLength;
	goto_next_read_packet(pkt);
    }
    if (YYPACKET_CURBLOCK(pkt)->pbUnreadLength >= bytes) {
	YYPACKET_READ_PTR(pkt) += bytes;
	pkt->pktUnreadLength -= bytes;
	YYPACKET_CURBLOCK(pkt)->pbnreadLength -= bytes;
    } else {
	pkt->pktUnreadLength = 0;
	YYPACKET_CURBLOCK(pkt)->pbnreadLength = 0;
    }
    DebugEndFunc("packet", "skip_packet_read_ptr");
    /*NoReturnValue*/
}

/*
 * void fix_packet_read_ptr(pkt, fix_boundary, room)
 *
 * ѥå pkt ɤߤ֤碌
 * fix_boundary  TRUE ǤС4ХȤζ
 * 碌褦ˤ
 * ߤΥ֥å room ХȤ̤ɤΰ褬ĤäƤʤ
 * Υ֥åɤ߽Ф褦ꤹ
 *   (Υ֥åλĤʬϼΤƤ)
 */
static void fix_packet_read_ptr(pkt, fix_boundary, room)
    register YYPACKET *pkt;
    register bool fix_boundary;
    register int room;
{
    register int bound;
    DebugSetFunc("packet", "fix_packet_read_ptr");
    if (fix_boundary &&
	(bound = ((YYPACKET_CURBLOCK(pkt)->pbUnreadLength)&3)) > 0) {
#ifdef DEBUGPRINT0
	DebugPrint0(9, "Fix Boundary\n");
#endif /*DEBUGPRINT0*/
	(void)skip_packet_read_ptr(pkt, (4 - bound));
    }
    if (YYPACKET_UNREADLENGTH_INBLOCK(pkt) < room)
	goto_next_read_packet(pkt);
    DebugEndFunc("packet", "fix_packet_read_ptr");
}

/***************************************************************************
 *****  WritePtr
 ***************************************************************************/

/*
 * void goto_next_write_packet(pkt)
 *
 * YY ˤѥå pkt ˤơߤΥ֥å
 * Υ֥å˽񤭹ߤǤ褦ꤹ
 */
static void goto_next_write_packet(pkt)
    register YYPACKET *pkt;
{
    register YYPACKETBLOCK *next;

    DebugSetFunc("packet", "goto_next_write_packet");
    next = YYPACKET_CURBLOCK(pkt)->pbNextBlock;
    if (next == (YYPACKETBLOCK *)NULL) {
#ifdef DEBUGPRINT0
	DebugPrint0(9, "Allocate New Packet Block\n");
#endif /*DEBUGPRINT0*/
	next = alloc_packet_block(pkt, (bytes *)NULL);
    }
    next->pbWritePtr = next->pbBuf + sizeof(YYPACKETHEADER);
    next->pbFreeLength = next->pbSize - sizeof(YYPACKETHEADER);
    YYPACKET_CURBLOCK(pkt) = next;
    DebugEndFunc("packet", "goto_next_write_packet");
    /*NoReturnValue*/
}

/*
 * void skip_packet_write_ptr(pkt, bytes)
 *
 * ѥå pkt ν񤭹֤߰ bytes 
 * bytes ʤ֤˥֥åΰ褬äƤޤä
 * Υ֥å˿ʤ
 */
static void skip_packet_write_ptr(pkt, bytes)
    register YYPACKET *pkt;
    register int bytes;
{
    DebugSetFunc("packet", "skip_packet_write_ptr");
    if (YYPACKET_CURBLOCK(pkt)->pbFreeLength < bytes) {
	bytes -= YYPACKET_CURBLOCK(pkt)->pbFreeLength;
	goto_next_read_packet(pkt);
    }
    if (YYPACKET_CURBLOCK(pkt)->pbFreeLength >= bytes) {
	YYPACKET_WRITE_PTR(pkt) += bytes;
	YYPACKET_CURBLOCK(pkt)->pbFreeLength -= bytes;
	pkt->pktLength += bytes;
    } else {
	YYPACKET_CURBLOCK(pkt)->pbFreeLength = 0;
    }
    DebugEndFunc("packet", "skip_packet_write_ptr");
    /*NoReturnValue*/
}


/*
 * void fix_packet_write_ptr(pkt, fix_boundary, room)
 *
 * ѥå pkt ν񤭹֤߰碌
 * fix_boundary  TRUE ǤС4ХȤζ
 * 碌褦ˤ
 * ߤΥ֥å room ХȤν񤭹ΰ褬ĤäƤʤ
 * Υ֥å񤭹褦ꤹ
 *   (Υ֥åλĤʬ֤Ȥʤ)
 */
static void fix_packet_write_ptr(pkt, fix_boundary, room)
    register YYPACKET *pkt;
    register bool fix_boundary;
    register int room;
{
    register int bound;

    DebugSetFunc("packet", "fix_packet_write_ptr");
    if (fix_boundary &&
	(bound = ((YYPACKET_CURBLOCK(pkt)->pbLength)&3)) > 0) {
#ifdef DEBUGPRINT0
	DebugPrint0(9, "Fix Boundary\n");
#endif /*DEBUGPRINT0*/
	(void)skip_packet_read_ptr(pkt, (4 - bound));
    }
    if (YYPACKET_UNREADLENGTH_INBLOCK(pkt) < room)
	goto_next_read_packet(pkt);
    DebugEndFunc("packet", "fix_packet_write_ptr");
}

/***************************************************************************
 *****
 ***************************************************************************/

bool pkt_entry_integer(pkt, dp)
    register YYPACKET *pkt;
    int *dp;
{
    register bool status = TRUE;

    DebugSetFunc("packet", "pkt_entry_integer");
    switch (pkt->pktOperation) {
    case YYPKT_READ:
	/* Get One Interger Value from Packet */
	fix_packet_read_ptr(pkt, YYPKT_FIX_BOUNDARY, 4);
	if (YYPACKET_UNREAD_LENGTH(pkt) > 3) {
#ifdef FOURBYTESINT
	    (void)bcopy(YYPACKET_READ_PTR(pkt), dp, 4);
#else /*!FOURBYTESINT*/
	    if (sizeof(int) < 4) {
		(void)bcopy(YYPACKET_READ_PTR(pkt), dp, 4);
	    } else {
		*dp = 0;
		(void)bcopy(YYPACKET_READ_PTR(pkt), dp+(sizeof(int)-4), 4);
	    }
#endif /*!FOURBYTESINT*/
	    skip_packet_read_ptr(pkt, 4);
	} else {
	    *dp = 0; status = FALSE;
	}
	break;
    case YYPKT_WRITE:
	/* Put One Interger Value on Packet */
	fix_packet_write_ptr(pkt, YYPKT_FIX_BOUNDARY, 4);
#ifdef FOURBYTESINT
	(void)bcopy(dp, YYPACKET_WRITE_PTR(pkt), 4);
#else /*!FOURBYTESINT*/
	if (sizeof(int) < 4) {
	    (void)bzero(YYPACKET_WRITE_PTR(pkt), 4);
	    (void)bcopy(dp, YYPACKET_WRITE_PTR(pkt)+(4-sizeof(int)),
			sizeof(int));
	} else {
	    (void)bcopy(dp+(sizeof(int)-4), YYPACKET_WRITE_PTR(pkt), 4);
	}
#endif /*!FOURBYTESINT*/
	skip_packet_write_ptr(pkt, 4);
	break;
    case YYPKT_ALLOC:
    case YYPKT_FREE:
	/*Do Nothing*/
	break;
    }
    DebugEndFunc("packet", "pkt_entry_integer");
    return TRUE;
}

typedef struct {
    int Leng;
    char *Ptr;
} pktstring;

bool pkt_entry_string(pkt, dp)
    register YYPACKET *pkt;
    pkt_string *dp;
{
    register bool status = TRUE;

    DebugSetFunc("packet", "pkt_entry_string");
    switch (pkt->pktOperation) {
    case YYPKT_READ:
	/* Get String from Packet */
	pkt_entry_integer(pkt, dp->leng);
	if (dp->leng > 0) {
	    dp->ptr = (char *)memALLOC(dp->leng);
	} else {
	    int dummy;
	    pkt_entry_integer(pkt, &dummy);
	}
	break;
    case YYPKT_WRITE:
	/* Put One Interger Value on Packet */
	fix_packet_write_ptr(pkt, YYPKT_FIX_BOUNDARY, 4);
#ifdef FOURBYTESINT
	(void)bcopy(dp, YYPACKET_WRITE_PTR(pkt), 4);
#else /*!FOURBYTESINT*/
	if (sizeof(int) < 4) {
	    (void)bzero(YYPACKET_WRITE_PTR(pkt), 4);
	    (void)bcopy(dp, YYPACKET_WRITE_PTR(pkt)+(4-sizeof(int)),
			sizeof(int));
	} else {
	    (void)bcopy(dp+(sizeof(int)-4), YYPACKET_WRITE_PTR(pkt), 4);
	}
#endif /*!FOURBYTESINT*/
	skip_packet_write_ptr(pkt, 4);
	break;
    case YYPKT_ALLOC:
    case YYPKT_FREE:
	/*Do Nothing*/
	break;
    }
    DebugEndFunc("packet", "pkt_entry_string");
    return TRUE;
}

#endif

/* $RCSFile:$
 */
/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
