/* Functions for EUC code handling
 * This file is part of YY-server of YYonX (1.4 Distribution)
 * $Id: kanji.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <sys/types.h>
#include "yydefs.h"

/**********************************************************************
 *****
 ***** $@F|K\8l(J EUC $@A`:n$N$?$a$N4X?t(J
 *****
 ***** $@0J2<$N4X?t$O4A;zF~NO$NM-L5$K4X78$J$/4A;zEy$r4^$`I=<($N$?$a$K$b(J
 ***** $@I,MW$G$"$k(J
 *****
 **********************************************************************/

/* JEUC_StrNChar(leng, ptr)
 *
 * ptr $@$r@hF,$H$9$kD9$5(J($@%P%$%H?t(J) leng $@$NJ8;zNs$rF|K\8l(JEUC$@J8;zNs$H$_$?(J
 * $@$H$-$NJ8;z?t$rF@$k(J
 *
 * BUG:
 *  $@:G8e$NJ8;z$,IT40A4$J$b$N$G$"$k(J ($@Nc$($P#2%P%$%HJ8;z$G$"$k$K$b(J
 *  $@$+$+$o$i$:%P%$%H?t$H$7$F$O#1$7$+B8:_$7$J$$(J) $@>l9g$K$O(J
 *  $@$=$l$OJ8;z$H$7$F%+%&%s%H$7$J$$(J
 */
int JEUC_StrNChar(leng, ptr)
    register int leng;
    register u_char *ptr;
{
    register int nchar = 0;
    DebugSetFunc("jeuc", "JEUC_StrNChar");
    while (leng > 0) {
	register int bytes = JEUC_Bytes(ptr);
	if (leng < bytes)
	    break;
	leng -= bytes;
	ptr += bytes;
	nchar++;
    }
    DebugEndFunc("jeuc", "JEUC_StrNChar");
    return nchar;
}

/* JEUC_StrNChar(leng, ptr)
 *
 * ptr $@$r@hF,$H$9$kD9$5(J($@J8;z?t(J) nchar $@$NJ8;zNs$rF|K\8l(JEUC$@J8;zNs$H$_$?(J
 * $@$H$-$N%P%$%H?tD9$5$rF@$k(J
 */
int JEUC_StrLen(nchar, ptr)
    register int nchar;
    register u_char *ptr;
{
    register int leng = 0;
    DebugSetFunc("jeuc", "JEUC_StrLen");
    while (nchar > 0) {
	register int bytes = JEUC_Bytes(ptr);
	leng += bytes;
	ptr += bytes;
	nchar--;
    }
    DebugEndFunc("jeuc", "JEUC_StrLen");
    return leng;
}

/* Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
