/* Support Character Input on Page Territory
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: edit.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

#ifndef lint
static char *RcsId =
    "$Id: edit.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/06/07 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.3 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"

static void input_beginning_of_line(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int col, row;

    DebugSetFunc("input", "input_beginning_of_line");
    col = ((row = GETPAGEROW(input_pg)) > 0? 0: input_pg->startCol);
    DebugPrint3(5, "Move CharCursor to <%d,%d> on TR#%d\n",
		col, row, input_tr->teID);
    locate_char_cursor_on_page(&input_pg->pcPagePlane, col, row);
    locate_char_cursor_on_page(&input_pg->pcInputPlane, 0, row);
    DebugEndFunc("input", "input_beginning_of_line");
    /*NoReturnValue*/
}

static void input_end_of_line(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int rcol;

    DebugSetFunc("input", "input_end_of_line");
    rcol = total_nchar_in_line_buffer(input_pg->pcPagePlane.curLineTop)
	- GETPAGECOL(input_pg);
    DebugPrint3(5, "Move CharCursor to <%d,%d> on TR#%d\n",
		rcol, 0, input_tr->teID);
    move_char_cursor_on_page(&input_pg->pcPagePlane, rcol, 0);
    move_char_cursor_on_page(&input_pg->pcInputPlane, rcol, 0);
    DebugEndFunc("input", "input_end_of_line");
    /*NoReturnValue*/
}

static void input_forward_char(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    PAGELINE *top = input_pg->pcPagePlane.curLineTop;

    DebugSetFunc("input", "input_forward_char");
    if (GETPAGECOL(input_pg) < total_nchar_in_line_buffer(top)) {
	DebugPrint3(5, "Move CharCursor to <%d,%d> on TR#%d\n",
		    1, 0, input_tr->teID);
	move_char_cursor_on_page(&input_pg->pcPagePlane, 1, 0);
	move_char_cursor_on_page(&input_pg->pcInputPlane, 1, 0);
    } else if (top->nextLine != (PAGELINE *)NULL) {
	int row = GETPAGEROW(input_pg)+1;
	DebugPrint3(5, "Move CharCursor to <%d,%d> on TR#%d\n",
		    0, row, input_tr->teID);
	locate_char_cursor_on_page(&input_pg->pcPagePlane, 0, row);
	locate_char_cursor_on_page(&input_pg->pcInputPlane, 0, row);
    }
    DebugEndFunc("input", "input_forward_char");
    /*NoReturnValue*/
}

static void input_backward_char(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;

    DebugSetFunc("input", "input_backward_char");
    if (GETPAGEROW(input_pg) == 0) {
	if (GETPAGECOL(input_pg) > input_pg->startCol) {
	    move_char_cursor_on_page(&input_pg->pcPagePlane, (-1), 0);
	    move_char_cursor_on_page(&input_pg->pcInputPlane, (-1), 0);
	}
    } else if (GETPAGECOL(input_pg) > 0) {
	move_char_cursor_on_page(&input_pg->pcPagePlane, (-1), 0);
	move_char_cursor_on_page(&input_pg->pcInputPlane, (-1), 0);
    } else {
	PAGELINE *prevtop = input_pg->pcInputPlane.curLineTop->prevLine;
	register int col = total_nchar_in_line_buffer(prevtop);
	register int row = GETPAGEROW(input_pg)-1;
	DebugPrint3(5, "Move CharCursor to <%d,%d> on TR#%d\n",
		    col+input_pg->startCol, row, input_tr->teID);
	locate_char_cursor_on_page(&input_pg->pcPagePlane,
				   col+input_pg->startCol, row);
	locate_char_cursor_on_page(&input_pg->pcInputPlane, col, row);
    }
    DebugEndFunc("input", "input_backward_char");
    /*NoReturnValue*/
}

static void input_delete_char(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;

    DebugSetFunc("input", "input_delete_char");
    delete_string_on_page(&input_pg->pcPagePlane, 1);
    delete_string_on_page(&input_pg->pcInputPlane, 1);
    redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    DebugEndFunc("input", "input_delete_char");
    /*NoReturnValue*/
}

static void input_delete_backward_char(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;

    DebugSetFunc("input", "input_delete_backward_char");
    if (GETPAGEROW(input_pg)>0 || GETPAGECOL(input_pg)>input_pg->startCol) {
	(void)input_backward_char(ch, tr, leng, ptr);
	(void)input_delete_char(ch, tr, leng, ptr);
    }
    DebugEndFunc("input", "input_delete_backward_char");
    /*NoReturnValue*/
}

/* ʹߤõ */
static void input_kill_line(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;
    register int col = GETPAGECOL(input_pg);
    register int max;

    DebugSetFunc("input", "input_kill_line");
    max = total_nchar_in_line_buffer(input_pg->pcPagePlane.curLineTop);
    if (col < max) {
	delete_string_on_page(&input_pg->pcPagePlane, (max-col));
	delete_string_on_page(&input_pg->pcInputPlane, (max-col));
	redraw_page_plane(ch, input_tr, &input_pg->pcPagePlane);
    } else
	(void)input_delete_char(ch, tr, leng, ptr);
    DebugEndFunc("input", "input_kill_line");
    /*NoReturnValue*/
}

static void input_redraw() {}

static void input_start_kana_input(ch, tr, leng, ptr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int leng;
    u_char *ptr;
{
    TERRITORY *input_tr = tr->teModeEnt.tPageControl.pcInputTerritory;
    TERRITORY_PAGE *input_pg = &input_tr->teModeEnt.tPageControl;

    DebugSetFunc("input", "input_start_kana_input");
#ifdef KINPUT
    input_pg->pcOperationMode &= ~PAGEOP_INPUTMODE;
    input_pg->pcOperationMode |= YYIN_KANA;
    destroy_page_plane(&input_pg->pcKanaInputPlane);
    init_page_plane(&input_pg->pcKanaInputPlane, GETPAGEFID(input_pg),
		    4, "    ");
    locate_char_cursor_on_page(&input_pg->pcKanaInputPlane, 0, 0);
#endif /*KINPUT*/
    DebugEndFunc("input", "input_start_kana_input");
    /*NoReturnValue*/
}

YYEDITFUNCLIST YYInputEditFuncList[] = {
{ "beginning-of-line", input_beginning_of_line },
{ "backward-char", input_backward_char },
{ "delete-char", input_delete_char },
{ "end-of-line", input_end_of_line },
{ "forward-char", input_forward_char },
{ "delete-backward-char", input_delete_backward_char },
{ "kill-line", input_kill_line },
{ "redraw", input_redraw },
{ "start-kana-input", input_start_kana_input },
{ NULL, NULL}
} ;

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
