/* Routines for YY-protocol
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: comm.c,v 3.1 1992/10/27 08:10:20 keisuke Exp keisuke $
 */

#ifndef lint
static char *RcsId =
    "$Id: comm.c,v 3.1 1992/10/27 08:10:20 keisuke Exp keisuke $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.2 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.1 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/27 08:10:20 $
****************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include "yydefs.h"
#include "yypacket.h"
#include "sched.h"

/*
 * Communication
 */

extern int YYPacketBlockSize;

static void recv_yy_packet();
static void send_yy_packet();
static void send_yy_event_packet();

#define QUE(c)		(&(c)->ccSystemQueue)
#define SENDQ(c)	((c)->ccSystemQueue.sysqSend)
#define SENDEVENTQ(c)	((c)->ccSystemQueue.sysqEvent)
#define READQ(c)	((c)->ccSystemQueue.sysqRead)
#define RECVQ(c)	((c)->ccSystemQueue.sysqRecv)
#define WRITEQ(c)	((c)->ccSystemQueue.sysqWrite)

static yy_font_table *alloc_font_table();

/* int make_unix_tmp_dir()
 *
 * UNIX Domain socket ΤΥǥ쥯ȥ(̾ '/tmp/.YY-unix')
 * 
 */
int make_unix_tmp_dir()
{
    struct stat s_buf;
    if (stat(YYPROTO_UNIX_DIR, &s_buf) == 0) {
	if (S_ISDIR(s_buf.st_mode))
	    return 0;
	fprintf(stderr, "%s: Unknwon file type\n", YYPROTO_UNIX_DIR);
	return -1;
    }
    if (mkdir(YYPROTO_UNIX_DIR, 0777) < 0 || chmod(YYPROTO_UNIX_DIR, 0777) < 0)
	return -1;
    return 0;
}

#ifdef SCHEDDEBUG
static void dummy_sched_function(ch, myself, id, type, flag, tp, delay)
    yy_comm_channel *ch;
    void (*myself)();
    int id, type, flag;
    struct timeval *tp;
    long delay;
{
    printf("dummy_sched_function() is called\n");
    printf(" TIME: %ld.%ld, DELAY=%ld\n", tp->tv_sec, tp->tv_usec, delay);
    /* εư֤60ø˼ʬȤƵư */
    tp->tv_sec += 60;
    yysched_addque(ch, myself, id, type, flag, tp, 0);
}
#endif /*SCHEDDEBUG*/


int wait_first_connection(ureq, ireq)
    int ureq;	/* UNIX Domain */
    int ireq;	/* INET Doamin */
{
    int width = MAX(ureq, ireq)+1;
    int fd;
    fd_set rfds;
#ifdef SCHEDDEBUG
    struct timeval timeout, *tp;
    yy_comm_channel dummy;
    int i;
    int selectval;
#endif /*SCHEDDEBUG*/

    DebugSetFunc("network", "wait_first_connection");
#ifdef SCHEDDEBUG
    dummy.ccSchedQueue = (YYSCHED *)NULL;
    for (i = 1; i <= 30; i++) {
	yysched_addque(&dummy, dummy_sched_function,
		       1, YYSCHED_TYPE_ANIMATION, 0,
		       (struct timeval *)NULL, 2000*i);
    }
#endif /*SCHEDDEBUG*/
    for (;;) {
	FD_ZERO(&rfds);
	FD_SET(ireq, &rfds);
	FD_SET(ureq, &rfds);
#ifdef SCHEDDEBUG
	tp = yysched_get_next_time(&dummy, &timeout);
	DebugPrint2(5, "Select will be timeout on %ld.%ld\n",
		    (tp? tp->tv_sec: 0), (tp? tp->tv_usec: 0));
	selectval = select(width, &rfds, NULL, NULL, tp);
	if (selectval < 0) { perror("Select"); return -1; }
	if (selectval > 0) {
	    if (FD_ISSET((fd = ireq), &rfds)) break;
	    if (FD_ISSET((fd = ureq), &rfds)) break;
	    /* 褯狼ʤ */
	} else {
	    /* ڤ */
	    yysched_popque(&dummy);
	}
#else
	if (select(width, &rfds, NULL, NULL, NULL) < 0) {
	    perror("Select");
	    return -1;
	}
	if (FD_ISSET((fd = ireq), &rfds)) break;
	if (FD_ISSET((fd = ureq), &rfds)) break;
#endif
    }
    DebugEndFunc("network", "wait_first_connection");
    return fd;
}

int wait_second_connection(req)
    int req;
{
    struct sockaddr addr;
    int addrlen;
    int sock;
    DebugSetFunc("network", "wait_second_connection");
    addrlen = sizeof(addr);
    if ((sock = accept(req, &addr, &addrlen)) < 0) {
	perror("accept");
	return -1;
    }
    DebugPrint2(1, "accept request on %d/%s\n", sock,
		(addr.sa_family == PF_UNIX? "UNIX": "INET"));
    DebugEndFunc("network", "wait_second_connection");
    return sock;
}

#ifdef SUPERSERVER
/* YY request դΤ INET port 򳫤
 */
int open_inet_request_port()
{
    struct sockaddr_in addr;
    int retry;
    int sock;
    DebugSetFunc("network", "open_inet_request_port");
    if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
	perror("Socket"); return -1;
    }
    bzero((char *)&addr, sizeof(addr));
    addr.sin_family = PF_INET;
    addr.sin_port = htons(YYPROTO_INET_PORT);
    DebugPrint1(1, "waiting on PORT#%d\n", ntohs(addr.sin_port));
    retry = 5;
    while (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
	if (--retry == 0) {
	    perror("bind"); return -1;
	}
	sleep(5);
    }
    if (listen(sock, 5) < 0) {
	perror("listen"); return -1;
    }
    DebugEndFunc("network", "open_inet_request_port");
    return sock;
}


/* YY request դΤ UNIX domain port 򳫤
 */
int open_unix_request_port()
{
    int sock;
    struct sockaddr_un addr;
    int retry;
    DebugSetFunc("network", "open_unix_request_port");
    if (make_unix_tmp_dir() < 0) {
	fprintf(stderr, "Can't create '%s' directory\n", YYPROTO_UNIX_DIR);
	return -1;
    }
    if ((sock = socket(PF_UNIX, SOCK_STREAM, 0)) < 0) {
	perror("Socket"); return -1;
    }
    bzero((char *)&addr, sizeof(addr));
    addr.sun_family = PF_UNIX;
    sprintf(addr.sun_path, "%s/%s",
	    YYPROTO_UNIX_DIR, YYPROTO_UNIX_PORT);
    unlink(addr.sun_path);
    DebugPrint1(1, "waiting on PORT'%s'\n", addr.sun_path);
    retry = 5;
    while (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
	if (--retry == 0) {
	    perror("bind"); return -1;
	}
	sleep(5);
    }
    if (listen(sock, 1) < 0) {
	perror("listen"); return -1;
    }
    DebugEndFunc("network", "open_unix_request_port");
    return sock;
}

/* ٥ȼդΤ INET port 򳫤
 */
int open_inet_event_port(addrp)
    struct sockaddr_in *addrp;
{
    int sock;
    int no;
    DebugSetFunc("network", "open_inet_event_port");
    if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
	perror("Socket"); return -1;
    }
    bzero((char *)addrp, sizeof(struct sockaddr_in));
    for (no = 1; no <= YYMAX_CONNECTION ; no++) {
	addrp->sin_family = PF_INET;
	addrp->sin_port = htons(YYPROTO_INET_PORT+no);
	DebugPrint1(1, "waiting on PORT#%d\n", ntohs(addrp->sin_port));
	if (bind(sock, (struct sockaddr *)addrp, sizeof(struct sockaddr_in)) == 0) {
	    if (listen(sock, 1) < 0) {
		perror("listen"); return -1;
	    }
	    break;
	}
	sleep(1);
    }
    DebugEndFunc("network", "open_inet_event_port");
    return sock;
}

/* YY request դΤ UNIX domain port 򳫤
 */
int open_unix_event_port(addrp)
    struct sockaddr_un *addrp;
{
    int sock;
    int no;
    DebugSetFunc("network", "open_unix_event_port");
    if ((sock = socket(PF_UNIX, SOCK_STREAM, 0)) < 0) {
	perror("Socket"); return -1;
    }
    for (no = 1; ; no++) {
	bzero((char *)addrp, sizeof(struct sockaddr_un));
	addrp->sun_family = PF_UNIX;
	sprintf(addrp->sun_path, "%s/%s%04d",
		YYPROTO_UNIX_DIR, YYPROTO_UNIX_PORT, no);
	DebugPrint1(1, "waiting on PORT'%s'\n", addrp->sun_path);
	if (bind(sock, (struct sockaddr *)addrp, sizeof(struct sockaddr_un)) == 0) {
	    if (listen(sock, 2) < 0) {
		perror("listen"); return -1;
	    }
	    DebugPrint1(1, "Waiting on '%s'\n", addrp->sun_path);
	    break;
	}
    }
    DebugEndFunc("network", "open_unix_event_port");
    return sock;
}










static yy_comm_channel *wait_new_client(uport, iport)
    int uport, iport;
{
    static yy_comm_channel ch_buf;
    struct sockaddr addr;
    int addrlen;
    int req;

    ch_buf.ccXFd = -1;
    ch_buf.ccXNeedFlush = FALSE;
    ch_buf.ccXPrivate = (char *)NULL;
    ch_buf.ccXEventEnable = TRUE;
    ch_buf.ccXMotionEnable = TRUE;
    ch_buf.ccXDClickInterval = YYMOUSE_DCLICK_TIME;
    ch_buf.ccXDClickRegion = YYMOUSE_DCLICK_REGION;

    /* Entries for YY Client */
    ch_buf.ccYYServNo = 0;
    ch_buf.ccYYCmdCH.FD = ch_buf.ccYYEvtCH.FD = -1;	/* Socket */
    ch_buf.ccYYSyncCount = ch_buf.ccYYSyncPacketNum = 0;
    /* Font Table */
    ch_buf.ccFontTable = alloc_font_table(YYFONTINFOFILE);
    /* Packet Queue */
    SENDQ(&ch_buf) = RECVQ(&ch_buf) = SENDEVENTQ(&ch_buf) =
	(YYPKTQUEENT *)NULL;
    READQ(&ch_buf) = WRITEQ(&ch_buf) = (YYPKTQUEENT *)NULL;
    /* TimeOut Table */
    ch_buf.ccSchedQueue = (YYSCHED *)NULL;
    ch_buf.ccYYWaitTime = DEFAULTTIMEOUT*1000;
    ch_buf.ccYYXFlushCount = (TIMEOUTFORXFLUSH/DEFAULTTIMEOUT);
    ch_buf.ccYYKeyinCount = (TIMEOUTFORKEYIN/DEFAULTTIMEOUT);
#ifdef DEBUG
    /* Debug Table */
    ch_buf.ccDeBugTable.dbWriteBlocked = 0;
    ch_buf.ccDeBugTable.dbTimer.tv_sec = 0;
    ch_buf.ccDeBugTable.dbTimer.tv_usec = 0;
#endif

    /* դ Connection ϡΤޤޥޥ̿ϩȤ
     *  Connection б٥̿ϩ򳫤
     */
    req = wait_first_connection(uport, iport);
    addrlen = sizeof(addr);
    if ((ch_buf.ccYYCmdCH.FD = accept(req, &addr, &addrlen)) < 0) {
	perror("Accept");
	return (yy_comm_channel *)NULL;
    }
    ch_buf.ccYYChannel.yyStatBuf.csDomain = addr.sa_family;
    return &ch_buf;
}


int recv_first_packet(sock)
    int sock;
{
    int leng, rlen;
    char buf[16], user[64], pass[64];
    char *s;
    int magic, version, type, size;

    DebugSetFunc("network", "recv_first_packet");

    /* Recv first 24+X octets
     * Packet Format:
     *  +--------+--------+--------+--------+
     *  |  M  A  G  I  C  N  U  M  B  E  R  |
     *  +--------+--------+--------+--------+
     *  |  V  E  R  S  I  O  N              |
     *  +--------+--------+--------+--------+
     *  |  T  Y  P  E                       |
     *  +--------+--------+--------+--------+
     *  |  L E N G T H (B L O C K #)        |
     *  +--------+--------+--------+--------+
     *  |  P  A  C  K  E  T  S  I  Z  E     |
     *  +--------+--------+--------+--------+
     *  |  Length of USER ID                |
     *  +--------+--------+--------+--------+
     *  |  U  S  E  R     I  D              |
     *  |    ....                           |
     *  +--------+--------+--------+--------+
     *  |  Length of Password               |
     *  +--------+--------+--------+--------+
     *  |  P  A  S  S  W  O  R  D           |
     *  |    ....                           |
     *  +--------+--------+--------+--------+
     */
    recv_from_yy_connection(sock, buf, 20);
    bcopy(buf, (char *)&magic, 4);
    bcopy(&buf[4], (char *)&version, 4);
    bcopy(&buf[8], (char *)&type, 4);
    bcopy(&buf[12], (char *)&leng, 4);
    bcopy(&buf[16], (char *)&size, 4); size <<= 2;
    recv_from_yy_connection(sock, buf, 4);
    bcopy(buf, (char *)&leng, 4);
    if (leng > 0) {
	rlen = ((leng+3)&(~3));
	recv_from_yy_connection(sock, user, rlen);
	user[leng] = '\0';
    }
    recv_from_yy_connection(sock, buf, 4);
    bcopy(buf, (char *)&leng, 4);
    if (leng > 0) {
	rlen = ((leng+3)&(~3));
	recv_from_yy_connection(sock, pass, rlen);
	pass[leng] = '\0';
    }

    DebugPrint1(1, "YYPacketBlockSize in YY-Client is %d\n", size);
    DebugPrint1(1, "YY-Server assumes %d\n", YYPacketBlockSize);
    if (YYPacketBlockSize < size) {
	DebugPrint1(1, " .. No! YYPacketBlockSize = %d\n", YYPacketBlockSize);
	size = YYPacketBlockSize;
    } else {
	DebugPrint1(1, " .. OK! We accept it\n", YYPacketBlockSize);
	YYPacketBlockSize = size;
    }
    DebugEndFunc("network", "recv_first_packet");
    return (size >> 2);
}

int send_first_packet(sock, size, addrp)
    int sock;
    int size;
    struct sockaddr *addrp;
{
    char pac[1024];
    int leng = 0;
    int hlen, plen;
    int magic = YYPROTO_MAGIC;
    int version = 1;
    int server_id = 1;
    DebugSetFunc("network", "send_first_packet");
    bcopy((char *)&magic, &pac[(leng<<2)], 4); leng++;
    bcopy((char *)&version, &pac[(leng<<2)], 4); leng++;
    bcopy((char *)&leng, &pac[(leng<<2)], 4); leng++; /* ϥߡ */
    bcopy((char *)&size, &pac[(leng<<2)], 4); leng++;
    bcopy((char *)&server_id, &pac[(leng<<2)], 4); leng++;
    bcopy((char *)&server_id, &pac[(leng<<2)], 4); leng++; /*桼ID*/
    /* ФΥޥɥݡȼ̻ */
    hlen = 0; plen = 0;
    bcopy((char *)&hlen, &pac[(leng<<2)], 4); leng++;
    bcopy((char *)&plen, &pac[(leng<<2)], 4); leng++;
    /* ٥ȥݡȼ̻ */
    if (addrp->sa_family == PF_UNIX) {
	/* UNIX Domain */
	struct sockaddr_un *ad = (struct sockaddr_un *)addrp;
	DebugPrint0(5, "Send UNIX Domain\n");
	hlen = 0;
	bcopy((char *)&hlen, &pac[(leng<<2)], 4); leng++;
	plen = strlen(ad->sun_path);
	bcopy((char *)&plen, &pac[(leng<<2)], 4); leng++;
	if (plen > 0) {
	    bcopy(ad->sun_path, &pac[(leng<<2)], plen);
	    leng += (((plen-1)>>2)+1);
	}
    } else {
	/* INET Domain */
	struct sockaddr_in *ad = (struct sockaddr_in *)addrp;
	DebugPrint0(5, "Send INET Domain\n");
	hlen = sizeof(ad->sin_addr.s_addr);
	bcopy((char *)&hlen, &pac[(leng<<2)], 4); leng++;
	if (hlen > 0) {
	    bcopy((char *)&ad->sin_addr.s_addr, &pac[(leng<<2)], hlen);
	    leng += (((hlen-1)>>2)+1);
	}
	plen = sizeof(ad->sin_port);
	bcopy((char *)&plen, &pac[(leng<<2)], 4); leng++;
	if (plen > 0) {
	    bcopy((char *)&ad->sin_port, &pac[(leng<<2)], plen);
	    leng += (((plen-1)>>2)+1);
	}
    }
    bcopy((char *)&leng, &pac[8], 4); /* 줬 */
    DebugPrint1(5, "Send %dblock packet\n", leng);
    send_to_yy_connection(sock, pac, (leng<<2));
    DebugEndFunc("network", "send_first_packet");
    return 0;
}


#include <setjmp.h>
static jmp_buf SigChildEnv;
static jmp_buf SigTimeoutEnv;

static void ChildTermination()
{
    wait(0);
    longjmp(SigChildEnv, 1);
}

static void ChildTimeout()
{
    longjmp(SigTimeoutEnv, 1);
}


static int UnixPort = (-1);
static int InetPort = (-1);

static void SuperServerTermination()
{
    fprintf(stderr, "Closing port on YY-server..\n");
    if (InetPort >= 0) {
	shutdown(UnixPort, 2); close(UnixPort);
    }
    if (UnixPort >= 0) {
	shutdown(UnixPort, 2); close(UnixPort);
    }
    exit(0);
}

extern int YYSingleShot;

static void do_yyserv_main(ch)
    yy_comm_channel *ch;
{
    int req;
    struct sockaddr *addrp;
    void (*oldfunc)();

    signal(SIGHUP, SIG_DFL);
    signal(SIGQUIT, SIG_DFL);
    signal(SIGTERM, SIG_DFL);

    /* դ Connection ϡΤޤޥޥ̿ϩȤ
     *  Connection б٥̿ϩ򳫤
     */
    ch->ccYYEvtCH.FD = (-1);
    if (ch->ccYYChannel.yyStatBuf.csDomain == PF_UNIX) {
	/* UNIX Domain */
	static struct sockaddr_un addr;
	DebugPrint1(1, "accept request on %d/UNIX\n", ch->ccYYCmdCH.FD);
	req = open_unix_event_port(&addr);
	addrp = (struct sockaddr *)&addr;
    } else {
	static struct sockaddr_in addr;
	DebugPrint1(1, "accept request on %d/INET\n", ch->ccYYCmdCH.FD);
	req = open_inet_event_port(&addr);
	addrp = (struct sockaddr *)&addr;
    }

    /* ॢȤƻ뤹뤿Υ
     *  fork Ƥ 90 øޤǤ event ΤΥͥޤ
     * λʤΤ򥯥ꥢ
     */
    if (req < 0 || setjmp(SigTimeoutEnv)) {
	fprintf(stderr, "Can't setup connection to new client\n");
	shutdown(ch->ccYYCmdCH.FD, 2);
	close(ch->ccYYCmdCH.FD);
	exit(1);
    }

    /* ǽΥѥåȤΤȤԤʤ
     */
    oldfunc = signal(SIGALRM, ChildTimeout);
    alarm(30);
    ch->ccYYChannel.yyMaxPacketSize = recv_first_packet(ch->ccYYCmdCH.FD);
    alarm(30);
    if (send_first_packet(ch->ccYYCmdCH.FD,
			  ch->ccYYChannel.yyMaxPacketSize, addrp) < 0) {
	DebugPrint0(1, "Error on send_first_packet\n");
	longjmp(SigTimeoutEnv, 1);
    }
    alarm(30);
    if ((ch->ccYYEvtCH.FD = wait_second_connection(req)) < 0) {
	longjmp(SigTimeoutEnv, 1);
    }
    alarm(0);
    signal(SIGALRM, oldfunc);
}


yy_comm_channel *make_channel()
{
    static yy_comm_channel *ch;
    int u_port, i_port;

    DebugSetFunc("network", "make_channel");
    /* ׵դΤΥݡȤ򳫤 */
    InetPort = UnixPort = (-1);
    if ((InetPort = i_port = open_inet_request_port()) < 0 ||
	(UnixPort = u_port = open_unix_request_port()) < 0) {
	fprintf(stderr, "Can't Create Socket (for Request)!!\n");
	DebugEndFunc("network", "make_channel");
	return (yy_comm_channel *)NULL;
    }
    fprintf(stderr, "Waiting new request from YY-client...\n");

    signal(SIGHUP, SuperServerTermination);
    signal(SIGINT, SuperServerTermination);
    signal(SIGQUIT, SuperServerTermination);
    signal(SIGTERM, SuperServerTermination);

    setjmp(SigChildEnv);
    for (;;) {
	/* ͥ */
	register int pid;
	ch = wait_new_client(u_port, i_port);
	if ((pid = fork()) < 0)
	    return (yy_comm_channel *)NULL;
	if (pid == 0) {
	    /* ҥץ */
	    (void)close(u_port); (void)close(i_port);
	    UnixPort = InetPort = (-1);
	    (void)do_yyserv_main(ch);
	    break;
	}
	/* ƥץϼΥͥԤ */
	signal(SIGCLD, ChildTermination);
	(void)close(ch->ccYYCmdCH.FD);
	if (YYSingleShot) {
	    /* single shot mode Ǥ λ */
	    shutdown(u_port, 2); close(u_port);
	    shutdown(i_port, 2); close(i_port);
	    exit(0);
	}
	/* ƥץϱʱˤޤ³ */
    }
    DebugEndFunc("network", "make_channel");
    return ch;
}

#else /*SUPERSERVER*/
yy_comm_channel *make_channel(no)
    int no; /* Server Number */
{
    yy_comm_channel *ch;
    int fd;
    DebugSetFunc("network", "make_channel");
    /* Get One Channel for YY client */
    ch = (yy_comm_channel *)malloc(sizeof(yy_comm_channel));
    if (ch == (yy_comm_channel *)NULL)
	return (yy_comm_channel *)NULL;
    /* Entries for X Window System */
    ch->ccXFd = -1;
    ch->ccXNeedFlush = FALSE;
    ch->ccXPrivate = (char *)NULL;
    /* Entries for YY Client */
    ch->ccYYServNo = no;
    ch->ccYYCmdCH.FD = ch->ccYYEvtCH.FD = -1;	/* Socket */
    ch->ccYYSyncCount = ch->ccYYSyncPacketNum = 0;
    /* Font Table */
    ch->ccFontTable = alloc_font_table(YYFONTINFOFILE);
    /* Packet Queue */
    SENDQ(ch) = RECVQ(ch) = SENDEVENTQ(ch) = (YYPKTQUEENT *)NULL;
    READQ(ch) = WRITEQ(ch) = (YYPKTQUEENT *)NULL;
    /* TimeOut Table */
    ch->ccYYWaitTime = DEFAULTTIMEOUT*1000;
    ch->ccYYXFlushCount = (TIMEOUTFORXFLUSH/DEFAULTTIMEOUT);
    ch->ccYYKeyinCount = (TIMEOUTFORKEYIN/DEFAULTTIMEOUT);
#ifdef DEBUG
    /* Debug Table */
    ch->ccDeBugTable.dbWriteBlocked = 0;
    ch->ccDeBugTable.dbTimer.tv_sec = 0;
    ch->ccDeBugTable.dbTimer.tv_usec = 0;
#endif
    /* Create New Sockets for waiting YY Request */
    if (wait_connection(&(ch->ccYYChannel), no) < 0) {
	fprintf(stderr, "Can't Setup Connection with YY Client..\n");
	DebugEndFunc("network", "make_channel");
	return (yy_comm_channel *)NULL;
    }
    DebugEndFunc("network", "make_channel");
    return ch;
}

int set_inet_port(no)
    int no;	/* Server # */
{
    struct sockaddr_in addr;
    int retry;
    int sock;

    DebugSetFunc("network", "set_inet_port");
    if ((sock = socket(PF_INET, SOCK_STREAM, 0)) < 0) {
	perror("Socket");
	return -1;
    }
    bzero((char *)&addr, sizeof(addr));
    addr.sin_family = PF_INET;
    addr.sin_port = htons(YYPROTO_INET_PORT+no);
    DebugPrint0(1, "waiting on PORT#%d\n", ntohs(addr.sin_port));
    retry = 5;
    while (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
	if (--retry == 0) {
	    perror("bind");
	    return -1;
	}
	sleep(5);
    }
    if (listen(sock, 1) < 0) {
	perror("listen");
	return -1;
    }
    DebugEndFunc("network", "set_inet_port");
    return sock;
}


int set_unix_port(no)
    int no;
{
    int sock;
    struct sockaddr_un addr;
    int retry;

    DebugSetFunc("network", "set_unix_port");
    if (make_unix_tmp_dir() < 0) {
	fprintf(stderr, "Can't create '%s' directory\n", YYPROTO_UNIX_DIR);
	return -1;
    }
    if ((sock = socket(PF_UNIX, SOCK_STREAM, 0)) < 0) {
	perror("Socket");
	return -1;
    }
    bzero((char *)&addr, sizeof(addr));
    addr.sun_family = PF_UNIX;
    sprintf(addr.sun_path, "%s/%s%02d",
	    YYPROTO_UNIX_DIR, YYPROTO_UNIX_PORT, no);
    unlink(addr.sun_path);
    DebugPrint0(1, "waiting on PORT'%s'\n", addr.sun_path);
    retry = 5;
    while (bind(sock, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
	if (--retry == 0) {
	    perror("bind");
	    return -1;
	}
	sleep(5);
    }
    if (listen(sock, 1) < 0) {
	perror("listen");
	return -1;
    }
    DebugEndFunc("network", "set_unix_port");
    return sock;
}



int wait_connection(yych, no)
    struct _yy_channel_for_yy_client *yych;
{
    int req;	/* Request Port to be Accepted */
    struct sockaddr addr;
    int addrlen;

    DebugSetFunc("network", "wait_connection");
    /* Create Two Request Ports */
    if ((yych->yyUnixReqFd = set_unix_port(no)) < 0 ||
	(yych->yyInetReqFd = set_inet_port(no)) < 0) {
	fprintf(stderr, "Can't Create Socket (for Request)!!\n");
	DebugEndFunc("network", "wait_connection");
	return -1;
    }
    /* Wait First Request on Request Port */
    req = wait_first_connection(yych->yyUnixReqFd,yych->yyInetReqFd);
    if (req < 0) {
	fprintf(stderr, "Can't Find New Request!!\n");
	DebugEndFunc("network", "wait_connection");
	return -1;
    }
    /* Accept Connection Request */
    addrlen = sizeof(addr);
    if ((yych->yyCmdCH.FD = accept(req, &addr, &addrlen)) < 0) {
	perror("Accept");
	DebugEndFunc("network", "wait_connection");
	return -1;
    }
    if ((yych->yyStatBuf.csDomain = addr.sa_family) == PF_UNIX) {
	/* UNIX Domain */
	DebugPrint0(1, "accept request on %d/UNIX\n",
		    yych->yyCmdCH.FD);
	req = set_unix_port(yych->yyServNo+1);
    } else {
	DebugPrint0(1, "accept request on %d/INET\n",
		    yych->yyCmdCH.FD);
	req = set_inet_port(yych->yyServNo+1);
    }
    yych->yyMaxPacketSize = get_packet_size(yych->yyCmdCH.FD);
    if ((yych->yyEvtCH.FD = wait_second_connection(req)) < 0) {
	DebugEndFunc("network", "wait_connection");
	return -1;
    }
    DebugEndFunc("network", "wait_connection");
    return 0;
}

int get_packet_size(sock)
    int sock;
{
    int leng, rlen;
    char buf[8];
    char *s;
    int magic, size;

    DebugSetFunc("network", "get_packet_size");
    /* Recv first 8 octets
     * Packet Format:
     *  +--------+--------+--------+--------+
     *  |  M  A  G  I  C  N  U  M  B  E  R  |
     *  +--------+--------+--------+--------+
     *  |  P  A  C  K  E  T  S  I  Z  E     |
     *  +--------+--------+--------+--------+
     */
    recv_from_yy_connection(sock, buf, 8);
    bcopy(buf, (char *)&magic, 4);
    bcopy(&buf[4], (char *)&size, 4); size <<= 2;
    DebugPrint0(1, "YYPacketBlockSize in YY-Client is %d\n", size);
    DebugPrint0(1, "YY-Server assumes %d\n", YYPacketBlockSize);
    if (YYPacketBlockSize < size) {
	DebugPrint0(1, " .. No! YYPacketBlockSize = %d\n", YYPacketBlockSize);
	size = YYPacketBlockSize;
    } else {
	DebugPrint0(1, " .. OK! We accept it\n", YYPacketBlockSize);
	YYPacketBlockSize = size;
    }
    size >>= 2; bcopy((char *)&size, &buf[4], 4);
    send_to_yy_connection(sock, buf, 8);
    DebugEndFunc("network", "get_packet_size");
    return (size >> 2);
}

#endif /*!SUPERSERVER*/

void timeout_on_yy_connection()
{
    cleanup(EX_IOERR, "I/O Error on TCP connection for YY\n");
}

send_to_yy_connection(sock, buf, leng)
    int sock;
    u_char *buf;
    int leng;
{
    register u_char *s = buf;
    register int l = leng;
    void (*old_func)();
    
    DebugSetFunc("network", "send_to_yy_connection");
    old_func = signal(SIGALRM, timeout_on_yy_connection);
    while (l > 0) {
	register int slen;
	alarm(5);
	if ((slen = send(sock, s, l, 0)) <= 0) {
	    if (slen < 0) {
		cleanup(EX_IOERR, "Output Error on YY Connection\n");
	    }
	    cleanup(EX_OK, "YY Connection has been closed...\n");
	}
	alarm(0);
	l -= slen;
	s += slen;
    }
    signal(SIGALRM, old_func);
    DebugEndFunc("network", "send_to_yy_connection");
    return leng;
}

int recv_from_yy_connection(sock, buf, leng)
    int sock;
    u_char *buf;
    int leng;
{
    register u_char *s = buf;
    register int l = leng;
    void (*old_func)();

    DebugSetFunc("network", "recv_from_yy_connection");
    old_func = signal(SIGALRM, timeout_on_yy_connection);
    while (l > 0) {
	register int rlen;
	fd_set rfds;
	FD_ZERO(&rfds);
	FD_SET(sock, &rfds);
	if ((rlen = select(sock+1, &rfds, NULL, NULL, NULL)) < 0) {
	    extern int errno;
	    cleanup(EX_IOERR, "Error on select(READ) (%d)\n", errno);
	}
	alarm(10);
	if ((rlen = recv(sock, s, l, 0)) <= 0) {
	    if (rlen < 0) {
		extern int errno;
		cleanup(EX_IOERR, "Input Error on YY Connection (%d)\n",
			errno);
	    }
	    cleanup(EX_OK, "YY Connection has been closed...\n");
	}
	alarm(0);
	l -= rlen;
	s += rlen;
    }
    signal(SIGALRM, old_func);
    DebugEndFunc("network", "recv_from_yy_connection");
    return leng;
}




#ifndef NOIPAPATCH
/* extern int mouse_event_ok;	/* Added by T.Kosaka */
#endif /*!NOIPAPATCH*/

int wait_for_request(channel)
    yy_comm_channel *channel;
{
    int xfd = channel->ccXFd;
    int yyfd = channel->ccYYFd;
    int yyfd2 = channel->ccYYFd2;
    int width = 0;
    fd_set rfds, wfds;
    YYPKTQUEENT *rq;
    int ret;
    yy_timeout_table timecount;
    struct timeval timeout;
#ifdef DEBUG
    bool check_norm_blocked = FALSE;
    bool check_event_blocked = FALSE;
#endif

    DebugSetFunc("network", "wait_for_request");
    timecount.toXFlushCount = channel->ccYYXFlushCount;
    timecount.toKeyinCount = channel->ccYYKeyinCount;
    timecount.toDClickCount = channel->ccYYDClickCount;
 retry:
    FD_ZERO(&rfds);
    FD_ZERO(&wfds);
    /* X input */
    if (xfd > 0) {
	DebugPrint0(8, " waiting on X-connection (recv)\n");
	get_events_on_x_server(channel, FALSE);
	width = MAX(width, xfd);
	FD_SET(xfd, &rfds);
    }
    /* YY input */
    if (yyfd > 0) {
	DebugPrint0(8, " waiting on YY-connection (recv)\n");
	width = MAX(width, yyfd);
	FD_SET(yyfd, &rfds);
	if (SENDQ(channel) != (YYPKTQUEENT *)NULL) {
	    DebugPrint0(8, " waiting on YY-connection (send)\n");
	    FD_SET(yyfd, &wfds);
#ifdef DEBUG
	    check_norm_blocked = TRUE;
#endif
	}
    }
    /* YY Event */
    if (yyfd2 > 0) {
	if (SENDEVENTQ(channel) != (YYPKTQUEENT *)NULL) {
	    DebugPrint0(8, " waiting on YY-connection (event)\n");
	    width = MAX(width, yyfd2);
	    FD_SET(yyfd2, &wfds);
#ifdef DEBUG
	    check_event_blocked = TRUE;
#endif
	}
    }
    /* Waiting.. */
    if (yysched_get_next_time(channel, &timeout) == (struct timeval *)NULL ||
	timeout.tv_sec > 0 || timeout.tv_usec < channel->ccYYWaitTime) {
	timeout.tv_sec = 0;
	timeout.tv_usec = channel->ccYYWaitTime;
    }
    DebugPrint1(8, " with TIMEOUT (%dusec)\n", timeout.tv_usec);
    ret = select(width+1, &rfds, &wfds, NULL, &timeout);
    if (ret < 0) {
	fprintf(stderr, "ERROR ON SELECT!!!!!");
	return -1;
    }
    if (ret == 0) {
	/* TimeOut */
	register bool doretry = TRUE;
	DebugPrint0(8, "Timeout.. \n");
#ifndef NOIPAPATCH
	/* mouse_event_ok = TRUE;	/* Added by T.Kosaka */
#endif /*!NOIPAPATCH*/
	if (channel->ccXNeedFlush &&
	    (--timecount.toXFlushCount) <= 0) {
	    DebugPrint0(8, "Send XFlush Request\n");
	    sync_x_server(channel->ccXPrivate);
	    channel->ccXNeedFlush = FALSE;
	    doretry = FALSE;
	}
	if (channel->ccYYHaveKeyIN &&
	    (--timecount.toKeyinCount) <= 0) {
	    DebugPrint0(8, "Send Keyin Data\n");
	    send_keyin_string(channel);
	    doretry = FALSE;
	}
	sched_animation(channel);
	yysched_popque(channel);
	if (doretry)
	    goto retry;
    } else {
	/* X Event? */
	if (xfd > 0 && FD_ISSET(xfd, &rfds)) {
	    /* get next X event */
	    DebugPrint0(8, " recv packet on X-connection\n");
	    get_events_on_x_server(channel, TRUE);
	}
	/* YY Packet? */
	if (yyfd > 0 && FD_ISSET(yyfd, &rfds)) {
	    /* recv and make recv queue */
	    DebugPrint0(8, " recv packet on YY-connection\n");
	    (void)recv_yy_packet(yyfd, QUE(channel));
	}
	if (yyfd > 0 && FD_ISSET(yyfd, &wfds)) {
	    /* send and remove from queue */
	    DebugPrint0(8, " we can send packet on YY-connection\n");
	    (void)send_yy_packet(yyfd, QUE(channel));
	}
#ifdef DEBUG
	else if (check_norm_blocked)
	    channel->ccDeBugTable.dbWriteBlocked++;
#endif
	if (yyfd2 > 0 && FD_ISSET(yyfd2, &wfds)) {
	    /* send event packet and remove from queue */
	    DebugPrint0(8, " we can send event on YY-connection\n");
	    (void)send_yy_event_packet(yyfd2, QUE(channel));
	}
#ifdef DEBUG
	else if (check_event_blocked)
	    channel->ccDeBugTable.dbWriteBlocked++;
#endif
    }
    if (READQ(channel) != (YYPKTQUEENT *)NULL) {
	DebugPrint0(8, " we have a YY packet in the queue\n");
	dispatch_command(channel, get_packet_from_readq(QUE(channel)));
    }
    sched_animation(channel);
    DebugEndFunc("network", "wait_for_request");
    return 0;
}

send_keyin_string(CH)
    yy_comm_channel *CH;
{
    DebugSetFunc("network", "send_keyin_string");
    DebugEndFunc("network", "send_keyin_string");
}

#define YYHEADERSIZE	sizeof(yy_packet_header)

static void recv_yy_packet(yyfd, queue)
    int yyfd;
    yy_packet_system_queue *queue;
{
    int leng, pleng, body;
    byte *bp = (byte *)alloc_packet_data_area();
    DebugSetFunc("network", "recv_yy_packet");
    DebugPrint1(5, "Allocate %dbytes for new packet\n", YYPacketBlockSize);
    /* Recv Header Info */
    recv_from_yy_connection(yyfd, bp, YYHEADERSIZE);
    DebugPrint0(5, "recv Header Info\n");
    if (DebugON(7)) {
	register int l; register byte *s;
	for (l = YYHEADERSIZE, s = bp; l > 0 ; l--, s++)
	    DebugPrint1(7, " %02x", ((*s)&0377));
	DebugPrint0(7, "\n");
    }
    /* Get Packet Length */
    bcopy(bp, (byte *)&pleng, 4);
    pleng = ((pleng & 07777) << 2);
    body = pleng - YYHEADERSIZE;
    DebugPrint2(5, "Header said length is %d (body:%d)\n", pleng, body);
    recv_from_yy_connection(yyfd, bp+YYHEADERSIZE, body);
    DebugPrint1(9, " recv one block (LENGTH:%d)\n", pleng);
    put_block_on_recvq(queue, bp, pleng);
    DebugEndFunc("network", "recv_yy_packet");
}

static void send_yy_packet(yyfd, queue)
    int yyfd;
    yy_packet_system_queue *queue;
{
    int leng;
    byte *bp;
    DebugSetFunc("network", "send_yy_packet"); 
    if (get_block_from_sendq(queue, &bp, &leng) > 0) {
	DebugPrint1(9, " send one block (LENGTH:%d)\n",leng);
	if (send(yyfd, bp, leng, 0) != leng) {
	    fprintf(stderr, "BOOOOOOM!! (in send)\n");
	    DebugEndFunc("network", "send_yy_packet");
	    return;
	}
    }
    DebugEndFunc("network", "send_yy_packet");
}

static void send_yy_event_packet(fd, queue)
    int fd;
    yy_packet_system_queue *queue;
{
    int leng;
    byte *bp;
    DebugSetFunc("network", "send_yy_event_packet");
    if (get_block_from_eventq(queue, &bp, &leng) > 0) {
	DebugPrint1(9, " send one block (LENGTH:%d)\n",leng);
	if (send(fd, bp, leng, 0) != leng) {
	    fprintf(stderr, "BOOOOOOM!! (in send)\n");
	    DebugEndFunc("network", "send_yy_event_packet");
	    return;
	}
    }
    DebugEndFunc("network", "send_yy_event_packet");
}

void sync_packet(channel, cmd, pkt)
    yy_comm_channel *channel;
    int cmd;
    yy_packet *pkt;
{
    DebugSetFunc("packet", "sync_packet");
    if (pkt == (yy_packet *)NULL) {
	channel->ccYYSyncCount--;
	if (channel->ccYYSyncCount > 0)
	    return;
	pkt = alloc_new_yy_packet(cmd, YYPACKETTYPE_SYNC, 0, NULL);
	channel->ccYYSyncCount = channel->ccYYSyncPacketNum;
	DebugPrint1(3, "Send Sync Packet (%d)\n",
		    channel->ccYYSyncPacketNum);
    } else {
	channel->ccYYSyncCount = channel->ccYYSyncPacketNum;
    }
    put_packet_on_sendq(QUE(channel), pkt);
    DebugEndFunc("packet", "sync_packet");
}

#ifdef DEBUG
yy_packet *yycom_debug_show_table(CH, pkt)
    yy_comm_channel *CH;
    yy_packet *pkt;
{
    DebugSetFunc("debug", "yycom_debug_show_table");
    DebugPrint1(1, "Write Block: %d\n", CH->ccDeBugTable.dbWriteBlocked);
    DebugPrint2(1, "Timer: %5d.%06d\n",
		CH->ccDBTimer.tv_sec, CH->ccDBTimer.tv_usec);
    DebugEndFunc("debug", "yycom_debug_show_table");
    return (yy_packet *)NULL;
}
#endif /* DEBUG */

#ifdef notdef
#define IPCCHTYPE_UDPPORT	01
#define IPCCHTYPE_TCPPORT	02

#define IPCCHTYPE_LOCAL		010
#define IPCCHTYPE_REMOTE	020

#define IPCCHTYPE_RECVONLY	0100
#define IPCCHTYPE_SENDONLY	0200
#define IPCCHTYPE_SENDRECV	0400

#define IPCCHSTAT_ACTIVE	01
#define IPCCHSTAT_ERROR		02

typedef struct _yy_ipc_channel_ YYIPCCHANNEL;
struct _yy_ipc_channel_ {
    int ipcFD;
    int ipcType;
    int ipcStatus;
    struct yypktquetab *ipc;
    char *ipcPrivate;
    struct ipcfunctab *ipcFuncs;
} ;

int local_udp_ipc_open(ipcch)
    YYIPCCHANNEL *ipcch;
{
    if (ipcch->Status & IPCCHSTAT_ACTIVE)
	return 0;
    if (ipcch->Status & IPCCHSTAT_ERROR)
	return 1;
    
    
}
#endif
/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
