/* Functions for Handling Territories
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: com_territory.c,v 3.1 1992/10/27 08:10:20 keisuke Exp keisuke $
 */

#ifndef lint
static char *RcsId =
    "$Id: com_territory.c,v 3.1 1992/10/27 08:10:20 keisuke Exp keisuke $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/26 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.15 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.1 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/27 08:10:20 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <X11/cursorfont.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"

static Window create_window_for_root_territory();
static Window create_window_for_territory();
static TERRITORY *territory_alloc();
static void territory_free();
static void territory_unlink();
static void list_territory_for_debug();

/*
 * Territory Control
 */

extern void clear_page_territory();
CTRLFUNCS CtrlFuncTab[] = {
{ TR_NONE,	NULL, NULL, NULL, NULL, NULL },
{ TR_PAGE,	NULL, NULL, NULL, NULL, clear_page_territory },
{ TR_VIEWPORT,	NULL, NULL, NULL, NULL, NULL },
{ TR_FENCE,	NULL, NULL, NULL, NULL, NULL },
{ 0,		NULL, NULL, NULL, NULL, NULL },
} ;

static CTRLFUNCS *get_control_functab(type)
    int type;
{
    register CTRLFUNCS *ft = CtrlFuncTab;
    for (ft = CtrlFuncTab; ft->TerritoryType > 0; ft++)
	if (ft->TerritoryType == type)
	    return ft;
    return ft;
}

/*
 * TERRITORY *get_specified_territory(pkt, err)
 *
 * read one integer value from packet
 * and get the entry for the specified territory
 */

TERRITORY *get_specified_territory(pkt, err)
    yy_packet *pkt;
    yy_packet **err;
{
    register territory_entry *tr;
    tr = search_territory(read_packet_entry_integer(pkt));
    if (tr != (TERRITORY *)NULL)
	return tr;
    *err = create_error_packet(pkt, YYERROR_NOTERRITORY);
    return (TERRITORY *)NULL;
}

TERRITORY *catch_territory(pkt, type, err)
    yy_packet *pkt;
    register int type;		/* Territory Type */
    yy_packet **err;
{
    register territory_entry *tr;
    tr = search_territory(read_packet_entry_integer(pkt));
    if (tr == (TERRITORY *)NULL || !(tr->teTRType & type)) {
	*err = create_error_packet(pkt, (tr? YYERROR_TYPEMISMATCH:
					 YYERROR_NOTERRITORY));
	return (TERRITORY *)NULL;
    }
    return tr;
}

/*******************************************
 YYץȥбν
********************************************/
yy_packet *yycom_create_territory(CH, pkt)
    yy_comm_channel *CH;
    yy_packet *pkt;
{
    TERRITORY *TR;
#ifndef VERSION104
    int id;
#endif /*!VERSION104*/
    int x, y, w, h;
    TRID parent_id;	/* ID for the Parent Territory */
    bool visible, drawable;
    int draw_flag;
    int type;
    yy_packet *repl;
    int err_code;

    DebugSetFunc("territory", "yycom_create_territory");
    /* Size of Territory */
#ifndef VERSION104
    id = read_packet_entry_integer(pkt);
#endif /*!VERSION104*/
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    /* Parent ID */
    parent_id = (TRID)read_packet_entry_integer(pkt);
    /* Visible or Not */
    visible = ((read_packet_entry_integer(pkt)&1)? TRUE: FALSE);
    /* Type of Territory */
    draw_flag = read_packet_entry_integer(pkt);
    drawable = ((draw_flag&0400)? TRUE: FALSE);
    switch (draw_flag) {
    case 0:	type = TR_NONE;		break;
    case 01:	type = TR_FENCE;	break;
    case 0401:	type = TR_VIEWPORT;	break;
#ifndef IPA
    case 0403:	DebugPrint0(9, "SPLITE\n");
	type = TR_SPLITE; break;
#endif
    case 0400:	type = TR_PAGE;		break;
    default:
	DebugPrint1(1, " Unknown Territory Type: 0%o\n", draw_flag);
	repl = ALLOC_ERRPACKET(pkt);
	SETYYERRORCODE(repl, 0);
	SETYYERRORCODE(repl, YYERROR_TYPEMISMATCH);
	DebugEndFunc("territory", "yycom_create_territory");
	return repl;
    }
    /* Create Territory */
#ifndef VERSION104
    TR = create_territory(CH, id, x, y, w, h, parent_id,
			  visible, drawable, type, &err_code);
#else /*VERSION104*/
    TR = create_territory(CH, x, y, w, h, parent_id,
			  visible, drawable, type, &err_code);
#endif /*VERSION104*/
    if (TR != (TERRITORY *)NULL) {
	DebugPrint1(1, " Create new Territory (ID:%d)\n", TR->teID);
	repl = NULL;
#ifdef VERSION104
	repl = ALLOC_ACKPACKET(pkt);
	append_packet_entry_integer(repl, TR->teID);
#endif VERSION104
	if (DebugON(6))
	    list_territory_for_debug();
    } else {
	DebugPrint1(1, " Can't Create Territory, Error Code=%d\n", err_code);
	repl = ALLOC_ERRPACKET(pkt);
	SETYYERRORCODE(repl, 0);
	SETYYERRORCODE(repl, err_code);
    }
    DebugEndFunc("territory", "yycom_create_territory");
    return repl;
}


yy_packet *yycom_display_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    register int visible;
    TERRITORY *tr;
    yy_packet *err;

    DebugSetFunc("territory", "yycom_display_territory");
    if ((tr = catch_territory(pkt, TR_VISIBLE, &err)) == (TERRITORY *)NULL)
	return err;
    visible = (read_packet_entry_integer(pkt)&1);
    (void) display_territory(ch, tr, visible);
    DebugEndFunc("territory", "yycom_display_territory");
    return (yy_packet *)NULL;
}

yy_packet *yycom_move_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    yy_packet *err;
    int new_x, new_y;

    DebugSetFunc("territory", "yycom_move_territory");
    if ((tr = catch_territory(pkt, TR_ALL, &err)) == (TERRITORY *)NULL)
	return err;
    new_x = read_packet_entry_integer(pkt);
    new_y = read_packet_entry_integer(pkt);
    (void) move_territory(ch, tr, new_x, new_y);
    DebugEndFunc("territory", "yycom_move_territory");
    return (yy_packet *)NULL;
}


yy_packet *yycom_resize_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    TERRITORY *tr;
    yy_packet *err;
    int nx, ny, nw, nh; /* New Size */
    int origX, origY;
    DebugSetFunc("territory", "yycom_resize_territory");
    if ((tr = catch_territory(pkt, TR_ALL, &err)) == (TERRITORY *)NULL)
	return err;
    nx = read_packet_entry_integer(pkt);	/* new Origin */
    ny = read_packet_entry_integer(pkt);
    nw = read_packet_entry_integer(pkt);	/* new Size */
    nh = read_packet_entry_integer(pkt);
    origX = read_packet_entry_integer(pkt);	/* */
    origY = read_packet_entry_integer(pkt);
    (void) resize_territory(ch, tr, nx, ny, nw, nh, origX, origY);
    DebugEndFunc("territory", "yycom_resize_territory");
    return (yy_packet *)NULL;
}


yy_packet *yycom_destroy_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    territory_entry *tr;
    yy_packet *repl;
    int id;

    DebugSetFunc("territory", "yycom_destroy_territory");
    if ((tr = catch_territory(pkt, TR_ALL, &repl)) == (TERRITORY *)NULL)
	return repl;
    /* Save Territtory ID, because destroy_territory() removes
     * all data on *tr */
    id = tr->teID;
    DebugPrint1(5, " -- destroy territory #%d\n", id);
    ch->ccXNeedFlush = TRUE;
    if (destroy_territory(xp->xDisp, tr, TRUE)) {
	repl = ALLOC_ACKPACKET(pkt);
	ch->ccXNeedFlush = TRUE;
	append_packet_entry_integer(pkt, id);
    } else {
	/* Error.. */
	repl = ALLOC_NACKPACKET(pkt);
	append_packet_entry_integer(pkt, 0);
    }
    DebugEndFunc("territory", "yycom_destroy_territory");
    return repl;
}


yy_packet *yycom_reparent_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    territory_entry *tr, *parent;
    yy_packet *err;
    int nx, ny;

    DebugSetFunc("territory", "yycom_reparent_territory");
    /* Target Territory */
    if ((tr = catch_territory(pkt, TR_ALL, &err)) == (TERRITORY *)NULL)
	return err;
    /* New Parent */
    if ((parent = catch_territory(pkt, TR_VISIBLE, &err)) == (TERRITORY *)NULL)
	return err;
    if (tr->teParent == (TERRITORY *)NULL ||
	parent->teID == tr->teParent->teID || parent->teID == tr->teID)
	return create_error_packet(pkt, YYERROR_NOTERRITORY);
    nx = read_packet_entry_integer(pkt);
    ny = read_packet_entry_integer(pkt);
    (void) reparent_territory(ch, tr, parent, nx, ny);
    DebugEndFunc("territory", "yycom_reparent_territory");
    return (yy_packet *)NULL;
}

yy_packet *yycom_raise_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    territory_entry *tr;
    yy_packet *err;
    DebugSetFunc("territory", "yycom_raise_territory");
    if (NULLTERRITORY((tr = catch_territory(pkt, TR_ALL, &err))))
	return err;
    if (tr->teParent != (TERRITORY *)NULL)
	(void) raise_territory(ch, tr);
    DebugEndFunc("territory", "yycom_raise_territory");
    return (yy_packet *)NULL;
}

yy_packet *yycom_lower_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    territory_entry *tr;
    yy_packet *err;
    DebugSetFunc("territory", "yycom_lower_territory");
    if (NULLTERRITORY((tr = catch_territory(pkt, TR_ALL, &err))))
	return err;
    if (tr->teParent != (TERRITORY *)NULL)
	(void) lower_territory(ch, tr);
    DebugEndFunc("territory", "yycom_lower_territory");
    return (yy_packet *)NULL;
}


yy_packet *yycom_clear_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    territory_entry *tr;
    yy_packet *err;
    x_color color;
    DebugSetFunc("territory", "yycom_clear_territory");
    if ((tr = catch_territory(pkt, TR_ALL, &err)) == (TERRITORY *)NULL)
	return err;
    color = read_packet_entry_color(pkt);
    clear_territory(ch, tr, color);
    DebugEndFunc("territory", "yycom_clear_territory");
    return (yy_packet *)NULL;
}

/*******************************/
/*  YY protocol 32             */
/*******************************/
yy_packet *yycom_draw_background(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    territory_entry *tr, *p_tr;
    yy_packet *err;
    DebugSetFunc("territory", "yycom_draw_background");
    if ((tr = catch_territory(pkt, TR_ALL, &err)) != (TERRITORY *)NULL ||
	(p_tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL)
	return err;
    (void) draw_background(ch, tr, p_tr);
    DebugEndFunc("territory", "yycom_draw_background");
    return (yy_packet *)NULL;
}


/************************************************************************
 ****** YYץȥбδؿƤФ
 ****** 
 ***********************************************************************/
void display_territory(ch, tr, visible)
    yy_comm_channel *ch;
    TERRITORY *tr;
    bool visible;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    DebugSetFunc("territory", "display_territory");
    tr->teVisible = visible;
    DebugPrint2(5, " -- %s window for Territory#%d\n",
		(visible? "Map": "Unmap"), tr->teID);
    if (visible)
	XMapWindow(xp->xDisp, tx->txWindow);
    else {
	XUnmapWindow(xp->xDisp, tx->txWindow);
	if (tr->teTRType == TR_SPLITE)
	    (void)delete_objects_on_splite(ch, tr);
    }
    ch->ccXNeedFlush = TRUE;
    DebugEndFunc("territory", "display_territory");
    /*NoReturnValue*/
}

void move_territory(ch, tr, nx, ny)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int nx, ny;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *parent;
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    int lt_x = nx;	/*  LeftTop ɸ (X) */
    int lt_y = ny;	/*  LeftTop ɸ (Y) */

    DebugSetFunc("territory", "move_territory");
    if (DebugON(5)) {
	Window root; int x, y, w, h, b, d;
	XGetGeometry(xp->xDisp, tx->txWindow, &root, &x, &y, &w, &h, &b, &d);
	DebugPrint6(5, " move Window (%d,%d)[%d,%d] -> (%d,%d)\n",
		    x, y, w, h, nx, ny);
    }
    if ((parent = GetParentTerritory(tr)) != (TERRITORY *)NULL) {
	lt_x = parent->teXOrigin + nx;
	lt_y = parent->teYOrigin + ny;
    }

    if (tr->teTRType == TR_SPLITE) {
	/* ץ饤ȥƥȥФ
	 *  tr ƥȥβ̾Ǹʤ
	 *   LeftTop ɸꤷƥץ饤Ⱦʪ
	 *  Ԥʤ
	 *
	 *  ˡʤ....
	 */
	TERRITORY dummy_tr;
	(void)delete_objects_on_splite(ch, tr);
	tr->teX = lt_x;
	tr->teY = lt_y;
#ifdef KOSAKA921021
	/* ȯɽѤäĤ patch */
	memcpy(&dummy_tr, tr, sizeof(TERRITORY));
	dummy_tr.teVisible = 0;
	(void)delete_objects_on_splite(ch, &dummy_tr);
#else /*!KOSAKA921021*/
	/* ꥸʥɽ */
	(void)put_objects_on_splite(tr, XEntry(tr->teParent)->txWindow,
				    (YYRectangle *)NULL);
#endif /*!KOSAKA921021*/
    } else {
	tr->teX = lt_x;
	tr->teY = lt_y;
    }

    XMoveWindow(xp->xDisp, tx->txWindow, lt_x, lt_y);
    if (IsVisibleTerritory(tr)) ch->ccXNeedFlush = TRUE;
    DebugEndFunc("territory", "move_territory");
}

void clear_pixmap(xp, pix, gc, w, h, cp)
    x_private *xp;
    Pixmap pix;
    GC gc;
    int w, h;
    x_color_entry *cp;
{
    GC wgc;
    u_long mask;
    XGCValues gcv;
    gcv.function = GXcopy;
    if (cp->xcUsePixel) {
	gcv.fill_style = FillSolid;
	gcv.foreground = cp->xcPixel;
	mask = (GCFunction|GCFillStyle|GCForeground);
    } else {
	gcv.fill_style = FillTiled;
	gcv.tile = cp->xcPixmap;
	mask = (GCFunction|GCFillStyle|GCTile);
    }
    wgc = XCreateGC(xp->xDisp, pix, mask, &gcv);
    XFillRectangle(xp->xDisp, pix, wgc, 0, 0, w, h);
    XFreeGC(xp->xDisp, wgc);
}
    
#ifndef NOIPAPATCH
/* źˤɲ 1991.12.19 */
/*
 * ץ饤ȥƥȥ Resize Ȱư
 *
 */
bool splite_move_territory(ch, tr, add_x, add_y)
    yy_comm_channel *ch;
    territory_entry *tr;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx;
    territory_entry *child, *next;

    DebugSetFunc("territory", "splite_move_territory");

    for (child = tr->teChildren; child != (TERRITORY *)NULL; child = next) {
	next = child->teNextGen;
		
	/* For SPLITE */
	if(child->teTRType == TR_SPLITE) {
	    /* Ū˥ץ饤ȥƥȥγä */
	    (void)delete_objects_on_splite(ch, child);
	}
	
	child->teX += add_x;
	child->teY += add_y;
	tx = GetTerritoryXEntry(child);
		
	/* ٥ȤȯΤǤʤ
	 * if(child->teTRType == TR_SPLITE) {
	 * backup_splite_territory(child);
	 * }
	 */
	XMoveWindow(xp->xDisp, tx->txWindow, child->teX, child->teY);
    }
    DebugEndFunc("territory", "splite_move_territory");
    return TRUE;
}
/* źˤɲ ޤ */
#endif /*!NOIPAPATCH*/

static void splite_resize_territory(ch, tr, new_x, new_y, new_w, new_h)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int new_x, new_y, new_w, new_h;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);

    DebugSetFunc("territory", "splite_resize_territory");

    /* ץ饤ȥƥȥΥꥵϡ
     * ɬγä ....  ...
     */
    set_clear_on_splite(ch, tr);

    if (new_w != tr->teWidth || new_h != tr->teHeight) {
	/* ѹ
	 */
	XFreePixmap(xp->xDisp, tx->txPixmap);
	tx->txPixmap = XCreatePixmap(xp->xDisp, tx->txWindow,
				     MAX(new_w,tr->teWidth),
				     MAX(new_h,tr->teHeight),
				     DefaultDepth(xp->xDisp, xp->xScreen));
	tr->teWidth = new_w; tr->teHeight = new_h;
	XMoveResizeWindow(xp->xDisp, tx->txWindow, new_x, new_y, new_w, new_h);
    } else {
	XMoveWindow(xp->xDisp, tx->txWindow, new_x, new_y);
    }
    DebugEndFunc("territory", "splite_resize_territory");
    /*NoReturnValue*/
}

void resize_territory(ch, tr, new_x, new_y, new_w, new_h, orig_x, orig_y)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int new_x, new_y, new_w, new_h;
    int orig_x, orig_y;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *parent;
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    int new_lt_x, new_lt_y;

    DebugSetFunc("territory", "resize_territory");
    if (DebugON(5)) {
	Window root; int x, y, w, h, b, d;
	XGetGeometry(xp->xDisp, tx->txWindow, &root, &x, &y, &w, &h, &b, &d);
	DebugPrint8(5, " resize (%d,%d)[%d,%d] -> (%d,%d)[%d,%d]\n",
		    x, y, w, h, new_x, new_y, new_w, new_h); 
    }

    /*  LeftTop ɸ (new_lt_x, new_lt_y) 
     */
    new_lt_x = new_x; new_lt_y = new_y;
    if ((parent = GetParentTerritory(tr)) != (TERRITORY *)NULL) {
	new_lt_x += parent->teXOrigin; new_lt_y += parent->teYOrigin;
    }

    if(tr->teTRType == TR_SPLITE) {
	splite_resize_territory(ch, tr, new_lt_x, new_lt_y, new_w, new_h);
    } else {
	/* ץ饤ȰʳΥƥȥξ
	 */
	if (tx->txPixmap != (Pixmap)NULL
	    && (new_w != tr->teWidth || new_h != tr->teHeight)) {
	    /* Pixmap äƤƥȥǤ礭ѹˤʤ
	     */
	    Pixmap newpix;
	    int copy_src_x, copy_src_y;
	    int copy_dst_x, copy_dst_y;
	    int copy_w, copy_h;
	    newpix = XCreatePixmap(xp->xDisp, tx->txWindow, new_w, new_h,
				   DefaultDepth(xp->xDisp, xp->xScreen));
	    clear_pixmap(xp, newpix, tx->txGC, new_w, new_h,
			 &tx->txBackGroundColor);
	    copy_src_x = MAX((-orig_x), 0); copy_src_y = MAX((-orig_y), 0);
	    copy_dst_x = MAX(orig_x, 0); copy_dst_y = MAX(orig_y, 0);
	    copy_w = MIN((copy_dst_x+(tr->teWidth-copy_src_x)),new_w)-
		copy_dst_x;
	    copy_h = MIN((copy_dst_y+(tr->teHeight-copy_src_y)),new_h)-
		copy_dst_y;
	    if (copy_w > 0 && copy_h > 0) {
		DebugPrint0(4, " CopyArea in resize_territory()\n");
		DebugPrint6(4, "  from (%d,%d)[%d,%d] to (%d,%d)\n",
			    copy_src_x, copy_src_y, copy_w, copy_h,
			    copy_dst_x, copy_dst_y);
		
		XCopyArea(xp->xDisp, tx->txPixmap, newpix, tx->txGC,
			  copy_src_x, copy_src_y, copy_w, copy_h,
			  copy_dst_x, copy_dst_y);
	    }
	    XFreePixmap(xp->xDisp, tx->txPixmap);
	    tx->txPixmap = newpix;
	    tr->teWidth = new_w;
	    tr->teHeight = new_h;
	    XMoveResizeWindow(xp->xDisp, tx->txWindow,
			      new_lt_x, new_lt_y, new_w, new_h);
	} else if (new_w != tr->teWidth || new_h != tr->teHeight) {
	    tr->teWidth = new_w;
	    tr->teHeight = new_h;
	    XMoveResizeWindow(xp->xDisp, tx->txWindow,
			      new_lt_x, new_lt_y, new_w, new_h);
	} else
	    XMoveWindow(xp->xDisp, tx->txWindow, new_lt_x, new_lt_y);
    }
    if (IsVisibleTerritory(tr))
	ch->ccXNeedFlush = TRUE;
	
    tr->teX = new_lt_x;
    tr->teY = new_lt_y;
#ifndef NOIPAPATCH
    /* źˤɲ 1991.12.19 */
    /* children windows should be moved */
    splite_move_territory(ch, tr, orig_x, orig_y);
#endif /*!NOIPAPATCH*/
    DebugEndFunc("territory", "resize_territory");
    /*NoReturnValue*/
}


bool destroy_territory(ch, tr, nowin)
    yy_comm_channel *ch;
    territory_entry *tr;
    bool nowin;	/* parent territory has no window */
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    territory_entry *child, *next;
    DebugSetFunc("territory", "destroy_territory");
    for (child = tr->teChildren; child != (TERRITORY *)NULL; child = next) {
	next = child->teNextGen;
	if (!destroy_territory(ch, child))
	    return FALSE;
    }
    /* destroy parent */
    if (tx->txGC != (GC)NULL)
	XFreeGC(xp->xDisp, tx->txGC);
    if (tx->txPixmap != (Pixmap)NULL)
	XFreePixmap(xp->xDisp, tx->txPixmap);
    if (tx->txWindow != (Window)NULL)
	XDestroyWindow(xp->xDisp, tx->txWindow);
    territory_unlink(tr);
    DebugEndFunc("territory", "destroy_territory");
    return TRUE;
}

void reparent_territory(ch, tr, parent, nx, ny)
    yy_comm_channel *ch;
    TERRITORY *tr, *parent;
    int nx, ny;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    TERRITORY_X_ENTRY *ptx = GetTerritoryXEntry(parent);
    DebugSetFunc("territory", "reparent_territory");
    DebugPrint3(5, " -- chnge parent for %d (#%d -> #%d)\n",
		tr->teID, tr->teParent->teID, parent->teID);
    /* change link */
    if (tr->tePrevGen == (TERRITORY *)NULL)
	tr->teParent->teChildren = tr->teNextGen;
    else
	tr->tePrevGen->teNextGen = tr->teNextGen;
    if (tr->teNextGen != (TERRITORY *)NULL)
	tr->teNextGen->tePrevGen = tr->tePrevGen;
    tr->tePrevGen = (TERRITORY *)NULL;
    tr->teNextGen = parent->teChildren;
    parent->teChildren = tr;
    /* Change Window Parent */
    XReparentWindow(xp->xDisp, tx->txWindow, ptx->txWindow, nx, ny);
    if (IsVisibleTerritory(tr)) {
	XMapWindow(xp->xDisp, tx->txWindow);
	ch->ccXNeedFlush = TRUE;
    }
    DebugEndFunc("territory", "reparent_territory");
}

void raise_territory(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    DebugSetFunc("territory", "raise_territory");
    DebugPrint1(5, "Raise for #%d\n", tr->teID);
    if (tr->tePrevGen != (TERRITORY *)NULL) {
	/* unlink */
	tr->tePrevGen->teNextGen = tr->teNextGen;
	if (tr->teNextGen != (TERRITORY *)NULL)
	    tr->teNextGen->tePrevGen = tr->tePrevGen;
	/* link */
	tr->tePrevGen = (territory_entry *)NULL;
	tr->teNextGen = tr->teParent->teChildren;
	tr->teNextGen->tePrevGen = tr;
	tr->teParent->teChildren = tr;
	XRaiseWindow(xp->xDisp, tx->txWindow);
	if (IsVisibleTerritory(tr))
	    ch->ccXNeedFlush = TRUE;
    }
    DebugEndFunc("territory", "raise_territory");
    /*NoReturnValue*/
}

void lower_territory(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *ltr;
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);

    DebugSetFunc("territory", "lower_territory");
    DebugPrint1(5, "Lower for #%d\n", tr->teID);
    if (tr->teNextGen != (TERRITORY *)NULL) {
	/* unlink */
	tr->teNextGen->tePrevGen = tr->tePrevGen;
	if (!NULLTERRITORY(tr->tePrevGen))
	    tr->tePrevGen->teNextGen = tr->teNextGen;
	else
	    tr->teParent->teChildren = tr->teNextGen;
	/* link */
	for (ltr = tr->teNextGen; !NULLTERRITORY(ltr->teNextGen); )
	    ltr = ltr->teNextGen;
	ltr->teNextGen = tr;
	tr->tePrevGen = ltr;
	tr->teNextGen = (territory_entry *)NULL;
	XLowerWindow(xp->xDisp, tx->txWindow);
	if (IsVisibleTerritory(tr))
	    ch->ccXNeedFlush = TRUE;
    }
    DebugEndFunc("territory", "lower_territory");
    /*NoReturnValue*/
}

static u_long set_gc_for_territory_foreground(cp, gcvp)
    x_color_entry *cp;
    XGCValues *gcvp;
{
    if (cp->xcUsePixel) {
	gcvp->fill_style = FillSolid;
	gcvp->foreground = cp->xcPixel;
	return (GCFillStyle|GCForeground);
    }
    gcvp->fill_style = FillTiled;
    gcvp->tile = cp->xcPixmap;
    return (GCFillStyle|GCTile);
}

static u_long set_gc_for_territory_background(cp, gcvp)
    x_color_entry *cp;
    XGCValues *gcvp;
{
    if (cp->xcUsePixel) {
	gcvp->background = cp->xcPixel;
	return (GCForeground);
    }
    gcvp->fill_style = FillTiled;
    gcvp->tile = cp->xcPixmap;
    return (GCFillStyle|GCTile);
}

void clear_territory(ch, tr, color)
    yy_comm_channel *ch;
    TERRITORY *tr;
    x_color color;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    XGCValues gcv;
    DebugSetFunc("territory", "clear_territory");
    if (IsDrawableTerritory(tr) || tr->teTRType == TR_NONE) {
	DebugPrint1(5, "Clear #%d\n", tr->teID);
	gcv.function = GXcopy;
	gcv.fill_style = FillSolid;
	gcv.foreground = color;
	gcv.background = color;
	XChangeGC(xp->xDisp, tx->txGC,
		  (GCFunction|GCFillStyle|GCForeground|GCBackground), &gcv);
	/* Set BackGround Color */
	tx->txBackGroundColor.xcPixel = color;

	if (IsDrawableTerritory(tr)) {
	    XFillRectangle(xp->xDisp, tx->txPixmap, tx->txGC,
			   0, 0, tr->teWidth, tr->teHeight);
	}

	if (IsVisibleTerritory(tr) && tx->txWindow != (Window)NULL) {
#ifndef IPA_PATCH       
	    if(!(tr->teTRType == TR_SPLITE)) {
		DebugPrint1(8, "Clear Window with color#%lu\n", color);
		XClearArea(xp->xDisp, tx->txWindow, 0, 0, 0, 0, True);
	    }
	    else {
		clear_splite_territory(ch, tr);
	    }
#else			
	    DebugPrint1(8, "Clear Window with color#%lu\n", color);
	    XClearArea(xp->xDisp, tx->txWindow, 0, 0, 0, 0, True);
	    ch->ccXNeedFlush = TRUE;
#endif
	}
	if (tr->teTRType == TR_PAGE)
	    clear_page_territory(ch, tr, color);
    }
    ch->ccXNeedFlush = TRUE;
    DebugEndFunc("territory", "clear_territory");
}

void draw_background(ch, tr, pattern_tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TERRITORY *pattern_tr;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    XGCValues gcv;
    DebugSetFunc("territory", "draw_background");
    DebugPrint2(5, "Draw background #%d on #%d\n", pattern_tr->teID, tr->teID);

    if(!(tr->teTRType == TR_SPLITE)) {  /* Add T.kosaka */
	/* ץ饤ȥƥȥʳ¹ */
	gcv.function = GXcopy;
	gcv.tile = XEntry(pattern_tr)->txPixmap;
	XChangeGC(xp->xDisp, tx->txGC, (GCFunction|GCTile), &gcv);
	XFillRectangle(xp->xDisp, tx->txPixmap, tx->txGC,
		       0, 0, tr->teWidth, tr->teHeight);
	if (IsVisibleTerritory(tr)) {
	    DebugPrint0(8, "Clear Window with tile\n");
	    XClearWindow(xp->xDisp, tx->txWindow);
	}
    }
    sync_x_server(xp);
    ch->ccXNeedFlush = TRUE;
    DebugEndFunc("territory", "draw_background");
}

#define ABS(i)		((i)>0? (i): (-(i)))

void scroll_territory(ch, tr, x, y, w, h, x2, y2, do_resize)
    yy_comm_channel *ch;
    TERRITORY *tr;
    int x, y;
    int w, h;
    int x2, y2;
    bool do_resize;
{
    int n_w, n_h;
    if (!IsDrawableTerritory(tr) || x <= 0 || y <= 0 || w <= 0 || h <= 0)
	return;
    /* New Origin */
    n_w = w + ABS(x);
    n_h = h + ABS(y);
}



/************************************************************************
 ******
 ***********************************************************************/

static void wait_for_mapping(disp, win)
    Display *disp;
    Window win;
{
    XEvent event;
    XWindowEvent(disp, win, ExposureMask, &event);
}

/************************************************************************
 ******
 ***********************************************************************/

static void set_default_foreground(xp, cp)
    x_private *xp;
    x_color_entry *cp;
{
    cp->xcUsePixel = TRUE;
    cp->xcPixel = BlackPixel(xp->xDisp, xp->xScreen);
    cp->xcPixmap = (Pixmap)NULL;
}

static void set_default_background(xp, cp)
    x_private *xp;
    x_color_entry *cp;
{
    cp->xcUsePixel = TRUE;
    cp->xcPixel = WhitePixel(xp->xDisp, xp->xScreen);
    cp->xcPixmap = (Pixmap)NULL;
}

u_long set_window_background_attribute(cp, attr)
    x_color_entry *cp;
    XSetWindowAttributes *attr;
{
    if (cp->xcUsePixel) {
	attr->background_pixel = cp->xcPixel;
	return CWBackPixel;
    }
    attr->background_pixmap = cp->xcPixmap;
    return CWBackPixmap;
}

u_long set_window_border_attribute(xp, attr)
    x_private *xp;
    XSetWindowAttributes *attr;
{
    attr->border_pixel = BlackPixel(xp->xDisp, xp->xScreen);
    return CWBorderPixel;
}


/***************************************************************************
 * CREATE TERRITORY
 ***************************************************************************/

#ifndef VERSION104
TERRITORY *create_territory(ch, id, x, y, w, h, parent_id,
			    visible, drawable, type, err_code)
    int id;
#else /*VERSION104*/
TERRITORY *create_territory(ch, x, y, w, h, parent_id,
			    visible, drawable, type, err_code)
#endif /*VERSION104*/
    yy_comm_channel *ch;
    int x, y, w, h;
    TRID parent_id;
    bool visible, drawable;
    int type;
    int *err_code;
{
    TERRITORY *TR;
    DebugSetFunc("territory", "create_territory");
    /* Allocate New Entry and Set Infomation of Territory */
    if ((TR = territory_alloc()) == (TERRITORY *)NULL) {
	DebugPrint0(1, " can't alloc TERRITORY ENTRY - No enough memory\n");
	DebugEndFunc("territory", "create_territory");
	*err_code = YYERROR_SYSERR;
	return (TERRITORY *)NULL;
    }
    /* Size of Territory */
    DebugPrint4(1, "Create New Territory SIZE[%d,%d] at (%d,%d), type#0%o\n",
		w, h, x, y);
#ifndef VERSION104
    TR->teID = id;
#endif /*!VERSION104*/
    TR->teX = x;	TR->teY = y;
    TR->teWidth = w;	TR->teHeight = h;
    TR->teVisible = visible;
    TR->teDrawable = drawable;
    TR->teTRType = type;
    TR->teCtrlFuncs = get_control_functab(type);
    TR->teEventNum = 0;
    *err_code = (parent_id == 0? create_root_territory(ch, TR):
		 create_normal_territory(ch, TR, parent_id));
    if (*err_code != YYNOERROR) {
	territory_unlink(TR); TR = (TERRITORY *)NULL;
    }
    DebugEndFunc("territory", "create_territory");
    return TR;
}

static u_long set_attr_for_territory(xp, tr, attr, root)
    x_private *xp;
    register TERRITORY *tr;
    XSetWindowAttributes *attr;
    bool root;
{
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    u_long mask = 0;
    if (root) {
	/* Set Default Cursor */
	tx->txDefCursor = XCreateFontCursor(xp->xDisp, YYDEFAULTCURSORFONT);
	attr->cursor = tx->txDefCursor;
	mask |= CWCursor;
    }
    /* Default ForeGround Color */
    set_default_foreground(xp, &tx->txForeGroundColor);
    /* Default BackGround Color */
    set_default_background(xp, &tx->txBackGroundColor);
    mask |= set_window_background_attribute(&tx->txBackGroundColor, attr);
#ifdef KEISUKEENV
    /* Border */
    if (YYWINDEBUGBORDERWIDTH > 0)
		mask |=set_window_border_attribute(xp, attr);
#endif
    return mask;
}

static void set_default_gc(disp, tx, gc)
    Display *disp;
    TERRITORY_X_ENTRY *tx;
    GC gc;
{
    XGCValues gcv;
    gcv.function = GXcopy;
    gcv.foreground = tx->txForeGroundColor.xcPixel;
    gcv.background = tx->txBackGroundColor.xcPixel;
    XChangeGC(disp, gc, (GCFunction|GCForeground|GCBackground), &gcv);
}


static void set_hints_for_root_territory(xp, tr, win)
    x_private *xp;
    territory_entry *tr;
    Window win;
{
    XSizeHints shint;
    XClassHint chint;
    /* Send hints to Window Manager */
    shint.x = tr->teX; shint.y = tr->teY;
    shint.width = shint.min_width = tr->teWidth;
    shint.height = shint.min_height = tr->teHeight;
    shint.max_width = DisplayWidth(xp->xDisp, xp->xScreen);
    shint.max_height = DisplayHeight(xp->xDisp, xp->xScreen);
    shint.flags = (PPosition|PSize|PMinSize|PMaxSize);
    XSetStandardProperties(xp->xDisp, win, xp->xWindowName, xp->xIconName,
			   NULL, NULL, 0, &shint);
    chint.res_name = YYRESOURCENAME;
    chint.res_class = YYCLASSNAME;
    XSetClassHint(xp->xDisp, win, &chint);
}

static int create_root_territory(ch, tr)
    yy_comm_channel *ch;
    TERRITORY *tr;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    Window w;
    GC gc;
    XSetWindowAttributes attr;
    u_long mask;
    DebugSetFunc("territory", "create_root_territory");
    if (selected_territory() != (TERRITORY *)NULL) {
	/* We alread have another Root Territory */
	DebugPrint0(9, "Duplicated ROOT\n");
	DebugEndFunc("territory", "create_root_territory");
	return YYERROR_DUPROOT;
    }
    /* Create new window as a Root Window of YY */
    mask = set_attr_for_territory(xp, tr, &attr, TRUE);
    DebugPrint5(5, "Create Window for ROOT Territory#%d at (%d,%d)[%d,%d]\n",
		tr->teID, tr->teX, tr->teY, tr->teWidth, tr->teHeight);
    w = XCreateWindow(xp->xDisp, DefaultRootWindow(xp->xDisp),
		      tr->teX, tr->teY, tr->teWidth, tr->teHeight,
		      YYWINDEFAULTBORDERWIDTH,
		      DefaultDepth(xp->xDisp, xp->xScreen), InputOutput,
		      DefaultVisual(xp->xDisp, xp->xScreen), mask, &attr);
    /* Set GC for root territory */
    gc = XCreateGC(xp->xDisp, w, 0, 0);
    XCopyGC(xp->xDisp, DefaultGC(xp->xDisp, xp->xScreen), ~0L, gc);
    (void) set_default_gc(xp->xDisp, tx, gc);
    /* Set Hints */
    set_hints_for_root_territory(xp, tr, w);
    /* Map YY Root Window */
    XSelectInput(xp->xDisp, w, (VisibilityChangeMask|ExposureMask));
    if (tr->teVisible) {
	DebugPrint0(5, "Map Root Window on the Screen\n");
	XMapWindow(xp->xDisp, w);
	wait_for_mapping(xp->xDisp, w);
    }
    XSelectInput(xp->xDisp, w, (ExposureMask|KeyPressMask));
    tx->txWindow = w;
    tx->txPixmap = (Pixmap)NULL;
    tx->txGC = gc;
    /* */
    ch->ccYYRootTerritory = tr;
    DebugEndFunc("territory", "create_root_territory");
    return YYNOERROR;
}

/**********************************************************************
 *****
 *****  ƥȥμ̤˰¸륨ȥκؿ
 *****
 **********************************************************************/
 
/*
 *
 * ѥƥȥ¸ؿ
 *
 * 줾 Depth Ǥꡢϥѥ
 * ⤦ϥޥѥ¸
 */
int create_cursor_territory(xp, tr, win, gc, pix)
    x_private *xp;	/* X ¸ */
    TERRITORY *tr;	/* ƥȥ */
    Window win;		/* ƥȥбƤ Window */
    GC gc;		/* ƥȥбƤ GC */
    Pixmap pix;		/* ƥȥбƤ Pixmap */
{
    TERRITORY_CURSOR *cs = &tr->teModeEnt.tCursorControl;

    DebugSetFunc("territory", "create_cursor_territory");
    DebugPrint2(5, "Create Cursor Pixmap [%d,%d]\n",
		tr->teWidth, tr->teHeight);
    cs->ccPattern = XCreatePixmap(xp->xDisp, win,
				  tr->teWidth, tr->teHeight, 1);
    cs->ccMask = XCreatePixmap(xp->xDisp, win,
			       tr->teWidth, tr->teHeight, 1);
    cs->ccHotX = cs->ccHotY = 0;
    cs->ccCursor = (Cursor)NULL;
    DebugEndFunc("territory", "create_cursor_territory");
    return YYNOERROR;
}


int create_page_territory(xp, tr, w, gc, pix)
    x_private *xp;
    TERRITORY *tr;
    Window w;
    GC gc;
    Pixmap pix;
{
    DebugSetFunc("territory", "create_page_territory");
    DebugEndFunc("territory", "create_page_territory");
    return YYNOERROR;
}

int create_viewport_territory(xp, tr, w, gc, pix)
    x_private *xp;
    TERRITORY *tr;
    Window w;
    GC gc;
    Pixmap pix;
{
    DebugSetFunc("territory", "create_viewport_territory");
    DebugEndFunc("territory", "create_viewport_territory");
    return YYNOERROR;
}

static int create_normal_territory(ch, tr, parent_id)
    yy_comm_channel *ch;
    TERRITORY *tr;
    TRID parent_id;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *parent;
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    Window w = (Window)NULL;
    GC gc = (GC)NULL;
    Pixmap p = (Pixmap)NULL;
    TERRITORY_SPLITE *sp;
    XGCValues gcval;
    TERRITORY_X_ENTRY *ptx;

    DebugSetFunc("territory", "create_normal_territory");
    if ((parent = search_territory(parent_id)) == (TERRITORY *)NULL ||
		XEntry(parent)->txWindow == (Window)NULL ||
		XEntry(parent)->txGC == (GC)NULL)
		return YYERROR_NOTERRITORY;
    switch (tr->teTRType) {
    case TR_NONE:
    case TR_PAGE:
    case TR_VIEWPORT:
    case TR_CURSOR:
    default: {
	TERRITORY_X_ENTRY *ptx = GetTerritoryXEntry(parent);
	XSetWindowAttributes attr;
	u_long mask;
	mask = set_attr_for_territory(xp, tr, &attr, FALSE);
	w = XCreateWindow(xp->xDisp, ptx->txWindow, tr->teX, tr->teY,
			  tr->teWidth, tr->teHeight, YYWINDEBUGBORDERWIDTH, 0,
			  InputOutput, CopyFromParent, mask, &attr);
	gc = XCreateGC(xp->xDisp, w, 0, 0);
	XCopyGC(xp->xDisp, ptx->txGC, ~0L, gc);
	(void) set_default_gc(xp->xDisp, tx, gc);
	if (tr->teTRType == TR_PAGE) {
	    register int ret;
	    p = XCreatePixmap(xp->xDisp, w, tr->teWidth, tr->teHeight,
			      DefaultDepth(xp->xDisp, xp->xScreen));
	    if ((ret = create_page_territory(xp, tr, w, gc, p)) != YYNOERROR)
		return ret;
	} else if (tr->teTRType == TR_CURSOR) {
	    register int ret;
	    p = XCreatePixmap(xp->xDisp, w, tr->teWidth, tr->teHeight,
			      DefaultDepth(xp->xDisp, xp->xScreen));
	    if ((ret = create_cursor_territory(xp, tr, w, gc, p)) != YYNOERROR)
		return ret;
	    tr->teVisible = FALSE;
	} else if (tr->teTRType == TR_VIEWPORT) {
	    register int ret;
	    p = XCreatePixmap(xp->xDisp, w, tr->teWidth, tr->teHeight,
			      DefaultDepth(xp->xDisp, xp->xScreen));
	    if ((ret = create_viewport_territory(xp, tr, w, gc, p)) 
		!= YYNOERROR)
		return ret;
	}
	break;
    }
    case TR_FENCE: {
	TERRITORY_X_ENTRY *ptx = GetTerritoryXEntry(parent);
	/* Fence mode Territory */
	w = XCreateWindow(xp->xDisp, ptx->txWindow,
			  tr->teX, tr->teY, tr->teWidth, tr->teHeight,
			  0, 0, InputOnly, CopyFromParent, NULL, NULL);
	/* Fence has no Pixmap and GC */
	p = (Pixmap)NULL;
	gc = (GC)NULL;
	break;
    }
    case TR_SPLITE:
#ifndef NO_IPA_PATCH /* T.kosaka add 1992 3/17 */
	/* ץ饤ȥƥȥκ
	 *  1) ƤΥƥȥФ InputOnly  Window 
	 *      ֤礭ϻ˽
	 *     -> ٥θФΤ
	 *  2) 줿礭 Pixmap 
	 *      ϼºݤ˲̤˸뤿Ѥ
	 *  3) GC ϿƤΤΤѤǰĤ
	 */
	sp = GetSpliteTerritoryEnt(tr);
	ptx = GetTerritoryXEntry(parent);
	
	/* Fence mode Territory */
	w = XCreateWindow(xp->xDisp, ptx->txWindow,
			  tr->teX, tr->teY, tr->teWidth, tr->teHeight,
			  0, 0, InputOnly, CopyFromParent, NULL, NULL);
	p = XCreatePixmap(xp->xDisp, w, tr->teWidth, tr->teHeight,
			  DefaultDepth(xp->xDisp, xp->xScreen));
	bzero((char *)sp, sizeof(TERRITORY_SPLITE));
	gc = XCreateGC(xp->xDisp, p, 0, 0);
	XCopyGC(xp->xDisp, ptx->txGC, ~0L, gc);
	DebugPrint0(9, "Create SPLITE --- kosaka--- \n");
#else
	p = (Pixmap)NULL;
	gc = (GC)NULL;
#endif
	break;
    }
    tx->txWindow = w;
    tx->txPixmap = p;
    tx->txGC = gc;
    set_default_foreground(xp, &tx->txForeGroundColor);
    set_default_background(xp, &tx->txBackGroundColor);
    /* Link Info. */
    tr->teParent = parent;
    tr->teNextGen = parent->teChildren;
    if (parent->teChildren != (TERRITORY *)NULL)
	parent->teChildren->tePrevGen = tr;
    parent->teChildren = tr;

    /* Clear Territory */
    if (gc != (GC)NULL)
	clear_territory(ch, tr, tx->txBackGroundColor.xcPixel);
    /* Basic Event Handling */
    if (IsDrawableTerritory(tr))
	XSelectInput(xp->xDisp, w,
		     (ExposureMask|VisibilityChangeMask|ResizeRedirectMask));
    if (IsVisibleTerritory(tr)) {
	DebugPrint0(5, "Map Window on the Screen\n");
	XMapWindow(xp->xDisp, w);
	ch->ccXNeedFlush = TRUE;
    }
    DebugEndFunc("territory", "create_normal_territory");
    return YYNOERROR;
}

static TERRITORY
    *CurSelectedTerritory = (TERRITORY *)NULL;
static TERRITORY
    *TerritoryTop = (TERRITORY *)NULL;
static TERRITORY
    *TerritoryTail = (TERRITORY *)NULL;
static int TerritoryID = 0;

static TERRITORY *territory_alloc()
{
    register territory_entry *new;
    if ((new = (TERRITORY *)memALLOC(sizeof(TERRITORY))) == (TERRITORY *)NULL)
	return (TERRITORY *)NULL;
    bzero((char *)new, sizeof(TERRITORY));
    if (TerritoryTail != (territory_entry *)NULL) {
	TerritoryTail->teNext = new;
	new->tePrev = TerritoryTail;
	TerritoryTail = new;
    } else {
	TerritoryTop = TerritoryTail = new;
    }
#ifdef VERSION104
    if (TerritoryID++ > 30000)
	TerritoryID = 1;
    new->teID = TerritoryID;
#endif /*VERSION104*/
    return new;
}

static void territory_free(tr)
    register TERRITORY *tr;
{
    if (tr != (territory_entry *)NULL)
	free((char *)tr);
}

static void territory_unlink(tr)
    register TERRITORY *tr;
{
    /* If Specified Territory is selected.. */
    if (tr == CurSelectedTerritory)
	CurSelectedTerritory = tr->teParent;
    /* Link Info in TerritoryList */
    if (tr->tePrev != (TERRITORY *)NULL)
	tr->tePrev->teNext = tr->teNext;
    else
	TerritoryTop = tr->teNext;
    if (tr->teNext != (TERRITORY *)NULL)
	tr->teNext->tePrev = tr->tePrev;
    else
	TerritoryTail = tr->tePrev;
    /* Link Info in Generation List */
    if (tr->tePrevGen != (territory_entry *)NULL)
	tr->tePrevGen->teNextGen = tr->teNextGen;
    else if (tr->teParent != (territory_entry *)NULL)
	tr->teParent->teChildren = tr->teNextGen;
    if (tr->teNextGen != (territory_entry *)NULL)
	tr->teNextGen->tePrevGen = tr->tePrevGen;
    territory_free(tr);
}


territory_entry *change_selected_territory(id)
    register int id;
{
    register territory_entry *tr = search_territory(id);
    if (tr == (territory_entry *)NULL)
	return (territory_entry *)NULL;
    CurSelectedTerritory = tr;
    return tr;
}

territory_entry *selected_territory()
{
    return CurSelectedTerritory;
}

territory_entry *search_territory(id)
    register int id;
{
    register territory_entry *tr = TerritoryTop;
    DebugSetFunc("territory", "search_territory");
    for (tr = TerritoryTop;tr != (territory_entry *)NULL;tr = tr->teNext)
	if (tr->teID == id)
	    break;
    DebugEndFunc("territory", "search_territory");
    return tr;
}

territory_entry *search_territory_from_win(w)
    Window w;
{
    register territory_entry *tr = TerritoryTop;
    for (tr = TerritoryTop;tr != (territory_entry *)NULL;tr = tr->teNext)
	if (XEntry(tr)->txWindow == w)
	    return tr;
    return (territory_entry *)NULL;
}

/***************************************************************************
 *** For Debbugging
 **************************************************************************/

static char *TerritoryType(tr)
    TERRITORY *tr;
{
    char *s;
    switch (tr->teTRType) {
    case TR_NONE:	s = "Normal";	break;
    case TR_PAGE:	s = "Page";	break;
    case TR_VIEWPORT:	s = "ViewPort";	break;
    case TR_FENCE:	s = "Fence";	break;
    case TR_SPLITE:	s = "Splite";	break;
    case TR_CURSOR:	s = "Cursor";	break;
    default:		s = "UNKNOWN";	break;
    }
    return s;
}

#define GETID(tr)	((tr)!=(TERRITORY *)NULL? (tr)->teID: 0)

static void list_territory_for_debug()
{
    territory_entry *tr;
    DebugSetFunc("territory", "list_territory_for_debug");
    DebugPrint0(1, "********** LIST OF TERRITORIES ******************\n");
    DebugPrint1(1, "Cuurent ID = %d\n", TerritoryID);
    DebugPrint1(1, "Cuurent Selected Territory = %d\n",
		(CurSelectedTerritory != (territory_entry *)NULL?
		 CurSelectedTerritory->teID: 0));
    DebugPrint0(1, "********** TERRITORIES ******************\n");
    for (tr = TerritoryTop;tr != (territory_entry *)NULL;tr = tr->teNext){
	DebugPrint6(1, "ID#%3d <%s> (%d,%d)[%d,%d]\n",
		    GETID(tr), TerritoryType(tr),
		    tr->teX, tr->teY, tr->teWidth, tr->teHeight);
	DebugPrint4(1, "\tParent#%3d, Child#%3d, Next#%3d, Prev#%3d\n",
		    GETID(tr->teParent), GETID(tr->teChildren),
		    GETID(tr->teNextGen), GETID(tr->tePrevGen));
    }
    DebugEndFunc("territory", "list_territory_for_debug");
}

yy_packet *yycom_debug_list_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    list_territory_for_debug();
    return (yy_packet *)NULL;
}


/**********************************************************************
 *****
 *****  ޥΥϥɥ
 *****
 *********************************************************************/

static void set_cursor_mask(ch, tr, pat_pix, mask_pix, gc)
    yy_comm_channel *ch;
    TERRITORY *tr;
    Pixmap pat_pix, mask_pix;
    GC gc;
{
    x_private *xp = XPRIVATE(ch);
    int x, y;
    XImage *src, *dst;
    DebugSetFunc("cursor", "set_cursor_mask"); 
    src = XGetImage(xp->xDisp, pat_pix, 0, 0, tr->teWidth, tr->teHeight,
		    1, XYPixmap);
    /* mask 򥼥ꥢ */
    XSetFunction(xp->xDisp, gc, GXcopy);
    XSetForeground(xp->xDisp, gc, (u_long)0); /* BackGround Color Ǥʤ 0 */
    XFillRectangle(xp->xDisp, mask_pix, gc, 0, 0, tr->teWidth, tr->teHeight);
    dst = XGetImage(xp->xDisp, mask_pix, 0, 0, tr->teWidth, tr->teHeight,
		    1, XYPixmap);
#ifdef GETPIXELDEBUG
    for (y = tr->teHeight-1; y >= 0; y--) {
	for (x = tr->teWidth-1; x >= 0; x--) {
	    u_long pixel = XGetPixel(dst, x, y);
	    printf("%d", pixel);
	}
	printf("\n");
    }
    for (y = tr->teHeight-1; y >= 0; y--) {
	for (x = tr->teWidth-1; x >= 0; x--) {
	    u_long pixel = XGetPixel(src, x, y);
	    printf("%d", pixel);
	}
	printf("\n");
    }
#endif
    /* ѥ󤫤ޥ */
    for (y = tr->teHeight-1; y >= 0; y--)
	for (x = tr->teWidth-1; x >= 0; x--) {
	    u_long pixel = XGetPixel(src, x, y);
	    if (pixel == WhitePixel(xp->xDisp, xp->xScreen)) {
		XPutPixel(dst, x, y, 1);
		if (x > 0) XPutPixel(dst, x-1, y, 1);
		if (x < tr->teWidth-1) XPutPixel(dst, x+1, y, 1);
		if (y > 0) {
		    XPutPixel(dst, x, y-1, 1);
		    if (x > 0) XPutPixel(dst, x-1, y-1, 1);
		    if (x < tr->teWidth-1) XPutPixel(dst, x+1, y-1, 1);
		}
		if (y < tr->teHeight) {
		    XPutPixel(dst, x, y+1, 1);
		    if (x > 0) XPutPixel(dst, x-1, y+1, 1);
		    if (x < tr->teWidth-1) XPutPixel(dst, x+1, y+1, 1);
		}
	    }
	}
#ifdef GETPIXELDEBUG
    for (y = tr->teHeight-1; y >= 0; y--) {
	for (x = tr->teWidth-1; x >= 0; x--) {
	    u_long pixel = XGetPixel(dst, x, y);
	    printf("%d", pixel);
	}
	printf("\n");
    }
#endif

    
    XPutImage(xp->xDisp, mask_pix, gc, dst,
	      0, 0, 0, 0, tr->teWidth, tr->teHeight);
    XDestroyImage(src);
    XDestroyImage(dst);
    DebugEndFunc("cursor", "set_cursor_mask"); 
    /*NoReturnValue*/
}



static void set_cursor_pattern(ch, src_tr, tr, hot_x, hot_y)
    yy_comm_channel *ch;
    TERRITORY *src_tr;		/* ѥäƤƥȥ */
    TERRITORY *tr;		/* ѥƥȥ */
    int hot_x, hot_y;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
    TERRITORY_CURSOR *cs = &tr->teModeEnt.tCursorControl;
    GC g;
    XColor cfore, cback;

    DebugSetFunc("cursor", "set_cursor_pattern");
    if (src_tr != (TERRITORY *)NULL) {
	/* src_tr  Pixmap Ƥ tr  Pixmap ˥ԡ */
	TERRITORY_X_ENTRY *src_tx = GetTerritoryXEntry(src_tr);
	XSetFunction(xp->xDisp, tx->txGC, GXcopy);
	XSetForeground(xp->xDisp, tx->txGC, tx->txForeGroundColor.xcPixel);
	XSetBackground(xp->xDisp, tx->txGC, tx->txBackGroundColor.xcPixel);
	XCopyArea(xp->xDisp, src_tx->txPixmap, tx->txPixmap, tx->txGC,
		  0, 0, MIN(src_tr->teWidth, tr->teWidth),
		  MIN(src_tr->teHeight, tr->teHeight), 0, 0);
    } else {
	/* ѥ Pixmap 򥼥ꥢƤޤ */
	XSetFunction(xp->xDisp, tx->txGC, GXcopy);
	XSetForeground(xp->xDisp, tx->txGC, (u_long)0);
	XFillRectangle(xp->xDisp, tx->txPixmap, tx->txGC,
		       0, 0, tr->teWidth, tr->teHeight);
    }

    /* Ѥ GC ƥޥѥ
     * ޥޥѥ */
    g = XCreateGC(xp->xDisp, cs->ccPattern, 0, 0);
    XSetGraphicsExposures(xp->xDisp, g, False);
    XSetFunction(xp->xDisp, g, GXcopy);
    DebugPrint2(5, "Copy Plane from Pixmap#%ld to Pixmap#%ld\n",
		tx->txPixmap, cs->ccPattern);
    XCopyPlane(xp->xDisp, tx->txPixmap, cs->ccPattern, g,
	       0, 0, tr->teWidth, tr->teHeight, 0, 0, 1);
    set_cursor_mask(ch, tr, cs->ccPattern, cs->ccMask, g);
    XFreeGC(xp->xDisp, g);

    /* Hot Spot  */
    cs->ccHotX = hot_x;
    cs->ccHotY = hot_y;

    if (cs->ccCursor != (Cursor)NULL) XFreeCursor(xp->xDisp, cs->ccCursor);
    cfore.pixel = tx->txForeGroundColor.xcPixel;
    cback.pixel = tx->txBackGroundColor.xcPixel;
    XQueryColor(xp->xDisp, xp->xColor, &cfore);
    XQueryColor(xp->xDisp, xp->xColor, &cback);
    cs->ccCursor = XCreatePixmapCursor(xp->xDisp,
				       cs->ccPattern, cs->ccMask,
				       &cback, &cfore, hot_x, hot_y);

    DebugEndFunc("cursor", "set_cursor_pattern");
    /*NoReturnValue*/
}    


yy_packet *yycom_create_cursor_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;	/* Cursor Territory */
    int width, height;
    int err_code;
    yy_packet *repl;
    int parentID;
    int hot_x, hot_y;
    int patternID; TERRITORY *pattern;
#ifndef VERSION104
    int id;
#endif /*VERSION104*/

    DebugSetFunc("cursor", "yycom_create_cursor_territory");
    /* ʥƥȥ
     * 礭ȿƤϥѥåȤˤäƻꤵ
     */
#ifndef VERSION104
    id = read_packet_entry_integer(pkt);
#endif /*VERSION104*/
    width = read_packet_entry_integer(pkt);
    height = read_packet_entry_integer(pkt);
    parentID = read_packet_entry_integer(pkt);
    hot_x = read_packet_entry_integer(pkt);
    hot_y = read_packet_entry_integer(pkt);
    patternID = read_packet_entry_integer(pkt);
    if (patternID > 0 &&
	(pattern = search_territory(patternID)) == (TERRITORY *)NULL) {
	DebugPrint0(5, "No Patten Territory for Cursor\n");
	repl = create_error_packet(pkt, YYERROR_NOTERRITORY);
	goto send_reply;
    }
    if (patternID <= 0 || !pattern->teDrawable)
	pattern = (TERRITORY *)NULL;
    
#ifndef VERSION104
    tr = create_territory(ch, id, 0, 0, width, height, parentID,
			  FALSE, TRUE, TR_CURSOR, &err_code);
#else /*VERSION104*/
    tr = create_territory(ch, 0, 0, width, height, parentID,
			  FALSE, TRUE, TR_CURSOR, &err_code);
#endif /*VERSION104*/
    if (tr == (TERRITORY *)NULL) {
	repl = create_error_packet(pkt, YYERROR_NOTERRITORY);
	goto send_reply;
    }

    /* ѥäƥȥ꤬ꤵƤΤǤ
     * Ƥ򥫡ƥȥ˥ԡ
     */
    (void)set_cursor_pattern(ch, pattern, tr, hot_x, hot_y);

#ifndef VERSION104
    repl = (yy_packet *)NULL;
#else /*VERSION104*/
    repl = ALLOC_ACKPACKET(pkt);
    append_packet_entry_integer(repl, tr->teID);
#endif /*VERSION104*/
 send_reply:
    DebugEndFunc("cursor", "yycom_create_cursor_territory");
    return repl;
}

yy_packet *yycom_move_cursor_hotspot(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    territory_entry *tr;
    yy_packet *err = (yy_packet *)NULL;
    TERRITORY_CURSOR *cs;
    int hot_x, hot_y;

    DebugSetFunc("cursor", "yycom_move_cursor_hotspot");
    tr = catch_territory(pkt, TR_CURSOR, &err);
    if (tr == (territory_entry *)NULL) goto send_reply;

    hot_x = read_packet_entry_integer(pkt);
    hot_y = read_packet_entry_integer(pkt);
    /* Hot Spot  */
    cs = &tr->teModeEnt.tCursorControl;
    cs->ccHotX = MAX(0,hot_x);
    cs->ccHotY = MAX(0,hot_y);

    /* ߤΥޥǤν */
    if (tr->teID == ch->ccXCursorID) {
	TERRITORY *root_tr;
	TERRITORY_X_ENTRY *tx = GetTerritoryXEntry(tr);
	XColor cfore, cback;
	/* Root Territory б Window õФ */
	for (root_tr = tr; root_tr->teParent != (TERRITORY *)NULL; )
	    root_tr = root_tr->teParent;

	if (cs->ccCursor != (Cursor)NULL) XFreeCursor(xp->xDisp, cs->ccCursor);
	cfore.pixel = tx->txForeGroundColor.xcPixel;
	cback.pixel = tx->txBackGroundColor.xcPixel;
	XQueryColor(xp->xDisp, xp->xColor, &cfore);
	XQueryColor(xp->xDisp, xp->xColor, &cback);
	cs->ccCursor = XCreatePixmapCursor(xp->xDisp,
					   cs->ccPattern, cs->ccMask,
					   &cback, &cfore, hot_x, hot_y);
	XDefineCursor(xp->xDisp, XEntry(root_tr)->txWindow, cs->ccCursor);
    }

 send_reply:
    DebugEndFunc("cursor", "yycom_move_cursor_hotspot");
    return (yy_packet *)err;
}

yy_packet *yycom_change_cursor_bitmap(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    territory_entry *tr;
    int patternID;
    territory_entry *pattern;
    yy_packet *err = (yy_packet *)NULL;

    DebugSetFunc("cursor", "yycom_change_cursor_bitmap");    

    tr = catch_territory(pkt, TR_CURSOR, &err);
    if (tr == (territory_entry *)NULL) goto send_reply;

    patternID = read_packet_entry_integer(pkt);
    if (patternID > 0 &&
	(pattern = search_territory(patternID)) == (TERRITORY *)NULL) {
	DebugPrint0(5, "No Patten Territory for Cursor\n");
	err = create_error_packet(pkt, YYERROR_NOTERRITORY);
	goto send_reply;
    }
    if (patternID <= 0 || !pattern->teDrawable)
	pattern = (TERRITORY *)NULL;

    (void)set_cursor_pattern(ch, pattern, tr,
			     tr->teModeEnt.tCursorControl.ccHotX,
			     tr->teModeEnt.tCursorControl.ccHotY);

 send_reply:
    DebugEndFunc("cursor", "yycom_change_cursor_bitmap");
    return (yy_packet *)err;
}

yy_packet *yycom_move_cursor(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    territory_entry *tr;
    yy_packet *err;

    DebugSetFunc("cursor", "yycom_move_cursor");
    tr = catch_territory(pkt, TR_CURSOR, &err);
    if (tr == (territory_entry *)NULL) goto send_reply;

    /*  select Ƥ륫Ǥʤв⤷ʤ */
    if (tr->teID == ch->ccXCursorID) {
	register TERRITORY *target = catch_territory(pkt, TR_ALL, &err);
	register int x, y;
	if (target == (TERRITORY *)NULL) goto send_reply;
	if (!IsVisibleTerritory(target)) goto send_reply;
	if (XEntry(target)->txWindow == (Window)NULL) goto send_reply;
	x = read_packet_entry_integer(pkt);
	y = read_packet_entry_integer(pkt);
	XWarpPointer(xp->xDisp, None, XEntry(target)->txWindow,
		     0, 0, 0, 0, x, y);
    }
 send_reply:
    DebugEndFunc("cursor", "yycom_move_cursor");
    return (yy_packet *)NULL;
}

yy_packet *yycom_destroy_cursor(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    territory_entry *tr;
    yy_packet *err;
    yy_packet *repl;
    DebugSetFunc("cursor", "yycom_destroy_cursor");

    DebugEndFunc("cursor", "yycom_destroy_cursor");
    return (yy_packet *)NULL;
}

static int get_current_cursor_position(xp, tr_x, tr_y, mask)
    x_private *xp;
    int *tr_x, *tr_y;
    u_int *mask;
{
    int id = 0;
    Window top = XEntry(TerritoryTop)->txWindow;
    Window r_win, c_win;
    int r_x, r_y, w_x, w_y;
    u_int x_mask;
    DebugSetFunc("territory", "get_current_cursor_position");
    *mask = 0;
    if (XQueryPointer(xp->xDisp, top, &r_win, &c_win,
		      &r_x, &r_y, &w_x, &w_y, &x_mask) == True) {
	if (c_win != None) {
	    Window win_dummy;
	    TERRITORY *tr = search_territory_from_win(c_win);
	    id = tr->teID;
	    XTranslateCoordinates(xp->xDisp, top, c_win, w_x, w_y,
				  tr_x, tr_y, &win_dummy);
	} else {
	    TERRITORY *tr = search_territory_from_win(top);
	    if (w_x >= 0 && w_x <= tr->teWidth &&
		w_y >= 0 && w_y <= tr->teHeight) {
		id = tr->teID;
		*tr_x = w_x; *tr_y = w_y;
	    } else
		id = *tr_x = *tr_y = 0;
	}
	DebugPrint3(2, "QueryPointer...(%d,%d) on TR#%d\n", *tr_x, *tr_y, id);
    } else {
	/* Cursor is not in this screen */
	*tr_x = *tr_y = *mask = 0;
	id = 0;
    }
    if (id != 0) {
	/* Parse x_mask */
	*mask = parse_button_state(YYMASK_ALL, YYMASK_BUTTON_PRESS, x_mask);
    }
    DebugEndFunc("territory", "get_current_cursor_position");
    return id;
}


yy_packet *yycom_get_cursur_position(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    int cs_id;		/* TerritoryID for Cursor Territory */
    int id;		/* The cursor is in this territory */
    int tr_x, tr_y;	/* Position of cursor */
    u_int mask;
    yy_packet *repl = (yy_packet *)NULL;

    DebugSetFunc("cursor", "yycom_get_cursur_position");
    if ((cs_id = read_packet_entry_integer(pkt)) == 0) {
	/* Get Position for Current Cursor */
	id = get_current_cursor_position(xp, &tr_x, &tr_y, &mask);
    } else {
	TERRITORY *tr = search_territory(cs_id);
	/* if (TypeOfTerritory(tr) != TR_CURSOR) */
	id = 0;
	tr_x = tr_y = 0;
	mask = 9;
    }
    repl = ALLOC_ACKPACKET(pkt);
    append_packet_entry_integer(repl, id);
    append_packet_entry_integer(repl, mask);
    append_packet_entry_integer(repl, tr_x);
    append_packet_entry_integer(repl, tr_y);
    DebugEndFunc("cursor", "yycom_get_cursur_position");
    return (yy_packet *)repl;
}


yy_packet *yycom_display_cursor(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    territory_entry *tr;
    territory_entry *root_tr;	/* Root Territory */
    int id;
    yy_packet *err = (yy_packet *)NULL;
    
    DebugSetFunc("cursor", "yycom_display_cursor");
    id = read_packet_entry_integer(pkt);
    if (id > 0) {
	tr = search_territory(id);
	if (tr == (TERRITORY *)NULL || !(tr->teTRType & TR_CURSOR)) {
	    err = create_error_packet(pkt, (tr? YYERROR_TYPEMISMATCH:
					     YYERROR_NOTERRITORY));
	    goto send_reply;
	}
	if (tr->teModeEnt.tCursorControl.ccCursor == (Cursor)NULL)
	    goto send_reply;
	/* Root Territory б Window õФ */
	for (root_tr = tr; root_tr->teParent != (TERRITORY *)NULL; )
	    root_tr = root_tr->teParent;
	XDefineCursor(xp->xDisp, XEntry(root_tr)->txWindow,
		      tr->teModeEnt.tCursorControl.ccCursor);
    } else {
	DebugPrint0(5, "Reset Mouse Cursor\n");
	root_tr = ch->ccYYRootTerritory;
	XDefineCursor(xp->xDisp, XEntry(root_tr)->txWindow,
		      XEntry(root_tr)->txDefCursor);
    }
 send_reply:
    DebugEndFunc("cursor", "yycom_display_cursor");
    return (yy_packet *)err;
}



/**********************************************************************
 ****  Event Control ***********************************************
 *********************************************************************/

/***************************************************************************
 ***** Command 71
 *****
 *****  Select a Territory to Input
 *****
 ***************************************************************************/
yy_packet *yycom_select_territory(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    territory_entry *tr;
    yy_packet *err;

    DebugSetFunc("event", "yycom_select_territory");
    tr = get_specified_territory(pkt, &err);
    if (tr == (territory_entry *)NULL)
	return err; /* Unknow Territory */
    change_selected_territory(tr->teID);
    DebugEndFunc("event", "yycom_select_territory");
    return (yy_packet *)NULL;
}

/***************************************************************************
 ***** Command 72
 *****
 *****  Set Mask for Event
 *****
 ***************************************************************************/
yy_packet *yycom_set_event_mask(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    territory_entry *tr;
    TERRITORY_X_ENTRY *tx;
    register int mask;		/* Event Mask for YYonX */
    register u_long event_mask;	/* Event Mask for X Window System */
    yy_packet *err = (yy_packet *)NULL;
    
    DebugSetFunc("event", "yycom_set_event_mask");
    if ((tr = catch_territory(pkt, TR_ALL, &err)) == (TERRITORY *)NULL)
	goto send_reply;

    mask = read_packet_entry_integer(pkt);
    tx = GetTerritoryXEntry(tr);
    
    /* Set Default Event Mask */
    event_mask = ExposureMask;
    if (tr->teParent == (TERRITORY *)NULL)
	event_mask |= KeyPressMask;	/* Ϥϥ롼ȤǸФ */
#ifdef DCLICKDEBUG
    if (mask & (YYMASK_BUTTON_PRESS|YYMASK_BUTTON_RELEASE))
	mask |= YYMASK_DOUBLE_CLICK;
#endif /*DCLICKDEBUG*/
#ifdef STAYDEBUG0
    if (mask & (YYMASK_BUTTON_PRESS));
	mask |= YYMASK_STAY;
#endif /* STAYDEBUG */
    if (mask & YYMASK_BUTTON_PRESS)
	event_mask |= ButtonPressMask;
    if (mask & YYMASK_BUTTON_RELEASE)
	event_mask |= ButtonReleaseMask;
    if (mask & YYMASK_MOVE) {
#ifndef IPA_NOPATCH
	if(mask & YYMASK_BUTTON_PRESS)
	    event_mask |= ButtonMotionMask;
#endif
	event_mask |= PointerMotionMask;
    }
    if (mask & YYMASK_IN)
	event_mask |= EnterWindowMask;
    if (mask & YYMASK_OUT)
	event_mask |= LeaveWindowMask;
    if (mask & YYMASK_STAY) {
	event_mask |= (EnterWindowMask|LeaveWindowMask);
	if (!(event_mask & PointerMotionMask)) 
	    /*event_mask |= (PointerMotionMask|PointerMotionHintMask);*/
	    event_mask |= (PointerMotionMask);
    }
    if (mask & YYMASK_DOUBLE_CLICK)
	event_mask |= (ButtonPressMask|ButtonReleaseMask);

    XSelectInput(xp->xDisp, tx->txWindow, event_mask);
    DebugPrint2(1, "SetEventMask: Mask=0%o, XEvent=0%om\n", mask, event_mask);
    tr->teEventMask = mask;
    if (IsVisibleTerritory(tr))
	ch->ccXNeedFlush = TRUE;
 send_reply:
    DebugEndFunc("event", "yycom_set_event_mask");
    return err;
}

/***************************************************************************
 ***** Command 74
 *****
 *****  Enable/Disable Handle Events
 *****
 ***************************************************************************/
yy_packet *yycom_mask_event(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    register int flag;
    
    DebugSetFunc("event", "yycom_mask_event");
    flag = read_packet_entry_integer(pkt);
    ch->ccXEventEnable = (flag == 1);
    DebugEndFunc("event", "yycom_mask_event");
    return (yy_packet *)NULL;
}

#ifndef NOIPAPATCH
/* źˤɲ 1991.5.23 */
/* ˤ뽤 1992.07.27 */
yy_packet *yycom_request_motion(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    XEvent ev;
    XEvent temp_ev;
    /* extern int mouse_event_ok; */
    /* extern XMotionEvent last_motion; */
    int flg;
    
    DebugSetFunc("event", "yycom_request_motion");
    /* MotionEvent Τʰ˸¤˺Ƴ
     */
#ifdef STAYDEBUG
    printf("Next MotionEvent will be reported!!\n");
#endif
    ch->ccXMotionEnable = TRUE;
#ifdef BUGBUG
    /* 1992.07.28
     *   LastPointer ˵Ͽ줿Τ٥٥ȤȤ
     *  Τ졢˺ƤӡǱʱˤäƤޤ
     */
    if (xp->xLastPointer.type == MotionNotify) {
	XPutBackEvent(xp->xLastPointer.xmotion.display, &xp->xLastPointer);
	xp->xLastPointer.type = LASTEvent;
    }
#endif
    xp->xLastPointer.type = LASTEvent;
    DebugEndFunc("event", "yycom_request_motion");
    return (yy_packet *)NULL;
}
/* źˤɲ ޤ */
#endif /*!NOIPAPATCH*/

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
